/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pd.as.jacc.cfg;

import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.InvalidParameterNameException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.provider.SimpleAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.SimpleCommandProvider;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.exception.RepositoryException;
import com.tivoli.pd.as.jacc.cfg.ConfigAction;
import com.tivoli.pd.as.jacc.cfg.MigrateToTAMConfigAction;
import com.tivoli.pd.as.jacc.cfg.PasswordCoder;
import com.tivoli.pd.as.jacc.cfg.SequenceNumberHelper;
import com.tivoli.pd.as.jacc.cfg.TAMConfigConstants;
import com.tivoli.pd.as.jacc.cfg.TAMConfigController;
import com.tivoli.pd.as.jacc.cfg.TAMConfigException;
import com.tivoli.pd.as.jacc.cfg.TAMConfigInitialize;
import com.tivoli.pd.as.jacc.cfg.TAMConfigInvalidParameterException;
import com.tivoli.pd.as.jacc.cfg.TAMConfigLoggers;
import com.tivoli.pd.as.jacc.cfg.TAMConfigStringGenerator;
import com.tivoli.pd.as.jacc.cfg.TAMConfigUtils;
import com.tivoli.pd.as.util.AmasMessage;
import com.tivoli.pd.jras.pdjlog.jlog.ILogger;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import javax.management.ObjectName;

public class TAMConfigCommandProvider
extends SimpleCommandProvider {
    private final String TAMConfigCommandProvider_java_sourceCodeID = "$Id: @(#)67 1.22.1.1 src/jacc/com/tivoli/pd/as/jacc/cfg/TAMConfigCommandProvider.java, amemb.jacc.was, amemb600, 080423a 08/04/23 02:40:47 @(#) $";
    public static final String sCopyright = "IBM Confidential\nObject Code Only Source Materials\n5747-SM3\n(c) Copyright International Business Machines Corp. 1994-2002.  All Rights Reserved.\nThe source code for this program is not published or otherwise divested\nof its trade secrets, irrespective of what has been deposited with the\nU.S. Copyright Office.\n";
    private static final String defaultPortRange = "8900:8999";
    private ILogger _traceLogger = null;
    private ILogger _messageLogger = null;
    private static final String CLASSNAME = (class$com$tivoli$pd$as$jacc$cfg$TAMConfigCommandProvider == null ? (class$com$tivoli$pd$as$jacc$cfg$TAMConfigCommandProvider = TAMConfigCommandProvider.class$("com.tivoli.pd.as.jacc.cfg.TAMConfigCommandProvider")) : class$com$tivoli$pd$as$jacc$cfg$TAMConfigCommandProvider).getName();
    private static final String ALL_NODES = "*";
    private static final String[][] configParams = new String[][]{{"policySvr", "localhost:7135"}, {"authSvrs", "localhost:7136:1"}, {"adminUid", "sec_master"}, {"adminPasswd", null}, {"mode", "local"}, {"secDomain", "Default"}, {"portSet", "8900:8999"}, {"wasAdminDN", null}, {"dnSuffix", null}, {"mtsTimeout", "60"}};
    private static final String[][] reconfigParams = new String[][]{{"policySvr", "localhost:7135:1"}, {"authSvrs", "localhost:7136:1"}, {"adminUid", "sec_master"}, {"adminPasswd", null}, {"mode", "local"}, {"secDomain", "Default"}, {"portSet", "8900:8999"}, {"wasAdminDN", null}, {"dnSuffix", null}, {"mtsTimeout", "60"}, {"force", "no"}};
    private static final String[][] modifyParams = new String[][]{{"adminUid", "sec_master"}, {"adminPasswd", null}};
    private static final String[][] unconfigParams = new String[][]{{"adminUid", "sec_master"}, {"adminPasswd", null}, {"force", "no"}};
    private static final String[][] migrateParams = new String[][]{{"adminUid", "sec_master"}, {"adminPasswd", null}, {"wasAdminDN", null}, {"secDomain", "Default"}, {"dnSuffix", null}, {"mtsTimeout", "60"}};
    private TAMConfigStringGenerator _stringGenerator = null;
    private boolean _initialized = false;
    static /* synthetic */ Class class$com$tivoli$pd$as$jacc$cfg$TAMConfigCommandProvider;

    private synchronized void init() {
        if (!this._initialized) {
            this._stringGenerator = TAMConfigUtils.getStringGeneratorForCtx();
            try {
                TAMConfigUtils.initializeLogging(this._stringGenerator);
                this._traceLogger = TAMConfigLoggers.getInstance().getTraceLogger();
                this._messageLogger = TAMConfigLoggers.getInstance().getMessageLogger();
            }
            catch (TAMConfigException tAMConfigException) {
                throw new IllegalStateException(tAMConfigException.toString());
            }
        }
        this._initialized = true;
    }

    Properties createActionProperties(String string, String[][] stringArray, SimpleAdminCommand simpleAdminCommand) throws CommandException {
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "createActionProperties(String, String, SimpleAdminCommand) action = " + string + " params = " + stringArray + " cmd = " + simpleAdminCommand);
        }
        String string2 = this.getActionConfigFilename(simpleAdminCommand);
        Properties properties = null;
        try {
            if (this._traceLogger != null && this._traceLogger.isLogging()) {
                this._traceLogger.text(16L, (Object)CLASSNAME, "createActionProperties(String, String, SimpleAdminCommand)", "Attempting to read the current sequence number from the file " + string2);
            }
            properties = TAMConfigUtils.readCfgRepositoryProperties(string2);
        }
        catch (IOException iOException) {
            AmasMessage amasMessage = new AmasMessage(864636965, new Object[]{string2, iOException.toString()});
            throw new CommandException(amasMessage.getMessageString());
        }
        Properties properties2 = new Properties(properties);
        this.checkAndPopulateProps(properties2, stringArray, simpleAdminCommand);
        if (string != null && !string.equals("modify")) {
            properties2.setProperty("action", string);
            int n = SequenceNumberHelper.getActionSeqNo(properties);
            SequenceNumberHelper.setActionSeqNo(++n, properties2);
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "createActionProperties(String, String, SimpleAdminCommand) returning " + properties2);
        }
        return properties2;
    }

    private Properties populateActionConfigFile(Properties properties, SimpleAdminCommand simpleAdminCommand) throws CommandException {
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "populateActionConfigFile(Properties, SimpleAdminCommand) actionConfigProps = " + properties + " cmd = " + simpleAdminCommand);
        }
        Properties properties2 = null;
        String string = this.getActionConfigFilename(simpleAdminCommand);
        try {
            if (this._traceLogger != null && this._traceLogger.isLogging()) {
                this._traceLogger.text(16L, (Object)CLASSNAME, "populateActionConfigFile(Properties, SimpleAdminCommand)", "Reading existing action properties from the file " + string);
            }
            properties2 = TAMConfigUtils.readCfgRepositoryProperties(string);
        }
        catch (IOException iOException) {
            AmasMessage amasMessage = new AmasMessage(864636965, new Object[]{string, iOException.toString()});
            throw new CommandException(amasMessage.getMessageString());
        }
        try {
            if (this._traceLogger != null && this._traceLogger.isLogging()) {
                this._traceLogger.text(16L, (Object)CLASSNAME, "populateActionConfigFile(Properties, SimpleAdminCommand)", "Outputting action properties to the file  " + string);
            }
            Properties properties3 = new Properties();
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string2 = enumeration.nextElement().toString();
                properties3.setProperty(string2, properties.getProperty(string2));
            }
            TAMConfigUtils.writeCfgRepositoryProperties(properties3, string, "Embedded Tivoli Access Manager configuration action parameters - THIS FILE IS MACHINE GENERATED - PLEASE DO NOT EDIT");
        }
        catch (IOException iOException) {
            AmasMessage amasMessage = new AmasMessage(864636966, new Object[]{string, iOException.toString()});
            if (this._messageLogger != null && this._messageLogger.isLogging()) {
                this._messageLogger.text(16L, (Object)CLASSNAME, "populateActionConfigFile(Properties, SimpleAdminCommand)", amasMessage.getMessageString());
            }
            throw new CommandException(amasMessage.getMessageString());
        }
        catch (RepositoryException repositoryException) {
            AmasMessage amasMessage = new AmasMessage(864636966, new Object[]{string, repositoryException.toString()});
            if (this._messageLogger != null && this._messageLogger.isLogging()) {
                this._messageLogger.text(16L, (Object)CLASSNAME, "populateActionConfigFile(Properties, SimpleAdminCommand)", amasMessage.getMessageString());
            }
            throw new CommandException(amasMessage.getMessageString());
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "populateActionConfigFile(Properties, SimpleAdminCommand) returning " + properties2);
        }
        return properties2;
    }

    private String getActionConfigFilename(SimpleAdminCommand simpleAdminCommand) throws CommandException {
        boolean bl;
        String string = null;
        String string2 = (String)simpleAdminCommand.getParameter("nodeName");
        if (string2 == null) {
            string2 = ALL_NODES;
        }
        if (!(bl = string2.equals(ALL_NODES))) {
            this.verifyNode(string2);
            this._stringGenerator.setNodeName(string2);
            string = this._stringGenerator.getStringFromTemplate("cells/${CELL_NAME}/nodes/${NODE_NAME}/amwas.action.properties");
        } else {
            string = this._stringGenerator.getStringFromTemplate("cells/${CELL_NAME}/amwas.action.properties");
        }
        return string;
    }

    private void verifyNode(String string) throws CommandException {
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "verifyNode(String) nodeName = " + string);
        }
        ObjectName[] objectNameArray = null;
        try {
            ConfigService configService = ConfigServiceFactory.getConfigService();
            if (configService == null) {
                throw new IllegalStateException(new AmasMessage(864636983).getMessageString());
            }
            objectNameArray = configService.resolve(null, "Node=" + string);
        }
        catch (Exception exception) {
            throw new CommandException(new AmasMessage(864636984, exception.toString()).getMessageString());
        }
        if (objectNameArray == null || objectNameArray.length == 0) {
            throw new CommandException(new AmasMessage(864636985, (Object)"nodeName", string).getMessageString());
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "verifyNode(String)");
        }
    }

    private void checkAndPopulateProps(Properties properties, String[][] stringArray, SimpleAdminCommand simpleAdminCommand) throws InvalidParameterValueException {
        String string;
        int n;
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "checkAndPopulateProps(Properties, String[][], SimpleAdminCommand) actionConfigProps = " + properties + " params = " + stringArray + " cmd = " + simpleAdminCommand);
        }
        PasswordCoder passwordCoder = new PasswordCoder(null);
        for (n = 0; n < TAMConfigConstants.PASSWORDS.length; ++n) {
            string = properties.getProperty(TAMConfigConstants.PASSWORDS[n]);
            if (string == null) continue;
            String string2 = passwordCoder.decode(string);
            properties.setProperty(TAMConfigConstants.PASSWORDS[n], string2);
        }
        for (n = 0; n < stringArray.length; ++n) {
            string = null;
            try {
                string = (String)simpleAdminCommand.getParameter(stringArray[n][0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string == null) {
                string = properties.getProperty(stringArray[n][0]);
            }
            if (string == null && (string = stringArray[n][1]) == null) {
                throw new IllegalStateException();
            }
            if (!TAMConfigUtils.validateParameter(stringArray[n][0], string)) {
                throw new TAMConfigInvalidParameterException(simpleAdminCommand.getName(), stringArray[n][0], string);
            }
            properties.setProperty(stringArray[n][0], string);
        }
        for (n = 0; n < TAMConfigConstants.PASSWORDS.length; ++n) {
            string = properties.getProperty(TAMConfigConstants.PASSWORDS[n]);
            if (string == null) continue;
            string = passwordCoder.encode(string);
            properties.setProperty(TAMConfigConstants.PASSWORDS[n], string);
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "checkAndPopulateProps(String[][], SimpleAdminCommand, Properties) returning " + properties);
        }
    }

    public Properties listTAMSettings(SimpleAdminCommand simpleAdminCommand) throws CommandException {
        if (!this._initialized) {
            this.init();
            if (!this._initialized) {
                return null;
            }
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "listTAMSettings(SimpleAdminCommand) cmd = " + simpleAdminCommand);
        }
        String string = this.getActionConfigFilename(simpleAdminCommand);
        Properties properties = null;
        try {
            if (this._traceLogger != null && this._traceLogger.isLogging()) {
                this._traceLogger.text(16L, (Object)CLASSNAME, "listTAMSettings(SimpleAdminCommand)", "Loading properties from file " + string);
            }
            properties = TAMConfigUtils.readCfgRepositoryProperties(string);
        }
        catch (IOException iOException) {
            AmasMessage amasMessage = new AmasMessage(864636965, new Object[]{string, iOException.toString()});
            throw new CommandException(amasMessage.getMessageString());
        }
        properties.remove("seqNo");
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "listTAMSettings(SimpleAdminCommand) returning " + properties);
        }
        return properties;
    }

    public String reconfigureTAM(SimpleAdminCommand simpleAdminCommand) throws CommandException {
        String string = null;
        boolean bl = false;
        if (!this._initialized) {
            this.init();
            if (!this._initialized) {
                return string;
            }
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "reconfigureTAM(SimpleAdminCommand) cmd = " + simpleAdminCommand);
        }
        if (!(bl = this.checkIfGUIConfig(simpleAdminCommand))) {
            string = this.processAction(simpleAdminCommand, "jaasunconfig", unconfigParams);
        }
        string = this.processAction(simpleAdminCommand, "reconfig", reconfigParams);
        if (!bl) {
            string = this.processAction(simpleAdminCommand, "jaasconfig", configParams);
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "reconfigureTAM(SimpleAdminCommand) returning " + string);
        }
        return string;
    }

    public String configureTAM(SimpleAdminCommand simpleAdminCommand) throws CommandException {
        String string = null;
        boolean bl = false;
        if (!this._initialized) {
            this.init();
            if (!this._initialized) {
                return string;
            }
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "configureTAM(SimpleAdminCommand) cmd = " + simpleAdminCommand);
        }
        bl = this.checkIfGUIConfig(simpleAdminCommand);
        string = this.processAction(simpleAdminCommand, "config", configParams);
        if (!bl) {
            string = this.processAction(simpleAdminCommand, "jaasconfig", configParams);
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "configureTAM(SimpleAdminCommand) returning " + string);
        }
        return string;
    }

    private String processAction(SimpleAdminCommand simpleAdminCommand, String string, String[][] stringArray) throws CommandException {
        String string2 = null;
        Properties properties = this.createActionProperties(string, stringArray, simpleAdminCommand);
        Properties properties2 = this.populateActionConfigFile(properties, simpleAdminCommand);
        if (string != null && !string.equals("modify")) {
            String string3 = (String)simpleAdminCommand.getParameter("defer");
            if (string3 != null && !TAMConfigUtils.isTrue(string3) || string.equals("jaasconfig") || string.equals("jaasunconfig")) {
                Session session = simpleAdminCommand.getConfigSession();
                TAMConfigInitialize tAMConfigInitialize = new TAMConfigInitialize(session);
                try {
                    boolean bl = TAMConfigUtils.isServant();
                    TAMConfigUtils.setServant(false);
                    tAMConfigInitialize.initialize(null);
                    TAMConfigUtils.setServant(bl);
                    AmasMessage amasMessage = new AmasMessage(864636971);
                    string2 = amasMessage.getMessageString();
                }
                catch (Exception exception) {
                    this.populateActionConfigFile(properties2, simpleAdminCommand);
                    throw new CommandException(exception);
                }
            }
            if (string.equals("jaasconfig") || string.equals("jaasunconfig")) {
                this.populateActionConfigFile(properties2, simpleAdminCommand);
            }
        }
        return string2;
    }

    public String modifyTAM(SimpleAdminCommand simpleAdminCommand) throws CommandException {
        String string = null;
        if (!this._initialized) {
            this.init();
            if (!this._initialized) {
                return string;
            }
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "modifyTAM(SimpleAdminCommand) cmd = " + simpleAdminCommand);
        }
        string = this.processAction(simpleAdminCommand, "modify", modifyParams);
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "modifyTAM(SimpleAdminCommand) returning " + string);
        }
        return string;
    }

    public String unconfigureTAM(SimpleAdminCommand simpleAdminCommand) throws CommandException {
        String string = null;
        boolean bl = false;
        if (!this._initialized) {
            this.init();
            if (!this._initialized) {
                return string;
            }
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "unconfigureTAM(SimpleAdminCommand) cmd = " + simpleAdminCommand);
        }
        if (!(bl = this.checkIfGUIConfig(simpleAdminCommand))) {
            string = this.processAction(simpleAdminCommand, "jaasunconfig", unconfigParams);
        }
        string = this.processAction(simpleAdminCommand, "unconfig", unconfigParams);
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "unconfigureTAM(SimpleAdminCommand) returning " + string);
        }
        return string;
    }

    public String migrateToTAM(SimpleAdminCommand simpleAdminCommand) throws CommandException {
        String string = null;
        if (!this._initialized) {
            this.init();
            if (!this._initialized) {
                return string;
            }
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "migrateAuthorizationTable(SimpleAdminCommand) cmd = " + simpleAdminCommand);
        }
        Properties properties = new Properties();
        this.checkAndPopulateProps(properties, migrateParams, simpleAdminCommand);
        TAMConfigUtils.setExtraConfigProperties(properties, this._stringGenerator);
        TAMConfigController tAMConfigController = new TAMConfigController();
        tAMConfigController.addConfigActions(new ConfigAction[]{new MigrateToTAMConfigAction()});
        tAMConfigController.setProperties(properties);
        try {
            tAMConfigController.execute();
        }
        catch (TAMConfigException tAMConfigException) {
            throw new CommandException(tAMConfigException.toString());
        }
        AmasMessage amasMessage = new AmasMessage(864636972);
        string = amasMessage.getMessageString();
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "migrateAuthorizationTable(SimpleAdminCommand) returning " + string);
        }
        return string;
    }

    private boolean checkIfGUIConfig(SimpleAdminCommand simpleAdminCommand) {
        boolean bl = false;
        String string = null;
        try {
            string = (String)simpleAdminCommand.getParameter("defer");
        }
        catch (InvalidParameterNameException invalidParameterNameException) {
            string = null;
        }
        if (string == null) {
            if (this._traceLogger != null && this._traceLogger.isLogging()) {
                this._traceLogger.text(16L, (Object)CLASSNAME, "checkIfGUIConfig(SimpleAdminCommand)", "A null value for defer was retrieved from the command.");
            }
            throw new IllegalStateException();
        }
        if (string.equalsIgnoreCase("TAMGUI")) {
            try {
                simpleAdminCommand.setParameter("defer", "no");
            }
            catch (InvalidParameterValueException invalidParameterValueException) {
                if (this._traceLogger != null && this._traceLogger.isLogging()) {
                    this._traceLogger.text(16L, (Object)CLASSNAME, "checkIfGUIConfig(SimpleAdminCommand)", "An invalid parameter value was encountered: no");
                }
                throw new IllegalStateException();
            }
            catch (InvalidParameterNameException invalidParameterNameException) {
                if (this._traceLogger != null && this._traceLogger.isLogging()) {
                    this._traceLogger.text(16L, (Object)CLASSNAME, "checkIfGUIConfig(SimpleAdminCommand)", "An invalid parameter name was encountered: defer");
                }
                throw new IllegalStateException();
            }
            bl = true;
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

