/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pd.as.jacc.cfg;

import com.tivoli.pd.as.jacc.cfg.ConfigAction;
import com.tivoli.pd.as.jacc.cfg.ConfigActionFailedException;
import com.tivoli.pd.as.jacc.cfg.ConfigStateProperties;
import com.tivoli.pd.as.jacc.cfg.TAMConfigException;
import com.tivoli.pd.as.jacc.cfg.TAMConfigLoggers;
import com.tivoli.pd.as.util.AmasMessage;
import com.tivoli.pd.jras.pdjlog.jlog.ILogger;
import java.io.IOException;
import java.util.Properties;

public class TAMConfigController {
    private final String TAMConfigController_java_sourceCodeID = "$Id: @(#)69  1.5 src/jacc/com/tivoli/pd/as/jacc/cfg/TAMConfigController.java, amemb.jacc.was, amemb600, 051118a 04/09/02 18:10:47 @(#) $";
    public static final String sCopyright = "IBM Confidential\nObject Code Only Source Materials\n5747-SM3\n(c) Copyright International Business Machines Corp. 1994-2002.  All Rights Reserved.\nThe source code for this program is not published or otherwise divested\nof its trade secrets, irrespective of what has been deposited with the\nU.S. Copyright Office.\n";
    private boolean _force = false;
    private String _ctxID = null;
    private String _configStateFilename = null;
    private Properties _props = new Properties();
    private ConfigAction[] _configActions = new ConfigAction[0];
    private ILogger _traceLogger = TAMConfigLoggers.getInstance().getTraceLogger();
    private ILogger _messageLogger = TAMConfigLoggers.getInstance().getMessageLogger();
    private static final String CLASSNAME = (class$com$tivoli$pd$as$jacc$cfg$TAMConfigController == null ? (class$com$tivoli$pd$as$jacc$cfg$TAMConfigController = TAMConfigController.class$("com.tivoli.pd.as.jacc.cfg.TAMConfigController")) : class$com$tivoli$pd$as$jacc$cfg$TAMConfigController).getName();
    static /* synthetic */ Class class$com$tivoli$pd$as$jacc$cfg$TAMConfigController;

    public void setForce(boolean bl) {
        this._force = bl;
    }

    public void setCtxID(String string) {
        this._ctxID = string;
    }

    public void setProperties(Properties properties) {
        this._props = properties;
    }

    public void setConfigStateFilename(String string) {
        this._configStateFilename = string;
    }

    public void addConfigActions(ConfigAction[] configActionArray) {
        this._configActions = configActionArray;
    }

    public void clearConfigActions() {
        this._configActions = new ConfigAction[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws TAMConfigException {
        int n;
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "execute()");
        }
        for (n = 0; n < this._configActions.length; ++n) {
            if (this._traceLogger != null && this._traceLogger.isLogging()) {
                this._traceLogger.text(16L, (Object)CLASSNAME, "execute()", "Checking that the config action " + this._configActions[n].getName() + " has been supplied with sufficient and valid properties.");
            }
            this._configActions[n].setUniqueCtxID(this._ctxID);
            this._configActions[n].setProperties(this._props);
            if (this._configActions[n].isPropertiesValid()) continue;
            AmasMessage amasMessage = new AmasMessage(864636973);
            if (this._messageLogger != null && this._messageLogger.isLogging()) {
                this._messageLogger.text(4L, (Object)CLASSNAME, "execute()", amasMessage.getMessageString());
            }
            throw new TAMConfigException(amasMessage.getMessageString());
        }
        for (n = 0; n < this._configActions.length; ++n) {
            if (this._force) {
                this._configActions[n].setForce(true);
            }
            if (!this._configActions[n].isReadyToBeExecuted()) continue;
            ConfigStateProperties configStateProperties = new ConfigStateProperties(this._configStateFilename);
            try {
                try {
                    configStateProperties.load();
                }
                catch (IOException iOException) {
                    AmasMessage amasMessage = new AmasMessage(864636965, new Object[]{configStateProperties.getConfigStateFilename(), iOException.toString()});
                    throw new TAMConfigException(amasMessage.getMessageString());
                }
                this._configActions[n].setConfigStateProperties(configStateProperties);
                try {
                    this._configActions[n].execute();
                    continue;
                }
                catch (ConfigActionFailedException configActionFailedException) {
                    AmasMessage amasMessage = new AmasMessage(864636976, configActionFailedException.toString());
                    if (this._messageLogger != null && this._messageLogger.isLogging()) {
                        this._messageLogger.text(4L, (Object)CLASSNAME, "execute()", amasMessage.getMessageString());
                    }
                    throw new TAMConfigException(amasMessage.getMessageString());
                }
            }
            finally {
                configStateProperties.finished();
            }
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "execute()");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

