/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pd.as.jacc.cfg;

import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.exception.RepositoryException;
import com.tivoli.pd.as.jacc.cfg.ConfigAction;
import com.tivoli.pd.as.jacc.cfg.ConfigureAmjaccConfigAction;
import com.tivoli.pd.as.jacc.cfg.ConfigureAuthenticationConfigAction;
import com.tivoli.pd.as.jacc.cfg.ConfigureAuthzTableConfigAction;
import com.tivoli.pd.as.jacc.cfg.ConfigurePdJrteConfigAction;
import com.tivoli.pd.as.jacc.cfg.ConfigureSvrSslCfgAuthzTableConfigAction;
import com.tivoli.pd.as.jacc.cfg.ConfigureSvrSslCfgConfigAction;
import com.tivoli.pd.as.jacc.cfg.JAASConfigAction;
import com.tivoli.pd.as.jacc.cfg.JAASUnconfigAction;
import com.tivoli.pd.as.jacc.cfg.MigrateToTAMConfigAction;
import com.tivoli.pd.as.jacc.cfg.ModifyAuthenticationConfigAction;
import com.tivoli.pd.as.jacc.cfg.ModifySvrSslCfgConfigAction;
import com.tivoli.pd.as.jacc.cfg.PasswordCoder;
import com.tivoli.pd.as.jacc.cfg.RollbackMigrateConfigAction;
import com.tivoli.pd.as.jacc.cfg.SequenceNumberHelper;
import com.tivoli.pd.as.jacc.cfg.TAMConfigConstants;
import com.tivoli.pd.as.jacc.cfg.TAMConfigController;
import com.tivoli.pd.as.jacc.cfg.TAMConfigException;
import com.tivoli.pd.as.jacc.cfg.TAMConfigLoggers;
import com.tivoli.pd.as.jacc.cfg.TAMConfigStringGenerator;
import com.tivoli.pd.as.jacc.cfg.TAMConfigUtils;
import com.tivoli.pd.as.jacc.cfg.UnconfigureAmjaccConfigAction;
import com.tivoli.pd.as.jacc.cfg.UnconfigureAuthenticationConfigAction;
import com.tivoli.pd.as.jacc.cfg.UnconfigureAuthzTableConfigAction;
import com.tivoli.pd.as.jacc.cfg.UnconfigurePdJrteConfigAction;
import com.tivoli.pd.as.jacc.cfg.UnconfigureSvrSslCfgAuthzTableConfigAction;
import com.tivoli.pd.as.jacc.cfg.UnconfigureSvrSslCfgConfigAction;
import com.tivoli.pd.as.util.AmasMessage;
import com.tivoli.pd.jadmin.PDAdmin;
import com.tivoli.pd.jras.pdjlog.jlog.ILogger;
import com.tivoli.pd.jutil.PDException;
import com.tivoli.pd.jutil.PDMessages;
import java.io.IOException;
import java.util.Properties;

public class TAMConfigService {
    private final String TAMConfigService_java_sourceCodeID = "$Id: @(#)71  1.20 src/jacc/com/tivoli/pd/as/jacc/cfg/TAMConfigService.java, amemb.jacc.was, amemb600, 071009a 07/10/09 01:35:43 @(#) $";
    public static final String sCopyright = "IBM Confidential\nObject Code Only Source Materials\n5747-SM3\n(c) Copyright International Business Machines Corp. 1994-2002.  All Rights Reserved.\nThe source code for this program is not published or otherwise divested\nof its trade secrets, irrespective of what has been deposited with the\nU.S. Copyright Office.\n";
    private static final String CLASSNAME = (class$com$tivoli$pd$as$jacc$cfg$TAMConfigService == null ? (class$com$tivoli$pd$as$jacc$cfg$TAMConfigService = TAMConfigService.class$("com.tivoli.pd.as.jacc.cfg.TAMConfigService")) : class$com$tivoli$pd$as$jacc$cfg$TAMConfigService).getName();
    private Properties _globalActionProps = null;
    private Properties _nodeActionProps = null;
    private Properties _localProps = null;
    private String _cellName = null;
    private String _nodeName = null;
    private String _serverName = null;
    private String _globalActionConfigFilename = null;
    private String _nodeActionConfigFilename = null;
    private String _localConfigFilename = null;
    private TAMConfigStringGenerator _stringGenerator = TAMConfigUtils.getStringGeneratorForCtx();
    private boolean _config = true;
    private Session _cfgSession = null;
    private ILogger _traceLogger = null;
    private ILogger _messageLogger = null;
    static /* synthetic */ Class class$com$tivoli$pd$as$jacc$cfg$TAMConfigService;

    public TAMConfigService(Session session) throws TAMConfigException {
        try {
            String string = this._stringGenerator.getStringFromTemplate("${COMMON_FILE_LOCATION}");
            if (string != null) {
                System.out.println(CLASSNAME + " " + "initialize() About to initialize PDAdmin with the value " + string);
                Properties properties = new Properties();
                properties.setProperty("pd.cfg.home", string);
                PDAdmin.initialize((String)"AMJACC", (Properties)properties, (PDMessages)new PDMessages());
            } else {
                PDAdmin.initialize((String)"AMJACC", (PDMessages)new PDMessages());
            }
        }
        catch (PDException pDException) {
            System.out.println(CLASSNAME + " initialize() Caught PDException while initializing PDAdmin. The details are: " + pDException.toString());
        }
        this._cfgSession = session;
        TAMConfigUtils.initializeLogging(this._stringGenerator);
        this._traceLogger = TAMConfigLoggers.getInstance().getTraceLogger();
        this._messageLogger = TAMConfigLoggers.getInstance().getMessageLogger();
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "TAMConfigService()");
        }
        this._cellName = this._stringGenerator.getStringFromTemplate("${CELL_NAME}");
        this._nodeName = this._stringGenerator.getStringFromTemplate("${NODE_NAME}");
        this._serverName = this._stringGenerator.getStringFromTemplate("${SERVER_NAME}");
        this._globalActionConfigFilename = this._stringGenerator.getStringFromTemplate("cells/${CELL_NAME}/amwas.action.properties");
        this._nodeActionConfigFilename = this._stringGenerator.getStringFromTemplate("cells/${CELL_NAME}/nodes/${NODE_NAME}/amwas.action.properties");
        this._localConfigFilename = this._stringGenerator.getStringFromTemplate("${WAS_PROFILES_ROOT}/etc/tam/amwas.${NODE_NAME}_${SERVER_NAME}.config.properties");
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "TAMConfigService() returning " + this);
        }
    }

    private void loadActionConfig() throws TAMConfigException {
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "loadActionConfig()");
        }
        String string = null;
        try {
            if (this._traceLogger != null && this._traceLogger.isLogging()) {
                this._traceLogger.text(16L, (Object)CLASSNAME, "loadActionConfig()", "Loading global action config properties from " + this._globalActionConfigFilename);
            }
            string = this._globalActionConfigFilename;
            this._globalActionProps = TAMConfigUtils.readCfgRepositoryProperties(this._globalActionConfigFilename);
            this._globalActionProps.setProperty("actionfileused", "global");
            if (this._traceLogger != null && this._traceLogger.isLogging()) {
                this._traceLogger.text(16L, (Object)CLASSNAME, "loadActionConfig()", "Loading node-level action config properties from " + this._nodeActionConfigFilename);
            }
            string = this._nodeActionConfigFilename;
            this._nodeActionProps = TAMConfigUtils.readCfgRepositoryProperties(this._nodeActionConfigFilename);
            this._nodeActionProps.setProperty("actionfileused", "node");
        }
        catch (IOException iOException) {
            AmasMessage amasMessage = new AmasMessage(864636965, new Object[]{string, iOException.toString()});
            if (this._messageLogger != null && this._messageLogger.isLogging()) {
                this._messageLogger.text(4L, (Object)CLASSNAME, "loadActionConfig()", amasMessage.getMessageString());
            }
            throw new TAMConfigException(amasMessage.getMessageString());
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "loadActionConfig()");
        }
    }

    private void loadLocalConfig() throws TAMConfigException {
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "loadLocalConfig()");
        }
        try {
            if (this._traceLogger != null && this._traceLogger.isLogging()) {
                this._traceLogger.text(16L, (Object)CLASSNAME, "loadLocalConfig()", "Loading local config properties from " + this._localConfigFilename);
            }
            this._localProps = TAMConfigUtils.readProperties(this._localConfigFilename);
        }
        catch (IOException iOException) {
            AmasMessage amasMessage = new AmasMessage(864636965, new Object[]{this._localConfigFilename, iOException.toString()});
            if (this._messageLogger != null && this._messageLogger.isLogging()) {
                this._messageLogger.text(4L, (Object)CLASSNAME, "loadLocalConfig()", amasMessage.getMessageString());
            }
            throw new TAMConfigException(amasMessage.getMessageString());
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "loadLocalConfig()");
        }
    }

    private void storeLocalConfig() throws TAMConfigException {
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "storeLocalConfig()");
        }
        if (this._localProps != null) {
            try {
                TAMConfigUtils.writeProperties(this._localProps, this._localConfigFilename, "Embedded Tivoli Access Manager configuration sequence numbers - THIS FILE IS MACHINE GENERATED - PLEASE DO NOT EDIT");
            }
            catch (IOException iOException) {
                AmasMessage amasMessage = new AmasMessage(864636966, new Object[]{this._localConfigFilename, iOException.toString()});
                if (this._messageLogger != null && this._messageLogger.isLogging()) {
                    this._messageLogger.text(4L, (Object)CLASSNAME, "storeLocalConfig()", amasMessage.getMessageString());
                }
                throw new TAMConfigException(amasMessage.getMessageString());
            }
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "storeLocalConfig()");
        }
    }

    private void processAction(Properties properties) throws TAMConfigException {
        String string;
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "processAction(Properties) actionProps = " + properties);
        }
        String string2 = properties.getProperty("action");
        String string3 = string = properties == this._nodeActionProps ? this._nodeActionConfigFilename : this._globalActionConfigFilename;
        if (string2 != null) {
            int n;
            ConfigAction[] configActionArray;
            TAMConfigController tAMConfigController = new TAMConfigController();
            String string4 = this._cellName.equals("") ? "N/A" : this._cellName;
            String string5 = this._nodeName.equals("") ? "N/A" : this._nodeName;
            String string6 = this._serverName.equals("") ? "N/A" : this._serverName;
            AmasMessage amasMessage = new AmasMessage(864636969, new Object[]{string2, string4, string5, string6});
            if (this._messageLogger != null && this._messageLogger.isLogging()) {
                this._messageLogger.text(1L, (Object)CLASSNAME, "processAction(Properties)", amasMessage.getMessageString());
            }
            ConfigAction[] configActionArray2 = new ConfigAction[]{new ConfigurePdJrteConfigAction(), new ConfigureAuthenticationConfigAction(), new ConfigureSvrSslCfgConfigAction(), new ConfigureSvrSslCfgAuthzTableConfigAction(), new ConfigureAmjaccConfigAction(), new ConfigureAuthzTableConfigAction(), new MigrateToTAMConfigAction()};
            ConfigAction[] configActionArray3 = new ConfigAction[]{new ModifySvrSslCfgConfigAction(), new ModifyAuthenticationConfigAction()};
            ConfigAction[] configActionArray4 = new ConfigAction[]{new RollbackMigrateConfigAction(), new UnconfigureSvrSslCfgAuthzTableConfigAction(), new UnconfigureSvrSslCfgConfigAction(), new UnconfigureAuthenticationConfigAction(), new UnconfigureAuthzTableConfigAction(), new UnconfigureAmjaccConfigAction(), new UnconfigurePdJrteConfigAction()};
            if (string2.equalsIgnoreCase("config")) {
                tAMConfigController.addConfigActions(configActionArray2);
            } else if (string2.equalsIgnoreCase("modify")) {
                tAMConfigController.addConfigActions(configActionArray3);
            } else if (string2.equalsIgnoreCase("unconfig")) {
                tAMConfigController.addConfigActions(configActionArray4);
            } else if (string2.equalsIgnoreCase("reconfig")) {
                configActionArray = new ConfigAction[configActionArray4.length + configActionArray2.length];
                for (n = 0; n < configActionArray4.length; ++n) {
                    configActionArray[n] = configActionArray4[n];
                }
                for (n = 0; n < configActionArray2.length; ++n) {
                    configActionArray[n + configActionArray4.length] = configActionArray2[n];
                }
                tAMConfigController.addConfigActions(configActionArray);
            } else if (string2.equalsIgnoreCase("jaasconfig")) {
                configActionArray = new ConfigAction[]{new JAASConfigAction(this._cfgSession)};
                tAMConfigController.addConfigActions(configActionArray);
            } else if (string2.equalsIgnoreCase("jaasunconfig")) {
                configActionArray = new ConfigAction[]{new JAASUnconfigAction(this._cfgSession)};
                tAMConfigController.addConfigActions(configActionArray);
            } else {
                AmasMessage amasMessage2 = new AmasMessage(864636974, new Object[]{"action", string2, string});
                if (this._messageLogger != null && this._messageLogger.isLogging()) {
                    this._messageLogger.text(4L, (Object)CLASSNAME, "processAction(Properties)", amasMessage2.getMessageString());
                }
                throw new TAMConfigException(amasMessage2.getMessageString());
            }
            configActionArray = new PasswordCoder(null);
            for (n = 0; n < TAMConfigConstants.PASSWORDS.length; ++n) {
                String string7 = properties.getProperty(TAMConfigConstants.PASSWORDS[n]);
                if (string7 == null) continue;
                string7 = configActionArray.decode(string7);
                properties.setProperty(TAMConfigConstants.PASSWORDS[n], string7);
            }
            TAMConfigUtils.setExtraConfigProperties(properties, this._stringGenerator);
            tAMConfigController.setProperties(properties);
            tAMConfigController.setForce(TAMConfigUtils.isTrue(properties.getProperty("force")));
            tAMConfigController.setCtxID(properties.getProperty("uniqueCtxString"));
            tAMConfigController.setConfigStateFilename(properties.getProperty("commonConfigFilename"));
            tAMConfigController.execute();
            amasMessage = new AmasMessage(864636970, new Object[]{string2, string4, string5, string6});
            if (this._messageLogger != null && this._messageLogger.isLogging()) {
                this._messageLogger.text(1L, (Object)CLASSNAME, "processAction(Properties)", amasMessage.getMessageString());
            }
        } else {
            AmasMessage amasMessage = new AmasMessage(864636975, new Object[]{"action", string});
            if (this._messageLogger != null && this._messageLogger.isLogging()) {
                this._messageLogger.text(4L, (Object)CLASSNAME, "processAction(Properties)", amasMessage.getMessageString());
            }
            throw new TAMConfigException(amasMessage.getMessageString());
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "processAction(Properties)");
        }
    }

    public void initializeZOS(boolean bl) throws TAMConfigException {
        this._config = bl;
        this.initialize();
    }

    public void initialize() throws TAMConfigException {
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "initialize()");
        }
        SequenceNumberHelper sequenceNumberHelper = new SequenceNumberHelper();
        this.loadActionConfig();
        sequenceNumberHelper.setActionProps(this._nodeActionProps, this._nodeName, 1);
        sequenceNumberHelper.setActionProps(this._globalActionProps, "", 0);
        boolean bl = TAMConfigUtils.isServant();
        if (sequenceNumberHelper.isActionPropsPending()) {
            String string;
            this.loadLocalConfig();
            sequenceNumberHelper.setLocalProps(this._localProps);
            Properties properties = null;
            if (bl) {
                string = this._localProps.getProperty("actionfileused");
                properties = string == null ? sequenceNumberHelper.getBestActionProps() : (string.equals("global") ? this._globalActionProps : this._nodeActionProps);
                if (this._config) {
                    properties.setProperty("action", "config");
                } else {
                    properties.setProperty("action", "unconfig");
                }
            } else {
                properties = sequenceNumberHelper.getBestActionProps();
            }
            if (properties != null) {
                if (this._traceLogger != null && this._traceLogger.isLogging()) {
                    this._traceLogger.text(16L, (Object)CLASSNAME, "initialize()", "About to perform the configuration action defined by the properties " + properties);
                }
                this.processAction(properties);
                string = properties.getProperty("action");
                if (!string.equalsIgnoreCase("jaasconfig") && !string.equalsIgnoreCase("jaasunconfig")) {
                    sequenceNumberHelper.markDone(null);
                    this._localProps.setProperty("actionfileused", properties.getProperty("actionfileused"));
                }
                if (!bl) {
                    this.storeLocalConfig();
                }
                if (this._stringGenerator.getRewriteForceEntry() && (string.equalsIgnoreCase("config") || string.equalsIgnoreCase("reconfig"))) {
                    this.udpateAllActionFiles();
                }
            } else if (this._traceLogger != null && this._traceLogger.isLogging()) {
                this._traceLogger.text(16L, (Object)CLASSNAME, "initialize()", "Already processed all action config properties - doing nothing");
            }
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "initialize()");
        }
    }

    private void udpateAllActionFiles() {
        this.updateActionFile(this._nodeActionConfigFilename);
        this.updateActionFile(this._globalActionConfigFilename);
    }

    private void updateActionFile(String string) {
        block6: {
            if (string != null) {
                try {
                    String string2;
                    Properties properties = TAMConfigUtils.readCfgRepositoryProperties(string);
                    if (properties != null && (string2 = properties.getProperty("action")) != null && (string2.equalsIgnoreCase("config") || string2.equalsIgnoreCase("reconfig")) && TAMConfigUtils.isTrue(properties.getProperty("force"))) {
                        properties.setProperty("force", "no");
                        TAMConfigUtils.writeCfgRepositoryProperties(properties, string, "Embedded Tivoli Access Manager configuration action parameters - THIS FILE IS MACHINE GENERATED - PLEASE DO NOT EDIT");
                    }
                }
                catch (IOException iOException) {
                    AmasMessage amasMessage = new AmasMessage(864636966, new Object[]{string, iOException.toString()});
                    if (this._messageLogger != null && this._messageLogger.isLogging()) {
                        this._messageLogger.text(16L, (Object)CLASSNAME, "populateActionConfigFile(Properties, SimpleAdminCommand)", amasMessage.getMessageString());
                    }
                }
                catch (RepositoryException repositoryException) {
                    AmasMessage amasMessage = new AmasMessage(864636966, new Object[]{string, repositoryException.toString()});
                    if (this._messageLogger == null || !this._messageLogger.isLogging()) break block6;
                    this._messageLogger.text(16L, (Object)CLASSNAME, "populateActionConfigFile(Properties, SimpleAdminCommand)", amasMessage.getMessageString());
                }
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

