/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pd.as.jacc.cfg;

import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.tivoli.pd.as.jacc.cfg.TAMConfigConstants;
import com.tivoli.pd.as.jacc.cfg.TAMConfigUtils;
import java.io.File;
import java.io.IOException;
import java.util.Properties;

public class TAMConfigStringGenerator {
    private final String TAMConfigStringGenerator_java_sourceCodeID = "$Id: @(#)72  1.18 src/jacc/com/tivoli/pd/as/jacc/cfg/TAMConfigStringGenerator.java, amemb.jacc.was, amemb600, 071025a 07/10/25 01:29:37 @(#) $";
    public static final String sCopyright = "IBM Confidential\nObject Code Only Source Materials\n5747-SM3\n(c) Copyright International Business Machines Corp. 1994-2002.  All Rights Reserved.\nThe source code for this program is not published or otherwise divested\nof its trade secrets, irrespective of what has been deposited with the\nU.S. Copyright Office.\n";
    private static final String CLASSNAME = "com.tivoli.pd.as.jacc.cfg.TAMConfigStringGenerator";
    String _wasRoot = null;
    String _wasConfigRoot = null;
    String _cellName = null;
    static String _nodeName = null;
    static String _javaHome = null;
    static String _serverName = null;
    static String _wasJvmHome = null;
    String _wasProfilesRoot = null;
    String _commFileLocation = null;
    String _commPDFileLocation = null;
    String _ignoreAuthTableEntry = null;
    String _svrSslCfgDbRefreshEntry = null;
    boolean _rewriteForceEntry = true;
    boolean _leavePolicyRefreshDmgr = false;
    boolean _authTableRemoteMode = false;
    String _timeoutPeriod = null;
    String _commPDHome = null;
    String _stoken = null;
    private static boolean _jvmHomeInitialized = false;

    public TAMConfigStringGenerator(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        this.setWASRoot(string);
        this.setJavaHome(string2);
        this.setWASConfigRoot(string3);
        this.setCellName(string4);
        this.setNodeName(string5);
        this.setServerName(string6);
        this.setWASProfilesRoot(string7);
        this.setPDHome("${WAS_JVM_HOME}/PolicyDirector");
        String string8 = null;
        String string9 = null;
        String string10 = null;
        String string11 = null;
        String string12 = null;
        String string13 = null;
        String string14 = null;
        String string15 = null;
        String string16 = null;
        try {
            String string17 = this.getStringFromTemplate("cells/${CELL_NAME}/amwas.amjacc.template.properties");
            Properties properties = TAMConfigUtils.readCfgRepositoryProperties(string17);
            if (TAMConfigUtils.isZOS()) {
                this.setWasJavaHome(_nodeName, _serverName);
            } else {
                _wasJvmHome = _javaHome;
            }
            string8 = properties.getProperty("com.tivoli.pd.as.jacc.CommonFileLocation");
            string10 = properties.getProperty("com.tivoli.pd.as.jacc.ConfigTimeout");
            string11 = properties.getProperty("com.tivoli.pd.as.amwas.DisableAddAuthorizationTableEntry");
            string12 = properties.getProperty("com.tivoli.pd.as.jacc.CellHasZosEntry");
            string13 = properties.getProperty("com.tivoli.pd.as.jacc.DmgrPolicyRefresh");
            string14 = properties.getProperty("com.tivoli.pd.as.jacc.DBRefresh", "7200");
            string15 = properties.getProperty("com.tivoli.pd.as.jacc.AuthTableRemoteMode");
            string16 = properties.getProperty("com.tivoli.pd.as.jacc.PDHome");
        }
        catch (IOException iOException) {
            System.out.println("com.tivoli.pd.as.jacc.cfg.TAMConfigStringGenerator  Constructor : An error occurred reading the template properties file.");
            string8 = null;
            string10 = null;
            string11 = null;
            string12 = null;
            string14 = "7200";
            string15 = null;
            string13 = null;
        }
        if (string8 == null) {
            string8 = "${WAS_JVM_HOME}";
            string9 = "${WAS_JVM_HOME}/PolicyDirector";
        } else {
            string9 = string8;
        }
        string8 = this.getStringFromTemplate(string8);
        string9 = this.getStringFromTemplate(string9);
        this.setCommonFileLocation(string8);
        this.setCommonPDFileLocation(string9);
        this.setIgnoreAuthTableEntry(string11);
        this.setRewriteForceEntry(string12);
        this.setTimeoutPeriod(string10);
        this.setSvrSslCfgDbRefresh(string14);
        this.setAuthTableRemoteMode(string15);
        this.setLeavePolicyRefreshDmgr(string13);
        if (string16 == null) {
            string16 = "${WAS_JVM_HOME}/PolicyDirector";
        }
        string16 = this.getStringFromTemplate(string16);
        this.setPDHome(string16);
        this._stoken = TAMConfigUtils.getServantToken();
    }

    public String getStringFromTemplate(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string;
        string2 = string2.replaceAll("\\$\\{WAS_JVM_HOME\\}", _wasJvmHome);
        string2 = string2.replaceAll("\\$\\{WAS_ROOT\\}", this._wasRoot);
        string2 = string2.replaceAll("\\$\\{JAVA_HOME\\}", _javaHome);
        string2 = string2.replaceAll("\\$\\{WAS_CONFIG_ROOT\\}", this._wasConfigRoot);
        string2 = string2.replaceAll("\\$\\{CELL_NAME\\}", this._cellName);
        string2 = string2.replaceAll("\\$\\{NODE_NAME\\}", _nodeName);
        string2 = string2.replaceAll("\\$\\{SERVER_NAME\\}", _serverName);
        string2 = string2.replaceAll("\\$\\{WAS_PROFILES_ROOT\\}", this._wasProfilesRoot);
        string2 = string2.replaceAll("\\$\\{COMMON_FILE_LOCATION\\}", this._commFileLocation);
        string2 = string2.replaceAll("\\$\\{COMMON_FILE_LOCATION_PD\\}", this._commPDFileLocation);
        string2 = string2.replaceAll("\\$\\{COMMON_PD_HOME\\}", this._commPDHome);
        string2 = string2.replaceAll("\\$\\{STOKEN\\}", this._stoken);
        if (File.separatorChar == '\\') {
            string2 = string2.replace('/', '\\');
        } else if (File.separatorChar == '/') {
            string2 = string2.replace('\\', '/');
        }
        return string2;
    }

    public String getFileFromTemplate(String string, String string2) {
        if (string == null || string2 == null) {
            return null;
        }
        String string3 = string;
        string3 = string3.replaceAll("\\$\\{WAS_JVM_HOME\\}", _wasJvmHome);
        string3 = string3.replaceAll("\\$\\{WAS_ROOT\\}", this._wasRoot);
        string3 = string3.replaceAll("\\$\\{JAVA_HOME\\}", _javaHome);
        string3 = string3.replaceAll("\\$\\{WAS_CONFIG_ROOT\\}", this._wasConfigRoot);
        string3 = string3.replaceAll("\\$\\{CELL_NAME\\}", this._cellName);
        string3 = string3.replaceAll("\\$\\{NODE_NAME\\}", _nodeName);
        string3 = string3.replaceAll("\\$\\{SERVER_NAME\\}", string2);
        string3 = string3.replaceAll("\\$\\{WAS_PROFILES_ROOT\\}", this._wasProfilesRoot);
        string3 = string3.replaceAll("\\$\\{COMMON_FILE_LOCATION\\}", this._commFileLocation);
        string3 = string3.replaceAll("\\$\\{COMMON_FILE_LOCATION_PD\\}", this._commPDFileLocation);
        string3 = string3.replaceAll("\\$\\{COMMON_PD_HOME\\}", this._commPDHome);
        string3 = string3.replaceAll("\\$\\{STOKEN\\}", this._stoken);
        if (File.separatorChar == '\\') {
            string3 = string3.replace('/', '\\');
        } else if (File.separatorChar == '/') {
            string3 = string3.replace('\\', '/');
        }
        return string3;
    }

    private String escapeReplacementString(String string) {
        return string.replaceAll("\\\\", "\\\\\\\\");
    }

    public void setCellName(String string) {
        this._cellName = string != null ? this.escapeReplacementString(string) : "";
    }

    public void setNodeName(String string) {
        _nodeName = string != null ? this.escapeReplacementString(string) : "";
    }

    public void setServerName(String string) {
        _serverName = string != null ? this.escapeReplacementString(string) : "";
    }

    public void setWASConfigRoot(String string) {
        this._wasConfigRoot = string != null ? this.escapeReplacementString(string) : "";
    }

    public void setWASRoot(String string) {
        this._wasRoot = string != null ? this.escapeReplacementString(string) : "";
    }

    public void setWASProfilesRoot(String string) {
        this._wasProfilesRoot = string != null ? this.escapeReplacementString(string) : "";
    }

    public void setJavaHome(String string) {
        _javaHome = string != null ? this.escapeReplacementString(string) : "";
    }

    public void setCommonFileLocation(String string) {
        this._commFileLocation = string != null ? this.escapeReplacementString(string) : "";
    }

    public void setCommonPDFileLocation(String string) {
        this._commPDFileLocation = string != null ? this.escapeReplacementString(string) : "";
    }

    public void setTimeoutPeriod(String string) {
        this._timeoutPeriod = string;
    }

    public String getTimeoutPeriod() {
        return this._timeoutPeriod;
    }

    public void setIgnoreAuthTableEntry(String string) {
        this._ignoreAuthTableEntry = string;
    }

    public String getIgnoreAuthTableEntry() {
        return this._ignoreAuthTableEntry;
    }

    public void setSvrSslCfgDbRefresh(String string) {
        this._svrSslCfgDbRefreshEntry = string;
    }

    public String getSvrSslCfgDbRefresh() {
        return this._svrSslCfgDbRefreshEntry;
    }

    public void setRewriteForceEntry(String string) {
        this._rewriteForceEntry = string == null || !string.equalsIgnoreCase("false") && !string.equalsIgnoreCase("no");
    }

    public boolean getRewriteForceEntry() {
        return this._rewriteForceEntry;
    }

    public void setLeavePolicyRefreshDmgr(String string) {
        this._leavePolicyRefreshDmgr = string != null && (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes"));
    }

    public boolean getLeavePolicyRefreshDmgr() {
        return this._leavePolicyRefreshDmgr;
    }

    public void setAuthTableRemoteMode(String string) {
        this._authTableRemoteMode = string != null && (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes"));
    }

    public boolean getAuthTableRemoteMode() {
        return this._authTableRemoteMode;
    }

    public void setPDHome(String string) {
        this._commPDHome = string != null ? this.escapeReplacementString(string) : "";
    }

    public String getPDHome() {
        return this._commPDHome;
    }

    public void setStoken(String string) {
        this._stoken = string;
    }

    private synchronized void setWasJavaHome(String string, String string2) {
        if (_jvmHomeInitialized) {
            return;
        }
        _jvmHomeInitialized = true;
        Session session = new Session();
        try {
            CommandMgr commandMgr = CommandMgr.getCommandMgr();
            AdminCommand adminCommand = commandMgr.createCommand(TAMConfigConstants.GET_JAVA_HOME);
            adminCommand.setConfigSession(session);
            adminCommand.setParameter(TAMConfigConstants.NODENAME, string);
            adminCommand.setParameter(TAMConfigConstants.SERVERNAME, string2);
            adminCommand.setParameter(TAMConfigConstants.MODE, TAMConfigConstants.BIT_THIRTY_ONE);
            adminCommand.execute();
            CommandResult commandResult = adminCommand.getCommandResult();
            if (commandResult.isSuccessful()) {
                Object object = commandResult.getResult();
                _wasJvmHome = (String)object;
            } else {
                _wasJvmHome = _javaHome;
            }
        }
        catch (Exception exception) {
            System.out.println("com.tivoli.pd.as.jacc.cfg.TAMConfigStringGeneratorAn error was encountered while attempting to retrieve the z/os java home property.  The default system property JAVA_HOME will be used the details are: " + exception.toString());
            _wasJvmHome = _javaHome;
        }
    }
}

