/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pd.as.jacc.cfg;

import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.RepositoryException;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.websphere.management.repository.Document;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.tivoli.pd.as.jacc.cfg.ConfigActionFailedException;
import com.tivoli.pd.as.jacc.cfg.LockableFile;
import com.tivoli.pd.as.jacc.cfg.PDServer;
import com.tivoli.pd.as.jacc.cfg.PortRangeDecoder;
import com.tivoli.pd.as.jacc.cfg.TAMConfigConstants;
import com.tivoli.pd.as.jacc.cfg.TAMConfigException;
import com.tivoli.pd.as.jacc.cfg.TAMConfigLoggers;
import com.tivoli.pd.as.jacc.cfg.TAMConfigStringGenerator;
import com.tivoli.pd.as.rbpf.AmasSession;
import com.tivoli.pd.as.util.AmasMessage;
import com.tivoli.pd.as.util.AmasPDHelper;
import com.tivoli.pd.jadmin.PDAdmin;
import com.tivoli.pd.jazn.PDAuthorizationContext;
import com.tivoli.pd.jras.pdjlog.jlog.ILogger;
import com.tivoli.pd.jutil.PDContext;
import com.tivoli.pd.jutil.PDException;
import com.tivoli.pd.jutil.PDMessages;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.management.ObjectName;

public class TAMConfigUtils {
    private final String TAMConfigUtils_java_sourceCodeID = "$Id: @(#)73  1.28 src/jacc/com/tivoli/pd/as/jacc/cfg/TAMConfigUtils.java, amemb.jacc.was, amemb600, 051118a 05/04/14 01:00:15 @(#) $";
    public static final String sCopyright = "IBM Confidential\nObject Code Only Source Materials\n5747-SM3\n(c) Copyright International Business Machines Corp. 1994-2002.  All Rights Reserved.\nThe source code for this program is not published or otherwise divested\nof its trade secrets, irrespective of what has been deposited with the\nU.S. Copyright Office.\n";
    private static final String CLASSNAME = (class$com$tivoli$pd$as$jacc$cfg$TAMConfigUtils == null ? (class$com$tivoli$pd$as$jacc$cfg$TAMConfigUtils = TAMConfigUtils.class$("com.tivoli.pd.as.jacc.cfg.TAMConfigUtils")) : class$com$tivoli$pd$as$jacc$cfg$TAMConfigUtils).getName();
    private static boolean _servant = false;
    private static boolean _controller = false;
    private static boolean _zos = false;
    private static String _stoken;
    static /* synthetic */ Class class$com$tivoli$pd$as$jacc$cfg$TAMConfigUtils;

    public static void setServant(boolean bl) {
        _servant = bl;
    }

    public static boolean isServant() {
        return _servant;
    }

    public static boolean isController() {
        return _controller;
    }

    public static boolean isZOS() {
        return _zos;
    }

    public static String getServantToken() {
        return _stoken;
    }

    public static String getJACCSvrSslCfgFilename() {
        TAMConfigStringGenerator tAMConfigStringGenerator = TAMConfigUtils.getStringGeneratorForCtx();
        return tAMConfigStringGenerator.getStringFromTemplate("${WAS_PROFILES_ROOT}/etc/tam/amwas.${NODE_NAME}_${SERVER_NAME}.pdperm.properties");
    }

    public static String getAMSvrSSLCfgFilename() {
        TAMConfigStringGenerator tAMConfigStringGenerator = TAMConfigUtils.getStringGeneratorForCtx();
        return tAMConfigStringGenerator.getStringFromTemplate("${COMMON_FILE_LOCATION}/PdPerm.properties");
    }

    public static String getWASHome() {
        TAMConfigStringGenerator tAMConfigStringGenerator = TAMConfigUtils.getStringGeneratorForCtx();
        return tAMConfigStringGenerator.getStringFromTemplate("${WAS_ROOT}");
    }

    public static String getAMAuthzTableConfigFilename() {
        TAMConfigStringGenerator tAMConfigStringGenerator = TAMConfigUtils.getStringGeneratorForCtx();
        if (_servant) {
            return tAMConfigStringGenerator.getStringFromTemplate("${WAS_PROFILES_ROOT}/etc/tam/amwas.${NODE_NAME}_${SERVER_NAME}_${STOKEN}.authztable.properties");
        }
        return tAMConfigStringGenerator.getStringFromTemplate("${WAS_PROFILES_ROOT}/etc/tam/amwas.${NODE_NAME}_${SERVER_NAME}.authztable.properties");
    }

    public static String getAMJACCConfigFilename() {
        TAMConfigStringGenerator tAMConfigStringGenerator = TAMConfigUtils.getStringGeneratorForCtx();
        if (_servant) {
            return tAMConfigStringGenerator.getStringFromTemplate("${WAS_PROFILES_ROOT}/etc/tam/amwas.${NODE_NAME}_${SERVER_NAME}_${STOKEN}.amjacc.properties");
        }
        return tAMConfigStringGenerator.getStringFromTemplate("${WAS_PROFILES_ROOT}/etc/tam/amwas.${NODE_NAME}_${SERVER_NAME}.amjacc.properties");
    }

    public static String getAMJACCAuthnCfgFilename() {
        TAMConfigStringGenerator tAMConfigStringGenerator = TAMConfigUtils.getStringGeneratorForCtx();
        return tAMConfigStringGenerator.getStringFromTemplate("${COMMON_FILE_LOCATION}/PdPerm.properties");
    }

    public static String filenameToURL(String string) {
        return "file:" + (System.getProperty("os.name").startsWith("Windows") ? "/" : "") + string;
    }

    static String getPropertyFromFile(ILogger iLogger, String string, String string2) throws ConfigActionFailedException {
        if (iLogger != null && iLogger.isLogging()) {
            iLogger.entry(80L, (Object)CLASSNAME, "getPropertyFromFile(ILogger, String, String) logger = " + iLogger + " filename = " + string + " name = " + string2);
        }
        Properties properties = null;
        try {
            if (iLogger != null && iLogger.isLogging()) {
                iLogger.text(16L, (Object)CLASSNAME, "getPropertyFromFile(ILogger, String, String)", "Loading properties from " + string);
            }
            properties = TAMConfigUtils.readProperties(string);
        }
        catch (IOException iOException) {
            AmasMessage amasMessage = new AmasMessage(864636965, new Object[]{string, iOException.toString()});
            throw new ConfigActionFailedException(amasMessage.getMessageString());
        }
        String string3 = properties.getProperty(string2);
        if (string3 == null) {
            AmasMessage amasMessage = new AmasMessage(864636975, new Object[]{string3, string});
            throw new ConfigActionFailedException(amasMessage.getMessageString());
        }
        if (iLogger != null && iLogger.isLogging()) {
            iLogger.exit(96L, (Object)CLASSNAME, "getPropertyFromFile(ILogger, String, String)");
        }
        return string3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void addServerToGroup(ILogger iLogger, String string, String string2, String string3, String string4) throws ConfigActionFailedException {
        block14: {
            if (iLogger != null && iLogger.isLogging()) {
                iLogger.entry(80L, (Object)CLASSNAME, "addServerToAdminGroup(ILogger, String, String, String, String) logger = " + iLogger + " adminUid = " + string + " adminPasswd = ***** adminGroup = " + string3 + " cfgFilename = " + string4);
            }
            String string5 = TAMConfigUtils.getPropertyFromFile(iLogger, string4, "appsvr-username");
            PDAuthorizationContext pDAuthorizationContext = null;
            try {
                try {
                    if (!PDAdmin.isInited()) {
                        if (iLogger != null && iLogger.isLogging()) {
                            iLogger.text(16L, (Object)CLASSNAME, "addServerToAdminGroup(String, String, String)", "Initializing the PDAdmin API");
                        }
                        PDMessages pDMessages = new PDMessages();
                        PDAdmin.initialize((String)"AMWAS Configuration Utility", (PDMessages)pDMessages);
                    }
                    char[] cArray = new char[string2.length()];
                    string2.getChars(0, string2.length(), cArray, 0);
                    if (iLogger != null && iLogger.isLogging()) {
                        iLogger.text(16L, (Object)CLASSNAME, "addServerToAdminGroup(String, String, String)", "Creating a PD authorization context using user ID " + string + " and password **** to check that " + string5 + " is a member of the " + string3 + " group");
                    }
                    if (!AmasPDHelper.userInGroup(string5, string3, (PDContext)(pDAuthorizationContext = new PDAuthorizationContext(string, cArray, new URL(TAMConfigUtils.filenameToURL(string4)))))) {
                        if (iLogger != null && iLogger.isLogging()) {
                            iLogger.text(2L, (Object)CLASSNAME, "addServerToAdminGroup(String, String, String)", "Adding  " + string5 + " to the " + string3 + " group");
                        }
                        AmasPDHelper.addUserToGroup(string5, string3, (PDContext)pDAuthorizationContext);
                    }
                }
                catch (PDException pDException) {
                    AmasMessage amasMessage = new AmasMessage(864636978, new Object[]{string5, string3, string, pDException.toString()});
                    throw new ConfigActionFailedException(amasMessage.getMessageString());
                }
                catch (MalformedURLException malformedURLException) {
                    AmasMessage amasMessage = new AmasMessage(864636978, new Object[]{string5, string3, string, malformedURLException.toString()});
                    throw new ConfigActionFailedException(amasMessage.getMessageString());
                }
                Object var10_11 = null;
                if (pDAuthorizationContext == null) break block14;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                if (pDAuthorizationContext == null) throw throwable;
                try {
                    pDAuthorizationContext.close();
                    throw throwable;
                }
                catch (PDException pDException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (PDException pDException) {}
            pDAuthorizationContext.close();
        }
        if (iLogger == null) return;
        if (!iLogger.isLogging()) return;
        iLogger.exit(96L, (Object)CLASSNAME, "addServerToAdminGroup(ILogger, String, String, String, String)");
    }

    static void setExtraConfigProperties(Properties properties, TAMConfigStringGenerator tAMConfigStringGenerator) {
        int n;
        for (n = 0; n < TAMConfigConstants.COMMON_TEMPLATE_MAPPINGS.length; ++n) {
            properties.setProperty(TAMConfigConstants.COMMON_TEMPLATE_MAPPINGS[n][0], tAMConfigStringGenerator.getStringFromTemplate(TAMConfigConstants.COMMON_TEMPLATE_MAPPINGS[n][1]));
        }
        if (_servant) {
            for (n = 0; n < TAMConfigConstants.ZOS_TEMPLATE_MAPPINGS.length; ++n) {
                properties.setProperty(TAMConfigConstants.ZOS_TEMPLATE_MAPPINGS[n][0], tAMConfigStringGenerator.getStringFromTemplate(TAMConfigConstants.ZOS_TEMPLATE_MAPPINGS[n][1]));
            }
        } else {
            for (n = 0; n < TAMConfigConstants.NONZOS_TEMPLATE_MAPPINGS.length; ++n) {
                properties.setProperty(TAMConfigConstants.NONZOS_TEMPLATE_MAPPINGS[n][0], tAMConfigStringGenerator.getStringFromTemplate(TAMConfigConstants.NONZOS_TEMPLATE_MAPPINGS[n][1]));
            }
        }
    }

    static boolean isDeploymentManager() {
        AdminService adminService = AdminServiceFactory.getAdminService();
        if (adminService == null) {
            throw new IllegalStateException(new AmasMessage(864636983).getMessageString());
        }
        String string = adminService.getProcessType();
        if (string == null) {
            throw new IllegalStateException(new AmasMessage(864636983).getMessageString());
        }
        return string.equals("DeploymentManager");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static TAMConfigStringGenerator getStringGeneratorForCtx() {
        var0 = null;
        var1_1 = null;
        var2_2 = null;
        var3_3 = AdminServiceFactory.getAdminService();
        if (var3_3 != null) ** GOTO lbl38
        var0 = System.getProperty(TAMConfigConstants.LOCAL_CELL_NAME);
        var1_1 = System.getProperty(TAMConfigConstants.LOCAL_NODE_NAME);
        var4_4 = ConfigServiceFactory.getConfigService();
        var5_5 = new Session();
        if (var4_4 != null) {
            try {
                var6_6 = var4_4.resolve((Session)var5_5, TAMConfigConstants.CELL)[0];
                var7_9 = ConfigServiceHelper.createObjectName(null, TAMConfigConstants.SERVER_ENTRY);
                var8_10 /* !! */  = var4_4.queryConfigObjects((Session)var5_5, (ObjectName)var6_6, (ObjectName)var7_9, null);
                if (var8_10 /* !! */  == null) ** GOTO lbl50
                var9_11 = new Hashtable<K, V>();
                for (var10_12 = 0; var10_12 < var8_10 /* !! */ .length; ++var10_12) {
                    var11_13 = var8_10 /* !! */ [var10_12];
                    var12_14 = (String)var4_4.getAttribute((Session)var5_5, var11_13, TAMConfigConstants.SERVER_TYPE);
                    var13_15 = (String)var4_4.getAttribute((Session)var5_5, var11_13, TAMConfigConstants.SERVER_NAME);
                    var9_11.put(var12_14, var13_15);
                }
                if (var9_11.containsKey(TAMConfigConstants.DEPLOYMENT_MANAGER)) {
                    var2_2 = (String)var9_11.get(TAMConfigConstants.DEPLOYMENT_MANAGER);
                }
                if (var9_11.containsKey(TAMConfigConstants.APPLICATION_SERVER)) {
                    var2_2 = (String)var9_11.get(TAMConfigConstants.APPLICATION_SERVER);
                }
                System.out.println(TAMConfigUtils.CLASSNAME + "getStringGeneratorForCtx() An error was encountered while attempting to read the local mode server name. There is no DEPLOYMENT_MANAGER or APPLICATION_SERVER entry in ServerIndex.xml");
                throw new IllegalStateException(new AmasMessage(864636983).getMessageString());
            }
            catch (Exception var6_7) {
                System.out.println(TAMConfigUtils.CLASSNAME + "getStringGeneratorForCtx() An error was encountered while attempting to read the local mode server name. The details are : " + var6_7.toString());
                throw new IllegalStateException(new AmasMessage(864636993, var6_7.toString()).getMessageString());
            }
        } else {
            var6_8 = new AmasMessage(864636992, "ConfigService");
            System.out.println(var6_8.getMessageString());
            throw new IllegalStateException(var6_8.getMessageString());
lbl38:
            // 1 sources

            var4_4 = var3_3.getProcessType();
            if (var4_4 == null) {
                throw new IllegalStateException(new AmasMessage(864636983).getMessageString());
            }
            if (var4_4.equals("NodeAgent")) {
                var2_2 = null;
            } else if (var4_4.equals("ManagedProcess") || var4_4.equals("UnManagedProcess") || var4_4.equals("DeploymentManager")) {
                var2_2 = var3_3.getProcessName();
            } else {
                throw new IllegalStateException(new AmasMessage(864636983).getMessageString());
            }
            var0 = var3_3.getCellName();
            var1_1 = var3_3.getNodeName();
        }
lbl50:
        // 4 sources

        var4_4 = System.getProperty("was.install.root");
        var5_5 = System.getProperty("java.home");
        var6_6 = System.getProperty("user.install.root");
        var7_9 = System.getProperty("was.repository.root");
        if (var7_9 == null && var6_6 != null && !var6_6.equals("")) {
            var7_9 = (String)var6_6 + File.separatorChar + "config";
        }
        if (!(var9_11 = new File((String)(var8_10 /* !! */  = (String)var6_6 + File.separatorChar + "etc" + File.separatorChar + "tam"))).exists()) {
            var9_11.mkdir();
        } else if (!(var9_11.isDirectory() && var9_11.canRead() && var9_11.canWrite())) {
            throw new IllegalStateException(new AmasMessage(864636994, (Object)var8_10 /* !! */ ).getMessageString());
        }
        if (var7_9 == null || var4_4 == null || var5_5 == null || var6_6 == null || var0 == null || var1_1 == null) {
            throw new IllegalStateException(new AmasMessage(864636983).getMessageString());
        }
        return new TAMConfigStringGenerator((String)var4_4, (String)var5_5, (String)var7_9, var0, var1_1, var2_2, (String)var6_6);
    }

    static boolean validateParameter(String string, String string2) {
        boolean bl = true;
        if (string.equals("policySvr")) {
            try {
                ArrayList arrayList = TAMConfigUtils.parseServers(string2 + ":1");
                if (arrayList.size() != 1) {
                    bl = false;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                bl = false;
            }
        } else if (string.equals("authSvrs")) {
            try {
                ArrayList arrayList = TAMConfigUtils.parseServers(string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                bl = false;
            }
        } else if (string.equals("mode")) {
            bl = string2.equals("local") || string2.equals("remote");
        } else if (string.equals("portSet")) {
            try {
                PortRangeDecoder portRangeDecoder = new PortRangeDecoder(string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                bl = false;
            }
        }
        return bl;
    }

    static void initializeLogging(TAMConfigStringGenerator tAMConfigStringGenerator) throws TAMConfigException {
        String string = tAMConfigStringGenerator.getStringFromTemplate("cells/${CELL_NAME}/amwas.pdjlog.template.properties");
        TAMConfigLoggers tAMConfigLoggers = TAMConfigLoggers.getInstance(string);
    }

    static ArrayList parseServers(String string) throws IllegalArgumentException {
        return TAMConfigUtils.parseServers(string, ",");
    }

    static ArrayList parseServers(String string, String string2) throws IllegalArgumentException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        ArrayList<PDServer> arrayList = new ArrayList<PDServer>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(new PDServer(stringTokenizer.nextToken()));
        }
        if (arrayList.size() == 0) {
            throw new IllegalArgumentException();
        }
        return arrayList;
    }

    public static boolean isTrue(String string) {
        boolean bl = false;
        if (string != null && (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes"))) {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void outputProperties(Properties properties, String string, String string2, boolean bl) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string, bl);
            properties.store(fileOutputStream, string2);
            Object var6_5 = null;
            if (fileOutputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (fileOutputStream == null) throw throwable;
            try {
                fileOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            fileOutputStream.close();
            return;
        }
        catch (IOException iOException) {}
    }

    static void appendProperties(Properties properties, String string, String string2) throws IOException {
        TAMConfigUtils.outputProperties(properties, string, string2, true);
    }

    static void writeProperties(Properties properties, String string, String string2) throws IOException {
        TAMConfigUtils.outputProperties(properties, string, string2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Properties readProperties(String string) throws IOException {
        BufferedInputStream bufferedInputStream = null;
        Properties properties = new Properties();
        bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
        properties.load(bufferedInputStream);
        Object var5_3 = null;
        if (bufferedInputStream == null) return properties;
        try {
            bufferedInputStream.close();
            return properties;
        }
        catch (IOException iOException) {}
        return properties;
        {
            catch (FileNotFoundException fileNotFoundException) {
                Object var5_4 = null;
                if (bufferedInputStream == null) return properties;
                try {
                    bufferedInputStream.close();
                    return properties;
                }
                catch (IOException iOException) {}
                return properties;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (bufferedInputStream == null) throw throwable;
            try {
                bufferedInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void writeProperties(Properties properties, LockableFile lockableFile, String string) throws IOException {
        OutputStream outputStream = lockableFile.getOutputStream();
        if (outputStream == null) {
            throw new IllegalStateException();
        }
        try {
            properties.store(outputStream, string);
            Object var5_4 = null;
            if (outputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (outputStream == null) throw throwable;
            try {
                outputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            outputStream.close();
            return;
        }
        catch (IOException iOException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Properties readProperties(LockableFile lockableFile) throws IOException {
        InputStream inputStream = lockableFile.getInputStream();
        if (inputStream == null) {
            throw new IllegalStateException();
        }
        BufferedInputStream bufferedInputStream = null;
        Properties properties = new Properties();
        try {
            bufferedInputStream = new BufferedInputStream(inputStream);
            properties.load(bufferedInputStream);
            Object var5_4 = null;
            if (bufferedInputStream == null) return properties;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (bufferedInputStream == null) throw throwable;
            try {
                bufferedInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            bufferedInputStream.close();
            return properties;
        }
        catch (IOException iOException) {}
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean copyFile(File file, File file2, boolean bl) throws IOException {
        boolean bl2 = false;
        if (file.exists() && (!file2.exists() || bl)) {
            IOException iOException3;
            FileOutputStream fileOutputStream;
            block13: {
                FileInputStream fileInputStream = null;
                fileOutputStream = null;
                try {
                    fileInputStream = new FileInputStream(file);
                    fileOutputStream = new FileOutputStream(file2);
                    int n = 0;
                    byte[] byArray = new byte[1024];
                    while (n != -1) {
                        n = fileInputStream.read(byArray);
                        if (n == -1) continue;
                        fileOutputStream.write(byArray, 0, n);
                    }
                    bl2 = true;
                    Object var9_8 = null;
                    if (fileInputStream == null) break block13;
                }
                catch (Throwable throwable) {
                    IOException iOException22;
                    Object var9_9 = null;
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (IOException iOException22) {
                            // empty catch block
                        }
                    }
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (IOException iOException22) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException3) {
                    // empty catch block
                }
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException3) {}
            }
        }
        return bl2;
    }

    static Properties readCfgRepositoryProperties(String string) throws IOException {
        Properties properties = new Properties();
        try {
            DocumentContentSource documentContentSource;
            ConfigRepository configRepository = ConfigRepositoryFactory.getConfigRepository();
            if (configRepository != null && (documentContentSource = configRepository.extract(string)) != null) {
                InputStream inputStream = documentContentSource.getSource();
                properties.load(inputStream);
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return properties;
    }

    static void writeCfgRepositoryProperties(Properties properties, String string, String string2) throws IOException, RepositoryException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        properties.store(byteArrayOutputStream, string2);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ConfigRepository configRepository = ConfigRepositoryFactory.getConfigRepository();
        Document document = new Document(string);
        DocumentContentSource documentContentSource = new DocumentContentSource(document, byteArrayInputStream);
        try {
            configRepository.delete(string);
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        configRepository.create(documentContentSource);
    }

    static InputStream getCfgRepositoryInputStream(String string) throws IOException {
        InputStream inputStream = null;
        try {
            DocumentContentSource documentContentSource;
            ConfigRepository configRepository = ConfigRepositoryFactory.getConfigRepository();
            if (configRepository != null && (documentContentSource = configRepository.extract(string)) != null) {
                inputStream = documentContentSource.getSource();
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return inputStream;
    }

    static void createFileFromCfgRepository(String string, File file) throws ConfigActionFailedException, IOException {
        int n;
        if (string == null) {
            throw new ConfigActionFailedException("TAMConfigUtils.createFileFromCfgRepository config repository object name is null.");
        }
        if (file == null) {
            throw new ConfigActionFailedException("TAMConfigUtils.createFileFromCfgRepository file to create object is null.");
        }
        InputStream inputStream = TAMConfigUtils.getCfgRepositoryInputStream(string);
        if (inputStream == null) {
            AmasMessage amasMessage = new AmasMessage(864636992, string);
            throw new ConfigActionFailedException(amasMessage.getMessageString());
        }
        int n2 = inputStream.available();
        byte[] byArray = new byte[n2];
        for (int i = inputStream.read(byArray); i < n2; i += inputStream.read(byArray, n, n2 - n)) {
            n = i;
        }
        if (file.exists() && file.isFile()) {
            file.delete();
        }
        file.createNewFile();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(byArray);
    }

    public static String convertToHash(String string) {
        String string2 = string;
        if (string.indexOf("_") != -1) {
            String[] stringArray = string.split("_", 2);
            int n = stringArray[1].hashCode();
            string2 = stringArray[0] + "_" + n;
        }
        return string2;
    }

    public static void refreshServants(AmasSession amasSession, String string) {
        try {
            String[] stringArray;
            String string2;
            File file;
            TAMConfigStringGenerator tAMConfigStringGenerator = TAMConfigUtils.getStringGeneratorForCtx();
            if (tAMConfigStringGenerator != null && (file = new File(string2 = tAMConfigStringGenerator.getStringFromTemplate("${WAS_PROFILES_ROOT}/etc/tam"))).exists() && (stringArray = file.list()) != null) {
                Object object;
                HashSet<Object> hashSet = new HashSet<Object>();
                for (int i = 0; i < stringArray.length; ++i) {
                    Object object2;
                    if (!stringArray[i].endsWith("pdperm.properties") || stringArray[i].indexOf("authztable") != -1) continue;
                    try {
                        object = new URL(TAMConfigUtils.filenameToURL(string2 + File.separatorChar + stringArray[i]));
                        object2 = AmasPDHelper.getPDServerName((URL)object);
                        hashSet.add(object2);
                        continue;
                    }
                    catch (Exception exception) {
                        object2 = new AmasMessage(864636984, exception.toString());
                        System.out.println("TAMConfigUtils refreshServants" + ((AmasMessage)object2).getMessageString());
                    }
                }
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    object = (String)iterator.next();
                    try {
                        amasSession.policyRefresh((String)object);
                    }
                    catch (Exception exception) {
                        AmasMessage amasMessage = new AmasMessage(864636984, exception.toString());
                        System.out.println("TAMConfigUtils refreshServants" + amasMessage.getMessageString());
                    }
                }
            }
        }
        catch (Exception exception) {
            AmasMessage amasMessage = new AmasMessage(864636984, exception.toString());
            System.out.println("TAMConfigUtils refreshServants" + amasMessage.getMessageString());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        PlatformHelper platformHelper = PlatformHelperFactory.getPlatformHelper();
        if (platformHelper != null) {
            if (platformHelper.isZOS()) {
                _zos = true;
                if (platformHelper.isServantJvm()) {
                    _servant = true;
                    _stoken = platformHelper.getServantToken();
                    if (_stoken == null) {
                        AmasMessage amasMessage = new AmasMessage(864636992, "Servant Token");
                        System.out.println("TAMConfigUtils " + amasMessage.getMessageString());
                        _servant = false;
                    }
                } else {
                    _controller = true;
                }
            }
        } else {
            AmasMessage amasMessage = new AmasMessage(864636992, "PlatformHelper");
            System.out.println("TAMConfigUtils " + amasMessage.getMessageString());
        }
    }
}

