/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pd.as.jacc.cfg;

import com.tivoli.pd.as.jacc.cfg.ConfigAction;
import com.tivoli.pd.as.jacc.cfg.ConfigActionFailedException;
import com.tivoli.pd.as.jacc.cfg.RefCounter;
import com.tivoli.pd.as.util.AmasMessage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class UnconfigureAmjaccConfigAction
extends ConfigAction {
    private final String UnconfigureAmjaccConfigAction_java_sourceCodeID = "$Id: @(#)76  1.7 src/jacc/com/tivoli/pd/as/jacc/cfg/UnconfigureAmjaccConfigAction.java, amemb.jacc.was, amemb600, 051118a 04/09/02 18:10:50 @(#) $";
    public static final String sCopyright = "IBM Confidential\nObject Code Only Source Materials\n5747-SM3\n(c) Copyright International Business Machines Corp. 1994-2002.  All Rights Reserved.\nThe source code for this program is not published or otherwise divested\nof its trade secrets, irrespective of what has been deposited with the\nU.S. Copyright Office.\n";
    private String _cfgFilename = null;
    private String _cfgLogFilename = null;
    private String _serverPolicyFilename = null;
    private static final String _PDPRINCIPAL_AUTH = "   permission javax.security.auth.AuthPermission \"createPDPrincipal\";";
    private static final String _RTPERMISSION = "   permission com.tivoli.pd.as.rbpf.RtPermission \"*\", \"read\";";
    private static final String CLASSNAME = (class$com$tivoli$pd$as$jacc$cfg$UnconfigureAmjaccConfigAction == null ? (class$com$tivoli$pd$as$jacc$cfg$UnconfigureAmjaccConfigAction = UnconfigureAmjaccConfigAction.class$("com.tivoli.pd.as.jacc.cfg.UnconfigureAmjaccConfigAction")) : class$com$tivoli$pd$as$jacc$cfg$UnconfigureAmjaccConfigAction).getName();
    static /* synthetic */ Class class$com$tivoli$pd$as$jacc$cfg$UnconfigureAmjaccConfigAction;

    public UnconfigureAmjaccConfigAction() {
        this._name = "UnconfigureAmjacc";
        this._desc = "This class unconfigures the Tivoli Access Manager Java Authorization Contract for Containers Provider";
    }

    protected void executeInternal() throws ConfigActionFailedException {
        if (this._logger != null && this._logger.isLogging()) {
            this._logger.entry(80L, (Object)CLASSNAME, "executeInternal()");
        }
        File file = new File(this._cfgFilename);
        File file2 = new File(this._cfgLogFilename);
        if (file.exists()) {
            if (this._logger != null && this._logger.isLogging()) {
                this._logger.text(16L, (Object)CLASSNAME, "executeInternal()", "Deleting file " + file.getAbsolutePath());
            }
            file.delete();
        }
        if (file2.exists()) {
            if (this._logger != null && this._logger.isLogging()) {
                this._logger.text(16L, (Object)CLASSNAME, "executeInternal()", "Deleting file " + file2.getAbsolutePath());
            }
            file2.delete();
        }
        RefCounter refCounter = new RefCounter(this._stateProps.getConfigStateProps(), "secpolicyRefCount.", this._ctxID);
        if (this._force || refCounter.getRefCount() == 1) {
            this.updateServerPolicy();
        }
        if (this._force) {
            refCounter.clearRefCount();
        } else {
            refCounter.decrementRefCount();
        }
        try {
            this._stateProps.save();
        }
        catch (IOException iOException) {
            AmasMessage amasMessage = new AmasMessage(864636966, new Object[]{this._stateProps.getConfigStateFilename(), iOException.toString()});
            throw new ConfigActionFailedException(amasMessage.getMessageString());
        }
        if (this._logger != null && this._logger.isLogging()) {
            this._logger.exit(96L, (Object)CLASSNAME, "executeInternal()");
        }
    }

    private void updateServerPolicy() throws ConfigActionFailedException {
        int n;
        Object object;
        File file = new File(this._serverPolicyFilename);
        byte[] byArray = null;
        boolean bl = false;
        try {
            int n2;
            object = new FileInputStream(this._serverPolicyFilename);
            n = ((FileInputStream)object).available();
            byArray = new byte[n];
            for (int i = ((FileInputStream)object).read(byArray); i < n; i += ((FileInputStream)object).read(byArray, n2, n - n2)) {
                n2 = i;
            }
            ((FileInputStream)object).close();
        }
        catch (IOException iOException) {
            AmasMessage amasMessage = new AmasMessage(864636965, new Object[]{this._serverPolicyFilename, iOException.toString()});
            throw new ConfigActionFailedException(amasMessage.getMessageString());
        }
        object = new String(byArray);
        n = ((String)object).indexOf(_PDPRINCIPAL_AUTH);
        if (n > 1) {
            object = ((String)object).substring(0, n) + ((String)object).substring(n + _PDPRINCIPAL_AUTH.length() + 1);
            bl = true;
        }
        if ((n = ((String)object).indexOf(_RTPERMISSION)) > 1) {
            object = ((String)object).substring(0, n) + ((String)object).substring(n + _RTPERMISSION.length() + 1);
            bl = true;
        }
        if (bl) {
            File file2 = new File(file.getAbsolutePath() + "_AMWAS");
            if (this._logger != null && this._logger.isLogging()) {
                this._logger.text(16L, (Object)CLASSNAME, "updateServerPolicy()", "Renaming existing server policy file " + file.getAbsolutePath() + " to " + file2.getAbsolutePath());
            }
            if (file2.exists()) {
                file2.delete();
            }
            if (!file.renameTo(file2)) {
                AmasMessage amasMessage = new AmasMessage(864636968, new Object[]{file.getAbsolutePath(), file2.getAbsolutePath()});
                throw new ConfigActionFailedException(amasMessage.getMessageString());
            }
            if (this._logger != null && this._logger.isLogging()) {
                this._logger.text(16L, (Object)CLASSNAME, "updateServerPolicy()", "Removed AMWAS related policy from existing policy and saving the result to " + file.getAbsolutePath());
            }
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(this._serverPolicyFilename);
                fileOutputStream.write(((String)object).getBytes());
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                AmasMessage amasMessage = new AmasMessage(864636966, new Object[]{this._serverPolicyFilename, iOException.toString()});
                throw new ConfigActionFailedException(amasMessage.getMessageString());
            }
        }
    }

    protected boolean isReadyToBeExecutedInternal() {
        return this._force || new File(this._cfgFilename).exists() || new File(this._cfgLogFilename).exists();
    }

    protected boolean isPropertiesValidInternal() {
        boolean bl = false;
        this._cfgFilename = this.validateProperty("amjaccFilename");
        this._cfgLogFilename = this.validateProperty("amjaccLogCfgFilename");
        this._serverPolicyFilename = this.validateProperty("wasServerPolicyFilename");
        if (this._cfgFilename != null && this._cfgLogFilename != null && this._serverPolicyFilename != null) {
            bl = true;
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

