/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pd.as.jacc.cfg;

import com.tivoli.pd.as.jacc.cfg.ConfigAction;
import com.tivoli.pd.as.jacc.cfg.ConfigActionFailedException;
import com.tivoli.pd.as.jacc.cfg.RefCounter;
import com.tivoli.pd.as.jacc.cfg.TAMConfigStringGenerator;
import com.tivoli.pd.as.jacc.cfg.TAMConfigUtils;
import com.tivoli.pd.as.util.AmasMessage;
import java.io.File;
import java.io.IOException;

public class UnconfigurePdJrteConfigAction
extends ConfigAction {
    private final String UnconfigurePdJrteConfigAction_java_sourceCodeID = "$Id: @(#)79 1.16 src/jacc/com/tivoli/pd/as/jacc/cfg/UnconfigurePdJrteConfigAction.java, amemb.jacc.was, amemb600, 060405a 06/04/05 00:19:24 @(#) $";
    public static final String sCopyright = "IBM Confidential\nObject Code Only Source Materials\n5747-SM3\n(c) Copyright International Business Machines Corp. 1994-2002.  All Rights Reserved.\nThe source code for this program is not published or otherwise divested\nof its trade secrets, irrespective of what has been deposited with the\nU.S. Copyright Office.\n";
    private String _pdHome = null;
    private String _jreDir = null;
    private String _cfgFilename = null;
    private static final String CLASSNAME = (class$com$tivoli$pd$as$jacc$cfg$UnconfigurePdJrteConfigAction == null ? (class$com$tivoli$pd$as$jacc$cfg$UnconfigurePdJrteConfigAction = UnconfigurePdJrteConfigAction.class$("com.tivoli.pd.as.jacc.cfg.UnconfigurePdJrteConfigAction")) : class$com$tivoli$pd$as$jacc$cfg$UnconfigurePdJrteConfigAction).getName();
    static /* synthetic */ Class class$com$tivoli$pd$as$jacc$cfg$UnconfigurePdJrteConfigAction;

    public UnconfigurePdJrteConfigAction() {
        this._name = "UnconfigurePDJrteCfg";
        this._desc = "This class unconfigures the Tivoli Access Manager Java Runtime";
    }

    protected void executeInternal() throws ConfigActionFailedException {
        Object object;
        Object object2;
        if (this._logger != null && this._logger.isLogging()) {
            this._logger.entry(80L, (Object)CLASSNAME, "executeInternal()");
        }
        RefCounter refCounter = new RefCounter(this._stateProps.getConfigStateProps(), "amjrteRefCount.", this._ctxID);
        boolean bl = false;
        int n = refCounter.getRefCount();
        if (n == 1 && (object2 = refCounter.getAllPrefixMatches()).contains(refCounter.getUniqueId())) {
            bl = true;
        }
        if (bl || this._force) {
            Object object3;
            if (this._logger != null && this._logger.isLogging()) {
                object2 = null;
                object2 = this._force ? "Force mode has been set - unconfiguring the AMJRTE" : "This is the last AMJRTE application to be unconfigured on this node - unconfiguring the AMJRTE";
                this._logger.text(16L, (Object)CLASSNAME, "executeInternal()", (String)object2);
            }
            object2 = TAMConfigUtils.getStringGeneratorForCtx();
            object = ((TAMConfigStringGenerator)object2).getStringFromTemplate("${COMMON_FILE_LOCATION}");
            String string = ((TAMConfigStringGenerator)object2).getStringFromTemplate("${COMMON_PD_HOME}");
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this._jreDir);
            stringBuffer.append(File.separatorChar);
            stringBuffer.append("bin");
            stringBuffer.append(File.separatorChar);
            stringBuffer.append("java");
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append(this._jreDir);
            stringBuffer2.append(File.separatorChar);
            stringBuffer2.append("lib");
            stringBuffer2.append(File.separatorChar);
            stringBuffer2.append("ext");
            stringBuffer2.append(File.separatorChar);
            StringBuffer stringBuffer3 = new StringBuffer();
            stringBuffer3.append(stringBuffer2);
            stringBuffer3.append("PD.jar");
            stringBuffer3.append(File.pathSeparatorChar);
            stringBuffer3.append(stringBuffer2);
            stringBuffer3.append("ibmjceprovider.jar");
            stringBuffer3.append(File.pathSeparatorChar);
            stringBuffer3.append(stringBuffer2);
            stringBuffer3.append("ibmpkcs.jar");
            Boolean bl2 = new Boolean(true);
            String string2 = this.getWASSystemProps();
            if (string2 == null || string2.equals("")) {
                string2 = new String("-Djava.ext.dirs");
            }
            Object[][] objectArray = null;
            String[] stringArray = null;
            if (System.getProperty("os.name").equals("z/OS")) {
                object3 = this._jreDir;
                objectArray = new Object[][]{{"-action", bl2}, {"unconfig", bl2}, {"-cfgfiles_path", bl2}, {object, bl2}, {"-was", bl2}, {"-java_home", bl2}, {object3, bl2}};
                stringArray = new String[]{"CLASSPATH=" + this._jreDir + "/jre/lib/ext/PD.jar"};
            } else {
                System.setProperty("pd.home", string);
                objectArray = new Object[][]{{"-action", bl2}, {"unconfig", bl2}, {"-cfgfiles_path", bl2}, {object, bl2}, {"-was", bl2}};
            }
            if (this._force) {
                try {
                    this.exec(objectArray, stringArray, null, false);
                }
                catch (ConfigActionFailedException configActionFailedException) {
                    if (this._logger != null && this._logger.isLogging()) {
                        this._logger.text(2L, (Object)CLASSNAME, "executeInternal()", "Exception occurred whilst attempting to unconfigure. Details are: " + configActionFailedException);
                    }
                }
            } else {
                this.exec(objectArray, stringArray, null);
            }
            object3 = new File(this._cfgFilename);
            if (((File)object3).exists()) {
                ((File)object3).delete();
            }
        } else if (this._logger != null && this._logger.isLogging()) {
            this._logger.text(16L, (Object)CLASSNAME, "executeInternal()", "This is not the last AMJRTE application to be unconfigured on this node, so we will leave the AMJRTE configured");
        }
        if (this._force) {
            refCounter.clearRefCount();
        } else {
            refCounter.decrementRefCount();
        }
        try {
            this._stateProps.save();
        }
        catch (IOException iOException) {
            object = new AmasMessage(864636966, new Object[]{this._stateProps.getConfigStateFilename(), iOException.toString()});
            throw new ConfigActionFailedException(((AmasMessage)object).getMessageString());
        }
        if (this._logger != null && this._logger.isLogging()) {
            this._logger.exit(96L, (Object)CLASSNAME, "executeInternal()");
        }
    }

    protected boolean isReadyToBeExecutedInternal() {
        return this._force || new File(this._cfgFilename).exists();
    }

    protected boolean isPropertiesValidInternal() {
        boolean bl = false;
        this._cfgFilename = this.validateProperty("pdjrtecfgFilename");
        this._pdHome = this.validateProperty("pdHomeDirectory");
        this._jreDir = this.validateProperty("jrejavaDirectory");
        if (this._cfgFilename != null && this._pdHome != null && this._jreDir != null) {
            bl = true;
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

