/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pd.as.rbpf;

import com.tivoli.pd.as.rbpf.AmasSession;
import com.tivoli.pd.as.rbpf.AuthzObjects;
import com.tivoli.pd.as.rbpf.CfgPermission;
import com.tivoli.pd.as.rbpf.CfgRoleCollection;
import com.tivoli.pd.as.rbpf.Role;
import com.tivoli.pd.as.rbpf.RoleCollection;
import com.tivoli.pd.as.rbpf.RtPermission;
import com.tivoli.pd.as.rbpf.RtRoleCollection;
import com.tivoli.pd.as.util.AmasException;
import com.tivoli.pd.as.util.AmasMessage;
import java.util.Iterator;

final class AdminAuthzObjects
extends AuthzObjects {
    private final String AdminAuthzObjects_java_sourceCodeID = "$Id: @(#)77  1.3 src/amas/com/tivoli/pd/as/rbpf/AdminAuthzObjects.java, amemb.jacc.was, amemb600, 051118a 04/09/02 18:10:43 @(#) $";
    public static final String sCopyright = "IBM Confidential\nObject Code Only Source Materials\n5747-SM3\n(c) Copyright International Business Machines Corp. 1994-2002.  All Rights Reserved.\nThe source code for this program is not published or otherwise divested\nof its trade secrets, irrespective of what has been deposited with the\nU.S. Copyright Office.\n";
    private static final String CLASSNAME = "com.tivoli.pd.as.rbpf.AdminAuthzObjects";

    AdminAuthzObjects(AmasSession amasSession, RoleCollection roleCollection) {
        super(amasSession, roleCollection);
        this._trcLogger = amasSession.getLogManager().getTraceLogger("AmasRBPFTraceLogger");
        this._msgLogger = amasSession.getLogManager().getMessageLogger("AmasRBPFMessageLogger");
    }

    RoleCollection getAuthzRoles(String string) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "getAuthzRoles(String prin) { prin = " + string + " }");
        }
        RoleCollection roleCollection = null;
        if (this._objects instanceof CfgRoleCollection) {
            try {
                if (this._secMgr != null) {
                    this._secMgr.checkPermission(new CfgPermission("Role", "read"));
                }
            }
            catch (SecurityException securityException) {
                if (this._msgLogger != null && this._msgLogger.isLogging()) {
                    AmasMessage amasMessage = new AmasMessage(916942882, securityException.toString());
                    this._msgLogger.text(4L, (Object)CLASSNAME, "getAuthzRoles(String)", amasMessage.getMessageString());
                }
                throw new AmasException(securityException);
            }
            roleCollection = new CfgRoleCollection(this._sess);
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "getAuthzRoles", "Creating CfgRoleCollection rtn type");
            }
        } else {
            try {
                if (this._secMgr != null) {
                    this._secMgr.checkPermission(new RtPermission("Role", "read"));
                }
            }
            catch (SecurityException securityException) {
                if (this._msgLogger != null && this._msgLogger.isLogging()) {
                    AmasMessage amasMessage = new AmasMessage(916942882, securityException.toString());
                    this._msgLogger.text(4L, (Object)CLASSNAME, "getAuthzRoles(String)", amasMessage.getMessageString());
                }
                throw new AmasException(securityException);
            }
            roleCollection = new RtRoleCollection(this._sess);
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "getAuthzRoles", "Creating RtRoleCollection rtn type");
            }
        }
        Iterator iterator = this._objects.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (!(e2 instanceof Role) || !((Role)e2).isMember(string)) continue;
            roleCollection.add((Role)e2);
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.text(16L, (Object)CLASSNAME, "getAuthzRoles", "Returning [" + roleCollection.size() + "] roles");
            this._trcLogger.exit(96L, (Object)CLASSNAME, "getAuthzRoles(String)");
        }
        return roleCollection;
    }
}

