/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pd.as.rbpf;

import com.tivoli.pd.as.atcc.IObjectTreeCache;
import com.tivoli.pd.as.rbpf.AmasCmdObject;
import com.tivoli.pd.as.rbpf.AmasDeleteCmdObject;
import com.tivoli.pd.as.rbpf.AmasPDObjectDirect;
import com.tivoli.pd.as.rbpf.AmasSession;
import com.tivoli.pd.as.util.AmasException;
import com.tivoli.pd.as.util.AmasMessage;
import java.util.List;

public class AmasAddCmdObject
extends AmasCmdObject {
    private final String AmasAddCmdObject_java_sourceCodeID = "$Id: @(#)98  1.2 src/amas/com/tivoli/pd/as/rbpf/AmasAddCmdObject.java, amemb.jacc.was, amemb600, 051118a 05/05/06 01:41:21 @(#) $";
    public static final String sCopyright = "IBM Confidential\nObject Code Only Source Materials\n5747-SM3\n(c) Copyright International Business Machines Corp. 1994-2002.  All Rights Reserved.\nThe source code for this program is not published or otherwise divested\nof its trade secrets, irrespective of what has been deposited with the\nU.S. Copyright Office.\n";
    private static final String CLASSNAME = "com.tivoli.pd.as.rbpf.AmasAddCmdObject";
    private String _attrValue;
    private boolean _singleValueAttr;

    public AmasAddCmdObject(AmasSession amasSession, IObjectTreeCache iObjectTreeCache, String string, String string2, String string3, boolean bl) {
        super(amasSession, iObjectTreeCache, string, string2);
        this._attrValue = string3;
        this._singleValueAttr = bl;
    }

    public boolean execCmd() {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "execCmd() ['" + this.getPosName() + "']");
        }
        boolean bl = false;
        bl = this.checkCmd();
        if (!bl) {
            try {
                AmasPDObjectDirect amasPDObjectDirect = this.getCacheObject();
                if (amasPDObjectDirect == null) {
                    amasPDObjectDirect = new AmasPDObjectDirect(this._sess, this.getPosName());
                }
                if (this._attrValue == null && this.getAttrName() == null) {
                    amasPDObjectDirect.doCreateProtObject();
                    bl = true;
                } else if (this._attrValue != null && this.getAttrName() != null) {
                    if (this._singleValueAttr) {
                        amasPDObjectDirect.setSingleValueAttribute(this.getAttrName(), this._attrValue);
                    } else {
                        amasPDObjectDirect.doAddAttributeValue(this.getAttrName(), this._attrValue);
                    }
                    bl = true;
                }
                if (bl) {
                    this.getCache().addEntry(this.getPosName(), amasPDObjectDirect);
                }
            }
            catch (AmasException amasException) {
                AmasMessage amasMessage = new AmasMessage(916942849, amasException.toString());
                if (this._msgLogger != null && this._msgLogger.isLogging()) {
                    this._msgLogger.text(4L, (Object)this, "execCmd()", amasMessage.getMessageString());
                }
                this.setErrorMessage("Caught AmasException during execution: '" + amasException.toString() + "'");
                bl = false;
            }
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "execCmd()");
        }
        return bl;
    }

    public boolean checkCmd() {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "checkCmd() ['" + this.getPosName() + "']");
        }
        boolean bl = false;
        try {
            AmasPDObjectDirect amasPDObjectDirect = this.getCacheObject();
            if (amasPDObjectDirect != null) {
                if (this._attrValue != null && this.getAttrName() != null) {
                    List list = amasPDObjectDirect.doAttributeValueList(this.getAttrName());
                    bl = list.contains(this._attrValue);
                    if (this._singleValueAttr && list.size() != 1) {
                        bl = false;
                    }
                } else {
                    bl = true;
                }
            } else {
                bl = false;
            }
        }
        catch (AmasException amasException) {
            AmasMessage amasMessage = new AmasMessage(916942849, amasException.toString());
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                this._msgLogger.text(4L, (Object)this, "checkCmd()", amasMessage.getMessageString());
            }
            bl = false;
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "checkCmd()");
        }
        return bl;
    }

    public AmasCmdObject getRollbackCmd() {
        return new AmasDeleteCmdObject(this._sess, this.getCache(), this.getPosName(), this.getAttrName(), this._attrValue);
    }

    public String printCmd() {
        String string = "AmasAddCmdObject => ";
        string = this._singleValueAttr ? string + "Adding a single value attribute ( " + this.getAttrName() + "," + this._attrValue + ") to object [" + this.getPosName() + "]" : (this.getAttrName() != null && this._attrValue != null ? string + "Adding a attribute value ( " + this.getAttrName() + "," + this._attrValue + ") to object [" + this.getPosName() + "]" : string + "Creating object [" + this.getPosName() + "]");
        return string;
    }
}

