/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pd.as.rbpf;

import com.tivoli.pd.as.rbpf.AmasSession;
import com.tivoli.pd.as.rbpf.LocalAttributeList;
import com.tivoli.pd.as.rbpf.RemoteAttributeList;
import com.tivoli.pd.as.util.AmasException;
import com.tivoli.pd.as.util.AmasMessage;
import com.tivoli.pd.jazn.PDAuthorizationContext;
import com.tivoli.pd.jras.pdjlog.jlog.ILogger;
import com.tivoli.pd.jutil.PDAttrs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

abstract class AmasAttributeList {
    private final String AmasAttributeList_java_sourceCodeID = "$Id: @(#)41  1.3 src/amas/com/tivoli/pd/as/rbpf/AmasAttributeList.java, amemb.jacc.was, amemb600, 051118a 04/07/15 17:55:03 @(#) $";
    public static final String sCopyright = "IBM Confidential\nObject Code Only Source Materials\n5747-SM3\n(c) Copyright International Business Machines Corp. 1994-2002.  All Rights Reserved.\nThe source code for this program is not published or otherwise divested\nof its trade secrets, irrespective of what has been deposited with the\nU.S. Copyright Office.\n";
    protected String _objId;
    protected PDAttrs _attrs = null;
    protected AmasSession _sess = null;
    protected boolean _foundAttrs = false;
    protected ILogger _msgLogger;
    protected ILogger _trcLogger;
    private static final String CLASSNAME = "com.tivoli.pd.as.rbpf.AmasAttributeList";

    AmasAttributeList(AmasSession amasSession, String string) throws AmasException {
        this._sess = amasSession;
        this._objId = string;
        this._trcLogger = amasSession.getLogManager().getTraceLogger("AmasRBPFTraceLogger");
        this._msgLogger = amasSession.getLogManager().getMessageLogger("AmasRBPFMessageLogger");
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "AmasAttributeList(AmasSession, String attrName, String objId) { objId = " + string + " }");
        }
        this.initialiseLocalAttrValues();
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "AmasAttributeList(AmasSession, String attrName, String objId)");
        }
    }

    public static Object getAttrListObject(AmasSession amasSession, String string) throws AmasException {
        PDAuthorizationContext pDAuthorizationContext = amasSession.getSessionContext();
        if (pDAuthorizationContext.getMode().equalsIgnoreCase("local")) {
            return new LocalAttributeList(amasSession, string);
        }
        return new RemoteAttributeList(amasSession, string);
    }

    protected abstract void generatePDAttrs() throws AmasException;

    public void initialiseLocalAttrValues() throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "initialiseLocalAttrValues()");
        }
        if (this._attrs == null) {
            this.generatePDAttrs();
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "initialiseLocalAttrValues(String, String)");
        }
    }

    public List getLocalAttributeValues(String string) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "getLocalAttributeValues(String attrName) { attrName = " + string + " }");
        }
        ArrayList arrayList = null;
        if (this._attrs == null) {
            AmasMessage amasMessage = new AmasMessage(916942908, this._objId);
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                this._msgLogger.text(4L, (Object)CLASSNAME, "getLocalAttributeValues(String)", amasMessage.getMessageString());
            }
            throw new AmasException(amasMessage);
        }
        if (!this._foundAttrs) {
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "getLocalAttributeValues(String)", "Found no attributes on resource " + this._objId);
            }
            arrayList = new ArrayList();
        } else {
            Collection collection = this._attrs.getValues(string);
            arrayList = collection == null ? new ArrayList() : new ArrayList(collection);
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "getLocalAttributeValues(String)");
        }
        return arrayList;
    }

    String getPosName() {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "getPosName()");
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "getPosName() { retVal = " + this._objId + " }");
        }
        return this._objId;
    }
}

