/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pd.as.rbpf;

import com.tivoli.pd.as.nls.AmasMsgHelper;
import com.tivoli.pd.as.rbpf.AmasObject;
import com.tivoli.pd.as.rbpf.AmasSession;
import com.tivoli.pd.as.rbpf.IResourceHandler;
import com.tivoli.pd.as.rbpf.IRtResourceHandler;
import com.tivoli.pd.as.rbpf.Resource;
import com.tivoli.pd.as.rbpf.ResourceHandler;
import com.tivoli.pd.as.rbpf.Role;
import com.tivoli.pd.as.util.AmasException;
import com.tivoli.pd.as.util.AmasMessage;
import com.tivoli.pd.as.util.AmasUtil;
import com.tivoli.pd.jazn.PDPrincipal;
import com.tivoli.pd.jras.pdjlog.jlog.ILogger;
import com.tivoli.pd.jutil.PDException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

abstract class AmasManager {
    private final String AmasManager_java_sourceCodeID = "$Id: @(#)35  1.10 src/amas/com/tivoli/pd/as/rbpf/AmasManager.java, amemb.jacc.was, amemb600, 051118a 05/05/06 01:41:17 @(#) $";
    public static final String sCopyright = "IBM Confidential\nObject Code Only Source Materials\n5747-SM3\n(c) Copyright International Business Machines Corp. 1994-2002.  All Rights Reserved.\nThe source code for this program is not published or otherwise divested\nof its trade secrets, irrespective of what has been deposited with the\nU.S. Copyright Office.\n";
    protected AmasSession _sess;
    protected ILogger _trcLogger;
    protected ILogger _msgLogger;
    protected SecurityManager _secMgr;
    static final String CLASSNAME = "com.tivoli.pd.as.rbpf.AmasManager";

    protected AmasManager(AmasSession amasSession) throws AmasException {
        if (amasSession == null) {
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "AmasManager(AmasSession)", "Null AmasSession encountered.");
            }
            throw new IllegalArgumentException();
        }
        this._sess = amasSession;
        this._trcLogger = amasSession.getLogManager().getTraceLogger("AmasRBPFTraceLogger");
        this._msgLogger = amasSession.getLogManager().getMessageLogger("AmasRBPFMessageLogger");
        this._secMgr = System.getSecurityManager();
    }

    abstract AmasObject createObject(AmasSession var1, String var2) throws AmasException;

    abstract Role instantiateRole(String var1, String var2) throws AmasException;

    abstract Resource instantiateResource(String var1, ResourceHandler var2) throws AmasException;

    protected Role getRole(String string, String string2) throws AmasException {
        StringBuffer stringBuffer;
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "getRole(String roleName, String roleSuffix) { roleName = " + string + " , roleSuffix = " + string2 + " }");
        }
        Role role2 = null;
        if (string != null && string2 != null) {
            String string3 = this.getRolePrefix();
            stringBuffer = new StringBuffer(string3);
            if (!string3.endsWith("/")) {
                stringBuffer.append("/");
            }
            stringBuffer.append(string);
            if (string2.charAt(0) != '/') {
                stringBuffer.append("/");
            }
        } else {
            if (string == null && this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "getRole(String, String)", "Null roleName encountered.");
            }
            if (string2 == null && this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "getRole(String, String)", "Null roleSuffix encountered.");
            }
            throw new IllegalArgumentException();
        }
        stringBuffer.append(string2);
        role2 = this.instantiateRole(string, stringBuffer.toString());
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            if (role2 != null) {
                this._trcLogger.exit(96L, (Object)CLASSNAME, "getRole(String, String) { retVal = " + role2.getId() + " }");
            } else {
                this._trcLogger.exit(96L, (Object)CLASSNAME, "getRole(String, String) { retVal = null }");
            }
        }
        return role2;
    }

    protected Role getRole(Resource resource, String string) throws AmasException {
        Role role2 = null;
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            if (resource != null) {
                this._trcLogger.entry(80L, (Object)CLASSNAME, "getRole(Resource resource, String roleName) { resource = " + resource.getPosName() + " , roleName = " + string + " }");
            } else {
                this._trcLogger.entry(80L, (Object)CLASSNAME, "getRole(Resource resource, String roleName) { resource = null , roleName = " + string + " }");
            }
        }
        if (resource == null || string == null) {
            if (resource == null && this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "getRole(Resource, String)", "Null resource encountered.");
            }
            if (string == null && this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "getRole(Resource, String)", "Null roleName encountered.");
            }
            throw new IllegalArgumentException();
        }
        String string2 = resource.getRoleSuffix();
        role2 = this.getRole(string, string2);
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            if (role2 != null) {
                this._trcLogger.exit(96L, (Object)CLASSNAME, "getRole(Resource, String) { retVal = " + role2.getId() + " }");
            } else {
                this._trcLogger.exit(96L, (Object)CLASSNAME, "getRole(Resource, String) { retVal = null }");
            }
        }
        return role2;
    }

    protected Role[] getLocalGrantedRoles(Resource resource) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            if (resource != null) {
                this._trcLogger.entry(80L, (Object)CLASSNAME, "getLocalGrantedRoles(Resource) { Resource = " + resource.getPosName() + " }");
            } else {
                this._trcLogger.entry(80L, (Object)CLASSNAME, "getLocalGrantedRoles(Resource) { Resource = null }");
            }
        }
        Role[] roleArray = null;
        String[] stringArray = resource.getLocalRoles();
        roleArray = new Role[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            roleArray[i] = this.instantiateRole(stringArray[i], resource.getRoleObjName(stringArray[i]));
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "getLocalGrantedRoles(Resource)");
        }
        return roleArray;
    }

    protected String[] getBaseRoleNames() throws AmasException {
        String[] stringArray = null;
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "getBaseRoleNames()");
        }
        String string = this.getRolePrefix();
        AmasObject amasObject = this.createObject(this._sess, string);
        List list = amasObject.listChildObjects();
        Iterator iterator = list.iterator();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            AmasObject amasObject2 = this.createObject(this._sess, string2);
            if (!amasObject2.exists()) continue;
            int n = string2.lastIndexOf(47);
            String string3 = n == -1 ? string2 : string2.substring(n + 1, string2.length());
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "getBaseRoleNames()", "Found base role : " + string3 + " }");
            }
            arrayList.add(string3);
        }
        stringArray = arrayList.toArray(new String[0]);
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "getBaseRoleNames()");
        }
        return stringArray;
    }

    protected String getRolePrefix() throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "getRolePrefix()");
        }
        String string = null;
        string = this._sess.getRoleContainerName();
        if (string != null && !string.endsWith("/")) {
            string = string + '/';
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "getRolePrefix() { retVal = " + string + " }");
        }
        return string;
    }

    public Role[] getBaseRoles() throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "getBaseRoles()");
        }
        String string = this.getRolePrefix();
        AmasObject amasObject = this.createObject(this._sess, string);
        List list = amasObject.listChildObjects();
        Role[] roleArray = new Role[list.size()];
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = string2.substring(string2.lastIndexOf("/") + 1);
            roleArray[n] = this.instantiateRole(string3, string2);
            ++n;
            if (this._trcLogger == null || !this._trcLogger.isLogging()) continue;
            this._trcLogger.text(16L, (Object)CLASSNAME, "getBaseRoles()", "Found base role name = " + string3 + " , fullRoleId = " + string2 + " }");
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "getBaseRoles()");
        }
        return roleArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean roleExists(Object object, String string) throws AmasException {
        boolean bl;
        block9: {
            block8: {
                ResourceHandler resourceHandler;
                bl = false;
                if (this._trcLogger != null && this._trcLogger.isLogging()) {
                    this._trcLogger.entry(80L, (Object)CLASSNAME, "roleExists(Object res, String roleName) { roleName = " + string + " }");
                }
                if ((resourceHandler = this._sess.getHandlerFactory().createResourceHandler(object)) == null) break block8;
                if (this._trcLogger != null && this._trcLogger.isLogging()) {
                    this._trcLogger.text(16L, (Object)CLASSNAME, "roleExists(Object, String)", "Using resource handler: " + resourceHandler.getClass().getName());
                }
                if (resourceHandler instanceof IResourceHandler) {
                    IRtResourceHandler iRtResourceHandler = (IRtResourceHandler)((Object)resourceHandler);
                    String string2 = AmasUtil.appendPosValue(this._sess.getRoleContainerName(), string);
                    string2 = AmasUtil.appendPosValue(string2, iRtResourceHandler.getRoleSuffix());
                    AmasObject amasObject = this.createObject(this._sess, string2);
                    bl = amasObject.exists();
                    if (this._trcLogger != null && this._trcLogger.isLogging()) {
                        this._trcLogger.text(16L, (Object)CLASSNAME, "roleExists(Object, String)", "obj.exists() for " + string2 + " returned: " + bl + ", there for roleExists=" + bl);
                    }
                    break block9;
                } else {
                    AmasMessage amasMessage = new AmasMessage(916942880, object.getClass().getName());
                    if (this._msgLogger != null && this._msgLogger.isLogging()) {
                        this._msgLogger.text(4L, (Object)CLASSNAME, "roleExists(Object, String)", amasMessage.getMessageString());
                    }
                    throw new AmasException(amasMessage);
                }
            }
            AmasMessage amasMessage = new AmasMessage(916942878, object.getClass().getName());
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                this._msgLogger.text(4L, (Object)CLASSNAME, "roleExists(Object, String)", amasMessage.getMessageString());
            }
            throw new AmasException(amasMessage);
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "roleExists(Object, String) { retVal = " + bl + " }");
        }
        return bl;
    }

    public Object getPrincipal(String string) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "getPrincipal(String prinName) { prinName = " + string + " }");
        }
        PDPrincipal pDPrincipal = null;
        try {
            pDPrincipal = string.equalsIgnoreCase("unauthenticated") ? new PDPrincipal(this._sess.getSessionContext()) : new PDPrincipal(this._sess.getSessionContext(), string);
        }
        catch (PDException pDException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                this._msgLogger.text(4L, (Object)CLASSNAME, "getPrincipal(String)", AmasMsgHelper.formatDoubleParamMessage(916942903, string, pDException.toString()));
            }
            throw new AmasException(pDException);
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "getPrincipal(String)");
        }
        return pDPrincipal;
    }

    public boolean isConfiguredUncheckedRole(String string) {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "isConfiguredUncheckedRole(String roleName) { roleName = " + string + " }");
        }
        boolean bl = false;
        String[] stringArray = this._sess.getUncheckedNames();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.equals(stringArray[i])) continue;
                bl = true;
                break;
            }
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "isConfiguredUncheckedRole(String) { retVal = " + bl + " }");
        }
        return bl;
    }

    public boolean isConfiguredExcludedRole(String string) {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "isConfiguredExcludedRole(String roleName) { roleName = " + string + " }");
        }
        boolean bl = false;
        String[] stringArray = this._sess.getExcludedNames();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.equals(stringArray[i])) continue;
                bl = true;
                break;
            }
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "isConfiguredExcludedRole(String) { retVal = " + bl + " }");
        }
        return bl;
    }

    List listPos(String string, String string2) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "listPos(String prefix, String suffix) { prefix = " + string + " , suffix = " + string2 + " }");
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.text(16L, (Object)CLASSNAME, "listPos", "Listing POS with prefix: " + string + " and suffix: " + string2);
        }
        ArrayList arrayList = null;
        if (string == null || !string.startsWith("/")) {
            AmasMessage amasMessage = new AmasMessage(916942850);
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                this._msgLogger.text(4L, (Object)CLASSNAME, "listPos", amasMessage.getMessageString());
            }
            throw new AmasException(amasMessage);
        }
        if (string2 == null) {
            string2 = new String();
        }
        if (!string2.startsWith("/")) {
            string2 = string2 + '/';
        }
        if (!string2.endsWith("/")) {
            string2 = string2 + '/';
        }
        AmasObject amasObject = this.createObject(this._sess, string);
        List list = amasObject.listChildrenRecursive();
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.text(16L, (Object)CLASSNAME, "listPos", "Children [" + list.size() + "]");
        }
        if (list != null && list.size() > 0) {
            ArrayList arrayList2 = new ArrayList();
            this.list(list, string2, arrayList2);
            arrayList = arrayList2;
        } else if (string.endsWith(string2)) {
            ArrayList<String> arrayList3 = new ArrayList<String>();
            arrayList3.add(string);
            arrayList = arrayList3;
        } else {
            arrayList = new ArrayList();
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "listPos(String, String)");
        }
        return arrayList;
    }

    private void list(List list, String string, List list2) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "list(List prefixes, String suffix, List suffixMatches) { suffix = " + string + " }");
        }
        if (list != null && list.size() > 0 && list2 != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                String string2 = (String)list.get(i) + "/";
                if (!string2.endsWith(string)) continue;
                list2.add(string2);
            }
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "list(List, String, List)");
        }
    }
}

