/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pd.as.rbpf;

import com.tivoli.pd.as.atcc.IATCCache;
import com.tivoli.pd.as.atcc.IObjectTreeCache;
import com.tivoli.pd.as.rbpf.AmasAddCmdObject;
import com.tivoli.pd.as.rbpf.AmasDeleteCmdObject;
import com.tivoli.pd.as.rbpf.AmasGetCmdObject;
import com.tivoli.pd.as.rbpf.AmasListCmdObject;
import com.tivoli.pd.as.rbpf.AmasSession;
import com.tivoli.pd.as.rbpf.IAmasPDObject;
import com.tivoli.pd.as.util.AmasException;
import com.tivoli.pd.as.util.AmasMessage;
import com.tivoli.pd.jras.pdjlog.jlog.ILogger;
import java.util.ArrayList;
import java.util.List;

public class AmasPDObjectCache
implements IAmasPDObject {
    private final String AmasPDObjectCache_java_sourceCodeID = "$Id: @(#)03  1.2 src/amas/com/tivoli/pd/as/rbpf/AmasPDObjectCache.java, amemb.jacc.was, amemb600, 051118a 05/05/06 01:41:23 @(#) $";
    public static final String sCopyright = "IBM Confidential\nObject Code Only Source Materials\n5747-SM3\n(c) Copyright International Business Machines Corp. 1994-2002.  All Rights Reserved.\nThe source code for this program is not published or otherwise divested\nof its trade secrets, irrespective of what has been deposited with the\nU.S. Copyright Office.\n";
    private static String CLASSNAME = "com.tivoli.pd.as.rbpf.AmasPDObjectCache";
    private AmasSession _sess;
    private String _posName;
    private IObjectTreeCache _objectCache;
    private IATCCache _atcc;
    protected ILogger _msgLogger;
    protected ILogger _trcLogger;

    public AmasPDObjectCache(AmasSession amasSession, String string) {
        this._sess = amasSession;
        this._posName = string;
        this._atcc = amasSession.getCfgManager().getATCCache();
        this._objectCache = amasSession.getCfgManager().getObjectCache();
        this._trcLogger = this._sess.getLogManager().getTraceLogger("AmasRBPFTraceLogger");
        this._msgLogger = this._sess.getLogManager().getMessageLogger("AmasRBPFMessageLogger");
    }

    String getPosName() {
        return this._posName;
    }

    public boolean exists() throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "exists()");
        }
        boolean bl = false;
        AmasGetCmdObject amasGetCmdObject = new AmasGetCmdObject(this._sess, this._objectCache, this._posName, null, AmasGetCmdObject.CHECK_EXISTS);
        boolean bl2 = this._atcc.runTransaction(amasGetCmdObject);
        if (bl2) {
            bl = amasGetCmdObject.exists();
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "exists()");
        }
        return bl;
    }

    public List getAttributeNames() throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "getAttributeNames()");
        }
        List list = new ArrayList();
        AmasGetCmdObject amasGetCmdObject = new AmasGetCmdObject(this._sess, this._objectCache, this._posName, null, AmasGetCmdObject.GET_ATTR_NAMES);
        boolean bl = this._atcc.runTransaction(amasGetCmdObject);
        if (bl) {
            list = amasGetCmdObject.getResults();
        } else if (this._msgLogger != null && this._msgLogger.isLogging()) {
            this._msgLogger.text(4L, (Object)CLASSNAME, "getAttributeNames()", "AmasGetCmdObject( _objectCache, " + this.getPosName() + ") failed");
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "getAttributeNames()");
        }
        return list;
    }

    public void addAttributeValue(String string, String string2) throws AmasException {
        AmasAddCmdObject amasAddCmdObject;
        boolean bl;
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "addAttributeValue()");
        }
        if (!(bl = this._atcc.runTransaction(amasAddCmdObject = new AmasAddCmdObject(this._sess, this._objectCache, this.getPosName(), string, string2, false))) && this._msgLogger != null && this._msgLogger.isLogging()) {
            this._msgLogger.text(4L, (Object)CLASSNAME, "addAttributeValue()", "AmasAddCmdObject( _objectCache, " + this.getPosName() + ", " + string + ", " + string2 + ", false) failed");
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "addAttributeValue()");
        }
    }

    public List listChildObjects() throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "listChildObjects()");
        }
        List list = new ArrayList();
        AmasListCmdObject amasListCmdObject = new AmasListCmdObject(this._sess, this._objectCache, this.getPosName());
        boolean bl = this._atcc.runTransaction(amasListCmdObject);
        if (bl) {
            list = amasListCmdObject.getChildObjects();
        } else if (this._msgLogger != null && this._msgLogger.isLogging()) {
            this._msgLogger.text(4L, (Object)CLASSNAME, "listChildObjects()", "AmasAddCmdObject(_objectCache, " + this.getPosName() + ") failed");
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "listChildObjects()");
        }
        return list;
    }

    public List listChildren() throws AmasException {
        List list = this.listChildObjects();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "listChildren()");
        }
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Object object;
                String string = (String)list.get(i);
                int n2 = -1;
                if (string.startsWith(this._posName)) {
                    n2 = this._posName.length();
                }
                if (n2 == -1) {
                    object = new AmasMessage(916942856);
                    if (this._msgLogger != null && this._msgLogger.isLogging()) {
                        this._msgLogger.text(4L, (Object)CLASSNAME, "listChildren()", ((AmasMessage)object).getMessageString());
                    }
                    throw new AmasException((AmasMessage)object);
                }
                object = string.substring(n2);
                if (arrayList.contains(object)) continue;
                arrayList.add(object);
            }
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "listChildren()");
        }
        return arrayList;
    }

    public void removeAttributeValue(String string, String string2) throws AmasException {
        AmasDeleteCmdObject amasDeleteCmdObject;
        boolean bl;
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "removeAttributeValue()");
        }
        if (!(bl = this._atcc.runTransaction(amasDeleteCmdObject = new AmasDeleteCmdObject(this._sess, this._objectCache, this.getPosName(), string, string2))) && this._msgLogger != null && this._msgLogger.isLogging()) {
            this._msgLogger.text(4L, (Object)CLASSNAME, "removeAttributeValue()", "AmasDeleteCmdObject(_objectCache, " + this.getPosName() + ", " + string + ", " + string2 + ") failed");
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "removeAttributeValue()");
        }
    }

    public void removeAttribute(String string) throws AmasException {
        AmasDeleteCmdObject amasDeleteCmdObject;
        boolean bl;
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "removeAttribute()");
        }
        if (!(bl = this._atcc.runTransaction(amasDeleteCmdObject = new AmasDeleteCmdObject(this._sess, this._objectCache, this.getPosName(), string, null))) && this._msgLogger != null && this._msgLogger.isLogging()) {
            this._msgLogger.text(4L, (Object)CLASSNAME, "removeAttribute()", "AmasDeleteCmdObject(_objectCache, " + this.getPosName() + ", " + string + ", null) failed");
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "removeAttribute()");
        }
    }

    public List attributeValueList(String string) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "attributeValueList()");
        }
        List list = new ArrayList();
        AmasGetCmdObject amasGetCmdObject = new AmasGetCmdObject(this._sess, this._objectCache, this.getPosName(), string);
        boolean bl = this._atcc.runTransaction(amasGetCmdObject);
        if (bl) {
            list = amasGetCmdObject.getResults();
        } else if (this._msgLogger != null && this._msgLogger.isLogging()) {
            this._msgLogger.text(4L, (Object)CLASSNAME, "attributeValueList()", "AmasGetCmdObject(_objectCache, " + this.getPosName() + ", " + string + ") failed");
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "attributeValueList()");
        }
        return list;
    }

    public void setSingleValueAttribute(String string, String string2) throws AmasException {
        AmasAddCmdObject amasAddCmdObject;
        boolean bl;
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "setSingleValueAttribute()");
        }
        if (!(bl = this._atcc.runTransaction(amasAddCmdObject = new AmasAddCmdObject(this._sess, this._objectCache, this.getPosName(), string, string2, true))) && this._msgLogger != null && this._msgLogger.isLogging()) {
            this._msgLogger.text(4L, (Object)CLASSNAME, "setSingleValueAttribute()", "AmasAddCmdObject( _objectCache, " + this.getPosName() + ", " + string + ", " + string2 + ", true) failed");
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "setSingleValueAttribute()");
        }
    }

    public void createProtObject() throws AmasException {
        AmasAddCmdObject amasAddCmdObject;
        boolean bl;
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "createProtObject()");
        }
        if (!(bl = this._atcc.runTransaction(amasAddCmdObject = new AmasAddCmdObject(this._sess, this._objectCache, this.getPosName(), null, null, false))) && this._msgLogger != null && this._msgLogger.isLogging()) {
            this._msgLogger.text(4L, (Object)CLASSNAME, "createProtObject()", "AmasAddCmdObject(_objectCache, " + this.getPosName() + ", null, null, false) failed");
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "createProtObject()");
        }
    }

    public void deleteProtObject() throws AmasException {
        AmasDeleteCmdObject amasDeleteCmdObject;
        boolean bl;
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "deleteProtObject()");
        }
        if (!(bl = this._atcc.runTransaction(amasDeleteCmdObject = new AmasDeleteCmdObject(this._sess, this._objectCache, this.getPosName(), null, null))) && this._msgLogger != null && this._msgLogger.isLogging()) {
            this._msgLogger.text(4L, (Object)CLASSNAME, "deleteProtObject()", "AmasDeleteCmdObject(_objectCache, " + this.getPosName() + ", null, null) failed");
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "deleteProtObject()");
        }
    }
}

