/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pd.as.rbpf;

import com.tivoli.pd.as.nls.AmasMsgHelper;
import com.tivoli.pd.as.rbpf.AmasObject;
import com.tivoli.pd.as.rbpf.AmasSession;
import com.tivoli.pd.as.rbpf.IAmasPDObject;
import com.tivoli.pd.as.rbpf.PDPosUtil;
import com.tivoli.pd.as.util.AmasException;
import com.tivoli.pd.as.util.AmasMessage;
import com.tivoli.pd.as.util.AmasPDHelper;
import com.tivoli.pd.jadmin.PDAcl;
import com.tivoli.pd.jadmin.PDAclEntryAnyOther;
import com.tivoli.pd.jadmin.PDAclEntryGroup;
import com.tivoli.pd.jadmin.PDAclEntryUnAuth;
import com.tivoli.pd.jadmin.PDAclEntryUser;
import com.tivoli.pd.jadmin.PDProtObject;
import com.tivoli.pd.jadmin.PDUser;
import com.tivoli.pd.jazn.PDAuthorizationContext;
import com.tivoli.pd.jras.pdjlog.jlog.ILogger;
import com.tivoli.pd.jutil.PDAttrValue;
import com.tivoli.pd.jutil.PDAttrs;
import com.tivoli.pd.jutil.PDContext;
import com.tivoli.pd.jutil.PDException;
import com.tivoli.pd.jutil.PDMessages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class AmasPDObjectDirect
implements IAmasPDObject {
    private final String AmasPDObjectDirect_java_sourceCodeID = "$Id: @(#)04  1.3 src/amas/com/tivoli/pd/as/rbpf/AmasPDObjectDirect.java, amemb.jacc.was, amemb600, 081121a 08/11/20 20:25:00 @(#) $";
    public static final String sCopyright = "IBM Confidential\nObject Code Only Source Materials\n5747-SM3\n(c) Copyright International Business Machines Corp. 1994-2002.  All Rights Reserved.\nThe source code for this program is not published or otherwise divested\nof its trade secrets, irrespective of what has been deposited with the\nU.S. Copyright Office.\n";
    private AmasSession _sess;
    private String _posName;
    private PDProtObject _protObject = null;
    private String _aclName;
    private PDAcl _acl;
    private PDAttrs _attrs = null;
    private static String CLASSNAME = "com.tivoli.pd.as.rbpf.AmasPDObjectDirect";
    protected ILogger _msgLogger;
    protected ILogger _trcLogger;
    protected boolean _protObjectExists = false;

    public AmasPDObjectDirect(AmasSession amasSession, String string) {
        this._sess = amasSession;
        this._posName = string;
        this._trcLogger = this._sess.getLogManager().getTraceLogger("AmasRBPFTraceLogger");
        this._msgLogger = this._sess.getLogManager().getMessageLogger("AmasRBPFMessageLogger");
    }

    public boolean exists() throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "exists()");
        }
        boolean bl = false;
        try {
            bl = AmasPDHelper.objectExists(this._posName, (PDContext)this._sess.getSessionContext());
        }
        catch (PDException pDException) {
            throw new AmasException(pDException);
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "exists()");
        }
        return bl;
    }

    String getPosName() {
        return this._posName;
    }

    String getAclName() {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "getAclName()");
        }
        String string = this._sess.getRoleContainerName().replace('/', '_') + "_" + this._posName.hashCode();
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "getAclName() { retVal = " + string + " }");
        }
        return string;
    }

    public List getAttributeNames() throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "getAttributeNames()");
        }
        List list = new ArrayList();
        if (this.exists()) {
            list = this.doGetAttributeNames();
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "getAttributeNames()");
        }
        return list;
    }

    List doGetAttributeNames() throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "doGetAttributeNames()");
        }
        ArrayList arrayList = null;
        if (this._protObject == null && this._attrs != null) {
            Set set = this._attrs.keySet();
            arrayList = set != null ? new ArrayList(set) : new ArrayList();
        }
        if (arrayList == null) {
            this.setProtObject();
            try {
                arrayList = this._protObject.getAttributeNames();
            }
            catch (PDException pDException) {
                throw new AmasException(pDException);
            }
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "doGetAttributeNames()");
        }
        return arrayList;
    }

    public void addAttributeValue(String string, String string2) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "addAttributeValue()");
        }
        if (!this.exists()) {
            this.createProtObject();
        }
        this.doAddAttributeValue(string, string2);
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "addAttributeValue()");
        }
    }

    void doAddAttributeValue(String string, String string2) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "doAddAttributeValue()");
        }
        PDAuthorizationContext pDAuthorizationContext = this._sess.getSessionContext();
        try {
            this.setProtObject();
            this._protObject.setAttributeValue((PDContext)pDAuthorizationContext, string, string2, new PDMessages());
        }
        catch (PDException pDException) {
            throw new AmasException(pDException);
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "doAddAttributeValue()");
        }
    }

    public List listChildren() throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "listChildren()");
        }
        List list = this.listChildObjects();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Object object;
                String string = (String)list.get(i);
                int n2 = -1;
                if (string.startsWith(this._posName)) {
                    n2 = this._posName.length();
                }
                if (n2 == -1) {
                    object = new AmasMessage(916942856);
                    if (this._msgLogger != null && this._msgLogger.isLogging()) {
                        this._msgLogger.text(4L, (Object)CLASSNAME, "listChildren()", ((AmasMessage)object).getMessageString());
                    }
                    throw new AmasException((AmasMessage)object);
                }
                object = string.substring(n2);
                if (arrayList.contains(object)) continue;
                arrayList.add(object);
            }
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "listChildren()");
        }
        return arrayList;
    }

    public List listChildObjects() throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "listChildObjects()");
        }
        PDAuthorizationContext pDAuthorizationContext = this._sess.getSessionContext();
        ArrayList arrayList = null;
        if (this._posName == null) {
            throw new IllegalArgumentException();
        }
        try {
            String string = this._posName;
            if (string.endsWith("/")) {
                string.substring(0, string.length() - 1);
            }
            arrayList = PDProtObject.listProtObjects((PDContext)pDAuthorizationContext, (String)string, (PDAttrs)null, (PDAttrs)null, (PDMessages)new PDMessages());
        }
        catch (PDException pDException) {
            throw new AmasException(pDException);
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "listChildObjects()");
        }
        return arrayList;
    }

    public void removeAttributeValue(String string, String string2) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "removeAttributeValue()");
        }
        if (this.exists()) {
            this.doRemoveAttributeValue(string, string2);
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "removeAttributeValue()");
        }
    }

    void doRemoveAttributeValue(String string, String string2) throws AmasException {
        block5: {
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.entry(80L, (Object)CLASSNAME, "doRemoveAttributeValue()");
            }
            this.setProtObject();
            try {
                PDAuthorizationContext pDAuthorizationContext = this._sess.getSessionContext();
                PDMessages pDMessages = new PDMessages();
                pDMessages.clear();
                this._protObject.deleteAttributeValue((PDContext)pDAuthorizationContext, string, string2, pDMessages);
            }
            catch (PDException pDException) {
                if (AmasPDHelper.doesPDExceptionContainMsgCode(pDException, 268808653)) break block5;
                if (this._msgLogger != null && this._msgLogger.isLogging()) {
                    this._msgLogger.text(4L, (Object)CLASSNAME, "doRemoveAttributeValue(String, String)", AmasMsgHelper.formatDoubleParamMessage(916942887, this._posName, pDException.toString()));
                }
                throw new AmasException(pDException);
            }
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "doRemoveAttributeValue()");
        }
    }

    public void removeAttribute(String string) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "removeAttribute()");
        }
        if (this.exists()) {
            this.doRemoveAttribute(string);
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "removeAttribute()");
        }
    }

    void doRemoveAttribute(String string) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "doRemoveAttribute()");
        }
        this.setProtObject();
        try {
            PDAuthorizationContext pDAuthorizationContext = this._sess.getSessionContext();
            PDMessages pDMessages = new PDMessages();
            this._protObject.deleteAttribute((PDContext)pDAuthorizationContext, string, pDMessages);
            this._protObject = new PDProtObject((PDContext)pDAuthorizationContext, this._posName, (PDAttrs)null, (PDAttrs)null, new PDMessages());
        }
        catch (PDException pDException) {
            throw new AmasException(pDException);
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "doRemoveAttribute()");
        }
    }

    public List attributeValueList(String string) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "attributeValueList()");
        }
        if (string == null) {
            throw new IllegalArgumentException();
        }
        List list = new ArrayList();
        if (this.exists()) {
            list = this.doAttributeValueList(string);
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "attributeValueList()");
        }
        return list;
    }

    List doAttributeValueList(String string) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "doAttributeValueList()");
        }
        ArrayList<Object> arrayList = null;
        if (this._protObject == null && this._attrs != null) {
            Collection collection = this._attrs.getValues(string);
            arrayList = new ArrayList<Object>();
            if (collection != null) {
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    PDAttrValue pDAttrValue = (PDAttrValue)iterator.next();
                    arrayList.add(pDAttrValue.getValue());
                }
            }
        }
        if (arrayList == null) {
            this.setProtObject();
            try {
                arrayList = this._protObject.getAttributeValues(string);
            }
            catch (PDException pDException) {
                throw new AmasException(pDException);
            }
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "doAttributeValueList()");
        }
        return arrayList;
    }

    public void setSingleValueAttribute(String string, String string2) throws AmasException {
        List list;
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "setSingleValueAttribute()");
        }
        if ((list = this.attributeValueList(string)).size() > 0) {
            this.removeAttribute(string);
        }
        this.addAttributeValue(string, string2);
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "setSingleValueAttribute()");
        }
    }

    public PDAcl getAttachedAcl() throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "getAttachedAcl()");
        }
        if (this._acl == null && this.exists()) {
            this.doGetAttachedAcl();
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            if (this._acl != null) {
                this._trcLogger.exit(96L, (Object)CLASSNAME, "getAttachedAcl() { retVal = " + this._acl.toString() + " }");
            } else {
                this._trcLogger.exit(96L, (Object)CLASSNAME, "getAttachedAcl() { retVal = null }");
            }
        }
        return this._acl;
    }

    PDAcl doGetAttachedAcl() throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "doGetAttachedAcl()");
        }
        if (this._acl == null) {
            try {
                this.setProtObject();
                PDMessages pDMessages = new PDMessages();
                PDAuthorizationContext pDAuthorizationContext = this._sess.getSessionContext();
                String string = this._protObject.getAclId();
                if (string != null) {
                    this._acl = new PDAcl((PDContext)pDAuthorizationContext, string, pDMessages);
                }
            }
            catch (PDException pDException) {
                if (this._msgLogger != null && this._msgLogger.isLogging()) {
                    this._msgLogger.text(4L, (Object)CLASSNAME, "doGetAttachedAcl()", AmasMsgHelper.formatDoubleParamMessage(916942888, this._posName, pDException.toString()));
                }
                throw new AmasException(pDException);
            }
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            if (this._acl != null) {
                this._trcLogger.exit(96L, (Object)CLASSNAME, "doGetAttachedAcl() { retVal = " + this._acl.toString() + " }");
            } else {
                this._trcLogger.exit(96L, (Object)CLASSNAME, "doGetAttachedAcl() { retVal = null }");
            }
        }
        return this._acl;
    }

    public void addAclEntry(String string, int n, boolean bl, boolean bl2) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "addAclEntry(String entryName, int type, boolean dupParentPolicy, boolean propogateToChildren) { entryName = " + string + " , type = " + n + " , dupParentPolicy = " + bl + " , propogateToChildren = " + bl2 + " }");
        }
        this.prepareForAclOp(bl);
        this.addSingleAclEntry(string, n);
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.text(16L, (Object)CLASSNAME, "addAclEntry(String, int, boolean, boolean)", "Adding entry " + string + " to ACL " + this.getAclName());
        }
        if (bl2) {
            this.propogateAclEntry(string, n, bl);
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "addAclEntry(String, int, boolean, boolean)");
        }
    }

    public void createAndAttachAcl(boolean bl) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "createAndAttachAcl(boolean inheritPolicy) { inheritPolicy = " + bl + " }");
        }
        this.doCreateAndAttachAcl(bl);
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "createAndAttachAcl(boolean)");
        }
    }

    void doCreateAndAttachAcl(boolean bl) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "doCreateAndAttachAcl()");
        }
        PDAcl pDAcl = null;
        if (bl) {
            pDAcl = this.getInheritedAcl();
        }
        String string = AmasMsgHelper.formatSingleParamMessage(916942857, this._sess.getProductName());
        String string2 = this._posName;
        if (string2.endsWith("/")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        this._protObject = PDPosUtil.createAndAttachAcl(this._sess, string2, this.getAclName(), pDAcl, string);
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "doCreateAndAttachAcl()");
        }
    }

    public PDAcl getInheritedAcl() throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "getInheritedAcl()");
        }
        PDAcl pDAcl = this.doGetInheritedAcl();
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(96L, (Object)CLASSNAME, "getInheritedAcl()");
        }
        return pDAcl;
    }

    PDAcl doGetInheritedAcl() throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "doGetInheritedAcl()");
        }
        this.setProtObject();
        PDAcl pDAcl = null;
        try {
            PDMessages pDMessages = new PDMessages();
            PDAuthorizationContext pDAuthorizationContext = this._sess.getSessionContext();
            String string = this._protObject.getEffectiveAclId();
            if (string != null) {
                pDAcl = new PDAcl((PDContext)pDAuthorizationContext, string, pDMessages);
            }
        }
        catch (PDException pDException) {
            throw new AmasException(pDException);
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(96L, (Object)CLASSNAME, "doGetInheritedAcl()");
        }
        return pDAcl;
    }

    public void removeAclEntry(String string, int n, boolean bl) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "removeAclEntry()");
        }
        this.doRemoveAclEntry(string, n, bl);
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(96L, (Object)CLASSNAME, "removeAclEntry()");
        }
    }

    void doRemoveAclEntry(String string, int n, boolean bl) throws AmasException {
        Object object;
        block14: {
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.entry(80L, (Object)CLASSNAME, "removeAclEntry(String entryName, int type, boolean propogateToChildren) { entryName = " + string + " , type = " + n + " , propogateToChildren = " + bl + " }");
            }
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "removeAclEntry(String, int, boolean)", "Removing entry " + string + " from ACL " + this.getAclName());
            }
            try {
                object = new PDMessages();
                switch (n) {
                    case 3: {
                        PDAcl.removePDAclEntryUnAuth((PDContext)this._sess.getSessionContext(), (String)this.getAclName(), (PDMessages)object);
                        PDAclEntryUnAuth pDAclEntryUnAuth = new PDAclEntryUnAuth((PDContext)this._sess.getSessionContext(), "T", (PDMessages)object);
                        PDAcl.setPDAclEntryUnAuth((PDContext)this._sess.getSessionContext(), (String)this.getAclName(), (PDAclEntryUnAuth)pDAclEntryUnAuth, (PDMessages)object);
                        object.clear();
                        break;
                    }
                    case 4: {
                        PDAcl.removePDAclEntryAnyOther((PDContext)this._sess.getSessionContext(), (String)this.getAclName(), (PDMessages)object);
                        PDAclEntryAnyOther pDAclEntryAnyOther = new PDAclEntryAnyOther((PDContext)this._sess.getSessionContext(), "T", (PDMessages)object);
                        PDAcl.setPDAclEntryAnyOther((PDContext)this._sess.getSessionContext(), (String)this.getAclName(), (PDAclEntryAnyOther)pDAclEntryAnyOther, (PDMessages)object);
                        break;
                    }
                    case 2: {
                        string = AmasPDHelper.getGroupShortName(string, (PDContext)this._sess.getSessionContext());
                        PDAcl.removePDAclEntryGroup((PDContext)this._sess.getSessionContext(), (String)this.getAclName(), (String)string, (PDMessages)new PDMessages());
                        break;
                    }
                    default: {
                        string = AmasPDHelper.getUserShortName(string, (PDContext)this._sess.getSessionContext());
                        PDAcl.removePDAclEntryUser((PDContext)this._sess.getSessionContext(), (String)this.getAclName(), (String)string, (PDMessages)new PDMessages());
                        break;
                    }
                }
            }
            catch (PDException pDException) {
                if (AmasPDHelper.doesPDExceptionContainMsgCode(pDException, 268808648)) break block14;
                if (this._msgLogger != null && this._msgLogger.isLogging()) {
                    this._msgLogger.text(4L, (Object)CLASSNAME, "removeAclEntry()", AmasMsgHelper.formatDoubleParamMessage(916942892, this._posName, pDException.toString()));
                }
                throw new AmasException(pDException);
            }
        }
        if (bl && (object = this.listChildren()) != null) {
            int n2 = object.size();
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "removeAclEntry(String, int, boolean)", "Propogating to " + n2 + " child objects.");
            }
            for (int i = 0; i < n2; ++i) {
                String string2 = (String)object.get(i);
                if (string2 == null) continue;
                AmasObject amasObject = new AmasObject(this._sess, string2);
                amasObject.removeAclEntry(string, n, true);
            }
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "removeAclEntry(String, int, boolean)");
        }
    }

    void setProtObject() throws AmasException {
        if (this._protObject == null) {
            this.setProtObject(null);
        }
    }

    private void setProtObject(PDProtObject pDProtObject) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "setProtObject()");
        }
        if (pDProtObject == null) {
            try {
                PDMessages pDMessages = new PDMessages();
                if (this._trcLogger != null && this._trcLogger.isLogging()) {
                    this._trcLogger.text(16L, (Object)CLASSNAME, "setProtObject(PDProtObject)", "Instantiating new PDProtObject with posName = " + this._posName);
                }
                this._protObject = new PDProtObject((PDContext)this._sess.getSessionContext(), this._posName, (PDAttrs)null, (PDAttrs)null, pDMessages);
            }
            catch (PDException pDException) {
                AmasMessage amasMessage = new AmasMessage(916942909, pDException.toString());
                if (this._msgLogger != null && this._msgLogger.isLogging()) {
                    this._msgLogger.text(4L, (Object)CLASSNAME, "setProtObject(PDProtObject)", amasMessage.getMessageString());
                }
                if (this._trcLogger != null && this._trcLogger.isLogging()) {
                    this._trcLogger.text(16L, (Object)CLASSNAME, "setProtObject(PDProtObject)", "Caught PDException while attempting to create PDProtObject. PosName =  " + this._posName + " : details are " + pDException.toString());
                }
                throw new AmasException(amasMessage);
            }
        } else {
            this._protObject = pDProtObject;
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "setProtObject()");
        }
    }

    public void createProtObject() throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "createProtObject()");
        }
        if (!this.exists()) {
            this.doCreateProtObject();
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "createProtObject()");
        }
    }

    void doCreateProtObject() throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "doCreateProtObject()");
        }
        try {
            PDMessages pDMessages = new PDMessages();
            PDAuthorizationContext pDAuthorizationContext = this._sess.getSessionContext();
            AmasPDHelper.createObject(this._posName, AmasMsgHelper.formatSingleParamMessage(916942857, this._sess.getProductName()), (PDContext)pDAuthorizationContext);
            this._protObjectExists = true;
        }
        catch (PDException pDException) {
            throw new AmasException(pDException);
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "doCreateProtObject()");
        }
    }

    public void deleteProtObject() throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "deleteProtObject()");
        }
        if (this.exists()) {
            PDAcl pDAcl = this.getAttachedAcl();
            this.doDeleteProtObject(pDAcl);
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "deleteProtObject()");
        }
    }

    void doDeleteProtObject(PDAcl pDAcl) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "doDeleteProtObject()");
        }
        try {
            PDMessages pDMessages = new PDMessages();
            boolean bl = false;
            PDAuthorizationContext pDAuthorizationContext = this._sess.getSessionContext();
            if (pDAcl != null) {
                ArrayList arrayList = PDProtObject.listProtObjectsByAcl((PDContext)pDAuthorizationContext, (String)pDAcl.getId(), (PDMessages)pDMessages);
                if (arrayList.size() == 1) {
                    bl = true;
                } else if (this._msgLogger != null && this._msgLogger.isLogging()) {
                    this._msgLogger.text(2L, (Object)CLASSNAME, "doDeleteProtObject()", AmasMsgHelper.formatSingleParamMessage(916942862, pDAcl.getId()));
                }
            }
            AmasPDHelper.deleteObject(this._posName, (PDContext)pDAuthorizationContext);
            this._protObjectExists = false;
            if (bl) {
                AmasPDHelper.deleteAcl(pDAcl.getId(), (PDContext)pDAuthorizationContext);
            }
        }
        catch (PDException pDException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                this._msgLogger.text(4L, (Object)CLASSNAME, "doDeleteProtObject()", AmasMsgHelper.formatDoubleParamMessage(916942891, this._posName, pDException.toString()));
            }
            throw new AmasException(pDException);
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "doDeleteProtObject()");
        }
    }

    private void prepareForAclOp(boolean bl) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "prepareForAclOp()");
        }
        block2: while (true) {
            try {
                PDAcl pDAcl;
                while ((pDAcl = this.getAttachedAcl()) == null) {
                    if (this._trcLogger != null && this._trcLogger.isLogging()) {
                        this._trcLogger.text(16L, (Object)CLASSNAME, "prepareForAclOp(boolean)", "No attached ACL found.");
                    }
                    if ((pDAcl = new PDAcl((PDContext)this._sess.getSessionContext(), this.getAclName(), new PDMessages())) == null) break block2;
                    if (this._trcLogger != null && this._trcLogger.isLogging()) {
                        this._trcLogger.text(16L, (Object)CLASSNAME, "prepareForAclOp(boolean)", "No attached ACL but found ACL with the same name. Deleting this ACL now : " + pDAcl.toString());
                    }
                    AmasPDHelper.deleteAcl(pDAcl.getId(), (PDContext)this._sess.getSessionContext());
                }
                if (this._trcLogger != null && this._trcLogger.isLogging()) {
                    this._trcLogger.text(16L, (Object)CLASSNAME, "prepareForAclOp(boolean)", "Found attached ACL : " + pDAcl.toString());
                }
                this._aclName = pDAcl.getId();
            }
            catch (PDException pDException) {
                if (AmasPDHelper.doesPDExceptionContainMsgCode(pDException, 268808648)) {
                    this.createProtObject();
                    this.createAndAttachAcl(bl);
                    continue;
                }
                if (this._msgLogger != null && this._msgLogger.isLogging()) {
                    this._msgLogger.text(4L, (Object)CLASSNAME, "prepareForAclOp(boolean)", AmasMsgHelper.formatSingleParamMessage(916942849, pDException.toString()));
                }
                throw new AmasException(pDException);
            }
            break;
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "prepareForAclOp()");
        }
    }

    private void addSingleAclEntry(String string, int n) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "addSingleAclEntry(String entryName, int type) { entryName = " + string + " , type = " + n + " }");
        }
        PDAuthorizationContext pDAuthorizationContext = null;
        while (true) {
            try {
                if (pDAuthorizationContext == null) {
                    pDAuthorizationContext = this._sess.getSessionContext();
                }
                if (n == 2) {
                    string = AmasPDHelper.getGroupShortName(string, (PDContext)pDAuthorizationContext);
                } else if (n == 1) {
                    string = AmasPDHelper.getUserShortName(string, (PDContext)pDAuthorizationContext);
                }
                String string2 = "T" + this._sess.getAMActionString();
                if (this._trcLogger != null && this._trcLogger.isLogging()) {
                    this._trcLogger.text(16L, (Object)CLASSNAME, "addSingleAclEntry(String, int)", "Permissions = " + string2);
                }
                switch (n) {
                    case 2: {
                        PDAclEntryGroup pDAclEntryGroup = new PDAclEntryGroup((PDContext)this._sess.getSessionContext(), string, string2, new PDMessages());
                        PDAcl.setPDAclEntryGroup((PDContext)pDAuthorizationContext, (String)this.getAclName(), (PDAclEntryGroup)pDAclEntryGroup, (PDMessages)new PDMessages());
                        break;
                    }
                    case 4: {
                        PDAclEntryAnyOther pDAclEntryAnyOther = new PDAclEntryAnyOther((PDContext)this._sess.getSessionContext(), string2, new PDMessages());
                        PDAcl.setPDAclEntryAnyOther((PDContext)pDAuthorizationContext, (String)this.getAclName(), (PDAclEntryAnyOther)pDAclEntryAnyOther, (PDMessages)new PDMessages());
                        break;
                    }
                    case 3: {
                        PDMessages pDMessages = new PDMessages();
                        PDAclEntryUnAuth pDAclEntryUnAuth = new PDAclEntryUnAuth((PDContext)this._sess.getSessionContext(), string2, pDMessages);
                        PDAcl.setPDAclEntryUnAuth((PDContext)pDAuthorizationContext, (String)this.getAclName(), (PDAclEntryUnAuth)pDAclEntryUnAuth, (PDMessages)new PDMessages());
                        break;
                    }
                    default: {
                        PDAclEntryUser pDAclEntryUser = new PDAclEntryUser((PDContext)this._sess.getSessionContext(), string, string2, new PDMessages());
                        PDAcl.setPDAclEntryUser((PDContext)pDAuthorizationContext, (String)this.getAclName(), (PDAclEntryUser)pDAclEntryUser, (PDMessages)new PDMessages());
                    }
                }
                this._acl = null;
            }
            catch (PDException pDException) {
                try {
                    int n2 = PDUser.getUserRgy((PDContext)pDAuthorizationContext, (PDMessages)new PDMessages());
                    if (n2 == 1 && AmasPDHelper.doesPDExceptionContainMsgCode(pDException, 348132082) && n == 1 && this.isImportUsersEnabled() && this.getImportUserSuffix() != null) {
                        if (this._trcLogger != null && this._trcLogger.isLogging()) {
                            this._trcLogger.text(16L, (Object)CLASSNAME, "addSingleAclEntry(String, int)", "User " + string + " not found. Importing.");
                        }
                        PDPosUtil.importUser(this._sess, string, this.getImportUserPrefix(), this.getImportUserSuffix());
                        continue;
                    }
                    if (n2 == 2 && AmasPDHelper.doesPDExceptionContainMsgCode(pDException, 348132386) && n == 1 && this.isImportUsersEnabled() && this.getImportUserSuffix() != null) {
                        if (this._trcLogger != null && this._trcLogger.isLogging()) {
                            this._trcLogger.text(16L, (Object)CLASSNAME, "addSingleAclEntry(String, int)", "User " + string + " not found. Importing.");
                        }
                        PDPosUtil.importUser(this._sess, string, this.getImportUserPrefix(), this.getImportUserSuffix());
                        continue;
                    }
                    if (n2 == 3 && AmasPDHelper.doesPDExceptionContainMsgCode(pDException, 320938186) && n == 1 && this.isImportUsersEnabled() && this.getImportUserSuffix() != null) {
                        if (this._trcLogger != null && this._trcLogger.isLogging()) {
                            this._trcLogger.text(16L, (Object)CLASSNAME, "addSingleAclEntry(String, int)", "User " + string + " not found. Importing.");
                        }
                        PDPosUtil.importUser(this._sess, string, this.getImportUserPrefix(), this.getImportUserSuffix());
                        continue;
                    }
                    if (n2 == 1 && AmasPDHelper.doesPDExceptionContainMsgCode(pDException, 348132396) && n == 2 && this.isImportGroupsEnabled() && this.getImportGroupSuffix() != null) {
                        if (this._trcLogger != null && this._trcLogger.isLogging()) {
                            this._trcLogger.text(16L, (Object)CLASSNAME, "addSingleAclEntry(String, int)", "Group " + string + " not found. Importing.");
                        }
                        PDPosUtil.importGroup(this._sess, string, this.getImportGroupPrefix(), this.getImportGroupSuffix());
                        continue;
                    }
                    if (n2 == 2 && AmasPDHelper.doesPDExceptionContainMsgCode(pDException, 348132387) && n == 2 && this.isImportGroupsEnabled() && this.getImportGroupSuffix() != null) {
                        if (this._trcLogger != null && this._trcLogger.isLogging()) {
                            this._trcLogger.text(16L, (Object)CLASSNAME, "addSingleAclEntry(String, int)", "Group " + string + " not found. Importing.");
                        }
                        PDPosUtil.importGroup(this._sess, string, this.getImportGroupPrefix(), this.getImportGroupSuffix());
                        continue;
                    }
                    if (n2 == 3 && AmasPDHelper.doesPDExceptionContainMsgCode(pDException, 348132387) && n == 2 && this.isImportGroupsEnabled() && this.getImportGroupSuffix() != null) {
                        if (this._trcLogger != null && this._trcLogger.isLogging()) {
                            this._trcLogger.text(16L, (Object)CLASSNAME, "addSingleAclEntry(String, int)", "Group " + string + " not found. Importing.");
                        }
                        PDPosUtil.importGroup(this._sess, string, this.getImportGroupPrefix(), this.getImportGroupSuffix());
                        continue;
                    }
                    if (this._msgLogger != null && this._msgLogger.isLogging()) {
                        this._msgLogger.text(4L, (Object)CLASSNAME, "addSingleAclEntry(String, int)", AmasMsgHelper.formatDoubleParamMessage(916942889, this.getAclName(), pDException.toString()));
                    }
                    throw new AmasException(pDException);
                }
                catch (PDException pDException2) {
                    if (this._msgLogger != null && this._msgLogger.isLogging()) {
                        this._msgLogger.text(4L, (Object)CLASSNAME, "addSingleAclEntry(String, int)", AmasMsgHelper.formatDoubleParamMessage(916942889, this.getAclName(), pDException2.toString()));
                    }
                    throw new AmasException(pDException2);
                }
            }
            catch (AmasException amasException) {
                if (this._msgLogger != null && this._msgLogger.isLogging()) {
                    this._msgLogger.text(4L, (Object)CLASSNAME, "addSingleAclEntry(String, int)", AmasMsgHelper.formatSingleParamMessage(916942849, amasException.toString()));
                }
                throw new AmasException(amasException);
            }
            break;
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "addSingleAclEntry(String, int)");
        }
    }

    private void propogateAclEntry(String string, int n, boolean bl) throws AmasException {
        List list;
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "propogateAclEntry(String entryName, int type, boolean dupParentPolicy) { entryName = " + string + " , type = " + n + " , dupParentPolicy = " + bl + " }");
        }
        if ((list = this.listChildren()) != null) {
            int n2 = list.size();
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "addSingleAclEntry(String, int)", "Propogating ACL entry to " + n2 + " child objects.");
            }
            for (int i = 0; i < n2; ++i) {
                List list2;
                String string2 = (String)list.get(i);
                if (string2 == null) continue;
                AmasPDObjectDirect amasPDObjectDirect = new AmasPDObjectDirect(this._sess, string2);
                if (amasPDObjectDirect.exists() && ((list2 = amasPDObjectDirect.attributeValueList("ResourceName")) == null || list2.size() == 0)) {
                    amasPDObjectDirect.prepareForAclOp(bl);
                    amasPDObjectDirect.addSingleAclEntry(string, n);
                }
                amasPDObjectDirect.propogateAclEntry(string, n, bl);
            }
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "propogateAclEntry(String, int, boolean)");
        }
    }

    private boolean isImportUsersEnabled() {
        boolean bl = false;
        String string = this._sess.getProperty("com.tivoli.pd.as.rbpf.AutoImport.Users.Enabled");
        if (string != null && string.equalsIgnoreCase("TRUE")) {
            bl = true;
        }
        return bl;
    }

    private boolean isImportGroupsEnabled() {
        boolean bl = false;
        String string = this._sess.getProperty("com.tivoli.pd.as.rbpf.AutoImport.Groups.Enabled");
        if (string != null && string.equalsIgnoreCase("TRUE")) {
            bl = true;
        }
        return bl;
    }

    private String getImportUserSuffix() {
        return this._sess.getProperty("com.tivoli.pd.as.rbpf.AutoImport.User.Suffix");
    }

    private String getImportGroupSuffix() {
        return this._sess.getProperty("com.tivoli.pd.as.rbpf.AutoImport.Group.Suffix");
    }

    private String getImportUserPrefix() {
        String string = this._sess.getProperty("com.tivoli.pd.as.rbpf.AutoImport.User.Prefix");
        if (string == null) {
            string = "";
        }
        return string;
    }

    private String getImportGroupPrefix() {
        String string = this._sess.getProperty("com.tivoli.pd.as.rbpf.AutoImport.Group.Prefix");
        if (string == null) {
            string = "";
        }
        return string;
    }

    public void setAttr(PDAttrs pDAttrs) {
        this._attrs = pDAttrs;
    }

    public String toString() {
        return "AmasPDObjectDirect: ('" + this._posName + "')";
    }

    public boolean isObjectCreated() {
        return this._protObjectExists;
    }
}

