/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pd.as.rbpf;

import com.tivoli.pd.as.nls.AmasMsgHelper;
import com.tivoli.pd.as.rbpf.CfgManager;
import com.tivoli.pd.as.rbpf.PDPosUtil;
import com.tivoli.pd.as.rbpf.ResourceHandlerFactory;
import com.tivoli.pd.as.rbpf.RtManager;
import com.tivoli.pd.as.util.AmasException;
import com.tivoli.pd.as.util.AmasMessage;
import com.tivoli.pd.as.util.AmasPDHelper;
import com.tivoli.pd.as.util.AmasUtil;
import com.tivoli.pd.as.util.PDAdminSession;
import com.tivoli.pd.jadmin.PDAdmin;
import com.tivoli.pd.jazn.PDAuthorizationContext;
import com.tivoli.pd.jazn.PDLocalServer;
import com.tivoli.pd.jras.pdjlog.jlog.ILogger;
import com.tivoli.pd.jras.pdjlog.jlog.MessageCatalog;
import com.tivoli.pd.jras.pdjlog.jlog.mgr.ILogManager;
import com.tivoli.pd.jras.pdjlog.jlog.mgr.LogManager;
import com.tivoli.pd.jras.pdjlog.jlog.mgr.SinglePropertyDataStore;
import com.tivoli.pd.jutil.PDBasicContext;
import com.tivoli.pd.jutil.PDContext;
import com.tivoli.pd.jutil.PDException;
import com.tivoli.pd.jutil.PDMessages;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.Properties;

public final class AmasSession {
    private final String AmasSession_java_sourceCodeID = "$Id: @(#)32  1.17.1.2 src/amas/com/tivoli/pd/as/rbpf/AmasSession.java, amemb.jacc.was, amemb600, 081121a 08/11/20 20:24:59 @(#) $";
    public static final String sCopyright = "IBM Confidential\nObject Code Only Source Materials\n5747-SM3\n(c) Copyright International Business Machines Corp. 1994-2002.  All Rights Reserved.\nThe source code for this program is not published or otherwise divested\nof its trade secrets, irrespective of what has been deposited with the\nU.S. Copyright Office.\n";
    private RtManager _rtManager;
    private CfgManager _cfgManager;
    private PDAdminSession _amasSessionContext;
    private URL _url;
    private ResourceHandlerFactory _resourceHandlerFactory;
    private ILogManager _logManager;
    private ILogger _traceLogger;
    private ILogger _messageLogger;
    private String _posRoot;
    private String _roleContainer;
    private String _resContainer;
    private String _amActionName;
    private String _amActionReadName;
    private Properties _cfgProperties;
    private static final String FALSE = "false";
    private static final String NO = "no";
    private static final String CLASSNAME = "com.tivoli.pd.as.framework.AmasSession";
    static /* synthetic */ Class class$com$tivoli$pd$as$rbpf$AmasSession;

    private AmasSession(Properties properties) throws AmasException {
        if (properties == null) {
            throw new IllegalArgumentException();
        }
        this._cfgProperties = properties;
        String string = this.getProperty("com.tivoli.pd.as.rbpf.AmasSession.LoggingURL");
        AmasSession.checkProperty(string, "com.tivoli.pd.as.rbpf.AmasSession.LoggingURL");
        this.initializeLogging(string);
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "AmasSession(Properties)");
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.text(16L, (Object)CLASSNAME, "Constructor", "Tracing enabled successfully.");
        }
        this.createSessionContext();
        this.initializePDAdminAPI();
        this.constructContainerNames();
        this.preparePos();
        this._rtManager = new RtManager(this);
        this._cfgManager = new CfgManager(this);
        this.registerDBUpdates();
        this._resourceHandlerFactory = new ResourceHandlerFactory(this);
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "AmasSession(Properties)");
        }
    }

    public static AmasSession create(Properties properties) throws AmasException {
        AmasSession amasSession = new AmasSession(properties);
        return amasSession;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AmasSession create(URL uRL) throws AmasException {
        if (uRL == null) {
            throw new IllegalArgumentException();
        }
        Properties properties = new Properties();
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
        }
        catch (IOException iOException) {
            throw new AmasException(916942849, iOException.toString());
        }
        properties.load(inputStream);
        Object var5_5 = null;
        try {
            if (inputStream == null) return AmasSession.create(properties);
            inputStream.close();
            return AmasSession.create(properties);
        }
        catch (IOException iOException) {
            throw new AmasException(916942849, iOException.toString());
        }
        {
            catch (IOException iOException) {
                throw new AmasException(916942849, iOException.toString());
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                if (inputStream == null) throw throwable;
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw new AmasException(916942849, iOException.toString());
            }
        }
    }

    public static String createDefaultAdminURL() {
        String string = null;
        SecurityManager securityManager = System.getSecurityManager();
        string = securityManager == null ? "file:///" + System.getProperty("java.home") + System.getProperty("file.separator") + "PdPerm.properties" : (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return "file:///" + System.getProperty("java.home") + System.getProperty("file.separator") + "PdPerm.properties";
            }
        });
        return string;
    }

    private void initializePDAdminAPI() throws AmasException {
        if (!PDAdmin.isInited()) {
            String string = this.getProperty("com.tivoli.pd.as.rbpf.ProductId");
            try {
                if (string != null && string.length() > 0) {
                    PDAdmin.initialize((String)string, (PDMessages)new PDMessages());
                } else {
                    PDAdmin.initialize((String)"Role Based Policy Framework", (PDMessages)new PDMessages());
                }
            }
            catch (PDException pDException) {
                AmasMessage amasMessage = new AmasMessage(916942854);
                if (this._messageLogger != null && this._messageLogger.isLogging()) {
                    this._messageLogger.text(8L, (Object)CLASSNAME, "initializePDAdminAPI", amasMessage.getMessageString());
                }
                throw new AmasException(amasMessage);
            }
        }
    }

    public CfgManager getCfgManager() {
        return this._cfgManager;
    }

    public RtManager getRtManager() {
        return this._rtManager;
    }

    public String getProperty(String string) {
        String string2 = null;
        if (string != null) {
            string2 = this._cfgProperties.getProperty(string);
        }
        if (string2 != null) {
            string2 = string2.trim();
        }
        return string2;
    }

    public Properties getProperties() {
        return this._cfgProperties;
    }

    public PDAuthorizationContext getSessionContext() throws AmasException {
        PDAuthorizationContext pDAuthorizationContext = null;
        try {
            pDAuthorizationContext = this._amasSessionContext.getCtx();
        }
        catch (PDException pDException) {
            if (this._messageLogger != null && this._messageLogger.isLogging()) {
                AmasMessage amasMessage = new AmasMessage(916942853);
                this._messageLogger.text(8L, (Object)CLASSNAME, "getSessionContext", amasMessage.getMessageString());
            }
            throw new AmasException(916942849, pDException.toString());
        }
        return pDAuthorizationContext;
    }

    private void createSessionContext() throws AmasException {
        Object object;
        String string;
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "createSessionContext()");
        }
        if ((string = this.getProperty("com.tivoli.pd.as.rbpf.AmasSession.CfgURL")) == null) {
            string = AmasSession.createDefaultAdminURL();
            if (this._messageLogger != null && this._messageLogger.isLogging()) {
                object = new AmasMessage(916942859, string);
                this._messageLogger.text(1L, (Object)CLASSNAME, "createSessionContext", ((AmasMessage)object).getMessageString());
            }
        }
        try {
            if (this._traceLogger != null && this._traceLogger.isLogging()) {
                this._traceLogger.text(16L, (Object)CLASSNAME, "createSessionContext", "Attempting to create PD context with URL: " + string);
            }
            object = System.getSecurityManager();
            this._url = null;
            if (object == null) {
                this._url = new URL(string);
            } else {
                final String string2 = string;
                try {
                    this._url = (URL)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws MalformedURLException {
                            return new URL(string2);
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    if (this._messageLogger != null && this._messageLogger.isLogging()) {
                        AmasMessage amasMessage = new AmasMessage(916942854);
                        this._messageLogger.text(8L, (Object)CLASSNAME, "createSessionContext", amasMessage.getMessageString());
                    }
                    throw new AmasException(916942849, "The URL property [" + string + "] is the incorrect format");
                }
            }
            this._amasSessionContext = new PDAdminSession(this._url);
        }
        catch (MalformedURLException malformedURLException) {
            if (this._messageLogger != null && this._messageLogger.isLogging()) {
                AmasMessage amasMessage = new AmasMessage(916942854);
                this._messageLogger.text(8L, (Object)CLASSNAME, "createSessionContext", amasMessage.getMessageString());
            }
            throw new AmasException(916942849, "The URL property [" + string + "] is the incorrect format");
        }
        catch (PDException pDException) {
            if (this._messageLogger != null && this._messageLogger.isLogging()) {
                AmasMessage amasMessage = new AmasMessage(916942855);
                this._messageLogger.text(8L, (Object)CLASSNAME, "createSessionContext", amasMessage.getMessageString());
            }
            pDException.printStackTrace();
            throw new AmasException(pDException);
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "createSessionContext()");
        }
    }

    private void registerDBUpdates() throws AmasException {
        try {
            PDAuthorizationContext pDAuthorizationContext = this.getSessionContext();
            if (pDAuthorizationContext.getMode().equalsIgnoreCase("local")) {
                PDLocalServer.registerForDbUpdates((PDAuthorizationContext)pDAuthorizationContext, (Object)this._rtManager);
            }
        }
        catch (PDException pDException) {
            AmasMessage amasMessage = new AmasMessage(916942911, pDException.toString());
            if (this._messageLogger != null && this._messageLogger.isLogging()) {
                this._messageLogger.text(8L, (Object)CLASSNAME, "AmasSession(Properties)", amasMessage.getMessageString());
            }
            throw new AmasException(amasMessage);
        }
    }

    public String getProductId() {
        return this._cfgProperties.getProperty("com.tivoli.pd.as.rbpf.ProductId");
    }

    public String getProductName() {
        String string = this.getProperty("com.tivoli.pd.as.rbpf.ProductName");
        String string2 = null;
        string2 = string == null ? "RBPF" : string;
        return string2;
    }

    public ILogManager getLogManager() {
        return this._logManager;
    }

    public void registerResourceHandlerClass(Class clazz, Class clazz2) {
        this._resourceHandlerFactory.registerResourceHandlerClass(clazz, clazz2);
    }

    ResourceHandlerFactory getHandlerFactory() {
        return this._resourceHandlerFactory;
    }

    public String getResourceContainerName() {
        return this._resContainer;
    }

    public String getRoleContainerName() {
        return this._roleContainer;
    }

    public String getAMActionString() {
        return this._amActionName;
    }

    public String getAMActionReadString() {
        return this._amActionReadName;
    }

    public String getDefaultExcludedName() {
        return "Excluded";
    }

    public String getDefaultUncheckedName() {
        return "Unchecked";
    }

    public void registerResourceHandlerClasses(Properties properties) throws AmasException {
        if (properties != null) {
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                Object[] objectArray;
                String string = (String)enumeration.nextElement();
                String string2 = properties.getProperty(string);
                try {
                    Class<?> clazz = Class.forName(string);
                    objectArray = Class.forName(string2);
                    this._resourceHandlerFactory.registerResourceHandlerClass(clazz, (Class)objectArray);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    objectArray = new Object[]{string, string2, classNotFoundException.toString()};
                    AmasMessage amasMessage = new AmasMessage(916942920, objectArray);
                    if (this._messageLogger != null && this._messageLogger.isLogging()) {
                        this._messageLogger.text(8L, (Object)CLASSNAME, "registerResourceHandlerClasses(Properties)", amasMessage.getMessageString());
                    }
                    throw new AmasException(amasMessage);
                }
            }
        }
    }

    public void registerDecodeResourceHandlers(Properties properties) throws AmasException {
        if (properties != null) {
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = properties.getProperty(string);
                try {
                    Class<?> clazz = Class.forName(string2);
                    this._resourceHandlerFactory.registerDecodeResourceHandlerClass(string, clazz);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Object[] objectArray = new Object[]{string, string2, classNotFoundException.toString()};
                    AmasMessage amasMessage = new AmasMessage(916942920, objectArray);
                    if (this._messageLogger != null && this._messageLogger.isLogging()) {
                        this._messageLogger.text(8L, (Object)CLASSNAME, "registerDecodeResourceHandlers(Properties)", amasMessage.getMessageString());
                    }
                    throw new AmasException(amasMessage);
                }
            }
        }
    }

    String[] getExcludedNames() {
        String[] stringArray = null;
        String string = this.getDefaultExcludedName() + "," + this.getProperty("com.tivoli.pd.as.rbpf.ExcludedRoles");
        stringArray = AmasUtil.getPropValues(string, ",");
        return stringArray;
    }

    String[] getUncheckedNames() {
        String[] stringArray = null;
        String string = this.getDefaultUncheckedName() + "," + this.getProperty("com.tivoli.pd.as.rbpf.UncheckedRoles");
        stringArray = AmasUtil.getPropValues(string, ",");
        return stringArray;
    }

    private void constructContainerNames() throws AmasException {
        String string;
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "constructContainerNames()");
        }
        if ((string = this._cfgProperties.getProperty("com.tivoli.pd.as.rbpf.PosRoot")) == null) {
            string = "WebAppServer";
        }
        String string2 = this._cfgProperties.getProperty("com.tivoli.pd.as.rbpf.ProductId");
        AmasSession.checkProperty(string2, "com.tivoli.pd.as.rbpf.ProductId");
        String string3 = this._cfgProperties.getProperty("com.tivoli.pd.as.rbpf.ResourceContainerName");
        AmasSession.checkProperty(string3, "com.tivoli.pd.as.rbpf.ResourceContainerName");
        String string4 = this._cfgProperties.getProperty("com.tivoli.pd.as.rbpf.RoleContainerName");
        this._posRoot = "/" + string;
        this._roleContainer = "/";
        this._roleContainer = AmasUtil.appendPosValue(this._roleContainer, string);
        this._roleContainer = AmasUtil.appendPosValue(this._roleContainer, string2);
        if (string4 != null && !string4.equals("")) {
            this._roleContainer = AmasUtil.appendPosValue(this._roleContainer, string4);
        }
        this._resContainer = "/";
        this._resContainer = AmasUtil.appendPosValue(this._resContainer, string);
        this._resContainer = AmasUtil.appendPosValue(this._resContainer, string2);
        this._resContainer = AmasUtil.appendPosValue(this._resContainer, string3);
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "constructContainerNames()");
        }
    }

    private void preparePos() throws AmasException {
        boolean bl;
        block23: {
            Object[] objectArray;
            boolean bl2;
            String string;
            Object object;
            String string2;
            boolean bl3;
            block22: {
                boolean bl4;
                block21: {
                    if (this._traceLogger != null && this._traceLogger.isLogging()) {
                        this._traceLogger.entry(80L, (Object)CLASSNAME, "preparePos()");
                    }
                    String string3 = this._cfgProperties.getProperty("com.tivoli.pd.as.rbpf.RequirePolicySvrAtStartup");
                    bl3 = true;
                    if (string3 != null && (string3.equalsIgnoreCase("true") || string3.equalsIgnoreCase("yes"))) {
                        bl3 = false;
                    }
                    if ((string2 = this._cfgProperties.getProperty("com.tivoli.pd.as.rbpf.AMActionGroup")) == null) {
                        if (this._traceLogger != null && this._traceLogger.isLogging()) {
                            this._traceLogger.text(16L, (Object)CLASSNAME, "preparePos()", "Using default action group.");
                        }
                        string2 = "WebAppServer";
                    }
                    bl4 = false;
                    try {
                        bl4 = PDPosUtil.createActionGroup((PDContext)this.getSessionContext(), string2);
                    }
                    catch (AmasException amasException) {
                        object = new AmasMessage(916942921, (Object)string2, amasException.getAmasMessage());
                        if (this._messageLogger != null && this._messageLogger.isLogging()) {
                            this._messageLogger.text(4L, (Object)CLASSNAME, "preparePos()", ((AmasMessage)object).getMessageString());
                        }
                        Throwable throwable = amasException.getCause();
                        if (bl3 && (AmasPDHelper.doesPDExceptionContainMsgCode(throwable, 813334644) || amasException.toString().indexOf("HPDJA0116E") >= 0)) break block21;
                        throw new AmasException((AmasMessage)object);
                    }
                }
                if (bl4 && this._messageLogger != null && this._messageLogger.isLogging()) {
                    this._messageLogger.text(1L, (Object)CLASSNAME, "preparePos", "Created action group " + string2);
                }
                if ((string = this._cfgProperties.getProperty("com.tivoli.pd.as.rbpf.AMAction")) == null) {
                    if (this._traceLogger != null && this._traceLogger.isLogging()) {
                        this._traceLogger.text(16L, (Object)CLASSNAME, "preparePos()", "Using default action.");
                    }
                    string = "i";
                }
                object = AmasMsgHelper.formatSingleParamMessage(916942857, this.getProductName());
                bl2 = false;
                try {
                    bl2 = PDPosUtil.createAction((PDContext)this.getSessionContext(), string2, string, (String)object);
                }
                catch (AmasException amasException) {
                    Object[] objectArray2 = new Object[]{string, string2, amasException.getAmasMessage()};
                    AmasMessage amasMessage = new AmasMessage(916942922, objectArray2);
                    if (this._messageLogger != null && this._messageLogger.isLogging()) {
                        this._messageLogger.text(4L, (Object)CLASSNAME, "preparePos()", amasMessage.getMessageString());
                    }
                    objectArray = amasException.getCause();
                    if (bl3 && (AmasPDHelper.doesPDExceptionContainMsgCode((Throwable)objectArray, 813334644) || amasException.toString().indexOf("HPDJA0116E") >= 0)) break block22;
                    throw new AmasException(amasMessage);
                }
            }
            if (bl2 && this._messageLogger != null && this._messageLogger.isLogging()) {
                this._messageLogger.text(1L, (Object)CLASSNAME, "preparePos", "Created action " + string);
            }
            this._amActionName = "[" + string2 + "]" + string;
            String string4 = this._cfgProperties.getProperty("com.tivoli.pd.as.rbpf.AMActionRead");
            if (string4 == null) {
                if (this._traceLogger != null && this._traceLogger.isLogging()) {
                    this._traceLogger.text(16L, (Object)CLASSNAME, "preparePos()", "Using default read action.");
                }
                string4 = "x";
            }
            this._amActionReadName = "[" + string2 + "]" + string4;
            bl = false;
            try {
                bl = PDPosUtil.createObjectSpace((PDContext)this.getSessionContext(), this._posRoot, (String)object);
            }
            catch (AmasException amasException) {
                objectArray = new Object[]{this._posRoot, object, amasException.getAmasMessage()};
                AmasMessage amasMessage = new AmasMessage(916942923, objectArray);
                if (this._messageLogger != null && this._messageLogger.isLogging()) {
                    this._messageLogger.text(4L, (Object)CLASSNAME, "preparePos()", amasMessage.getMessageString());
                }
                Throwable throwable = amasException.getCause();
                if (bl3 && (AmasPDHelper.doesPDExceptionContainMsgCode(throwable, 813334644) || amasException.toString().indexOf("HPDJA0116E") >= 0)) break block23;
                throw new AmasException(amasMessage);
            }
        }
        if (bl && this._messageLogger != null && this._messageLogger.isLogging()) {
            this._messageLogger.text(1L, (Object)CLASSNAME, "preparePos()", "Created objectspace " + this._posRoot);
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "preparePos()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void initializeLogging(String var1_1) throws AmasException {
        block21: {
            if (this._traceLogger != null && this._traceLogger.isLogging()) {
                this._traceLogger.entry(80L, (Object)"com.tivoli.pd.as.framework.AmasSession", "initializeLogging(String jlogPropFileName) { jlogPropFileName = " + var1_1 + " }");
            }
            var2_2 = null;
            var3_3 = null;
            var4_4 = null;
            try {
                var5_5 = System.getSecurityManager();
                if (var5_5 == null) {
                    var2_2 = new URL(var1_1);
                } else {
                    var6_7 = var1_1;
                    try {
                        var2_2 = (URL)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws MalformedURLException {
                                return new URL(var6_7);
                            }
                        });
                    }
                    catch (PrivilegedActionException var7_9) {
                        System.out.println(var7_9.toString());
                        System.out.println(AmasMsgHelper.formatSingleParamMessage(916942851, var1_1));
                    }
                }
                var3_3 = new Properties();
                var4_4 = var2_2.openStream();
                var3_3.load(var4_4);
                var9_11 = null;
                ** if (var4_4 == null) goto lbl-1000
            }
            catch (Throwable var8_17) {
                var9_13 = null;
                if (var4_4 != null) {
                    try {
                        var4_4.close();
                    }
                    catch (IOException var10_16) {
                        System.out.println(var10_16.toString());
                    }
                }
                throw var8_17;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    var4_4.close();
                }
                catch (IOException var10_14) {
                    System.out.println(var10_14.toString());
                }
            }
lbl-1000:
            // 2 sources

            {
                break block21;
                catch (IOException var5_6) {
                    System.out.println(var5_6.toString());
                    System.out.println(AmasMsgHelper.formatSingleParamMessage(916942851, var1_1));
                    var9_12 = null;
                    if (var4_4 != null) {
                        try {
                            var4_4.close();
                        }
                        catch (IOException var10_15) {
                            System.out.println(var10_15.toString());
                        }
                    }
                }
            }
        }
        if (var3_3 != null) {
            var5_5 = new SinglePropertyDataStore(var3_3);
            try {
                var6_7 = new PDBasicContext(var3_3);
            }
            catch (PDException var6_8) {
                var7_10 = new AmasMessage(916942924, (Object)var1_1, var6_8.toString());
                System.out.println(var7_10.getMessageString());
                throw new AmasException(var7_10);
            }
            this._logManager = LogManager.getManager();
            MessageCatalog.setClassLoader((ClassLoader)(AmasSession.class$com$tivoli$pd$as$rbpf$AmasSession == null ? (AmasSession.class$com$tivoli$pd$as$rbpf$AmasSession = AmasSession.class$("com.tivoli.pd.as.rbpf.AmasSession")) : AmasSession.class$com$tivoli$pd$as$rbpf$AmasSession).getClassLoader());
            this._traceLogger = this._logManager.getTraceLogger("AmasRBPFTraceLogger");
            this._messageLogger = this._logManager.getMessageLogger("AmasRBPFMessageLogger");
        }
        if (this._logManager == null) {
            System.out.println(AmasMsgHelper.formatMessage(916942852, null));
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)"com.tivoli.pd.as.framework.AmasSession", "initializeLogging(String)");
        }
    }

    private static String appendPosValue(String string, String string2) {
        if (string2 != null) {
            string = string + string2 + '/';
        }
        return string;
    }

    public String getDefaultRoleAttrName() {
        return "AmasRoles";
    }

    private static void checkProperty(String string, String string2) throws AmasException {
        if (string == null) {
            AmasMessage amasMessage = new AmasMessage(916942858, string2);
            throw new AmasException(amasMessage);
        }
    }

    public void closeSessionContext() throws AmasException {
        if (this._amasSessionContext != null) {
            try {
                this._amasSessionContext.closeCtx();
            }
            catch (PDException pDException) {
                throw new AmasException(pDException);
            }
        }
    }

    public void policyRefresh() {
        block5: {
            if (this._traceLogger != null && this._traceLogger.isLogging()) {
                this._traceLogger.entry(80L, (Object)CLASSNAME, "policyRefresh()");
            }
            try {
                String string = AmasPDHelper.getPDServerName(this._url);
                if (this._traceLogger != null && this._traceLogger.isLogging()) {
                    this._traceLogger.text(16L, (Object)CLASSNAME, "policyRefresh()", "Calling policyRefresh for server " + string);
                }
                this.policyRefresh(string);
            }
            catch (PDException pDException) {
                if (this._messageLogger == null || !this._messageLogger.isLogging()) break block5;
                AmasMessage amasMessage = new AmasMessage(916942884, pDException.toString());
                this._messageLogger.text(4L, (Object)CLASSNAME, "policyRefresh()", amasMessage.getMessageString());
            }
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "policyRefresh()");
        }
    }

    public void policyRefresh(String string) {
        block9: {
            if (this._traceLogger != null && this._traceLogger.isLogging()) {
                this._traceLogger.entry(80L, (Object)CLASSNAME, "policyRefresh(String) policyServerName = " + string);
            }
            boolean bl = true;
            String string2 = this.getProperty("com.tivoli.pd.as.rbpf.PolicyRefresh");
            String string3 = this.getProperty("com.tivoli.pd.as.jacc.ForcePolicyRefresh");
            if (string2 != null && (string2.equalsIgnoreCase(FALSE) || string2.equalsIgnoreCase(NO)) && (string3 == null || string3.equalsIgnoreCase(FALSE) || string3.equalsIgnoreCase(NO))) {
                bl = false;
            }
            if (bl) {
                try {
                    if (this._traceLogger != null && this._traceLogger.isLogging()) {
                        this._traceLogger.text(16L, (Object)CLASSNAME, "policyRefresh(String)", "Performing policy update");
                    }
                    AmasPDHelper.policyServerReplicate((PDContext)this.getSessionContext(), string);
                }
                catch (PDException pDException) {
                    if (this._messageLogger != null && this._messageLogger.isLogging()) {
                        AmasMessage amasMessage = new AmasMessage(916942884, pDException.toString());
                        this._messageLogger.text(4L, (Object)CLASSNAME, "policyRefresh(String)", amasMessage.getMessageString());
                    }
                }
                catch (AmasException amasException) {
                    if (this._messageLogger == null || !this._messageLogger.isLogging()) break block9;
                    this._messageLogger.text(4L, (Object)CLASSNAME, "policyRefresh(String)", amasException.getAmasMessage().getMessageString());
                }
            }
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "policyRefresh(String)");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

