/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pd.as.rbpf;

import com.tivoli.pd.as.atcc.IATCCache;
import com.tivoli.pd.as.atcc.IObjectTreeCache;
import com.tivoli.pd.as.nls.AmasMsgHelper;
import com.tivoli.pd.as.rbpf.AmasManager;
import com.tivoli.pd.as.rbpf.AmasObject;
import com.tivoli.pd.as.rbpf.AmasSession;
import com.tivoli.pd.as.rbpf.CfgPermission;
import com.tivoli.pd.as.rbpf.CfgResource;
import com.tivoli.pd.as.rbpf.CfgRole;
import com.tivoli.pd.as.rbpf.ICfgResourceHandler;
import com.tivoli.pd.as.rbpf.IDecodeResourceHandler;
import com.tivoli.pd.as.rbpf.IResourceHandler;
import com.tivoli.pd.as.rbpf.Resource;
import com.tivoli.pd.as.rbpf.ResourceHandler;
import com.tivoli.pd.as.rbpf.ResourceHandlerBase;
import com.tivoli.pd.as.rbpf.ResourceHandlerFactory;
import com.tivoli.pd.as.rbpf.Role;
import com.tivoli.pd.as.rbpf.RoleMember;
import com.tivoli.pd.as.util.AmasException;
import com.tivoli.pd.as.util.AmasMessage;
import com.tivoli.pd.as.util.AmasPDHelper;
import com.tivoli.pd.as.util.AmasUtil;
import com.tivoli.pd.jras.pdjlog.jlog.ILogger;
import com.tivoli.pd.jutil.PDContext;
import com.tivoli.pd.jutil.PDException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class CfgManager
extends AmasManager {
    private final String CfgManager_java_sourceCodeID = "$Id: @(#)17  1.18.2.1 src/amas/com/tivoli/pd/as/rbpf/CfgManager.java, amemb.jacc.was, amemb600, 081121a 08/11/20 20:24:58 @(#) $";
    public static final String sCopyright = "IBM Confidential\nObject Code Only Source Materials\n5747-SM3\n(c) Copyright International Business Machines Corp. 1994-2002.  All Rights Reserved.\nThe source code for this program is not published or otherwise divested\nof its trade secrets, irrespective of what has been deposited with the\nU.S. Copyright Office.\n";
    private static final String CLASSNAME = "com.tivoli.pd.as.rbpf.CfgManager";
    private static final String ATCCACHE_PROPERTY = "com.tivoli.pd.as.atcc.ATCCache";
    private static final String ATCCACHE_ENABLED = "com.tivoli.pd.as.atcc.ATCCache.enabled";
    protected ILogger _msgLogger;
    protected ILogger _trcLogger;
    protected IATCCache _atcCache;
    protected boolean _atcCacheEnabled = false;
    protected int _numberUsage = 0;

    CfgManager(AmasSession amasSession) throws AmasException {
        super(amasSession);
        this._trcLogger = amasSession.getLogManager().getTraceLogger("AmasRBPFTraceLogger");
        this._msgLogger = amasSession.getLogManager().getMessageLogger("AmasRBPFMessageLogger");
        this._atcCacheEnabled = AmasUtil.checkBoolProperty(amasSession.getProperty(ATCCACHE_ENABLED), false);
        if (this._atcCacheEnabled) {
            String string = null;
            string = amasSession.getProperty(ATCCACHE_PROPERTY);
            if (string == null) {
                if (this._msgLogger != null && this._msgLogger.isLogging()) {
                    AmasMessage amasMessage = new AmasMessage(916942877);
                    this._msgLogger.text(2L, (Object)CLASSNAME, "<init>", amasMessage.getMessageString());
                }
                this._atcCache = null;
            } else {
                try {
                    Class<?> clazz = Class.forName(string);
                    this._atcCache = (IATCCache)clazz.newInstance();
                    this._atcCache.initialize(amasSession);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (this._msgLogger != null && this._msgLogger.isLogging()) {
                        AmasMessage amasMessage = new AmasMessage(916942875, string);
                        this._msgLogger.text(4L, (Object)this, "<init>", amasMessage.getMessageString());
                    }
                    this._atcCache = null;
                }
                catch (InstantiationException instantiationException) {
                    if (this._msgLogger != null && this._msgLogger.isLogging()) {
                        AmasMessage amasMessage = new AmasMessage(916942876, string);
                        this._msgLogger.text(4L, (Object)this, "<init>", amasMessage.getMessageString());
                    }
                    this._atcCache = null;
                }
                catch (IllegalAccessException illegalAccessException) {
                    if (this._msgLogger != null && this._msgLogger.isLogging()) {
                        AmasMessage amasMessage = new AmasMessage(916942876, string);
                        this._msgLogger.text(4L, (Object)this, "<init>", amasMessage.getMessageString());
                    }
                    this._atcCache = null;
                }
            }
        }
    }

    public synchronized void enableCache() {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "enableCache()");
        }
        if (this._atcCacheEnabled && this._atcCache != null && !this._atcCache.isEnabled()) {
            this._atcCache.enableTransaction();
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "enableCache()");
        }
    }

    public synchronized void disableCache() {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "disableCache()");
        }
        if (this._atcCacheEnabled && this._atcCache != null && this._atcCache.isEnabled()) {
            this._atcCache.disableTransaction();
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "disableCache()");
        }
    }

    protected boolean isCachingEnabled() {
        boolean bl = false;
        if (this._atcCache != null) {
            bl = this._atcCache.isEnabled();
        }
        return bl;
    }

    protected IATCCache getATCCache() {
        return this._atcCache;
    }

    protected IObjectTreeCache getObjectCache() {
        IObjectTreeCache iObjectTreeCache = null;
        if (this._atcCache != null) {
            iObjectTreeCache = this._atcCache.getObjectCache();
        }
        return iObjectTreeCache;
    }

    protected AmasObject createObject(AmasSession amasSession, String string) throws AmasException {
        return new AmasObject(amasSession, string);
    }

    protected Role instantiateRole(String string, String string2) throws AmasException {
        return new CfgRole(this._sess, string, string2);
    }

    protected Resource instantiateResource(String string, ResourceHandler resourceHandler) throws AmasException {
        return new CfgResource(this._sess, string, resourceHandler);
    }

    public CfgRole[] getRoles(Object object) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "getRoles(Object)");
        }
        try {
            if (this._secMgr != null) {
                this._secMgr.checkPermission(new CfgPermission("Role", "read"));
            }
        }
        catch (SecurityException securityException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                AmasMessage amasMessage = new AmasMessage(916942882, securityException.toString());
                this._msgLogger.text(4L, (Object)CLASSNAME, "getRoles(Object)", amasMessage.getMessageString());
            }
            throw new AmasException(securityException);
        }
        CfgRole[] cfgRoleArray = null;
        String string = this.getRolePrefix();
        String string2 = this.getRoleSuffix(object);
        Role[] roleArray = this.getBaseRoles();
        ArrayList<CfgRole> arrayList = new ArrayList<CfgRole>();
        if (roleArray != null && roleArray.length != 0) {
            for (int i = 0; i < roleArray.length; ++i) {
                String string3 = roleArray[i].getId() + string2;
                AmasObject amasObject = new AmasObject(this._sess, string3);
                if (!amasObject.exists()) continue;
                String string4 = roleArray[i].getRoleName();
                arrayList.add((CfgRole)this.instantiateRole(string4, string3));
            }
        } else {
            cfgRoleArray = new CfgRole[]{};
        }
        cfgRoleArray = arrayList.toArray(new CfgRole[0]);
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "getRoles(Object)");
        }
        return cfgRoleArray;
    }

    public final Role getRole(Resource resource, String string) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            if (resource != null) {
                this._trcLogger.entry(80L, (Object)CLASSNAME, "getRole(Resource resource, String roleName) { resource = " + resource.getPosName() + " , roleName = " + string + " }");
            } else {
                this._trcLogger.entry(80L, (Object)CLASSNAME, "getRole(Resource resource, String roleName) { resource = null , roleName = " + string + " }");
            }
        }
        try {
            if (this._secMgr != null) {
                this._secMgr.checkPermission(new CfgPermission("Role", "read"));
            }
        }
        catch (SecurityException securityException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                AmasMessage amasMessage = new AmasMessage(916942882, securityException.toString());
                this._msgLogger.text(4L, (Object)CLASSNAME, "getRole(Resource, String)", amasMessage.getMessageString());
            }
            throw new AmasException(securityException);
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "getRole(Resource, String)");
        }
        return super.getRole(resource, string);
    }

    public CfgRole getRole(Object object, String string) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "getRole(Object id, String roleName) { roleName = " + string + " }");
        }
        try {
            if (this._secMgr != null) {
                this._secMgr.checkPermission(new CfgPermission("Role", "read"));
            }
        }
        catch (SecurityException securityException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                AmasMessage amasMessage = new AmasMessage(916942882, securityException.toString());
                this._msgLogger.text(4L, (Object)CLASSNAME, "getRole(Object, String)", amasMessage.getMessageString());
            }
            throw new AmasException(securityException);
        }
        CfgRole cfgRole = null;
        String string2 = this.getRolePrefix();
        String string3 = this.getRoleSuffix(object);
        String string4 = string2 + string + string3;
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.text(16L, (Object)CLASSNAME, "getRole(Object, String)", "Instantiating role with full ID = " + string4);
        }
        cfgRole = (CfgRole)this.instantiateRole(string, string4);
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            if (cfgRole != null) {
                this._trcLogger.exit(96L, (Object)CLASSNAME, "getRole(Object, String) { retVal = " + cfgRole.getId() + " }");
            } else {
                this._trcLogger.exit(96L, (Object)CLASSNAME, "getRole(Object, String) { retVal = null }");
            }
        }
        return cfgRole;
    }

    public CfgRole createRole(Object object, String string) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "createRole(Object id, String roleName) { roleName = " + string + " }");
        }
        try {
            if (this._secMgr != null) {
                this._secMgr.checkPermission(new CfgPermission("Role", "create"));
            }
        }
        catch (SecurityException securityException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                AmasMessage amasMessage = new AmasMessage(916942882, securityException.toString());
                this._msgLogger.text(4L, (Object)CLASSNAME, "createRole(Object, String)", amasMessage.getMessageString());
            }
            throw new AmasException(securityException);
        }
        CfgRole cfgRole = null;
        String string2 = this.getRoleObjName(object, string);
        cfgRole = this.createRole(string, string2);
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            if (cfgRole != null) {
                this._trcLogger.exit(96L, (Object)CLASSNAME, "createRole(Object, String) { retVal = " + cfgRole.getId() + " }");
            } else {
                this._trcLogger.exit(96L, (Object)CLASSNAME, "createRole(Object, String) { retVal = null }");
            }
        }
        return cfgRole;
    }

    public CfgRole createRole(Resource resource, String string) throws AmasException {
        String string2;
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            if (resource != null) {
                this._trcLogger.entry(80L, (Object)CLASSNAME, "createRole(Resource resource, String roleName) { resource = " + resource.getPosName() + " , roleName = " + string + " }");
            } else {
                this._trcLogger.entry(80L, (Object)CLASSNAME, "createRole(Resource resource, String roleName) { resource = null , roleName = " + string + " }");
            }
        }
        CfgRole cfgRole = null;
        try {
            if (this._secMgr != null) {
                this._secMgr.checkPermission(new CfgPermission("Role", "create"));
            }
        }
        catch (SecurityException securityException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                AmasMessage amasMessage = new AmasMessage(916942882, securityException.toString());
                this._msgLogger.text(4L, (Object)CLASSNAME, "createRole(Resource, String)", amasMessage.getMessageString());
            }
            throw new AmasException(securityException);
        }
        if (resource != null && string != null) {
            string2 = resource.getRoleObjName(string);
            if (string2 == null) {
                if (this._msgLogger != null && this._msgLogger.isLogging()) {
                    this._msgLogger.text(4L, (Object)CLASSNAME, "createRole(Resource, String)", AmasMsgHelper.formatMessage(916942865, null));
                }
                throw new AmasException(new AmasMessage(916942865));
            }
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "createRole(Resource, String)", "Creating role with rolename = " + string + " and roleobjname = " + string2 + " }");
            }
        } else {
            if (resource == null && this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "createRole(Resource, String)", "Null resource encountered.");
            }
            if (string == null && this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "createRole(Resource, String)", "Null roleName encountered.");
            }
            throw new IllegalArgumentException();
        }
        cfgRole = this.createRole(string, string2);
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            if (cfgRole != null) {
                this._trcLogger.exit(96L, (Object)CLASSNAME, "createRole(Resource, String) { retVal = " + cfgRole.getId() + " }");
            } else {
                this._trcLogger.exit(96L, (Object)CLASSNAME, "createRole(Resource, String) { retVal = null }");
            }
        }
        return cfgRole;
    }

    public void addMemberToRole(CfgRole cfgRole, RoleMember roleMember) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "addMemberToRole(CfgRole, RoleMember)");
        }
        if (this.isConfiguredUncheckedRole(cfgRole.getRoleName())) {
            AmasMessage amasMessage = new AmasMessage(916942906, cfgRole.getRoleName());
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                this._msgLogger.text(4L, (Object)CLASSNAME, "addMemberToRole(CfgRole, RoleMember)", amasMessage.getMessageString());
            }
            throw new AmasException(amasMessage);
        }
        if (this.isConfiguredExcludedRole(cfgRole.getRoleName())) {
            AmasMessage amasMessage = new AmasMessage(916942906, cfgRole.getRoleName());
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                this._msgLogger.text(4L, (Object)CLASSNAME, "addMemberToRole(CfgRole, RoleMember)", amasMessage.getMessageString());
            }
            throw new AmasException(amasMessage);
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.text(16L, (Object)CLASSNAME, "addMemberToRole", "Adding member [" + roleMember.getName() + "] to role [" + cfgRole.getId() + "]");
        }
        cfgRole.addMember(roleMember);
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "addMemberToRole(CfgRole, RoleMember)");
        }
    }

    public void removeMemberFromRole(CfgRole cfgRole, RoleMember roleMember) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "removeMemberFromRole(CfgRole, RoleMember)");
        }
        if (this.isConfiguredUncheckedRole(cfgRole.getRoleName())) {
            AmasMessage amasMessage = new AmasMessage(916942906, cfgRole.getRoleName());
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                this._msgLogger.text(4L, (Object)CLASSNAME, "addMemberToRole(CfgRole, RoleMember)", amasMessage.getMessageString());
            }
            throw new AmasException(amasMessage);
        }
        if (this.isConfiguredExcludedRole(cfgRole.getRoleName())) {
            AmasMessage amasMessage = new AmasMessage(916942906, cfgRole.getRoleName());
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                this._msgLogger.text(4L, (Object)CLASSNAME, "addMemberToRole(CfgRole, RoleMember)", amasMessage.getMessageString());
            }
            throw new AmasException(amasMessage);
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.text(16L, (Object)CLASSNAME, "removeMemberFromRole", "Adding member [" + roleMember.getName() + "] to role [" + cfgRole.getId() + "]");
        }
        cfgRole.removeMember(roleMember);
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "removeMemberFromRole(CfgRole, RoleMember)");
        }
    }

    public void addPrincipalToRole(CfgRole cfgRole, String string) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "addPrincipalToRole(CfgRole, String)");
        }
        try {
            if (this._secMgr != null) {
                this._secMgr.checkPermission(new CfgPermission("Role", "create"));
            }
        }
        catch (SecurityException securityException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                AmasMessage amasMessage = new AmasMessage(916942882, securityException.toString());
                this._msgLogger.text(4L, (Object)CLASSNAME, "addPrincipalToRole(CfgRole, String)", amasMessage.getMessageString());
            }
            throw new AmasException(securityException);
        }
        RoleMember roleMember = new RoleMember(string, 1);
        this.addMemberToRole(cfgRole, roleMember);
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "addPrincipalToRole(CfgRole, String)");
        }
    }

    public void addGroupToRole(CfgRole cfgRole, String string) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "addGroupToRole(CfgRole, String)");
        }
        try {
            if (this._secMgr != null) {
                this._secMgr.checkPermission(new CfgPermission("Role", "create"));
            }
        }
        catch (SecurityException securityException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                AmasMessage amasMessage = new AmasMessage(916942882, securityException.toString());
                this._msgLogger.text(4L, (Object)CLASSNAME, "addGroupToRole(CfgRole, String)", amasMessage.getMessageString());
            }
            throw new AmasException(securityException);
        }
        RoleMember roleMember = new RoleMember(string, 2);
        this.addMemberToRole(cfgRole, roleMember);
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "addGroupToRole(CfgRole, String)");
        }
    }

    public void removePrincipalFromRole(CfgRole cfgRole, String string) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "removePrincipalFromRole(CfgRole, String)");
        }
        try {
            if (this._secMgr != null) {
                this._secMgr.checkPermission(new CfgPermission("Role", "write"));
            }
        }
        catch (SecurityException securityException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                AmasMessage amasMessage = new AmasMessage(916942882, securityException.toString());
                this._msgLogger.text(4L, (Object)CLASSNAME, "removePrincipalFromRole(CfgRole, String)", amasMessage.getMessageString());
            }
            throw new AmasException(securityException);
        }
        RoleMember roleMember = new RoleMember(string, 1);
        this.removeMemberFromRole(cfgRole, roleMember);
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "removePrincipalFromRole(CfgRole, String)");
        }
    }

    public void removeGroupFromRole(CfgRole cfgRole, String string) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "removeGroupFromRole(CfgRole, String)");
        }
        try {
            if (this._secMgr != null) {
                this._secMgr.checkPermission(new CfgPermission("Role", "write"));
            }
        }
        catch (SecurityException securityException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                AmasMessage amasMessage = new AmasMessage(916942882, securityException.toString());
                this._msgLogger.text(4L, (Object)CLASSNAME, "removeGroupFromRole(CfgRole, String)", amasMessage.getMessageString());
            }
            throw new AmasException(securityException);
        }
        RoleMember roleMember = new RoleMember(string, 2);
        this.removeMemberFromRole(cfgRole, roleMember);
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "removeGroupFromRole(CfgRole, String)");
        }
    }

    public void addUnathenticatedToRole(CfgRole cfgRole) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "addUnauthenticatedToRole(CfgRole)");
        }
        try {
            if (this._secMgr != null) {
                this._secMgr.checkPermission(new CfgPermission("Role", "create"));
            }
        }
        catch (SecurityException securityException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                AmasMessage amasMessage = new AmasMessage(916942882, securityException.toString());
                this._msgLogger.text(4L, (Object)CLASSNAME, "addUnauthenicatedToRole(CfgRole)", amasMessage.getMessageString());
            }
            throw new AmasException(securityException);
        }
        RoleMember roleMember = new RoleMember(null, 3);
        this.addMemberToRole(cfgRole, roleMember);
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "addUnauthenticatedToRole(CfgRole)");
        }
    }

    public void addAnyOtherToRole(CfgRole cfgRole) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "addAnyOtherToRole(CfgRole)");
        }
        try {
            if (this._secMgr != null) {
                this._secMgr.checkPermission(new CfgPermission("Role", "create"));
            }
        }
        catch (SecurityException securityException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                AmasMessage amasMessage = new AmasMessage(916942882, securityException.toString());
                this._msgLogger.text(4L, (Object)CLASSNAME, "addAnyOtherToRole(CfgRole)", amasMessage.getMessageString());
            }
            throw new AmasException(securityException);
        }
        RoleMember roleMember = new RoleMember(null, 4);
        this.addMemberToRole(cfgRole, roleMember);
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "addAnyOtherToRole(CfgRole)");
        }
    }

    public void removeUnathenticatedFromRole(CfgRole cfgRole) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "removeUnauthenticatedFromRole(CfgRole)");
        }
        try {
            if (this._secMgr != null) {
                this._secMgr.checkPermission(new CfgPermission("Role", "write"));
            }
        }
        catch (SecurityException securityException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                AmasMessage amasMessage = new AmasMessage(916942882, securityException.toString());
                this._msgLogger.text(4L, (Object)CLASSNAME, "removeUnauthenticatedFromRole(CfgRole)", amasMessage.getMessageString());
            }
            throw new AmasException(securityException);
        }
        RoleMember roleMember = new RoleMember(null, 3);
        this.removeMemberFromRole(cfgRole, roleMember);
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "removeUnauthenticatedFromRole(CfgRole)");
        }
    }

    public void removeAnyOtherFromRole(CfgRole cfgRole) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "removeAnyOtherFromRole(CfgRole)");
        }
        try {
            if (this._secMgr != null) {
                this._secMgr.checkPermission(new CfgPermission("Role", "write"));
            }
        }
        catch (SecurityException securityException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                AmasMessage amasMessage = new AmasMessage(916942882, securityException.toString());
                this._msgLogger.text(4L, (Object)CLASSNAME, "removeAnyOtherFromRole(CfgRole)", amasMessage.getMessageString());
            }
            throw new AmasException(securityException);
        }
        RoleMember roleMember = new RoleMember(null, 4);
        this.removeMemberFromRole(cfgRole, roleMember);
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "removeAnyOtherFromRole(CfgRole)");
        }
    }

    private CfgRole createRole(String string, String string2) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "createRole(String roleName, String roleObjName) { roleName = " + string + " , roleObjName = " + string2 + " }");
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.text(16L, (Object)CLASSNAME, "createRole(String, String)", "Creating new Role " + string2);
        }
        CfgRole cfgRole = null;
        cfgRole = (CfgRole)this.instantiateRole(string, string2);
        cfgRole.createBaseObject();
        cfgRole.createObject();
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            if (cfgRole != null) {
                this._trcLogger.exit(96L, (Object)CLASSNAME, "createRole(String, String) { retVal = " + cfgRole.getId() + " }");
            } else {
                this._trcLogger.exit(96L, (Object)CLASSNAME, "createRole(String, String) { retVal = null }");
            }
        }
        return cfgRole;
    }

    public void deleteRole(CfgRole cfgRole) throws AmasException {
        Object object;
        String string;
        String[] stringArray;
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            if (cfgRole != null) {
                this._trcLogger.entry(80L, (Object)CLASSNAME, "deleteRole(CfgRole) { CfgRole = " + cfgRole.getId() + " }");
            } else {
                this._trcLogger.entry(80L, (Object)CLASSNAME, "deleteRole(CfgRole) { CfgRole = null }");
            }
        }
        String string2 = this._sess.getProperty("com.tivoli.pd.as.rbpf.DeleteBaseRoleRecursive");
        boolean bl = AmasUtil.checkBoolProperty(string2, true);
        String string3 = cfgRole.getRoleName();
        String string4 = this._sess.getProperty("com.tivoli.pd.as.rbpf.NoUncheckedRoles");
        boolean bl2 = AmasUtil.checkBoolProperty(string4, false);
        if (bl2 && string3 != null && string3.startsWith("unchecked_TIV_GC_")) {
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "deleteRole(CfgRole)", "Cleaning up unchecked resources.");
            }
            if ((stringArray = string3.split("_TIV_GC_")).length == 3) {
                if (this._trcLogger != null && this._trcLogger.isLogging()) {
                    this._trcLogger.text(16L, (Object)CLASSNAME, "deleteRole(CfgRole)", "The rolename is correct.");
                }
                StringBuffer stringBuffer = new StringBuffer(this._sess.getResourceContainerName());
                stringBuffer.append("/" + stringArray[1]);
                String string5 = stringBuffer.toString() + "/" + stringArray[2];
                string = stringBuffer.toString() + "/WebResourcePermission/" + stringArray[2];
                object = stringBuffer.toString() + "/WebUserDataPermission/" + stringArray[2];
                String string6 = stringBuffer.toString() + "/WebRoleRefPermission/" + stringArray[2];
                String string7 = stringBuffer.toString() + "/EJBRoleRefPermission/" + stringArray[2];
                String string8 = stringBuffer.toString() + "/EJBMethodPermission/" + stringArray[2];
                String[] stringArray2 = new String[]{string5, string, object, string6, string7, string8};
                if (this._trcLogger != null && this._trcLogger.isLogging()) {
                    this._trcLogger.text(16L, (Object)CLASSNAME, "deleteRole(CfgRole)", "Cleanup starting at : " + string5);
                }
                for (int i = 0; i < 6; ++i) {
                    AmasObject amasObject = new AmasObject(this._sess, stringArray2[i]);
                    List list = amasObject.listChildrenRecursive();
                    if (list == null) continue;
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        String string9 = (String)iterator.next();
                        AmasObject amasObject2 = new AmasObject(this._sess, string9);
                        amasObject2.deleteProtObject();
                    }
                }
            }
        }
        if (cfgRole.isRoleBase() && bl) {
            stringArray = cfgRole.getChildRoles();
            int n = stringArray.size();
            for (int i = 0; i < n; ++i) {
                string = (String)stringArray.get(i);
                object = (CfgRole)this.instantiateRole(string3, string);
                if (this._trcLogger != null && this._trcLogger.isLogging()) {
                    this._trcLogger.text(16L, (Object)CLASSNAME, "deleteRole(CfgRole)", "Deleting child role: " + string + " from base role: " + string3);
                }
                this.deleteRoleInternal((CfgRole)object, bl2);
            }
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.text(16L, (Object)CLASSNAME, "deleteRole(CfgRole)", "Deleting role: " + cfgRole.getId());
        }
        this.deleteRoleInternal(cfgRole, bl2);
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "deleteRole(CfgRole)");
        }
    }

    private void deleteRoleInternal(CfgRole cfgRole, boolean bl) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            if (cfgRole != null) {
                this._trcLogger.entry(80L, (Object)CLASSNAME, "deleteRoleInternal(CfgRole) { CfgRole = " + cfgRole.getId() + " }");
            } else {
                this._trcLogger.entry(80L, (Object)CLASSNAME, "deleteRoleInternal(CfgRole) { CfgRole = null }");
            }
        }
        try {
            if (this._secMgr != null) {
                this._secMgr.checkPermission(new CfgPermission("Role", "delete"));
            }
        }
        catch (SecurityException securityException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                AmasMessage amasMessage = new AmasMessage(916942882, securityException.toString());
                this._msgLogger.text(4L, (Object)CLASSNAME, "deleteRoleInternal(CfgRole)", amasMessage.getMessageString());
            }
            throw new AmasException(securityException);
        }
        if (cfgRole != null) {
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.entry(80L, (Object)CLASSNAME, "deleteRoleInternal(CfgRole)");
            }
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)this, "deleteRoleInternal(CfgRole)", "Deleting role: " + cfgRole.getId());
            }
            try {
                if (!bl) {
                    CfgResource[] cfgResourceArray = cfgRole.getResourceReferences();
                    for (int i = 0; i < cfgResourceArray.length; ++i) {
                        cfgResourceArray[i].removeRoleName(cfgRole.getRoleName());
                    }
                } else {
                    List list = AmasPDHelper.listResources(this._sess.getSessionContext(), cfgRole.getId());
                    if (list != null) {
                        int n = list.size();
                        for (int i = 0; i < n; ++i) {
                            String string = (String)list.get(i);
                            AmasPDHelper.deleteObject(string, (PDContext)this._sess.getSessionContext());
                        }
                    }
                }
                cfgRole.deleteObject(bl);
            }
            catch (AmasException amasException) {
                if (this._msgLogger != null && this._msgLogger.isLogging()) {
                    AmasMessage amasMessage = new AmasMessage(916942861, cfgRole.getId());
                    this._msgLogger.text(4L, (Object)this, "deleteRoleInternal(CfgRole)", amasMessage.getMessageString());
                }
                throw amasException;
            }
            catch (PDException pDException) {
                if (this._msgLogger != null && this._msgLogger.isLogging()) {
                    AmasMessage amasMessage = new AmasMessage(916942861, cfgRole.getId());
                    this._msgLogger.text(4L, (Object)this, "deleteRoleInternal(CfgRole)", amasMessage.getMessageString());
                }
                throw new AmasException(pDException);
            }
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.exit(96L, (Object)CLASSNAME, "deleteRoleInternal(CfgRole)");
            }
        } else {
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "deleteRoleInternal(CfgRole)", "Null role encountered.");
            }
            throw new IllegalArgumentException();
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "deleteRoleInternal(CfgRole)");
        }
    }

    public CfgRole addRoleToResource(CfgResource cfgResource, String string) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            if (cfgResource != null) {
                this._trcLogger.entry(80L, (Object)CLASSNAME, "addRoleToResource(CfgResource res, String roleName) { res = " + cfgResource.getPosName() + " , roleName = " + string + " }");
            } else {
                this._trcLogger.entry(80L, (Object)CLASSNAME, "addRoleToResource(CfgResource res, String roleName) { res = null , roleName = " + string + " }");
            }
        }
        try {
            if (this._secMgr != null) {
                this._secMgr.checkPermission(new CfgPermission("Resource", "write"));
            }
        }
        catch (SecurityException securityException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                AmasMessage amasMessage = new AmasMessage(916942882, securityException.toString());
                this._msgLogger.text(4L, (Object)CLASSNAME, "addRoleToResource(CfgResource, String)", amasMessage.getMessageString());
            }
            throw new AmasException(securityException);
        }
        CfgRole cfgRole = null;
        if (cfgResource != null && string != null) {
            String string2 = this._sess.getProperty("com.tivoli.pd.as.rbpf.NoUncheckedRoles");
            boolean bl = AmasUtil.checkBoolProperty(string2, false);
            if (bl && (string.equalsIgnoreCase("Unchecked") || string.equalsIgnoreCase("Excluded"))) {
                if (this._trcLogger != null && this._trcLogger.isLogging()) {
                    this._trcLogger.text(16L, (Object)CLASSNAME, "addRoleToResource(CfgResource, String)", "Not creating unchecked role.");
                }
                cfgResource.addRoleName(string);
            } else {
                boolean bl2 = false;
                if (this._trcLogger != null && this._trcLogger.isLogging()) {
                    this._trcLogger.text(16L, (Object)CLASSNAME, "addRoleToResource(CfgResource, String)", "Adding Role " + string + " to Resource " + cfgResource.getId());
                }
                if ((cfgRole = this.createRole(cfgResource, string)) != null) {
                    cfgResource.addRoleName(string);
                    if (!bl) {
                        cfgRole.addResourceReference(cfgResource);
                    }
                } else if (this._msgLogger != null && this._msgLogger.isLogging()) {
                    AmasMessage amasMessage = new AmasMessage(916942856);
                    this._msgLogger.text(4L, (Object)CLASSNAME, "addRoleFromResource(CfgResource, String)", amasMessage.getMessageString());
                    throw new AmasException(amasMessage);
                }
            }
        } else {
            if (cfgResource == null && this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "addRoleToResource(CfgResource, String)", "Null resource encountered.");
            }
            if (string == null && this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "addRoleToResource(CfgResource, String)", "Null roleName encountered.");
            }
            throw new IllegalArgumentException();
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            if (cfgRole != null) {
                this._trcLogger.exit(96L, (Object)CLASSNAME, "addRoleToResource(CfgResource, String) { retVal = " + cfgRole.getId() + " }");
            } else {
                this._trcLogger.exit(96L, (Object)CLASSNAME, "addRoleToResource(CfgResource, String) { retVal = null }");
            }
        }
        return cfgRole;
    }

    public void removeRoleFromResource(CfgResource cfgResource, CfgRole cfgRole) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            if (cfgResource != null && cfgRole != null) {
                this._trcLogger.entry(80L, (Object)CLASSNAME, "removeRoleFromResource(CfgResource res, CfgRole role) { res = " + cfgResource.getPosName() + " , role = " + cfgRole.getId() + " }");
            } else if (cfgResource == null && cfgRole != null) {
                this._trcLogger.entry(80L, (Object)CLASSNAME, "removeRoleFromResource(CfgResource res, CfgRole role) { res = null , role = " + cfgRole.getId() + " }");
            } else if (cfgResource != null && cfgRole == null) {
                this._trcLogger.entry(80L, (Object)CLASSNAME, "removeRoleFromResource(CfgResource res, CfgRole role) { res = " + cfgResource.getPosName() + " , role = null }");
            } else {
                this._trcLogger.entry(80L, (Object)CLASSNAME, "removeRoleFromResource(CfgResource res, CfgRole role) { res = null , role = null }");
            }
        }
        try {
            if (this._secMgr != null) {
                this._secMgr.checkPermission(new CfgPermission("Resource", "write"));
            }
        }
        catch (SecurityException securityException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                AmasMessage amasMessage = new AmasMessage(916942882, securityException.toString());
                this._msgLogger.text(4L, (Object)CLASSNAME, "removeRoleFromResource(CfgResource, CfgRole)", amasMessage.getMessageString());
            }
            throw new AmasException(securityException);
        }
        if (cfgResource != null && cfgRole != null) {
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "removeRoleFromResource(CfgResource, CfgRole)", "Removing role " + cfgRole.getRoleName() + " from Resource " + cfgResource.getId());
            }
        } else {
            if (cfgResource == null && this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "removeRoleFromResource(CfgResource, CfgRole)", "Null resource encountered.");
            }
            if (cfgRole == null && this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "removeRoleFromResource(CfgResource, CfgRole)", "Null role encountered.");
            }
            throw new IllegalArgumentException();
        }
        cfgRole.deleteResourceReference(cfgResource);
        cfgResource.removeRoleName(cfgRole.getRoleName());
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "removeRoleFromResource(CfgResource, CfgRole)");
        }
    }

    public void removeRoleFromResource(CfgResource cfgResource, String string) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            if (cfgResource != null) {
                this._trcLogger.entry(80L, (Object)CLASSNAME, "removeRoleFromResource(CfgResource res, String roleName) { res = " + cfgResource.getPosName() + " , roleName = " + string + " }");
            } else {
                this._trcLogger.entry(80L, (Object)CLASSNAME, "removeRoleFromResource(CfgResource res, String roleName) { res = null , roleName = " + string + " }");
            }
        }
        try {
            if (this._secMgr != null) {
                this._secMgr.checkPermission(new CfgPermission("Resource", "write"));
            }
        }
        catch (SecurityException securityException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                AmasMessage amasMessage = new AmasMessage(916942882, securityException.toString());
                this._msgLogger.text(4L, (Object)CLASSNAME, "removeRoleFromResource(CfgResource, String)", amasMessage.getMessageString());
            }
            throw new AmasException(securityException);
        }
        if (cfgResource == null || string == null) {
            if (cfgResource == null && this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "removeRoleFromResource(CfgResource, String)", "Null resource encountered.");
            }
            if (string == null && this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "removeRoleFromResource(CfgResource, String)", "Null roleName encountered.");
            }
            throw new IllegalArgumentException();
        }
        CfgRole cfgRole = (CfgRole)super.getRole(cfgResource, string);
        this.removeRoleFromResource(cfgResource, cfgRole);
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "removeRoleFromResource(CfgResource, String)");
        }
    }

    private String getRoleSuffix(Object object) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "getRoleSuffix(Object)");
        }
        Object object2 = null;
        ResourceHandlerFactory resourceHandlerFactory = this._sess.getHandlerFactory();
        ResourceHandler resourceHandler = resourceHandlerFactory.createResourceHandler(object);
        if (!(resourceHandler instanceof ICfgResourceHandler)) {
            AmasMessage amasMessage = new AmasMessage(916942879, CLASSNAME);
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                this._msgLogger.text(4L, (Object)CLASSNAME, "getRoleSuffix(Object)", amasMessage.getMessageString());
            }
            throw new AmasException(amasMessage);
        }
        Object object3 = (ICfgResourceHandler)((Object)resourceHandler);
        object2 = object3.getRoleSuffix();
        if (object2 != null && !((String)object2).startsWith("/")) {
            object2 = object3 = "/" + (String)object2;
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "getRoleSuffix(Object) { retVal = " + (String)object2 + " }");
        }
        return object2;
    }

    private String getRoleBaseObjName(String string) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "getRoleBaseObjName(String roleName) { roleName = " + string + " }");
        }
        String string2 = null;
        String string3 = this.getRolePrefix();
        string2 = AmasUtil.appendPosValue(string3, string);
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "getRoleBaseObjName(String) { retVal = " + string2 + " }");
        }
        return string2;
    }

    private String getRoleObjName(Object object, String string) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "getRolBaseObjName(Object id, String roleName) { roleName = " + string + " }");
        }
        String string2 = this.getRoleSuffix(object);
        String string3 = this.getRoleBaseObjName(string);
        String string4 = AmasUtil.appendPosValue(string3, string2);
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "getRoleBaseObjName(Object, String) { retVal = " + string4 + " }");
        }
        return string4;
    }

    public CfgResource[] listResources(Object object) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "listResources(Object)");
        }
        try {
            if (this._secMgr != null) {
                this._secMgr.checkPermission(new CfgPermission("Resource", "read"));
            }
        }
        catch (SecurityException securityException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                AmasMessage amasMessage = new AmasMessage(916942882, securityException.toString());
                this._msgLogger.text(4L, (Object)CLASSNAME, "listResources(Object)", amasMessage.getMessageString());
            }
            throw new AmasException(securityException);
        }
        ResourceHandler resourceHandler = this._sess.getHandlerFactory().createResourceHandler(object);
        CfgResource[] cfgResourceArray = this.listResource(resourceHandler);
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "listResources(Object)");
        }
        return cfgResourceArray;
    }

    public CfgResource[] findResources(Object object) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "findResources(Object)");
        }
        try {
            if (this._secMgr != null) {
                this._secMgr.checkPermission(new CfgPermission("Resource", "read"));
            }
        }
        catch (SecurityException securityException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                AmasMessage amasMessage = new AmasMessage(916942882, securityException.toString());
                this._msgLogger.text(4L, (Object)CLASSNAME, "findResources(Object)", amasMessage.getMessageString());
            }
            throw new AmasException(securityException);
        }
        ResourceHandler resourceHandler = this._sess.getHandlerFactory().createResourceHandler(object);
        CfgResource[] cfgResourceArray = this.loadResources(resourceHandler);
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "findResources(Object)");
        }
        return cfgResourceArray;
    }

    public CfgResource getCfgResource(Object object) throws AmasException {
        String string;
        ICfgResourceHandler iCfgResourceHandler;
        ResourceHandler resourceHandler;
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "getCfgResource(Object)");
        }
        try {
            if (this._secMgr != null) {
                this._secMgr.checkPermission(new CfgPermission("Resource", "read"));
            }
        }
        catch (SecurityException securityException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                AmasMessage amasMessage = new AmasMessage(916942882, securityException.toString());
                this._msgLogger.text(4L, (Object)CLASSNAME, "getCfgResource(Object)", amasMessage.getMessageString());
            }
            throw new AmasException(securityException);
        }
        CfgResource cfgResource = null;
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "getCfgResource(Object)");
        }
        if ((resourceHandler = this._sess.getHandlerFactory().createResourceHandler(object)) instanceof ICfgResourceHandler) {
            iCfgResourceHandler = (ICfgResourceHandler)((Object)resourceHandler);
            string = AmasUtil.appendPosValue(this._sess.getResourceContainerName(), iCfgResourceHandler.getResourceName());
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "getCfgResource(Object)", "Instantiating resource " + string);
            }
        } else {
            AmasMessage amasMessage = new AmasMessage(916942879, resourceHandler.getIdObject().getClass().getName());
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                this._msgLogger.text(4L, (Object)CLASSNAME, "findResource(Object)", amasMessage.getMessageString());
            }
            throw new AmasException(amasMessage);
        }
        cfgResource = (CfgResource)this.instantiateResource(string, (ResourceHandler)((Object)iCfgResourceHandler));
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            if (cfgResource != null) {
                this._trcLogger.exit(96L, (Object)CLASSNAME, "findResource(Object) { retVal = " + cfgResource.getPosName() + " }");
            } else {
                this._trcLogger.exit(96L, (Object)CLASSNAME, "findResource(Object) { retVal = null }");
            }
        }
        return cfgResource;
    }

    public CfgResource[] createResources(Object object) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "createResources(Object)");
        }
        try {
            if (this._secMgr != null) {
                this._secMgr.checkPermission(new CfgPermission("Resource", "create"));
            }
        }
        catch (SecurityException securityException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                AmasMessage amasMessage = new AmasMessage(916942882, securityException.toString());
                this._msgLogger.text(4L, (Object)CLASSNAME, "createResources(Object)", amasMessage.getMessageString());
            }
            throw new AmasException(securityException);
        }
        ResourceHandler resourceHandler = this._sess.getHandlerFactory().createResourceHandler(object);
        CfgResource[] cfgResourceArray = this.createResources(resourceHandler);
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "createResources(Object)");
        }
        return cfgResourceArray;
    }

    public void deleteResource(CfgResource cfgResource) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            if (cfgResource != null) {
                this._trcLogger.entry(80L, (Object)CLASSNAME, "deleteResource(CfgResource res) { res = " + cfgResource.getPosName() + " }");
            } else {
                this._trcLogger.entry(80L, (Object)CLASSNAME, "deleteResource(CfgResource res) { res = null }");
            }
        }
        try {
            if (this._secMgr != null) {
                this._secMgr.checkPermission(new CfgPermission("Resource", "delete"));
            }
        }
        catch (SecurityException securityException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                AmasMessage amasMessage = new AmasMessage(916942882, securityException.toString());
                this._msgLogger.text(4L, (Object)CLASSNAME, "deleteResource(CfgResource)", amasMessage.getMessageString());
            }
            throw new AmasException(securityException);
        }
        if (cfgResource != null) {
            String string = cfgResource.getId();
            CfgRole[] cfgRoleArray = this.getLocalGrantedRoles(cfgResource);
            for (int i = 0; i < cfgRoleArray.length; ++i) {
                if (this._trcLogger != null && this._trcLogger.isLogging()) {
                    this._trcLogger.text(16L, (Object)CLASSNAME, "deleteResource(CfgResource)", "Deleting resource reference to this role on " + cfgRoleArray[i].getId() + ".");
                }
                CfgRole cfgRole = cfgRoleArray[i];
                cfgRole.deleteResourceReference(cfgResource);
            }
        } else {
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "deleteResource(CfgResource)", "Null resource encountered.");
            }
            throw new IllegalArgumentException();
        }
        cfgResource.deleteObject();
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "deleteResource(CfgResource)");
        }
    }

    private CfgResource[] listResource(ResourceHandler resourceHandler) throws AmasException {
        CfgResource[] cfgResourceArray = null;
        if (resourceHandler != null) {
            String string = AmasUtil.appendPosValue(this._sess.getResourceContainerName(), ((IResourceHandler)((Object)resourceHandler)).getResourceName());
            List list = this.listPos(string, null);
            CfgResource cfgResource = (CfgResource)this.instantiateResource(string, resourceHandler);
            if (cfgResource.objectExists()) {
                list.add(string);
            }
            String[] stringArray = list.toArray(new String[0]);
            cfgResourceArray = new CfgResource[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                cfgResourceArray[i] = (CfgResource)this.instantiateResource(stringArray[i], resourceHandler);
            }
        } else {
            cfgResourceArray = new CfgResource[]{};
        }
        return cfgResourceArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    private CfgResource[] loadResources(ResourceHandler resourceHandler) throws AmasException {
        CfgResource[] cfgResourceArray = null;
        if (resourceHandler == null) {
            if (this._trcLogger == null) throw new IllegalArgumentException();
            if (!this._trcLogger.isLogging()) throw new IllegalArgumentException();
            this._trcLogger.text(16L, (Object)CLASSNAME, "loadResources(ResourceHandler)", "Null handler encountered.");
            throw new IllegalArgumentException();
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "loadResources(ResourceHandler)");
        }
        if (!(resourceHandler instanceof ICfgResourceHandler)) {
            AmasMessage amasMessage = new AmasMessage(916942879, resourceHandler.getIdObject().getClass().getName());
            if (this._msgLogger == null) throw new AmasException(amasMessage);
            if (!this._msgLogger.isLogging()) throw new AmasException(amasMessage);
            this._msgLogger.text(4L, (Object)CLASSNAME, "loadResources(ResourceHandler)", amasMessage.getMessageString());
            throw new AmasException(amasMessage);
        }
        ICfgResourceHandler iCfgResourceHandler = (ICfgResourceHandler)((Object)resourceHandler);
        String[] stringArray = iCfgResourceHandler.generateResourceNames();
        if (stringArray != null && stringArray.length > 0) {
            ArrayList<CfgResource> arrayList = new ArrayList<CfgResource>();
            String string = null;
            int n = 0;
            while (true) {
                if (n >= stringArray.length) {
                    cfgResourceArray = arrayList.toArray(new CfgResource[0]);
                    if (this._trcLogger == null) return cfgResourceArray;
                    if (!this._trcLogger.isLogging()) return cfgResourceArray;
                    this._trcLogger.exit(96L, (Object)CLASSNAME, "loadResources(ResourceHandler)");
                    return cfgResourceArray;
                }
                CfgResource cfgResource = null;
                string = AmasUtil.appendPosValue(this._sess.getResourceContainerName(), stringArray[n]);
                cfgResource = (CfgResource)this.instantiateResource(string, (ResourceHandler)((Object)iCfgResourceHandler));
                if (this._trcLogger != null && this._trcLogger.isLogging()) {
                    this._trcLogger.text(16L, (Object)CLASSNAME, "loadResources(ResourceHandler)", "Instantiating resource with POS name " + cfgResource.getId());
                }
                if (cfgResource.objectExists()) {
                    if (this._trcLogger != null && this._trcLogger.isLogging()) {
                        this._trcLogger.text(16L, (Object)CLASSNAME, "loadResources(ResourceHandler)", "Found resource with POS name " + cfgResource.getId());
                    }
                    arrayList.add(cfgResource);
                }
                ++n;
            }
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.text(16L, (Object)CLASSNAME, "loadResources(ResourceHandler)", "Null resource id encountered.");
        }
        AmasMessage amasMessage = new AmasMessage(916942856, "resNames = null");
        if (this._msgLogger == null) throw new AmasException(amasMessage);
        if (!this._msgLogger.isLogging()) throw new AmasException(amasMessage);
        this._msgLogger.text(4L, (Object)CLASSNAME, "loadResources(ResourceHandler)", amasMessage.getMessageString());
        throw new AmasException(amasMessage);
    }

    private CfgResource[] createResources(ResourceHandler resourceHandler) throws AmasException {
        CfgResource[] cfgResourceArray = null;
        if (resourceHandler != null) {
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.entry(80L, (Object)CLASSNAME, "createResources(ResourceHandler)");
            }
            if (resourceHandler instanceof ICfgResourceHandler) {
                ICfgResourceHandler iCfgResourceHandler = (ICfgResourceHandler)((Object)resourceHandler);
                String[] stringArray = iCfgResourceHandler.generateResourceNames();
                cfgResourceArray = new CfgResource[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = AmasUtil.appendPosValue(this._sess.getResourceContainerName(), stringArray[i]);
                    cfgResourceArray[i] = (CfgResource)this.instantiateResource(string, (ResourceHandler)((Object)iCfgResourceHandler));
                    cfgResourceArray[i].createObject();
                    if (this._trcLogger != null && this._trcLogger.isLogging()) {
                        this._trcLogger.text(16L, (Object)CLASSNAME, "createResources(ResourceHandler)", "Created protected object" + stringArray[i]);
                        this._trcLogger.text(16L, (Object)CLASSNAME, "createResources(ResourceHandler)", "Setting role suffix for (" + iCfgResourceHandler.getRoleSuffix() + ") to " + stringArray[i]);
                    }
                    cfgResourceArray[i].setRoleSuffix(iCfgResourceHandler.getRoleSuffix());
                }
            } else {
                AmasMessage amasMessage = new AmasMessage(916942879, resourceHandler.getIdObject().getClass().getName());
                if (this._msgLogger != null && this._msgLogger.isLogging()) {
                    this._msgLogger.text(4L, (Object)CLASSNAME, "createResources(ResourceHandler)", amasMessage.getMessageString());
                }
                throw new AmasException(amasMessage);
            }
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.exit(96L, (Object)CLASSNAME, "createResources(ResourceHandler)");
            }
        } else {
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "createResources(ResourceHandler)", "Null handler encountered.");
            }
            throw new IllegalArgumentException();
        }
        return cfgResourceArray;
    }

    public CfgRole[] getLocalGrantedRoles(CfgResource cfgResource) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            if (cfgResource != null) {
                this._trcLogger.entry(80L, (Object)CLASSNAME, "getLocalGrantedRoles(CfgResource resource) { resource = " + cfgResource.getPosName() + " }");
            } else {
                this._trcLogger.entry(80L, (Object)CLASSNAME, "getLocalGrantedRoles(CfgResource resource) { resource = null }");
            }
        }
        try {
            if (this._secMgr != null) {
                this._secMgr.checkPermission(new CfgPermission("Role", "read"));
            }
        }
        catch (SecurityException securityException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                AmasMessage amasMessage = new AmasMessage(916942882, securityException.toString());
                this._msgLogger.text(4L, (Object)CLASSNAME, "getLocalGrantedRoles(CfgResource)", amasMessage.getMessageString());
            }
            throw new AmasException(securityException);
        }
        Role[] roleArray = super.getLocalGrantedRoles(cfgResource);
        CfgRole[] cfgRoleArray = new CfgRole[roleArray.length];
        System.arraycopy(roleArray, 0, cfgRoleArray, 0, roleArray.length);
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "getLocalGrantedRoles(CfgResource)");
        }
        return cfgRoleArray;
    }

    public String[] getBaseRoleNames() throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "getBaseRoleNames()");
        }
        try {
            if (this._secMgr != null) {
                this._secMgr.checkPermission(new CfgPermission("Role", "read"));
            }
        }
        catch (SecurityException securityException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                AmasMessage amasMessage = new AmasMessage(916942882, securityException.toString());
                this._msgLogger.text(4L, (Object)CLASSNAME, "getBaseRoleNames()", amasMessage.getMessageString());
            }
            throw new AmasException(securityException);
        }
        String[] stringArray = super.getBaseRoleNames();
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "getBaseRoleNames()");
        }
        return stringArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isProtectedResource(Object object) throws AmasException {
        boolean bl;
        boolean bl2;
        block15: {
            String[] stringArray;
            block14: {
                block12: {
                    block13: {
                        if (this._trcLogger != null && this._trcLogger.isLogging()) {
                            this._trcLogger.entry(80L, (Object)CLASSNAME, "isProtectedResource(Object)");
                        }
                        try {
                            if (this._secMgr != null) {
                                this._secMgr.checkPermission(new CfgPermission("Resource", "read"));
                            }
                        }
                        catch (SecurityException securityException) {
                            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                                AmasMessage amasMessage = new AmasMessage(916942882, securityException.toString());
                                this._msgLogger.text(4L, (Object)CLASSNAME, "isProtectedResource(Object)", amasMessage.getMessageString());
                            }
                            throw new AmasException(securityException);
                        }
                        if (this._trcLogger != null && this._trcLogger.isLogging()) {
                            this._trcLogger.exit(96L, (Object)CLASSNAME, "isProtectedResource(Object)");
                        }
                        bl2 = false;
                        ResourceHandler resourceHandler = this._sess.getHandlerFactory().createResourceHandler(object);
                        if (resourceHandler == null) break block12;
                        if (this._trcLogger != null && this._trcLogger.isLogging()) {
                            this._trcLogger.text(16L, (Object)CLASSNAME, "isProtectedResource(Object)", "Using resource handler: " + resourceHandler.getClass().getName());
                        }
                        if (!(resourceHandler instanceof IResourceHandler)) break block13;
                        ICfgResourceHandler iCfgResourceHandler = (ICfgResourceHandler)((Object)resourceHandler);
                        stringArray = iCfgResourceHandler.generateResourceNames();
                        bl = true;
                        if (stringArray.length != 0) break block14;
                        bl = false;
                        break block15;
                    }
                    AmasMessage amasMessage = new AmasMessage(916942880, object.getClass().getName());
                    if (this._msgLogger != null && this._msgLogger.isLogging()) {
                        this._msgLogger.text(4L, (Object)CLASSNAME, "isProtectedResource(Object)", amasMessage.getMessageString());
                    }
                    throw new AmasException(amasMessage);
                }
                AmasMessage amasMessage = new AmasMessage(916942878, object.getClass().getName());
                if (this._msgLogger != null && this._msgLogger.isLogging()) {
                    this._msgLogger.text(4L, (Object)CLASSNAME, "isProtectedResource(Object)", amasMessage.getMessageString());
                }
                throw new AmasException(amasMessage);
            }
            for (int i = 0; i < stringArray.length; ++i) {
                String string = AmasUtil.appendPosValue(this._sess.getResourceContainerName(), stringArray[i]);
                AmasObject amasObject = this.createObject(this._sess, string);
                if (!amasObject.exists()) {
                    bl = false;
                    if (this._trcLogger == null || !this._trcLogger.isLogging()) break;
                    this._trcLogger.text(16L, (Object)CLASSNAME, "isProtectedResource(Object)", "obj.exists() for " + string + " returned: " + bl);
                    break;
                }
                if (this._trcLogger == null || !this._trcLogger.isLogging()) continue;
                this._trcLogger.text(16L, (Object)CLASSNAME, "isProtectedResource(Object)", "obj.exists() for " + string + " returned: " + bl);
            }
        }
        bl2 = bl;
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "isProtectedResource(Object) { retVal = " + bl2 + " }");
        }
        return bl2;
    }

    public boolean roleExists(Object object, String string) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "roleExists(Object res, String roleName) { roleName = " + string + " }");
        }
        try {
            if (this._secMgr != null) {
                this._secMgr.checkPermission(new CfgPermission("Role", "read"));
            }
        }
        catch (SecurityException securityException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                AmasMessage amasMessage = new AmasMessage(916942882, securityException.toString());
                this._msgLogger.text(4L, (Object)CLASSNAME, "roleExists(Object, String)", amasMessage.getMessageString());
            }
            throw new AmasException(securityException);
        }
        boolean bl = super.roleExists(object, string);
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "roleExists(Object, String) { retVal = " + bl + " }");
        }
        return bl;
    }

    public Object[] decodeCfgResource(CfgResource cfgResource, String string) throws AmasException {
        IDecodeResourceHandler iDecodeResourceHandler;
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "decodeCfgResource(CfgResource)");
        }
        Object[] objectArray = null;
        try {
            if (this._secMgr != null) {
                this._secMgr.checkPermission(new CfgPermission("Resource", "read"));
            }
        }
        catch (SecurityException securityException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                AmasMessage amasMessage = new AmasMessage(916942882, securityException.toString());
                this._msgLogger.text(4L, (Object)CLASSNAME, "decocdeCfgResource(CfgResource)", amasMessage.getMessageString());
            }
            throw new AmasException(securityException);
        }
        String string2 = cfgResource.getResourceType();
        ResourceHandlerBase resourceHandlerBase = this._sess.getHandlerFactory().createDecodeResourceHandler(string2);
        if (resourceHandlerBase instanceof IDecodeResourceHandler) {
            iDecodeResourceHandler = (IDecodeResourceHandler)((Object)resourceHandlerBase);
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "decodeCfgResource(CfgResource, String)", "calling decode [" + cfgResource.getPosName() + "," + string + "]");
            }
        } else {
            AmasMessage amasMessage = new AmasMessage(916942905, string2);
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                this._msgLogger.text(4L, (Object)CLASSNAME, "decodeCfgResource(CfgResource, String)", amasMessage.getMessageString());
            }
            throw new AmasException(amasMessage);
        }
        objectArray = iDecodeResourceHandler.decodeCfgResource(cfgResource, string);
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            if (objectArray != null) {
                this._trcLogger.exit(96L, (Object)CLASSNAME, "decodeCfgResource(CfgResource, String)");
            } else {
                this._trcLogger.exit(96L, (Object)CLASSNAME, "decodeCfgResource(CfgResource, String) { retVal = null }");
            }
        }
        return objectArray;
    }

    public CfgResource[] getResources(CfgRole cfgRole) throws AmasException {
        CfgResource[] cfgResourceArray = null;
        cfgResourceArray = cfgRole.getResourceReferences();
        return cfgResourceArray;
    }

    public String[] getPrincipalsForRole(CfgRole cfgRole) throws AmasException {
        String[] stringArray = null;
        RoleMember[] roleMemberArray = cfgRole.getMembers();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < roleMemberArray.length; ++i) {
            if (roleMemberArray[i].getType() != 1) continue;
            arrayList.add(roleMemberArray[i].getName());
        }
        stringArray = arrayList.toArray(new String[0]);
        return stringArray;
    }

    public String[] getGroupsFromRole(CfgRole cfgRole) throws AmasException {
        String[] stringArray = null;
        RoleMember[] roleMemberArray = cfgRole.getMembers();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < roleMemberArray.length; ++i) {
            if (roleMemberArray[i].getType() != 2) continue;
            arrayList.add(roleMemberArray[i].getName());
        }
        stringArray = arrayList.toArray(new String[0]);
        return stringArray;
    }

    public boolean isUnauthenticatedRole(CfgRole cfgRole) throws AmasException {
        boolean bl = false;
        RoleMember[] roleMemberArray = cfgRole.getMembers();
        for (int i = 0; i < roleMemberArray.length; ++i) {
            if (roleMemberArray[i].getType() != 3) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean isAnyOtherRole(CfgRole cfgRole) throws AmasException {
        boolean bl = false;
        RoleMember[] roleMemberArray = cfgRole.getMembers();
        for (int i = 0; i < roleMemberArray.length; ++i) {
            if (roleMemberArray[i].getType() != 4) continue;
            bl = true;
            break;
        }
        return bl;
    }
}

