/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pd.as.rbpf;

import com.tivoli.pd.as.rbpf.AmasObject;
import com.tivoli.pd.as.rbpf.AmasSession;
import com.tivoli.pd.as.rbpf.CfgPermission;
import com.tivoli.pd.as.rbpf.ICfgResourceHandler;
import com.tivoli.pd.as.rbpf.IResourceHandler;
import com.tivoli.pd.as.rbpf.Resource;
import com.tivoli.pd.as.rbpf.ResourceHandler;
import com.tivoli.pd.as.util.AmasException;
import com.tivoli.pd.as.util.AmasMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

public final class CfgResource
extends Resource {
    private final String CfgResource_java_sourceCodeID = "$Id: @(#)24  1.11 src/amas/com/tivoli/pd/as/rbpf/CfgResource.java, amemb.jacc.was, amemb600, 051118a 04/09/02 18:10:38 @(#) $";
    public static final String sCopyright = "IBM Confidential\nObject Code Only Source Materials\n5747-SM3\n(c) Copyright International Business Machines Corp. 1994-2002.  All Rights Reserved.\nThe source code for this program is not published or otherwise divested\nof its trade secrets, irrespective of what has been deposited with the\nU.S. Copyright Office.\n";
    AmasObject _resObj;
    private static final String CLASSNAME = "com.tivoli.pd.as.rbpf.CfgResource";
    private final String _resourceType;
    private final String _resourceSuffix;
    private HashMap _roleAttrData = null;

    CfgResource(AmasSession amasSession, String string, ResourceHandler resourceHandler) throws AmasException {
        super(amasSession, string);
        Object object;
        this._resObj = new AmasObject(amasSession, string);
        if (resourceHandler != null) {
            if (resourceHandler instanceof ICfgResourceHandler) {
                object = (IResourceHandler)((Object)resourceHandler);
                this.setResourceHandler((IResourceHandler)object);
            } else {
                AmasMessage amasMessage = new AmasMessage(916942879, resourceHandler.getIdObject().getClass().getName());
                if (this._msgLogger != null && this._msgLogger.isLogging()) {
                    this._msgLogger.text(4L, (Object)CLASSNAME, "CfgResource(AmasSession, String, ResourceHandler", amasMessage.getMessageString());
                }
                throw new AmasException(amasMessage);
            }
        }
        object = this._resObj.getPosName();
        String string2 = this._sess.getResourceContainerName();
        if (!string2.endsWith("/")) {
            string2 = string2 + "/";
        }
        String string3 = ((String)object).substring(string2.length());
        StringTokenizer stringTokenizer = new StringTokenizer(string3, "/");
        String string4 = stringTokenizer.nextToken();
        this._resourceType = stringTokenizer.nextToken();
        this._resourceSuffix = string3;
    }

    void createObject() throws AmasException {
        this._resObj.createProtObject();
    }

    void deleteObject() throws AmasException {
        this._resObj.deleteProtObject();
    }

    boolean objectExists() throws AmasException {
        return this._resObj.exists();
    }

    void setRoleSuffix(String string) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "setRoleSuffix(String suffix) { suffix = " + string + " }");
        }
        if (string == null) {
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "setRoleSuffix(String)", "Null suffix encountered.");
            }
            throw new IllegalArgumentException();
        }
        this._resObj.setSingleValueAttribute("AmasRoleSuffix", string);
        super.setRoleSuffix(string);
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "setRoleSuffix(String)");
        }
    }

    String getRoleSuffix() throws AmasException {
        Object object;
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "getRoleSuffix()");
        }
        if (super.getRoleSuffix() == null) {
            object = this._resObj.attributeValueList("AmasRoleSuffix");
            if (object != null && object.size() == 1) {
                super.setRoleSuffix((String)object.get(0));
            } else {
                super.setRoleSuffix("");
            }
        }
        object = super.getRoleSuffix();
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "getRoleSuffix() { retVal = " + (String)object + " }");
        }
        return object;
    }

    public String getPosName() {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "getPosName()");
        }
        String string = this._resObj.getPosName();
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "getPosName() { retVal = " + string + " }");
        }
        return string;
    }

    public List getLocalPolicyData(String string) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "getLocalPolicyData(String policyId) { policyId = " + string + " }");
        }
        try {
            if (this._secMgr != null) {
                this._secMgr.checkPermission(new CfgPermission("Resource", "read"));
            }
        }
        catch (SecurityException securityException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                AmasMessage amasMessage = new AmasMessage(916942882, securityException.toString());
                this._msgLogger.text(4L, (Object)CLASSNAME, "getLocalPolicyData", amasMessage.getMessageString());
            }
            throw new AmasException(securityException);
        }
        List list = super.getLocalPolicyData(string);
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "getLocalPolicyData(String)");
        }
        return list;
    }

    List attributeValueList(String string) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "attributeValueList(String attribute) { attribute = " + string + " }");
        }
        List list = this._resObj.attributeValueList(string);
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "attributeValueList(String)");
        }
        return list;
    }

    void addRoleName(String string) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "addRoleName(String roleName) { roleName = " + string + " }");
        }
        HashMap hashMap = this.getRoleAttrData(string);
        Set set = hashMap.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = (String)hashMap.get(string2);
            this.addPolicyDataEntryInt(string2, string3);
            if (this._trcLogger == null || !this._trcLogger.isLogging()) continue;
            this._trcLogger.text(16L, (Object)CLASSNAME, "addRoleName", "Added role [" + string2 + "] = [" + string3 + "]");
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "addRoleName(String)");
        }
    }

    void removeRoleName(String string) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "removeRoleName(String roleName) { roleName = " + string + " }");
        }
        HashMap hashMap = this.getRoleAttrData(string);
        Set set = hashMap.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = (String)hashMap.get(string2);
            this.removePolicyDataEntryInt(string2, string3);
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "removeRoleName", "Removed role [" + string2 + "] = [" + string3 + "]");
            }
            if (this.hasAttributes()) continue;
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "removeRoleName", "Removing resource as all roles have been removed");
            }
            this.deleteObject();
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "removeRoleName(String)");
        }
    }

    public void addPolicyDataEntry(String string, String string2) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "addPolicyDataEntry(String policyId, String value) { policyId = " + string + " , value = " + string2 + " }");
        }
        try {
            if (this._secMgr != null) {
                this._secMgr.checkPermission(new CfgPermission("Resource", "write"));
            }
        }
        catch (SecurityException securityException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                AmasMessage amasMessage = new AmasMessage(916942882, securityException.toString());
                this._msgLogger.text(4L, (Object)CLASSNAME, "addPolicyDataEntry", amasMessage.getMessageString());
            }
            throw new AmasException(securityException);
        }
        if (this.isReservedAttribute(string)) {
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "addPolicyDataEntry(String, String)", "Policy ID " + string + " is a reserved attribute.");
            }
            throw new IllegalArgumentException();
        }
        this.addPolicyDataEntryInt(string, string2);
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "addPolicyDataEntry(String, String)");
        }
    }

    private void addPolicyDataEntryInt(String string, String string2) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "addPolicyDataEntryInt(String policyId, String value) { policyId = " + string + " , value = " + string2 + " }");
        }
        this._resObj.addAttributeValue(string, string2);
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "addPolicyDataEntryInt(String, String)");
        }
    }

    public void removePolicyDataEntry(String string, String string2) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "removePolicyDataEntry(String policyId, String value) { policyId = " + string + " , value = " + string2 + " }");
        }
        try {
            if (this._secMgr != null) {
                this._secMgr.checkPermission(new CfgPermission("Resource", "write"));
            }
        }
        catch (SecurityException securityException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                AmasMessage amasMessage = new AmasMessage(916942882, securityException.toString());
                this._msgLogger.text(4L, (Object)CLASSNAME, "removePolicyDataEntry", amasMessage.getMessageString());
            }
            throw new AmasException(securityException);
        }
        if (this.isReservedAttribute(string)) {
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "removePolicyDataEntry(String, String)", "Policy ID " + string + " is a reserved attribute.");
            }
            throw new IllegalArgumentException();
        }
        this.removePolicyDataEntryInt(string, string2);
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "removePolicyDataEntry(String, String)");
        }
    }

    private void removePolicyDataEntryInt(String string, String string2) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "removePolicyDataEntryInt(String policyId, String value) { policyId = " + string + " , value = " + string2 + " }");
        }
        this._resObj.removeAttributeValue(string, string2);
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "removePolicyDataEntryInt(String, String)");
        }
    }

    private boolean hasAttributes() throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "hasAttributes()");
        }
        boolean bl = false;
        List list = this._resObj.getAttributeNames();
        if (list != null && list.size() > 1) {
            bl = true;
        } else if (list.size() == 1 && list.contains("AmasRoleSuffix")) {
            bl = false;
        } else if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.text(2L, (Object)CLASSNAME, "hasAttributes", "Resource does not have AmasRoleSuffix attribute.");
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "hasAttributes()");
        }
        return bl;
    }

    public String getResourceSuffix() {
        String string = null;
        string = this._resourceSuffix;
        return string;
    }

    public String getResourceType() {
        String string = null;
        string = this._resourceType;
        return string;
    }

    HashMap getRoleAttrData(String string) throws AmasException {
        HashMap hashMap = null;
        if (this._roleAttrData != null) {
            hashMap = this._roleAttrData;
        } else if (this._resHdl != null) {
            hashMap = ((ICfgResourceHandler)this._resHdl).getRoleAttrData(string);
        } else {
            AmasMessage amasMessage = new AmasMessage(916942907, this.getPosName());
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                this._msgLogger.text(4L, (Object)CLASSNAME, "getRoleAttrData(String)", amasMessage.getMessageString());
            }
            throw new AmasException(amasMessage);
        }
        return hashMap;
    }

    void setResourceHandler(IResourceHandler iResourceHandler) {
        this._resHdl = iResourceHandler;
    }

    void setRoleAttrData(HashMap hashMap) {
        this._roleAttrData = hashMap;
    }

    final String[] getLocalRoles() throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "getLocalRoles()");
        }
        String[] stringArray = null;
        ArrayList arrayList = new ArrayList();
        HashMap hashMap = this.getRoleAttrData("AmasRoleSuffix");
        Set set = hashMap.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            List list = this.getLocalPolicyData((String)iterator.next());
            arrayList.addAll(list);
        }
        stringArray = arrayList.toArray(new String[0]);
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "getLocalRoles()");
        }
        return stringArray;
    }
}

