/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pd.as.rbpf;

import com.tivoli.pd.as.nls.AmasMsgHelper;
import com.tivoli.pd.as.rbpf.AmasObject;
import com.tivoli.pd.as.rbpf.AmasSession;
import com.tivoli.pd.as.rbpf.CfgPermission;
import com.tivoli.pd.as.rbpf.CfgResource;
import com.tivoli.pd.as.rbpf.Resource;
import com.tivoli.pd.as.rbpf.Role;
import com.tivoli.pd.as.rbpf.RoleMember;
import com.tivoli.pd.as.util.AmasException;
import com.tivoli.pd.as.util.AmasMessage;
import com.tivoli.pd.as.util.AmasPDHelper;
import com.tivoli.pd.as.util.AmasUtil;
import com.tivoli.pd.jadmin.PDAcl;
import com.tivoli.pd.jadmin.PDAclEntryGroup;
import com.tivoli.pd.jadmin.PDAclEntryUser;
import com.tivoli.pd.jutil.PDContext;
import com.tivoli.pd.jutil.PDException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class CfgRole
extends Role {
    private final String CfgRole_java_sourceCodeID = "$Id: @(#)25  1.12 src/amas/com/tivoli/pd/as/rbpf/CfgRole.java, amemb.jacc.was, amemb600, 081121a 08/11/20 20:24:58 @(#) $";
    public static final String sCopyright = "IBM Confidential\nObject Code Only Source Materials\n5747-SM3\n(c) Copyright International Business Machines Corp. 1994-2002.  All Rights Reserved.\nThe source code for this program is not published or otherwise divested\nof its trade secrets, irrespective of what has been deposited with the\nU.S. Copyright Office.\n";
    private static final String RESREF_ATTR_NAME = "ResourceReference";
    static final String RESOURCE_NAME = "ResourceName";
    private static final String ROLE_ATTR_NAME = "RoleAttrName";
    private static final String CLASSNAME = "com.tivoli.pd.as.rbpf.CfgRole";
    private static final String ATTR_RES_SEP = ":";
    private AmasObject _roleObj;
    private AmasObject _roleBaseObj;
    private SecurityManager _secMgr;

    CfgRole(AmasSession amasSession, String string, String string2) throws AmasException {
        super(amasSession, string, string2);
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "CfgRole(AmasSession sess, String roleName, String roleId) { roleName = " + string + " , roleId = " + string2 + " }");
        }
        this._roleObj = new AmasObject(amasSession, string2);
        this._secMgr = System.getSecurityManager();
        this._roleBaseObj = this.isRoleBase() ? this._roleObj : new AmasObject(amasSession, this._roleBaseName);
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "CfgRole(AmasSession, String, String)");
        }
    }

    void createObject() throws AmasException {
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "createObject()");
        }
        this._roleObj.createProtObject();
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "createObject()");
        }
    }

    void createBaseObject() throws AmasException {
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "createBaseObject()");
        }
        this._roleBaseObj.createProtObject();
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "createBaseObject()");
        }
    }

    private List getResourceRefPosNames() throws AmasException {
        ArrayList arrayList = new ArrayList();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        try {
            AmasPDHelper.listResourcesRecursive(arrayList, this._sess.getSessionContext(), this._roleId);
        }
        catch (PDException pDException) {
            AmasMessage amasMessage = new AmasMessage(916942925, (Object)this._roleId, pDException.toString());
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                this._msgLogger.text(4L, (Object)CLASSNAME, "getResourceRefPosNames()", amasMessage.getMessageString());
            }
            throw new AmasException(amasMessage);
        }
        catch (AmasException amasException) {
            AmasMessage amasMessage = new AmasMessage(916942853);
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                this._msgLogger.text(4L, (Object)CLASSNAME, "getResourceRefPosNames()", amasMessage.getMessageString());
            }
            throw new AmasException(amasMessage);
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            List list = null;
            try {
                AmasObject amasObject = new AmasObject(this._sess, string);
                list = amasObject.attributeValueList(RESOURCE_NAME);
            }
            catch (AmasException amasException) {
                AmasMessage amasMessage = new AmasMessage(916942925, (Object)this._roleId, amasException.toString());
                if (this._msgLogger != null && this._msgLogger.isLogging()) {
                    this._msgLogger.text(4L, (Object)CLASSNAME, "getResourceRefPosNames()", amasMessage.getMessageString());
                }
                throw new AmasException(amasMessage);
            }
            if (list == null || list.size() != 1) continue;
            arrayList2.add(string);
        }
        return arrayList2;
    }

    void deleteObject(boolean bl) throws AmasException {
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "deleteObject()");
        }
        if (!bl) {
            List list = this.getResourceRefPosNames();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                try {
                    AmasPDHelper.deleteObject(string, (PDContext)this._sess.getSessionContext());
                }
                catch (PDException pDException) {
                    String string2 = AmasMsgHelper.formatDoubleParamMessage(916942891, string, pDException.toString());
                    if (this._msgLogger != null && this._msgLogger.isLogging()) {
                        this._msgLogger.text(4L, (Object)CLASSNAME, "deleteObject()", string2);
                    }
                    throw new AmasException(new AmasMessage(string2));
                }
            }
        }
        this._roleObj.deleteProtObject();
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "deleteObject()");
        }
    }

    void deleteBaseObject() throws AmasException {
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "deleteBaseObject()");
        }
        this._roleBaseObj.deleteProtObject();
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "deleteBaseObject()");
        }
    }

    void addMember(RoleMember roleMember) throws AmasException {
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            if (roleMember != null) {
                this._traceLogger.entry(80L, (Object)CLASSNAME, "addMember(RoleMember) { RoleMember = " + roleMember.getName() + " : " + roleMember.getType() + " }");
            } else {
                this._traceLogger.entry(80L, (Object)CLASSNAME, "addMember(RoleMember) { RoleMember = null }");
            }
        }
        boolean bl = true;
        if (roleMember.getType() == 2) {
            if ("iv-admin".equalsIgnoreCase(roleMember.getName())) {
                bl = false;
            }
        } else if (roleMember.getType() == 1 && "sec_master".equalsIgnoreCase(roleMember.getName())) {
            bl = false;
        }
        if (bl) {
            if (this._traceLogger != null && this._traceLogger.isLogging()) {
                this._traceLogger.text(16L, (Object)CLASSNAME, "addMember(RoleMember)", "Attempting to add " + roleMember.getName() + " to role " + this._roleObj.getPosName() + ".");
            }
        } else {
            if (this._traceLogger != null && this._traceLogger.isLogging()) {
                this._traceLogger.text(16L, (Object)CLASSNAME, "addMember(RoleMember)", "Not permitted to add member " + roleMember.getName() + " to role " + this._roleObj.getPosName());
            }
            AmasMessage amasMessage = new AmasMessage(916942866, (Object)roleMember.getName(), this._roleObj.getPosName());
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                this._msgLogger.text(4L, (Object)CLASSNAME, "addMember(RoleMember)", amasMessage.getMessageString());
            }
            throw new AmasException(amasMessage);
        }
        String string = this._sess.getProperty("com.tivoli.pd.as.rbpf.CopyParentRole");
        String string2 = this._sess.getProperty("com.tivoli.pd.as.rbpf.PropagateChildRole");
        boolean bl2 = AmasUtil.checkBoolProperty(string2, true);
        boolean bl3 = AmasUtil.checkBoolProperty(string, true);
        this._roleObj.addAclEntry(roleMember.getName(), roleMember.getType(), bl3, bl2);
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "addMember(RoleMember)");
        }
    }

    void removeMember(RoleMember roleMember) throws AmasException {
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            if (roleMember != null) {
                this._traceLogger.entry(80L, (Object)CLASSNAME, "removeMember(RoleMember) { RoleMember = " + roleMember.getName() + " : " + roleMember.getType() + " }");
            } else {
                this._traceLogger.entry(80L, (Object)CLASSNAME, "removeMember(RoleMember) { RoleMember = null }");
            }
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.text(16L, (Object)CLASSNAME, "removeMember(RoleMember)", "Attempting to remove " + roleMember.getName() + " from role " + this._roleObj.getPosName() + ".");
        }
        String string = this._sess.getProperty("com.tivoli.pd.as.rbpf.PropagateChildRole");
        boolean bl = AmasUtil.checkBoolProperty(string, true);
        this._roleObj.removeAclEntry(roleMember.getName(), roleMember.getType(), bl);
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "removeMember(RoleMember)");
        }
    }

    public RoleMember[] getMembers() throws AmasException {
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "getMembers()");
        }
        try {
            if (this._secMgr != null) {
                this._secMgr.checkPermission(new CfgPermission("Role", "read"));
            }
        }
        catch (SecurityException securityException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                AmasMessage amasMessage = new AmasMessage(916942882, securityException.toString());
                this._msgLogger.text(4L, (Object)CLASSNAME, "getMembers()", amasMessage.getMessageString());
            }
            throw new AmasException(securityException);
        }
        RoleMember[] roleMemberArray = null;
        try {
            ArrayList<RoleMember> arrayList = new ArrayList<RoleMember>();
            PDAcl pDAcl = this._roleObj.getInheritedAcl();
            String string = this._sess.getAMActionString();
            if (pDAcl != null) {
                String string2;
                String string3;
                String string4;
                Object object;
                Iterator iterator = pDAcl.getPDAclEntriesUser().values().iterator();
                while (iterator.hasNext()) {
                    object = (PDAclEntryUser)iterator.next();
                    string4 = object.getUserId();
                    if (string4.equalsIgnoreCase("sec_master") || (string3 = object.getPermission()).indexOf(string) == -1) continue;
                    arrayList.add(new RoleMember(string4, 1));
                }
                object = pDAcl.getPDAclEntriesGroup().values().iterator();
                while (object.hasNext()) {
                    string4 = (PDAclEntryGroup)object.next();
                    string3 = string4.getGroupId();
                    if (string3.equalsIgnoreCase("iv-admin") || (string2 = string4.getPermission()).indexOf(string) == -1) continue;
                    arrayList.add(new RoleMember(string3, 2));
                }
                string4 = pDAcl.getPDAclEntryUnAuth();
                string3 = pDAcl.getPDAclEntryAnyOther();
                if (string4 != null && (string2 = string4.getPermission()).indexOf(string) != -1) {
                    arrayList.add(new RoleMember("unauthenticated", 3));
                }
                if (string3 != null && (string2 = string3.getPermission()).indexOf(string) != -1) {
                    arrayList.add(new RoleMember("any-other", 4));
                }
                roleMemberArray = arrayList.toArray(new RoleMember[0]);
            }
        }
        catch (PDException pDException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                this._msgLogger.text(4L, (Object)CLASSNAME, "getMembers()", AmasMsgHelper.formatSingleParamMessage(916942884, pDException.toString()));
            }
            throw new AmasException(pDException);
        }
        if (roleMemberArray == null) {
            roleMemberArray = new RoleMember[]{};
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.text(16L, (Object)CLASSNAME, "getMembers", "Found " + roleMemberArray.length + " members for Role " + this.getId());
            this._traceLogger.exit(96L, (Object)CLASSNAME, "getMembers()");
        }
        return roleMemberArray;
    }

    public boolean isMember(String string) throws AmasException {
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "isMember(String prinName) { prinName = " + string + " }");
        }
        try {
            if (this._secMgr != null) {
                this._secMgr.checkPermission(new CfgPermission("Role", "read"));
            }
        }
        catch (SecurityException securityException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                AmasMessage amasMessage = new AmasMessage(916942882, securityException.toString());
                this._msgLogger.text(4L, (Object)CLASSNAME, "isMember(String)", amasMessage.getMessageString());
            }
            throw new AmasException(securityException);
        }
        boolean bl = false;
        RoleMember roleMember = new RoleMember(string, 1);
        bl = this.isMember(roleMember);
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "isMember(String) { retVal = " + bl + " }");
        }
        return bl;
    }

    public boolean isGroupMember(String string) throws AmasException {
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "isGroupMember(String groupName) { groupName = " + string + " }");
        }
        try {
            if (this._secMgr != null) {
                this._secMgr.checkPermission(new CfgPermission("Role", "read"));
            }
        }
        catch (SecurityException securityException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                AmasMessage amasMessage = new AmasMessage(916942882, securityException.toString());
                this._msgLogger.text(4L, (Object)CLASSNAME, "isGroupMember(String)", amasMessage.getMessageString());
            }
            throw new AmasException(securityException);
        }
        boolean bl = false;
        RoleMember roleMember = new RoleMember(string, 2);
        bl = this.isMember(roleMember);
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "isGroupMember(String) { retVal = " + bl + " }");
        }
        return bl;
    }

    private boolean isMember(RoleMember roleMember) throws AmasException {
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "isMember(RoleMember) { member = " + roleMember.getName() + " }");
        }
        boolean bl = false;
        RoleMember[] roleMemberArray = this.getMembers();
        for (int i = 0; i < roleMemberArray.length; ++i) {
            if (!roleMemberArray[i].equals(roleMember)) continue;
            if (this._traceLogger != null && this._traceLogger.isLogging()) {
                this._traceLogger.text(16L, (Object)CLASSNAME, "isMember", "Found member [{" + i + "}" + roleMemberArray[i].getName() + "==" + roleMember.getName() + "]");
            }
            bl = true;
            break;
        }
        return bl;
    }

    void addResourceReference(Resource resource) throws AmasException {
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            if (resource != null) {
                this._traceLogger.entry(80L, (Object)CLASSNAME, "addResourceReference(Resource) { Resource = " + resource.toString() + " }");
            } else {
                this._traceLogger.entry(80L, (Object)CLASSNAME, "addResourceReference(Resource) { Null encountered }");
            }
        }
        if (resource != null) {
            HashMap hashMap = ((CfgResource)resource).getRoleAttrData(this.getRoleName());
            Set set = hashMap.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (this.getRoleName() == hashMap.get(string)) {
                    if (this._traceLogger != null && this._traceLogger.isLogging()) {
                        this._traceLogger.text(16L, (Object)CLASSNAME, "addResourceReference", "Adding resource ref [" + resource.getId() + "] attrName [" + string + "]");
                    }
                    this.addResourceReference(resource.getId(), string);
                    continue;
                }
                if (this._traceLogger == null || !this._traceLogger.isLogging()) continue;
                this._traceLogger.text(16L, (Object)CLASSNAME, "addResourceReference", "Res role [" + hashMap.get(string) + "] != roleName [" + this.getRoleName() + "]");
            }
        } else {
            AmasMessage amasMessage = new AmasMessage(916942856, "null (res)");
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                this._msgLogger.text(4L, (Object)CLASSNAME, "addResourceReference(Resource)", amasMessage.getMessageString());
            }
            throw new AmasException(amasMessage);
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "addResourceReference(Resource)");
        }
    }

    private void addResourceReference(String string, String string2) throws AmasException {
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "addResourceReference(String resourcePosName, String roleAttrName) { resourcePosName = " + string + " roleAttrName = " + string2 + " }");
        }
        int n = string.hashCode();
        String string3 = new Integer(n).toString();
        String string4 = AmasUtil.appendPosValue(this._roleId, string3);
        AmasObject amasObject = new AmasObject(this._sess, string4);
        amasObject.createProtObject();
        amasObject.addAttributeValue(ROLE_ATTR_NAME, string2);
        amasObject.addAttributeValue(RESOURCE_NAME, string);
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "addResourceReference(String, String)");
        }
    }

    void deleteResourceReference(Resource resource) throws AmasException {
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            if (resource != null) {
                this._traceLogger.entry(80L, (Object)CLASSNAME, "deleteResourceReference(Resource) { Resource = " + resource.toString() + " }");
                HashMap hashMap = ((CfgResource)resource).getRoleAttrData(this.getRoleName());
                Set set = hashMap.keySet();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    if (this.getRoleName() == hashMap.get(string)) {
                        if (this._traceLogger != null && this._traceLogger.isLogging()) {
                            this._traceLogger.text(16L, (Object)CLASSNAME, "deleteResourceReference", "Deleting resource ref [" + resource.getId() + "] attrName [" + string + "]");
                        }
                        this.deleteResourceReference(resource.getId(), string);
                        continue;
                    }
                    if (this._traceLogger == null || !this._traceLogger.isLogging()) continue;
                    this._traceLogger.text(16L, (Object)CLASSNAME, "deleteResourceReference", "Res role [" + hashMap.get(string) + "] != roleName [" + this.getRoleName() + "]");
                }
            } else {
                this._traceLogger.entry(80L, (Object)CLASSNAME, "deleteResourceReference(Resource) { Null encountered }");
                AmasMessage amasMessage = new AmasMessage(916942856, "null (res )");
                if (this._msgLogger != null && this._msgLogger.isLogging()) {
                    this._msgLogger.text(4L, (Object)CLASSNAME, "deleteResourceReference(Resource)", amasMessage.getMessageString());
                }
                throw new AmasException(amasMessage);
            }
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "deleteResourceReference(Resource)");
        }
    }

    private void deleteResourceReference(String string, String string2) {
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "deleteResourceReference(String resourceName, String roleAttrName) { resourceName = " + string + ", " + "roleAttrName = " + string2 + " }");
        }
        try {
            int n = string.hashCode();
            String string3 = new Integer(n).toString();
            String string4 = AmasUtil.appendPosValue(this._roleId, string3);
            AmasObject amasObject = new AmasObject(this._sess, string4);
            amasObject.removeAttributeValue(ROLE_ATTR_NAME, string2);
            List list = amasObject.getAttributeNames();
            if (list == null || list.size() == 1) {
                amasObject.deleteProtObject();
            }
        }
        catch (AmasException amasException) {
            // empty catch block
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "deleteResourceReference(String, String)");
        }
    }

    CfgResource[] getResourceReferences() {
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "getResourceReferences()");
        }
        int n = 0;
        CfgResource[] cfgResourceArray = null;
        try {
            HashMap hashMap = this.getResourceRefDetails();
            Set set = hashMap.keySet();
            ArrayList<CfgResource> arrayList = new ArrayList<CfgResource>();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                CfgResource cfgResource = new CfgResource(this._sess, string, null);
                HashMap<String, String> hashMap2 = new HashMap<String, String>();
                List list = (List)hashMap.get(string);
                Iterator iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    hashMap2.put((String)iterator2.next(), this.getRoleName());
                }
                cfgResource.setRoleAttrData(hashMap2);
                if (cfgResource.objectExists()) {
                    if (this._traceLogger != null && this._traceLogger.isLogging()) {
                        this._traceLogger.text(16L, (Object)CLASSNAME, "getResourceReferences", "Resource exists adding to return list");
                    }
                    arrayList.add(cfgResource);
                    continue;
                }
                if (this._msgLogger != null && this._msgLogger.isLogging()) {
                    this._msgLogger.text(16L, (Object)CLASSNAME, "getResourceReferences", "Resource does NOT exist, removing reference");
                }
                this.deleteResourceReference(cfgResource);
                ++n;
            }
            cfgResourceArray = arrayList.toArray(new CfgResource[0]);
        }
        catch (AmasException amasException) {
            // empty catch block
        }
        if (cfgResourceArray == null) {
            cfgResourceArray = new CfgResource[]{};
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.text(16L, (Object)CLASSNAME, "getResourceReferences", "Found " + cfgResourceArray.length + " resource references for Role " + this.getId());
            this._traceLogger.text(16L, (Object)CLASSNAME, "getResourceReferences", "Cleaned up  " + n + " hanging resource references for Role " + this.getId());
            this._traceLogger.exit(96L, (Object)CLASSNAME, "getResourceReferences()");
        }
        return cfgResourceArray;
    }

    private HashMap getResourceRefDetails() throws AmasException {
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "getResourceRefDetails()");
        }
        HashMap<String, List> hashMap = new HashMap<String, List>();
        ArrayList arrayList = new ArrayList();
        try {
            AmasPDHelper.listResourcesRecursive(arrayList, this._sess.getSessionContext(), this._roleId);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                AmasObject amasObject = new AmasObject(this._sess, string);
                List list = amasObject.attributeValueList(RESOURCE_NAME);
                if (list == null || list.size() != 1) {
                    if (this._traceLogger == null || !this._traceLogger.isLogging()) continue;
                    this._traceLogger.text(16L, (Object)CLASSNAME, "getResourceRefDetails", "Object " + string + " is a role objec or a dangling resource reference.");
                    continue;
                }
                String string2 = (String)list.get(0);
                List list2 = amasObject.attributeValueList(ROLE_ATTR_NAME);
                hashMap.put(string2, list2);
            }
        }
        catch (PDException pDException) {
            AmasMessage amasMessage = new AmasMessage(916942926, (Object)this._roleId, pDException.toString());
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                this._msgLogger.text(4L, (Object)CLASSNAME, "getResourceRefDetails()", amasMessage.getMessageString());
            }
            throw new AmasException(amasMessage);
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "getResourceRefDetails()");
        }
        return hashMap;
    }

    public List getChildRoles() throws AmasException {
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "getChildRoles()");
        }
        List list = this._roleObj.listChildrenRecursive();
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "getChildRoles()");
        }
        return list;
    }
}

