/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pd.as.rbpf;

import com.tivoli.pd.as.rbpf.AmasSession;
import com.tivoli.pd.as.rbpf.IResourceHandler;
import com.tivoli.pd.as.util.AmasException;
import com.tivoli.pd.as.util.AmasUtil;
import com.tivoli.pd.jras.pdjlog.jlog.ILogger;
import java.util.List;

public abstract class Resource {
    private final String Resource_java_sourceCodeID = "$Id: @(#)33  1.8 src/amas/com/tivoli/pd/as/rbpf/Resource.java, amemb.jacc.was, amemb600, 051118a 04/07/15 17:53:22 @(#) $";
    public static final String sCopyright = "IBM Confidential\nObject Code Only Source Materials\n5747-SM3\n(c) Copyright International Business Machines Corp. 1994-2002.  All Rights Reserved.\nThe source code for this program is not published or otherwise divested\nof its trade secrets, irrespective of what has been deposited with the\nU.S. Copyright Office.\n";
    protected String _roleSuffix = null;
    protected String _resId;
    protected AmasSession _sess;
    protected ILogger _trcLogger;
    protected ILogger _msgLogger;
    protected SecurityManager _secMgr;
    protected IResourceHandler _resHdl = null;
    protected static final String ROLE_SUFF_ATTR_NAME = "AmasRoleSuffix";
    private static final String CLASSNAME = "com.tivoli.pd.as.rbpf.Resource";

    Resource(AmasSession amasSession, String string) throws AmasException {
        this._resId = string;
        this._sess = amasSession;
        this._secMgr = System.getSecurityManager();
        this._trcLogger = this._sess.getLogManager().getTraceLogger("AmasRBPFTraceLogger");
        this._msgLogger = amasSession.getLogManager().getMessageLogger("AmasRBPFMessageLogger");
    }

    public String toString() {
        return "Resource: Id = " + this.getPosName();
    }

    public final String getId() {
        return this.getPosName();
    }

    abstract String[] getLocalRoles() throws AmasException;

    String getRoleSuffix() throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "getRoleSuffix()");
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "getRoleSuffix() { retVal = " + this._roleSuffix + " }");
        }
        return this._roleSuffix;
    }

    void setRoleSuffix(String string) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "setRoleSuffix(String suffix) { suffix = " + string + " }");
        }
        this._roleSuffix = string;
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "setRoleSuffix(String)");
        }
    }

    final String getRoleBaseObjName(String string) throws AmasException {
        String string2 = null;
        String string3 = this._sess.getRoleContainerName();
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "getRoleBaseObjName(String roleName) { roleName = " + string + " }");
        }
        string2 = AmasUtil.appendPosValue(string3, string);
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "getRoleBaseObjName(String) { retVal = " + string2 + " }");
        }
        return string2;
    }

    final String getRoleObjName(String string) throws AmasException {
        String string2 = null;
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "getRoleObjName(String roleName) { roleName = " + string + " }", (Object)("Generating role object name for " + string + "."));
        }
        String string3 = this.getRoleBaseObjName(string);
        String string4 = this.getRoleSuffix();
        string2 = AmasUtil.appendPosValue(string3, string4);
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "getRoleObjName(String)", (Object)("Generated role name is: " + string2));
        }
        return string2;
    }

    protected List getLocalPolicyData(String string) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "getLocalPolicyData(String policyId) { policyId = " + string + " }");
        }
        List list = null;
        if (string == null) {
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "getLocalPolicyData(String)", "Null policyId encountered.");
            }
            throw new IllegalArgumentException();
        }
        list = this.attributeValueList(string);
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "getLocalPolicyData(String)");
        }
        return list;
    }

    String getSingleValueAttribute(String string) throws AmasException {
        List list;
        String string2 = null;
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "getSingleValueAttribute(String attrName) { attrName = " + string + " }");
        }
        if ((list = this.attributeValueList(string)).size() == 1) {
            string2 = (String)list.get(0);
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "getSingleValueAttribute(String) { retVal = " + string2 + " }");
        }
        return string2;
    }

    final boolean isReservedAttribute(String string) {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "isReservedAttribute(String attributeName) { attributeName = " + string + " }");
        }
        boolean bl = false;
        if (string.equals(ROLE_SUFF_ATTR_NAME)) {
            bl = true;
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "isReservedAttribute(String) { retVal = " + bl + " }");
        }
        return bl;
    }

    abstract List attributeValueList(String var1) throws AmasException;

    abstract String getPosName();

    abstract void setResourceHandler(IResourceHandler var1);
}

