/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pd.as.rbpf;

import com.tivoli.pd.as.rbpf.AmasSession;
import com.tivoli.pd.as.rbpf.ResourceHandler;
import com.tivoli.pd.as.rbpf.ResourceHandlerBase;
import com.tivoli.pd.as.util.AmasException;
import com.tivoli.pd.as.util.AmasMessage;
import java.lang.reflect.Constructor;
import java.util.HashMap;

final class ResourceHandlerFactory {
    private final String ResourceHandlerFactory_java_sourceCodeID = "$Id: @(#)21  1.4 src/amas/com/tivoli/pd/as/rbpf/ResourceHandlerFactory.java, amemb.jacc.was, amemb600, 051118a 04/07/15 17:53:15 @(#) $";
    public static final String sCopyright = "IBM Confidential\nObject Code Only Source Materials\n5747-SM3\n(c) Copyright International Business Machines Corp. 1994-2002.  All Rights Reserved.\nThe source code for this program is not published or otherwise divested\nof its trade secrets, irrespective of what has been deposited with the\nU.S. Copyright Office.\n";
    private HashMap _registeredHandlerClasses = new HashMap();
    private HashMap _registeredDecodeHandlers = new HashMap();
    private AmasSession _sess;

    ResourceHandlerFactory(AmasSession amasSession) {
        this._sess = amasSession;
    }

    ResourceHandler createResourceHandler(Object object) throws AmasException {
        ResourceHandler resourceHandler = null;
        Class clazz = this.getResourceHandlerClass(object);
        if (clazz != null) {
            try {
                Class[] classArray = new Class[]{this._sess.getClass(), new Object().getClass()};
                Constructor constructor = clazz.getConstructor(classArray);
                Object[] objectArray = new Object[]{this._sess, object};
                resourceHandler = (ResourceHandler)constructor.newInstance(objectArray);
            }
            catch (Exception exception) {
                throw new AmasException(exception);
            }
        } else {
            AmasMessage amasMessage = new AmasMessage(916942878, object.getClass().getName());
            throw new AmasException(amasMessage);
        }
        return resourceHandler;
    }

    ResourceHandlerBase createDecodeResourceHandler(String string) throws AmasException {
        ResourceHandlerBase resourceHandlerBase = null;
        Class clazz = this.getDecodeHandler(string);
        if (clazz != null) {
            try {
                Class[] classArray = new Class[]{this._sess.getClass()};
                Constructor constructor = clazz.getConstructor(classArray);
                Object[] objectArray = new Object[]{this._sess};
                resourceHandlerBase = (ResourceHandlerBase)constructor.newInstance(objectArray);
            }
            catch (Exception exception) {
                throw new AmasException(exception);
            }
        } else {
            AmasMessage amasMessage = new AmasMessage(916942878, string);
            throw new AmasException(amasMessage);
        }
        return resourceHandlerBase;
    }

    void registerResourceHandlerClass(Class clazz, Class clazz2) {
        if (clazz != null && clazz2 != null) {
            if (this._registeredHandlerClasses.containsKey(clazz)) {
                this._registeredHandlerClasses.remove(clazz);
            }
        } else {
            throw new IllegalArgumentException();
        }
        this._registeredHandlerClasses.put(clazz, clazz2);
    }

    void registerDecodeResourceHandlerClass(String string, Class clazz) {
        if (string != null && clazz != null) {
            if (this._registeredDecodeHandlers.containsKey(string)) {
                this._registeredDecodeHandlers.remove(string);
            }
        } else {
            throw new IllegalArgumentException();
        }
        this._registeredDecodeHandlers.put(string, clazz);
    }

    private Class getResourceHandlerClass(Object object) {
        Class clazz = null;
        if (object == null) {
            throw new IllegalArgumentException();
        }
        clazz = this.getResourceHandlerClass(object.getClass());
        return clazz;
    }

    private Class getResourceHandlerClass(Class clazz) {
        Class clazz2 = null;
        if (clazz != null && (clazz2 = (Class)this._registeredHandlerClasses.get(clazz)) == null) {
            Class clazz3;
            Class<?>[] classArray = clazz.getInterfaces();
            for (int i = 0; i < classArray.length && clazz2 == null; ++i) {
                clazz2 = this.getResourceHandlerClass(classArray[i]);
            }
            if (clazz2 == null && (clazz3 = clazz.getSuperclass()) != null) {
                clazz2 = this.getResourceHandlerClass(clazz3);
            }
        }
        return clazz2;
    }

    private Class getDecodeHandler(String string) {
        Class clazz = null;
        if (string != null) {
            clazz = (Class)this._registeredDecodeHandlers.get(string);
        }
        return clazz;
    }
}

