/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pd.as.rbpf;

import com.tivoli.pd.as.rbpf.AmasSession;
import com.tivoli.pd.as.rbpf.IResourceHandler;
import com.tivoli.pd.as.rbpf.ResourceHandler;
import com.tivoli.pd.as.rbpf.Role;
import com.tivoli.pd.as.util.AmasException;
import com.tivoli.pd.jras.pdjlog.jlog.ILogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

abstract class RoleCollection
extends ArrayList {
    private final String RoleCollection_java_sourceCodeID = "$Id: @(#)13  1.2 src/amas/com/tivoli/pd/as/rbpf/RoleCollection.java, amemb.jacc.was, amemb600, 051118a 04/07/15 17:53:11 @(#) $";
    public static final String sCopyright = "IBM Confidential\nObject Code Only Source Materials\n5747-SM3\n(c) Copyright International Business Machines Corp. 1994-2002.  All Rights Reserved.\nThe source code for this program is not published or otherwise divested\nof its trade secrets, irrespective of what has been deposited with the\nU.S. Copyright Office.\n";
    protected AmasSession _sess;
    protected ILogger _trcLogger;
    protected ILogger _msgLogger;
    protected SecurityManager _secMgr;
    private static final String CLASSNAME = "com.tivoli.pd.as.rbpf.RoleCollection";

    RoleCollection(AmasSession amasSession) throws AmasException {
        this._sess = amasSession;
        this._trcLogger = amasSession.getLogManager().getTraceLogger("AmasRBPFTraceLogger");
        this._msgLogger = amasSession.getLogManager().getMessageLogger("AmasRBPFMessageLogger");
    }

    RoleCollection(AmasSession amasSession, RoleCollection roleCollection) throws AmasException {
        super(roleCollection);
        this._sess = amasSession;
        this._trcLogger = amasSession.getLogManager().getTraceLogger("AmasRBPFTraceLogger");
        this._msgLogger = amasSession.getLogManager().getMessageLogger("AmasRBPFMessageLogger");
    }

    RoleCollection(AmasSession amasSession, int n) throws AmasException {
        super(n);
        this._sess = amasSession;
        this._trcLogger = amasSession.getLogManager().getTraceLogger("AmasRBPFTraceLogger");
        this._msgLogger = amasSession.getLogManager().getMessageLogger("AmasRBPFMessageLogger");
    }

    RoleCollection(AmasSession amasSession, String[] stringArray) throws AmasException {
        this._sess = amasSession;
        this._trcLogger = amasSession.getLogManager().getTraceLogger("AmasRBPFTraceLogger");
        this._msgLogger = amasSession.getLogManager().getMessageLogger("AmasRBPFMessageLogger");
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                Role role2 = this.createRole(stringArray[i]);
                this.add(role2);
            }
        }
    }

    RoleCollection(AmasSession amasSession, String[] stringArray, Object object) throws AmasException {
        this._sess = amasSession;
        this._trcLogger = amasSession.getLogManager().getTraceLogger("AmasRBPFTraceLogger");
        this._msgLogger = amasSession.getLogManager().getMessageLogger("AmasRBPFMessageLogger");
        for (int i = 0; i < stringArray.length; ++i) {
            Role role2 = this.createRole(stringArray[i], object);
            this.add(role2);
        }
    }

    abstract RoleCollection getAllowedRoles(String var1) throws AmasException;

    abstract boolean isGrantedRole(String var1) throws AmasException;

    abstract Role instantiateRole(String var1, String var2) throws AmasException;

    private Role createRole(String string) throws AmasException {
        int n;
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "createRole(String roleId) { roleId = " + string + " }");
        }
        String string2 = string;
        String string3 = this._sess.getRoleContainerName();
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.text(16L, (Object)CLASSNAME, "createRole", "Got roleId [" + string + "]");
        }
        if (!string3.startsWith("/")) {
            string3 = "/" + string3;
        }
        if (!string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        if (string2.startsWith(string3)) {
            n = string3.length();
            string2 = string2.substring(n + 1);
        }
        n = string2.indexOf("/");
        String string4 = "";
        string4 = n != -1 ? string2.substring(0, n) : string2;
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.text(16L, (Object)CLASSNAME, "createRole", "Creating role roleName [" + string4 + "] roleId [" + string + "]");
        }
        Role role2 = this.instantiateRole(string4, string);
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            if (role2 != null) {
                this._trcLogger.exit(96L, (Object)CLASSNAME, "createRole(String) { retVal = " + role2.getId() + " }");
            } else {
                this._trcLogger.exit(96L, (Object)CLASSNAME, "createRole(String) { retVal = null }");
            }
        }
        return role2;
    }

    private Role createRole(String string, Object object) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "createRole(String roleName, Object res) { roleName = " + string + " }");
        }
        Role role2 = null;
        ResourceHandler resourceHandler = this._sess.getHandlerFactory().createResourceHandler(object);
        if (resourceHandler instanceof IResourceHandler) {
            IResourceHandler iResourceHandler = (IResourceHandler)((Object)resourceHandler);
            String string2 = this._sess.getRoleContainerName();
            String string3 = iResourceHandler.getRoleSuffix();
            if (!string2.endsWith("/")) {
                string2 = string2 + "/";
            }
            if (!string3.startsWith("/")) {
                string3 = "/" + string3;
            }
            String string4 = string2 + string + string3;
            role2 = this.instantiateRole(string, string4);
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            if (role2 != null) {
                this._trcLogger.exit(96L, (Object)CLASSNAME, "createRole(String, Object) { retVal = " + role2.getId() + " }");
            } else {
                this._trcLogger.exit(96L, (Object)CLASSNAME, "createRole(String, Object) { retVal = null }");
            }
        }
        return role2;
    }

    protected Collection getRoleNames() throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "getRoleNames()");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Role role2 = (Role)iterator.next();
            arrayList.add(role2.getRoleName());
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "getRoleNames()");
        }
        return arrayList;
    }

    protected Collection getRoleIds() throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "getRoleIds()");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Role role2 = (Role)iterator.next();
            arrayList.add(role2.getId());
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "getRoleIds()");
        }
        return arrayList;
    }
}

