/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pd.as.rbpf;

import com.tivoli.pd.as.cache.IDynamicRoleCache;
import com.tivoli.pd.as.cache.IStaticRoleCache;
import com.tivoli.pd.as.nls.AmasMsgHelper;
import com.tivoli.pd.as.rbpf.AmasSession;
import com.tivoli.pd.as.rbpf.Role;
import com.tivoli.pd.as.rbpf.RtManager;
import com.tivoli.pd.as.util.AmasException;
import com.tivoli.pd.jazn.PDPermission;
import com.tivoli.pd.jazn.PDPrincipal;
import com.tivoli.pd.jutil.PDAttrs;
import com.tivoli.pd.jutil.PDException;

public final class RtRole
extends Role {
    private final String RtRole_java_sourceCodeID = "$Id: @(#)27  1.4 src/amas/com/tivoli/pd/as/rbpf/RtRole.java, amemb.jacc.was, amemb600, 051118a 04/07/15 17:53:19 @(#) $";
    public static final String sCopyright = "IBM Confidential\nObject Code Only Source Materials\n5747-SM3\n(c) Copyright International Business Machines Corp. 1994-2002.  All Rights Reserved.\nThe source code for this program is not published or otherwise divested\nof its trade secrets, irrespective of what has been deposited with the\nU.S. Copyright Office.\n";
    public static final String CLASSNAME = "com.tivoli.pd.as.rbpf.RtRole";
    private PDPermission _roleObj = null;

    RtRole(AmasSession amasSession, String string, String string2) throws AmasException {
        super(amasSession, string, string2);
        try {
            this._roleObj = new PDPermission(amasSession.getSessionContext(), string2, this._sess.getAMActionString());
        }
        catch (PDException pDException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                this._msgLogger.text(4L, (Object)CLASSNAME, "RtRole(AmasSession, String, String)", AmasMsgHelper.formatSingleParamMessage(916942884, pDException.toString()));
            }
            throw new AmasException(pDException);
        }
    }

    boolean isMember(String string) throws AmasException {
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "isMember(String prinName) { prinName = " + string + " }");
        }
        Object object = null;
        boolean bl = false;
        try {
            IDynamicRoleCache iDynamicRoleCache = this._sess.getRtManager().getDynamicRoleCache();
            if (iDynamicRoleCache != null && iDynamicRoleCache.isInitialized()) {
                object = iDynamicRoleCache.getPrincipal(string);
            }
            if (object == null) {
                RtManager rtManager = this._sess.getRtManager();
                object = rtManager.getPrincipal(string);
                if (iDynamicRoleCache != null && iDynamicRoleCache.isInitialized()) {
                    iDynamicRoleCache.addPrincipal(string, object);
                }
            } else if (this._traceLogger != null && this._traceLogger.isLogging()) {
                this._traceLogger.text(16L, (Object)CLASSNAME, "isMember", "Found principal in dynamic role cache.");
            }
            bl = this.isMember(object);
        }
        catch (Exception exception) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                this._msgLogger.text(4L, (Object)CLASSNAME, "isMember(String)", AmasMsgHelper.formatSingleParamMessage(916942849, exception.toString()));
            }
            throw new AmasException(exception);
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "isMember(String) { retVal = " + bl + " }");
        }
        return bl;
    }

    boolean isCachedMember(String string) {
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "isCachedMember(String prinName) { prinName = " + string + " }");
        }
        boolean bl = false;
        IStaticRoleCache iStaticRoleCache = this._sess.getRtManager().getStaticRoleCache();
        IDynamicRoleCache iDynamicRoleCache = this._sess.getRtManager().getDynamicRoleCache();
        if (iStaticRoleCache != null && iStaticRoleCache.isInitialized() && iStaticRoleCache.isStaticRole(this.getRoleName())) {
            if (this._traceLogger != null && this._traceLogger.isLogging()) {
                this._traceLogger.text(32L, (Object)CLASSNAME, "isCachedMember", "Role " + this.getRoleName() + " is static... checking static role cache");
            }
            bl = iStaticRoleCache.isRoleMember(string, this._roleName, this._roleId);
            if (this._traceLogger != null && this._traceLogger.isLogging()) {
                this._traceLogger.text(32L, (Object)CLASSNAME, "isCachedMember", "Principal: " + string + " isMember: " + bl);
            }
        } else if (iDynamicRoleCache != null && iDynamicRoleCache.isInitialized()) {
            if (this._traceLogger != null && this._traceLogger.isLogging()) {
                this._traceLogger.text(32L, (Object)CLASSNAME, "isCachedMember", "Checking dynamic role cache for role " + this.getRoleName());
            }
            String[] stringArray = iDynamicRoleCache.getRolesForPrincipal(string);
            for (int i = 0; i < stringArray.length && !bl; ++i) {
                if (this._traceLogger != null && this._traceLogger.isLogging()) {
                    this._traceLogger.text(32L, (Object)CLASSNAME, "isCachedMember", "Comparing cached Role -> " + stringArray[i]);
                }
                if (!stringArray[i].equals(this._roleId)) continue;
                if (this._traceLogger != null && this._traceLogger.isLogging()) {
                    this._traceLogger.text(32L, (Object)CLASSNAME, "isCachedMember", "Role found in dynamic cache");
                }
                bl = true;
            }
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "isCachedMember(String) { retVal = " + bl + " }");
        }
        return bl;
    }

    boolean isDeniedCachedMember(String string) {
        IDynamicRoleCache iDynamicRoleCache;
        boolean bl = false;
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "isDeniedCachedMember(String) { prinName = " + string + " }");
        }
        if ((iDynamicRoleCache = this._sess.getRtManager().getDynamicRoleCache()) != null && iDynamicRoleCache.isInitialized()) {
            if (this._traceLogger != null && this._traceLogger.isLogging()) {
                this._traceLogger.text(32L, (Object)CLASSNAME, "isDeniedCachedMember", "Checking dynamic role cache for denied role " + this.getRoleName());
            }
            String[] stringArray = iDynamicRoleCache.getDeniedRolesForPrincipal(string);
            for (int i = 0; i < stringArray.length && !bl; ++i) {
                if (this._traceLogger != null && this._traceLogger.isLogging()) {
                    this._traceLogger.text(32L, (Object)CLASSNAME, "isDeniedCachedMember", "Comparing denied cached Role -> " + stringArray[i]);
                }
                if (!stringArray[i].equals(this._roleId)) continue;
                if (this._traceLogger != null && this._traceLogger.isLogging()) {
                    this._traceLogger.text(32L, (Object)CLASSNAME, "isDeniedCachedMember", "Role found in dynamic cache");
                }
                bl = true;
            }
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "isDeniedCachedMember(String) { retVal = " + bl + " }");
        }
        return bl;
    }

    boolean isMember(Object object) throws AmasException {
        boolean bl = false;
        boolean bl2 = false;
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            if (object != null) {
                this._traceLogger.entry(80L, (Object)CLASSNAME, "isMember(PDPrincipal)", (Object)("Checking " + this._roleId + " : " + ((PDPrincipal)object).getName()));
            } else {
                this._traceLogger.entry(80L, (Object)CLASSNAME, "isMember(PDPrincipal) { prin = null }");
            }
        }
        try {
            bl = this._roleObj.implies(this._sess.getSessionContext(), (PDPrincipal)object, (PDAttrs)null, (PDAttrs)null);
        }
        catch (PDException pDException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                this._msgLogger.text(4L, (Object)CLASSNAME, "isMember(Object)", AmasMsgHelper.formatSingleParamMessage(916942884, pDException.toString()));
            }
            throw new AmasException(pDException);
        }
        IDynamicRoleCache iDynamicRoleCache = this._sess.getRtManager().getDynamicRoleCache();
        if (bl) {
            IStaticRoleCache iStaticRoleCache = this._sess.getRtManager().getStaticRoleCache();
            if (iStaticRoleCache != null && iStaticRoleCache.isInitialized() && iStaticRoleCache.isStaticRole(this.getRoleName())) {
                if (this._traceLogger != null && this._traceLogger.isLogging()) {
                    this._traceLogger.text(32L, (Object)CLASSNAME, "isMember", "Adding entry " + ((PDPrincipal)object).getName() + " : " + this._roleId + " to static role cache");
                }
                iStaticRoleCache.addRoleMember(((PDPrincipal)object).getName(), this._roleName, this._roleId);
            } else if (iDynamicRoleCache != null && iDynamicRoleCache.isInitialized()) {
                if (this._traceLogger != null && this._traceLogger.isLogging()) {
                    this._traceLogger.text(32L, (Object)CLASSNAME, "isMember", "Adding principal: " + ((PDPrincipal)object).getName() + " : " + this._roleId + " to dynamic role cache.");
                }
                iDynamicRoleCache.addRoleToPrincipal(((PDPrincipal)object).getName(), object, this._roleId);
            }
        } else if (iDynamicRoleCache != null && iDynamicRoleCache.isInitialized()) {
            if (this._traceLogger != null && this._traceLogger.isLogging()) {
                this._traceLogger.text(32L, (Object)CLASSNAME, "isMember", "Adding principal: " + ((PDPrincipal)object).getName() + " : " + this._roleId + " to denied dynamic role cache.");
            }
            iDynamicRoleCache.addDeniedRoleToPrincipal(((PDPrincipal)object).getName(), object, this._roleId);
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "isMember(PDPrincipal)", (Object)(((PDPrincipal)object).getName() + " isMember of " + this._roleId + ": " + bl + "."));
        }
        return bl;
    }
}

