/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pd.as.rbpf;

import com.tivoli.pd.as.cache.IDynamicRoleCache;
import com.tivoli.pd.as.cache.IStaticRoleCache;
import com.tivoli.pd.as.rbpf.AmasSession;
import com.tivoli.pd.as.rbpf.AuthzObjects;
import com.tivoli.pd.as.rbpf.Role;
import com.tivoli.pd.as.rbpf.RoleCollection;
import com.tivoli.pd.as.rbpf.RtRole;
import com.tivoli.pd.as.util.AmasException;
import java.util.Iterator;

class RtRoleCollection
extends RoleCollection {
    private final String RtRoleCollection_java_sourceCodeID = "$Id: @(#)14  1.2 src/amas/com/tivoli/pd/as/rbpf/RtRoleCollection.java, amemb.jacc.was, amemb600, 051118a 04/07/15 17:53:11 @(#) $";
    public static final String sCopyright = "IBM Confidential\nObject Code Only Source Materials\n5747-SM3\n(c) Copyright International Business Machines Corp. 1994-2002.  All Rights Reserved.\nThe source code for this program is not published or otherwise divested\nof its trade secrets, irrespective of what has been deposited with the\nU.S. Copyright Office.\n";
    private static final String CLASSNAME = "com.tivoli.pd.as.rbpf.RtRoleCollection";

    RtRoleCollection(AmasSession amasSession) throws AmasException {
        super(amasSession);
    }

    RtRoleCollection(AmasSession amasSession, RoleCollection roleCollection) throws AmasException {
        super(amasSession, roleCollection);
    }

    RtRoleCollection(AmasSession amasSession, int n) throws AmasException {
        super(amasSession, n);
    }

    RtRoleCollection(AmasSession amasSession, String[] stringArray) throws AmasException {
        super(amasSession, stringArray);
    }

    RtRoleCollection(AmasSession amasSession, String[] stringArray, Object object) throws AmasException {
        super(amasSession, stringArray, object);
    }

    protected RoleCollection getAllowedRoles(String string) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "getAllowedRoles(String prinName) { prinName = " + string + " }");
        }
        RtRoleCollection rtRoleCollection = new RtRoleCollection(this._sess);
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.text(16L, (Object)CLASSNAME, "geAllowedRoles", "Starting entries [" + rtRoleCollection.size() + "]");
        }
        RtRoleCollection rtRoleCollection2 = new RtRoleCollection(this._sess, this);
        RoleCollection roleCollection = this.getAllowedCacheRoles(string, rtRoleCollection2);
        rtRoleCollection.addAll(roleCollection);
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.text(16L, (Object)CLASSNAME, "geAllowedRoles", "Entries cached [" + rtRoleCollection.size() + "]");
        }
        rtRoleCollection2.removeAll(roleCollection);
        roleCollection = this.getDeniedCacheRoles(string, rtRoleCollection2);
        rtRoleCollection2.removeAll(roleCollection);
        if (!rtRoleCollection2.isEmpty()) {
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "geAllowedRoles", "Entries to check [" + rtRoleCollection2.size() + "] - not cached");
            }
            AuthzObjects authzObjects = AuthzObjects.createRtAuthz(this._sess, rtRoleCollection2);
            roleCollection = authzObjects.getAuthzRoles(string);
            rtRoleCollection.addAll(roleCollection);
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.text(16L, (Object)CLASSNAME, "geAllowedRoles", "Returning num entries [" + rtRoleCollection.size() + "]");
            this._trcLogger.exit(96L, (Object)CLASSNAME, "getAllowedRoles(String)");
        }
        return rtRoleCollection;
    }

    protected boolean isGrantedRole(String string) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "isGrantedRole(String prinName) { prinName = " + string + " }");
        }
        boolean bl = false;
        RtRoleCollection rtRoleCollection = new RtRoleCollection(this._sess, this);
        RoleCollection roleCollection = this.getAllowedCacheRoles(string, rtRoleCollection);
        if (!roleCollection.isEmpty()) {
            bl = true;
        } else {
            roleCollection = this.getDeniedCacheRoles(string, rtRoleCollection);
            rtRoleCollection.removeAll(roleCollection);
            if (!rtRoleCollection.isEmpty()) {
                AuthzObjects authzObjects = AuthzObjects.createRtAuthz(this._sess, rtRoleCollection);
                bl = authzObjects.isAuthzRole(string);
            } else {
                bl = false;
            }
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "isGrantedRole(String) { retVal = " + bl + " }");
        }
        return bl;
    }

    protected RoleCollection getAllowedCacheRoles(String string, RoleCollection roleCollection) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "getAllowedCacheRoles(String prinName, RoleCollection c) { prinName = " + string + " }");
        }
        RtRoleCollection rtRoleCollection = new RtRoleCollection(this._sess);
        Iterator iterator = roleCollection.iterator();
        IStaticRoleCache iStaticRoleCache = this._sess.getRtManager().getStaticRoleCache();
        IDynamicRoleCache iDynamicRoleCache = this._sess.getRtManager().getDynamicRoleCache();
        while (iterator.hasNext()) {
            Role role2 = (Role)iterator.next();
            if (!((RtRole)role2).isCachedMember(string)) continue;
            rtRoleCollection.add(role2);
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.text(16L, (Object)CLASSNAME, "geAllowedCacheRoles", "Returning num entries [" + rtRoleCollection.size() + "]");
            this._trcLogger.exit(96L, (Object)CLASSNAME, "getAllowedCacheRoles(String, RoleCollection)");
        }
        return rtRoleCollection;
    }

    protected RoleCollection getDeniedCacheRoles(String string, RoleCollection roleCollection) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "getDeniedCacheRoles(String prinName, RoleCollection c) { prinName = " + string + " }");
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.text(16L, (Object)CLASSNAME, "getDeniedCacheRoles", "Checking num entries [" + roleCollection.size() + "]");
        }
        RtRoleCollection rtRoleCollection = new RtRoleCollection(this._sess);
        Iterator iterator = roleCollection.iterator();
        IStaticRoleCache iStaticRoleCache = this._sess.getRtManager().getStaticRoleCache();
        IDynamicRoleCache iDynamicRoleCache = this._sess.getRtManager().getDynamicRoleCache();
        while (iterator.hasNext()) {
            Role role2 = (Role)iterator.next();
            if (!((RtRole)role2).isDeniedCachedMember(string)) continue;
            rtRoleCollection.add(role2);
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.text(16L, (Object)CLASSNAME, "getDeniedCacheRoles", "Returning num entries [" + rtRoleCollection.size() + "]");
            this._trcLogger.exit(96L, (Object)CLASSNAME, "getDeniedCacheRoles(String, RoleCollection)");
        }
        return rtRoleCollection;
    }

    Role instantiateRole(String string, String string2) throws AmasException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "instantiateRole(String roleName, String roleId) { roleName = " + string + " , roleId = " + string2 + " }");
        }
        RtRole rtRole = new RtRole(this._sess, string, string2);
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            if (rtRole != null) {
                this._trcLogger.exit(96L, (Object)CLASSNAME, "instantiateRole(String, String) { retVal = " + rtRole.getId() + " }");
            } else {
                this._trcLogger.exit(96L, (Object)CLASSNAME, "instantiateRole(String, String) { retVal = null }");
            }
        }
        return rtRole;
    }
}

