/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pd.as.util;

import com.tivoli.pd.jadmin.PDAcl;
import com.tivoli.pd.jadmin.PDProtObject;
import com.tivoli.pd.jutil.PDAttrs;
import com.tivoli.pd.jutil.PDContext;
import com.tivoli.pd.jutil.PDException;
import com.tivoli.pd.jutil.PDMessages;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class AMPOSCleanup {
    private final String AMPOSCleanup_java_sourceCodeID = "$Id: @(#)51  1.3 src/amas/com/tivoli/pd/as/util/AMPOSCleanup.java, amemb.jacc.was, amemb600, 051118a 04/09/02 18:10:40 @(#) $";
    private PDContext _ctx;
    private String _adminUrl;
    private String _posRoot;
    private boolean _inputsValid;
    private List _objectsToDelete;
    private List _aclsToDelete;
    private static final String _URL_ARGUMENT = "-admin_url";
    private static final String _POS_ARGUMENT = "-pos_root";
    private static final String _YES_STRING = "Yes";
    private static final String _DEFAULT_ADMIN_URL = "file:///" + System.getProperty("java.home") + System.getProperty("file.separator") + "PdPerm.properties";
    public static final String sCopyright = "IBM Confidential\nObject Code Only Source Materials\n5747-SM3\n(c) Copyright International Business Machines Corp. 1994-2002.  All Rights Reserved.\nThe source code for this program is not published or otherwise divested\nof its trade secrets, irrespective of what has been deposited with the\nU.S. Copyright Office.\n";

    public static void main(String[] stringArray) {
        try {
            AMPOSCleanup aMPOSCleanup = new AMPOSCleanup(stringArray);
            if (aMPOSCleanup.getInputsValid()) {
                System.out.println("Root Protected Object: " + aMPOSCleanup.getPosRoot());
                System.out.println("Config URL: " + aMPOSCleanup.getAdminUrl());
                aMPOSCleanup.populateDeleteLists(aMPOSCleanup.getPosRoot());
                boolean bl = aMPOSCleanup.confirmDelete();
                if (bl) {
                    aMPOSCleanup.performDelete();
                }
            } else {
                AMPOSCleanup.printUsage();
            }
        }
        catch (Exception exception) {
            System.out.println("Error in main function: " + exception);
        }
    }

    public AMPOSCleanup(String[] stringArray) throws Exception {
        this._inputsValid = this.checkInputArgs(stringArray);
        if (this._inputsValid) {
            try {
                this._ctx = this.createPDContext(this._adminUrl);
                this._aclsToDelete = new ArrayList();
                this._objectsToDelete = new ArrayList();
            }
            catch (Exception exception) {
                System.out.println("Error creating AMPOSCleanup Object: " + exception);
                throw new Exception("Error creating AMPOSCleanup Object: " + exception);
            }
        }
    }

    private boolean checkInputArgs(String[] stringArray) {
        int n;
        boolean bl = false;
        if (stringArray != null && (n = stringArray.length) >= 2) {
            if (stringArray[0] != null && stringArray[0].equals(_POS_ARGUMENT)) {
                this._posRoot = stringArray[1];
                bl = true;
            }
            if (n == 4) {
                if (stringArray[2] != null && stringArray[2].equals(_URL_ARGUMENT)) {
                    this._adminUrl = stringArray[3];
                }
            } else {
                this._adminUrl = _DEFAULT_ADMIN_URL;
            }
        }
        return bl;
    }

    private void populateDeleteLists(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("Invalid Argument specified in recursive search: null");
        }
        try {
            Object object;
            PDMessages pDMessages = new PDMessages();
            PDProtObject pDProtObject = new PDProtObject(this._ctx, string, (PDAttrs)null, (PDAttrs)null, pDMessages);
            if (PDProtObject.exists((PDContext)this._ctx, (String)string, (PDMessages)new PDMessages())) {
                this._objectsToDelete.add(string);
                object = pDProtObject.getAclId();
                if (object != null && ((String)object).length() > 0) {
                    this._aclsToDelete.add(object);
                }
            }
            object = PDProtObject.listProtObjects((PDContext)this._ctx, (String)string, (PDAttrs)null, (PDAttrs)null, (PDMessages)pDMessages);
            int n = object.size();
            if (object != null && n > 0) {
                for (int i = 0; i < n; ++i) {
                    String string2 = (String)object.get(i);
                    this.populateDeleteLists(string2);
                }
            }
        }
        catch (PDException pDException) {
            StringBuffer stringBuffer = new StringBuffer();
            this.getPDMessages(pDException, stringBuffer);
            System.out.println("PDException caught during delete list population: " + stringBuffer.toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean confirmDelete() throws Exception {
        int n = 0;
        int n2 = this._objectsToDelete.size();
        int n3 = this._aclsToDelete.size();
        boolean bl = false;
        if (n2 > 0 || n3 > 0) {
            System.out.println("Objects to delete = ");
            System.out.println("[");
            for (n = 0; n < n2; ++n) {
                System.out.println(this._objectsToDelete.get(n));
            }
            System.out.println("]");
            System.out.println("\n\nACLs to delete =");
            System.out.println("[");
            for (n = 0; n < n3; ++n) {
                System.out.println(this._aclsToDelete.get(n));
            }
            System.out.println("]");
            System.out.println("Are you sure you want to delete all Tivoli Access Manager objects and ACLs as shown above: [Yes/No]");
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                String string = bufferedReader.readLine();
                if (!string.equalsIgnoreCase(_YES_STRING)) return bl;
                return true;
            }
            catch (IOException iOException) {
                System.out.println("Error reading the user response from standard input: " + iOException);
                throw new Exception("Error reading the user response from standard input: " + iOException);
            }
        }
        System.out.println("No Protected Objects or ACLs to delete under: " + this._posRoot);
        return bl;
    }

    private void performDelete() throws Exception {
        int n = 0;
        int n2 = this._objectsToDelete.size();
        int n3 = this._aclsToDelete.size();
        String string = null;
        try {
            for (n = 0; n < n2; ++n) {
                string = (String)this._objectsToDelete.get(n);
                System.out.println("Attempting deletion of Protected Object: " + string);
                PDProtObject.deleteProtObject((PDContext)this._ctx, (String)string, (PDMessages)new PDMessages());
                System.out.println("Protected Object deleted successfully: " + string);
            }
        }
        catch (PDException pDException) {
            StringBuffer stringBuffer = new StringBuffer();
            this.getPDMessages(pDException, stringBuffer);
            System.out.println("Error deleting protected object: " + string + " : " + stringBuffer.toString());
            throw new Exception("Error deleting protected object: " + string + " : " + stringBuffer.toString());
        }
        try {
            for (n = 0; n < n3; ++n) {
                string = (String)this._aclsToDelete.get(n);
                System.out.println("Attempting deletion of ACL: " + string);
                PDAcl.deleteAcl((PDContext)this._ctx, (String)string, (PDMessages)new PDMessages());
                System.out.println("ACL deleted successfully: " + string);
            }
        }
        catch (PDException pDException) {
            StringBuffer stringBuffer = new StringBuffer();
            this.getPDMessages(pDException, stringBuffer);
            System.out.println("Error deleting ACL: " + string + " : " + stringBuffer.toString());
            throw new Exception("Error deleting ACL: " + string + " : " + stringBuffer.toString());
        }
    }

    private PDContext createPDContext(String string) throws Exception {
        PDContext pDContext = null;
        try {
            URL uRL = new URL(string);
            pDContext = new PDContext(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("Incorrect URL specified for PDPerm.properties");
            throw new Exception("Incorrect URL specified for PDPerm.properties");
        }
        catch (PDException pDException) {
            StringBuffer stringBuffer = new StringBuffer("PDException caught when creating PDContext with URL: " + string + "\n");
            this.getPDMessages(pDException, stringBuffer);
            stringBuffer.append("PDException deatils are: " + stringBuffer.toString());
            System.out.println(stringBuffer);
            throw new Exception(stringBuffer.toString());
        }
        return pDContext;
    }

    private static void printUsage() {
        System.out.println("* Indicates manditory field");
        System.out.println("Usage: -pos_root <*pos_root> -admin_url <admin_url>");
    }

    private void getPDMessages(Throwable throwable, StringBuffer stringBuffer) {
        if (stringBuffer != null && throwable != null && throwable instanceof PDException) {
            PDException pDException = (PDException)throwable;
            stringBuffer.append(pDException.toString() + "\n");
            Throwable throwable2 = pDException.getCause();
            if (throwable2 != null) {
                this.getPDMessages(throwable2, stringBuffer);
            }
        }
    }

    public String getAdminUrl() {
        return this._adminUrl;
    }

    public String getPosRoot() {
        return this._posRoot;
    }

    public boolean getInputsValid() {
        return this._inputsValid;
    }
}

