/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pd.as.util;

import com.tivoli.pd.as.util.RWLock;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;

public final class MaskString {
    private final String MaskString_java_sourceCodeID = "$Id: @(#)59  1.3 src/amas/com/tivoli/pd/as/util/MaskString.java, amemb.jacc.was, amemb600, 081121a 08/10/23 00:39:57 @(#) $";
    public static final String sCopyright = "IBM Confidential\nObject Code Only Source Materials\n5747-SM3\n(c) Copyright International Business Machines Corp. 1994-2002.  All Rights Reserved.\nThe source code for this program is not published or otherwise divested\nof its trade secrets, irrespective of what has been deposited with the\nU.S. Copyright Office.\n";
    private static final String CLASSNAME = "com.tivoli.pd.as.util.MaskString";
    private byte[] _byteRand;
    private byte[] _maskString;
    private RWLock _passwordLock = new RWLock();
    private Timer _passwordRefresh;
    private boolean _passwordValid;
    private long _expiry = -1L;

    public MaskString(String string, long l) {
        if (string != null) {
            this._passwordValid = true;
            this._maskString = this.maskString(string.getBytes());
        } else {
            this._passwordValid = false;
        }
        if (l > 0L) {
            this.scheduleRefresh(l);
        }
        this._expiry = l;
    }

    public MaskString(char[] cArray, long l) {
        if (cArray != null && cArray.length > 0) {
            String string = new String(cArray);
            this._passwordValid = true;
            this._maskString = this.maskString(string.getBytes());
        } else {
            this._passwordValid = false;
        }
        if (l > 0L) {
            this.scheduleRefresh(l);
        }
        this._expiry = l;
    }

    public MaskString(String string) {
        if (string != null) {
            this._passwordValid = true;
            this._maskString = this.maskString(string.getBytes());
        }
    }

    protected byte[] maskString(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        if (this._byteRand == null) {
            long l = System.currentTimeMillis();
            Random random = new Random(l);
            this._byteRand = new byte[byArray.length];
            random.nextBytes(this._byteRand);
        }
        this._maskString = new byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray2[i] = (byte)(byArray[i] ^ this._byteRand[i % this._byteRand.length]);
        }
        return byArray2;
    }

    public String getClearString() {
        this._passwordLock.getReaderLock();
        byte[] byArray = new byte[this._maskString.length];
        for (int i = 0; i < this._maskString.length; ++i) {
            byArray[i] = (byte)(this._maskString[i] ^ this._byteRand[i % this._byteRand.length]);
        }
        String string = new String(byArray);
        this._passwordLock.releaseLock();
        return string;
    }

    public byte[] getMaskedString() {
        this._passwordLock.getReaderLock();
        byte[] byArray = this._maskString;
        this._passwordLock.releaseLock();
        return byArray;
    }

    private void zeroMaskedString() {
        this._passwordLock.getWriterLock();
        this._passwordValid = false;
        if (this._maskString != null) {
            for (int i = 0; i < this._maskString.length; ++i) {
                this._maskString[i] = 0;
            }
        }
        this._passwordLock.releaseLock();
    }

    public void scheduleRefresh(long l) {
        if (this._passwordRefresh == null) {
            this._passwordRefresh = new Timer();
            this._passwordRefresh.schedule(new TimerTask(){

                public void run() {
                    MaskString.this.zeroMaskedString();
                }
            }, l, l);
        } else {
            this._passwordRefresh.cancel();
            this._passwordRefresh.schedule(new TimerTask(){

                public void run() {
                    MaskString.this.zeroMaskedString();
                }
            }, l, l);
        }
    }

    public boolean validPassword() {
        this._passwordLock.getReaderLock();
        boolean bl = this._passwordValid;
        this._passwordLock.releaseLock();
        return bl;
    }

    public void setMaskedString(String string) {
        this._passwordLock.getWriterLock();
        this._maskString = this.maskString(string.getBytes());
        this._passwordValid = true;
        this._passwordLock.releaseLock();
    }

    public long getExpiry() {
        return this._expiry;
    }
}

