/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pd.as.util;

import com.tivoli.pd.as.util.RWLockException;
import java.util.ArrayList;

public class RWLock {
    private final String RWLock_java_sourceCodeID = "$Id: @(#)57  1.2 src/amas/com/tivoli/pd/as/util/RWLock.java, amemb.jacc.was, amemb600, 051118a 04/07/15 17:53:34 @(#) $";
    public static final String sCopyright = "IBM Confidential\nObject Code Only Source Materials\n5747-SM3\n(c) Copyright International Business Machines Corp. 1994-2002.  All Rights Reserved.\nThe source code for this program is not published or otherwise divested\nof its trade secrets, irrespective of what has been deposited with the\nU.S. Copyright Office.\n";
    static final int READER_LOCK = 1;
    static final int WRITER_LOCK = 2;
    private ParticipantList list = new ParticipantList();

    public synchronized boolean getReaderLock() throws RWLockException {
        boolean bl = false;
        Thread thread = Thread.currentThread();
        int n = this.list.getCurrentThreadIndex(thread);
        Participant participant = null;
        if (n == -1) {
            participant = new Participant(1, thread);
            this.list.add(participant);
            n = this.list.size() - 1;
            if (participant != null && n != -1) {
                boolean bl2 = true;
                while (bl2) {
                    int n2 = this.list.getWriterIndex();
                    if (n2 == -1 || n2 > n) {
                        ++participant.numLocks;
                        bl2 = false;
                        bl = true;
                        continue;
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        this.list.remove(n);
                        bl2 = false;
                    }
                    if (!bl2) continue;
                    n = this.list.getCurrentThreadIndex(thread);
                }
            }
        } else {
            participant = (Participant)this.list.get(n);
            ++participant.numLocks;
        }
        return bl;
    }

    public synchronized boolean getWriterLock() throws RWLockException {
        boolean bl = false;
        Thread thread = Thread.currentThread();
        int n = this.list.getCurrentThreadIndex(thread);
        Participant participant = null;
        if (n == -1) {
            participant = new Participant(2, thread);
            this.list.add(participant);
            n = this.list.size() - 1;
            if (participant != null && n != -1) {
                boolean bl2 = true;
                while (bl2) {
                    if (n != 0) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            this.list.remove(n);
                            bl2 = false;
                        }
                        if (!bl2) continue;
                        n = this.list.getCurrentThreadIndex(thread);
                        continue;
                    }
                    bl2 = false;
                    bl = true;
                    ++participant.numLocks;
                }
            }
        } else {
            participant = (Participant)this.list.get(n);
            if (participant.lockType == 1) {
                throw new RWLockException("RWLock::getWriterLock -- Lock upgrades are not supported");
            }
            ++participant.numLocks;
        }
        return bl;
    }

    public synchronized boolean releaseLock() throws RWLockException {
        boolean bl = false;
        Thread thread = Thread.currentThread();
        int n = this.list.getCurrentThreadIndex(thread);
        Participant participant = null;
        if (n > -1) {
            participant = (Participant)this.list.get(n);
        }
        if (participant != null) {
            bl = true;
            --participant.numLocks;
            if (participant.numLocks == 0) {
                this.list.remove(n);
                this.notifyAll();
            }
        } else {
            throw new RWLockException("RWLock::releaseLock -- Lock not held");
        }
        return bl;
    }

    private class ParticipantList
    extends ArrayList {
        public int getCurrentThreadIndex(Thread thread) {
            int n = -1;
            for (int i = 0; i < this.size(); ++i) {
                Participant participant = (Participant)this.get(i);
                if (participant.threadID != thread) continue;
                n = i;
                break;
            }
            return n;
        }

        public int getWriterIndex() {
            int n = -1;
            for (int i = 0; i < this.size(); ++i) {
                Participant participant = (Participant)this.get(i);
                if (participant.lockType != 2) continue;
                n = i;
                break;
            }
            return n;
        }
    }

    private class Participant {
        int numLocks;
        int lockType;
        Thread threadID;

        public boolean equals(Object object) {
            boolean bl = false;
            Participant participant = (Participant)object;
            if (participant.threadID == this.threadID) {
                bl = true;
            }
            return bl;
        }

        public Participant(int n, Thread thread) {
            this.lockType = n;
            this.numLocks = 0;
            this.threadID = thread;
        }
    }
}

