/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pdwas.ddparser;

import com.tivoli.pdwas.ddparser.AnyOtherACE;
import com.tivoli.pdwas.ddparser.DTDEntityResolver;
import com.tivoli.pdwas.ddparser.GroupACE;
import com.tivoli.pdwas.ddparser.PDACL;
import com.tivoli.pdwas.ddparser.PDACLCollection;
import com.tivoli.pdwas.ddparser.UnauthenticatedACE;
import com.tivoli.pdwas.ddparser.UserACE;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class DeploymentDescriptorParser {
    private final String DeploymentDescriptorParser_java_sourceCodeID = "$Id: @(#)87  1.3 src/pdwas/com/tivoli/pdwas/ddparser/DeploymentDescriptorParser.java, amemb.jacc.was, amemb600, 061207a 06/10/09 23:15:38 @(#) $";
    public boolean DEBUG = true;
    private String xmlDD;
    private String applicationXMI;
    private InputStream xmlStream;
    private InputStream xmiStream;
    private Document xmlDoc;
    private Document xmiDoc;
    private int currentEJBName;
    private static String SECURITY_ASSIGN = "security-role-assignment";
    private static String PRINCIPAL_NAME = "principal-name";
    private static String EJB = "ejb";

    public DeploymentDescriptorParser(String string, String string2) {
        this.xmlDD = string;
        this.applicationXMI = string2;
    }

    public DeploymentDescriptorParser(String string) {
        this.xmlDD = string;
        this.applicationXMI = null;
    }

    public DeploymentDescriptorParser(InputStream inputStream, InputStream inputStream2) {
        this.xmlStream = inputStream;
        this.xmiStream = inputStream2;
    }

    public DeploymentDescriptorParser(InputStream inputStream) {
        this.xmlStream = inputStream;
        this.xmiStream = null;
    }

    private Document getXmlDoc() {
        try {
            if (this.xmlDoc == null) {
                DOMParser dOMParser = new DOMParser();
                dOMParser.setEntityResolver((EntityResolver)new DTDEntityResolver());
                if (this.xmlDD != null) {
                    dOMParser.parse(this.xmlDD);
                } else {
                    dOMParser.parse(new InputSource(this.xmlStream));
                }
                this.xmlDoc = dOMParser.getDocument();
                return this.xmlDoc;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.xmlDoc;
    }

    private Document getXmiDoc() {
        try {
            if (this.xmiDoc == null) {
                DOMParser dOMParser = new DOMParser();
                dOMParser.setEntityResolver((EntityResolver)new DTDEntityResolver());
                if (this.applicationXMI != null) {
                    dOMParser.parse(this.applicationXMI);
                } else {
                    dOMParser.parse(new InputSource(this.xmiStream));
                }
                this.xmiDoc = dOMParser.getDocument();
                return this.xmiDoc;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.xmiDoc;
    }

    public void writeXMLFile() throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(new File(this.xmlDD));
        XMLSerializer xMLSerializer = new XMLSerializer((OutputStream)fileOutputStream, new OutputFormat(this.getXmlDoc()));
        xMLSerializer.serialize(this.getXmlDoc());
        fileOutputStream.close();
    }

    public PDACLCollection getACLsXML() {
        PDACLCollection pDACLCollection = new PDACLCollection();
        try {
            Document document = this.getXmlDoc();
            if (document != null) {
                this.setWASRolesFromXML(document, pDACLCollection);
                this.setMembersFromXML(document, pDACLCollection);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        return pDACLCollection;
    }

    public PDACLCollection getACLs() {
        PDACLCollection pDACLCollection = new PDACLCollection();
        try {
            Document document = this.getXmlDoc();
            if (document != null) {
                this.setWASRolesFrom(document, pDACLCollection);
                this.setApplicationName(document, pDACLCollection);
            } else if (this.DEBUG) {
                System.out.println("The xml document could not be obtained.");
            }
            Document document2 = this.getXmiDoc();
            if (document2 != null) {
                this.setMembersFrom(document2, pDACLCollection);
            } else if (this.DEBUG) {
                System.out.println("The xmi document could not be obtained.");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        return pDACLCollection;
    }

    private void setApplicationName(Document document, PDACLCollection pDACLCollection) {
        NodeList nodeList = document.getElementsByTagName("display-name");
        String string = "";
        if (nodeList != null) {
            Node node = nodeList.item(0);
            if (node != null) {
                NodeList nodeList2 = node.getChildNodes();
                if (nodeList2 != null) {
                    Node node2 = nodeList2.item(0);
                    if (node2 != null) {
                        string = node2.getNodeValue();
                    } else if (this.DEBUG) {
                        System.out.println("display name value is null.");
                    }
                } else if (this.DEBUG) {
                    System.out.println("displayname attributes not found.");
                }
            } else if (this.DEBUG) {
                System.out.println("<display-name> expected.");
            }
        } else if (this.DEBUG) {
            System.out.println("<display-name> not found.");
        }
        pDACLCollection.setApplicationName(string);
    }

    private void setWASRolesFromXML(Document document, PDACLCollection pDACLCollection) {
        NodeList nodeList = document.getElementsByTagName("roles");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            PDACL pDACL = new PDACL();
            String string = "";
            NamedNodeMap namedNodeMap = nodeList.item(i).getAttributes();
            if (namedNodeMap == null) continue;
            Node node = namedNodeMap.getNamedItem("xmi:id");
            if (node != null) {
                string = node.getNodeValue();
            }
            pDACL.setID(string);
            String string2 = "";
            Node node2 = namedNodeMap.getNamedItem("roleName");
            if (node2 != null) {
                string2 = node2.getNodeValue();
            }
            pDACL.setRoleName(string2);
            if (pDACL.getRoleName() == null) continue;
            pDACLCollection.addACL(pDACL.getRoleName(), pDACL);
        }
    }

    private void setWASRolesFrom(Document document, PDACLCollection pDACLCollection) {
        NodeList nodeList = document.getElementsByTagName("security-role");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Object object;
            PDACL pDACL = new PDACL();
            String string = "";
            NamedNodeMap namedNodeMap = nodeList.item(i).getAttributes();
            if (namedNodeMap != null) {
                object = namedNodeMap.getNamedItem("id");
                if (object != null) {
                    string = object.getNodeValue();
                } else if (this.DEBUG) {
                    System.out.println("<security-role> id not found.");
                }
            } else if (this.DEBUG) {
                System.out.println("<security-role> attributes not found.");
            }
            pDACL.setID(string);
            object = nodeList.item(i).getChildNodes();
            int n2 = object.getLength();
            for (int j = 0; j < n2; ++j) {
                if (!"role-name".equals(object.item(j).getNodeName())) continue;
                String string2 = "";
                NodeList nodeList2 = object.item(j).getChildNodes();
                if (nodeList2 != null) {
                    Node node = nodeList2.item(0);
                    if (node != null) {
                        string2 = node.getNodeValue();
                    } else if (this.DEBUG) {
                        System.out.println("<role-name> value not found.");
                    }
                } else if (this.DEBUG) {
                    System.out.println("<role-name> attributes not found.");
                }
                pDACL.setRoleName(string2);
            }
            if (pDACL.getRoleName() == null) continue;
            pDACLCollection.addACL(pDACL.getRoleName(), pDACL);
        }
    }

    private void setMembersFrom(Document document, PDACLCollection pDACLCollection) {
        NodeList nodeList = document.getElementsByTagName("authorizations");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Object object;
            PDACL pDACL = new PDACL();
            String string = "";
            NamedNodeMap namedNodeMap = nodeList.item(i).getAttributes();
            if (namedNodeMap != null) {
                object = namedNodeMap.getNamedItem("xmi:id");
                if (object != null) {
                    string = object.getNodeValue();
                } else if (this.DEBUG) {
                    System.out.println("<authorizations> id expected.");
                }
            } else if (this.DEBUG) {
                System.out.println("<authorizations> attributes expected.");
            }
            object = pDACLCollection.getRoleFromID(string);
            pDACL.setRoleName((String)object);
            NodeList nodeList2 = nodeList.item(i).getChildNodes();
            int n2 = nodeList2.getLength();
            for (int j = 0; j < n2; ++j) {
                String string2;
                NamedNodeMap namedNodeMap2 = nodeList2.item(j).getAttributes();
                if ("role".equals(nodeList2.item(j).getNodeName())) {
                    string2 = "";
                    if (namedNodeMap2 != null) {
                        Node node = namedNodeMap2.getNamedItem("href");
                        if (node != null) {
                            string2 = node.getNodeValue();
                        } else if (this.DEBUG) {
                            System.out.println("<role> href attribute expected.");
                        }
                    } else if (this.DEBUG) {
                        System.out.println("<role> attributes not found.");
                    }
                    int n3 = string2.lastIndexOf(35) + 1;
                    String string3 = string2.substring(n3);
                    pDACL.setRoleName(pDACLCollection.getRoleFromID(string3));
                    continue;
                }
                if ("users".equals(nodeList2.item(j).getNodeName())) {
                    string2 = "";
                    if (namedNodeMap2 != null) {
                        Node node = namedNodeMap2.getNamedItem("name");
                        if (node != null) {
                            string2 = node.getNodeValue();
                        } else if (this.DEBUG) {
                            System.out.println("<users> name attribute expected.");
                        }
                    } else if (this.DEBUG) {
                        System.out.println("<users> attributes not found.");
                    }
                    pDACL.addMember(new UserACE(string2));
                    continue;
                }
                if ("groups".equals(nodeList2.item(j).getNodeName())) {
                    string2 = "";
                    if (namedNodeMap2 != null) {
                        Node node = namedNodeMap2.getNamedItem("name");
                        if (node != null) {
                            string2 = node.getNodeValue();
                        } else if (this.DEBUG) {
                            System.out.println("<groups> name attribute expected.");
                        }
                    } else if (this.DEBUG) {
                        System.out.println("<groups> attributes not found.");
                    }
                    pDACL.addMember(new GroupACE(string2));
                    continue;
                }
                if (!"specialSubjects".equals(nodeList2.item(j).getNodeName())) continue;
                string2 = "";
                if (namedNodeMap2 != null) {
                    Node node = namedNodeMap2.getNamedItem("name");
                    if (node != null) {
                        string2 = node.getNodeValue();
                    } else if (this.DEBUG) {
                        System.out.println("<specialSubjects> name attribute expected.");
                    }
                } else if (this.DEBUG) {
                    System.out.println("<specialSubjects> attributes not found.");
                }
                if (string2.equals("Everyone")) {
                    pDACL.addMember(new UnauthenticatedACE());
                    pDACL.addMember(new AnyOtherACE());
                    continue;
                }
                if (string2.equals("AllAuthenticatedUsers")) {
                    pDACL.addMember(new AnyOtherACE());
                    continue;
                }
                if (string2.equals("Server")) {
                    pDACL.addMember(new GroupACE("pdwas-admin"));
                    continue;
                }
                if (!this.DEBUG) continue;
                System.out.println("<specialSubjects> name value is invalid.");
            }
            if (pDACL.getRoleName() != null) {
                pDACLCollection.addACL(pDACL.getRoleName(), pDACL);
                continue;
            }
            if (!this.DEBUG) continue;
            System.out.println("Cannot add ACL -- role name not found.");
        }
    }

    private void setMembersFromXML(Document document, PDACLCollection pDACLCollection) {
        NodeList nodeList = document.getElementsByTagName("authorizations");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Object object;
            Object object2;
            PDACL pDACL = new PDACL();
            String string = "";
            String string2 = "";
            NamedNodeMap namedNodeMap = nodeList.item(i).getAttributes();
            if (namedNodeMap != null) {
                object2 = namedNodeMap.getNamedItem("xmi:id");
                if (object2 != null) {
                    string = object2.getNodeValue();
                } else if (this.DEBUG) {
                    System.out.println("<authorizations> id expected.");
                }
                object = namedNodeMap.getNamedItem("role");
                if (object != null) {
                    string2 = object.getNodeValue();
                }
            } else if (this.DEBUG) {
                System.out.println("<authorizations> attributes expected.");
            }
            object2 = pDACLCollection.getRoleFromID(string);
            pDACL.setRoleName((String)object2);
            pDACL.setRoleName(pDACLCollection.getRoleFromID(string2));
            object = nodeList.item(i).getChildNodes();
            int n2 = object.getLength();
            for (int j = 0; j < n2; ++j) {
                Node node;
                String string3;
                NamedNodeMap namedNodeMap2 = object.item(j).getAttributes();
                if ("users".equals(object.item(j).getNodeName())) {
                    string3 = "";
                    if (namedNodeMap2 != null) {
                        node = namedNodeMap2.getNamedItem("name");
                        if (node != null) {
                            string3 = node.getNodeValue();
                        } else if (this.DEBUG) {
                            System.out.println("<users> name attribute expected.");
                        }
                    } else if (this.DEBUG) {
                        System.out.println("<users> attributes not found.");
                    }
                    pDACL.addMember(new UserACE(string3));
                    continue;
                }
                if ("groups".equals(object.item(j).getNodeName())) {
                    string3 = "";
                    if (namedNodeMap2 != null) {
                        node = namedNodeMap2.getNamedItem("name");
                        if (node != null) {
                            string3 = node.getNodeValue();
                        } else if (this.DEBUG) {
                            System.out.println("<groups> name attribute expected.");
                        }
                    } else if (this.DEBUG) {
                        System.out.println("<groups> attributes not found.");
                    }
                    pDACL.addMember(new GroupACE(string3));
                    continue;
                }
                if (!"specialSubjects".equals(object.item(j).getNodeName())) continue;
                string3 = "";
                if (namedNodeMap2 != null) {
                    node = namedNodeMap2.getNamedItem("xmi:type");
                    if (node != null) {
                        string3 = node.getNodeValue();
                    } else if (this.DEBUG) {
                        System.out.println("<specialSubjects> name attribute expected.");
                    }
                } else if (this.DEBUG) {
                    System.out.println("<specialSubjects> attributes not found.");
                }
                if (string3.indexOf("Everyone") != -1) {
                    pDACL.addMember(new UnauthenticatedACE());
                    pDACL.addMember(new AnyOtherACE());
                    continue;
                }
                if (string3.indexOf("AllAuthenticatedUsers") != -1) {
                    pDACL.addMember(new AnyOtherACE());
                    continue;
                }
                if (string3.indexOf("Server") != -1) {
                    pDACL.addMember(new GroupACE("pdwas-admin"));
                    continue;
                }
                if (string3.indexOf("PrimaryAdmin") != -1 || !this.DEBUG) continue;
                System.out.println("<specialSubjects> name value is invalid.");
            }
            if (pDACL.getRoleName() != null) {
                pDACLCollection.addACL(pDACL.getRoleName(), pDACL);
                continue;
            }
            if (!this.DEBUG) continue;
            System.out.println("Cannot add ACL -- role name not found.");
        }
    }

    private static void print(NodeList nodeList, String string) {
        if (nodeList == null) {
            return;
        }
        if (string == null) {
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element = (Element)nodeList.item(i);
                DeploymentDescriptorParser.print(element, element.getAttributes());
            }
        } else {
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element = (Element)nodeList.item(i);
                NamedNodeMap namedNodeMap = element.getAttributes();
                if (namedNodeMap.getNamedItem(string) == null) continue;
                DeploymentDescriptorParser.print(element, namedNodeMap);
            }
        }
    }

    private static void print(Element element, NamedNodeMap namedNodeMap) {
        System.out.print('<');
        System.out.print(element.getNodeName());
        if (namedNodeMap != null) {
            int n = namedNodeMap.getLength();
            for (int i = 0; i < n; ++i) {
                Attr attr = (Attr)namedNodeMap.item(i);
                System.out.print(' ');
                System.out.print(attr.getNodeName());
                System.out.print("=\"");
                System.out.print(DeploymentDescriptorParser.normalize(attr.getNodeValue()));
                System.out.print('\"');
            }
        }
        System.out.println('>');
    }

    private static String normalize(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string != null ? string.length() : 0;
        block7: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block7;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block7;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block7;
                }
                case '\n': 
                case '\r': {
                    stringBuffer.append("&#");
                    stringBuffer.append(Integer.toString(c));
                    stringBuffer.append(';');
                    continue block7;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }
}

