/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pdwas.gso;

import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.WSSubject;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.security.auth.j2c.WSAuthDataAliasCallback;
import com.ibm.ws.security.auth.j2c.WSManagedConnectionFactoryCallback;
import com.ibm.ws.security.common.auth.WSPrincipalImpl;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.tivoli.pd.as.gso.GSOHelper;
import com.tivoli.pd.as.nls.AmasMsgHelper;
import com.tivoli.pd.as.util.AmasException;
import com.tivoli.pd.as.util.AmasMessage;
import com.tivoli.pd.jadmin.PDSSOCred;
import com.tivoli.pd.jras.pdjlog.jlog.ILogger;
import com.tivoli.pd.jras.pdjlog.jlog.MessageCatalog;
import com.tivoli.pd.jras.pdjlog.jlog.mgr.LogManager;
import com.tivoli.pd.jras.pdjlog.jlog.mgr.SinglePropertyDataStore;
import com.tivoli.pd.jutil.PDBasicContext;
import com.tivoli.pd.jutil.PDException;
import java.io.IOException;
import java.net.URL;
import java.security.Principal;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class AMPrincipalMapper
implements LoginModule {
    private final String AMPrincipalMapper_java_sourceCodeID = "$Id: @(#)65  1.1 src/pdwas/com/tivoli/pdwas/gso/AMPrincipalMapper.java, amemb.jacc.was, amemb600, 051118a 04/09/30 22:52:24 @(#) $";
    public static final String sCopyright = "IBM Confidential\nObject Code Only Source Materials\n5747-SM3\n(c) Copyright International Business Machines Corp. 1994-2002.  All Rights Reserved.\nThe source code for this program is not published or otherwise divested\nof its trade secrets, irrespective of what has been deposited with the\nU.S. Copyright Office.\n";
    private ILogger _traceLogger;
    private ILogger _msgLogger;
    private Subject _subject;
    private CallbackHandler _callbackHandler;
    private Map _sharedState;
    private Map _options;
    private boolean _aliasContainsUserName = false;
    private boolean _aliasContainsNodeName = false;
    private boolean _succeeded = false;
    private boolean _commitSucceeded = false;
    private WSPrincipalImpl _principal = null;
    private PasswordCredential _passwordCredential = null;
    private String _cfgURL = null;
    public static final String ALIAS_CONTAINS_USER_NAME = "com.tivoli.pd.as.gso.AliasContainsUserName";
    public static final String ALIAS_CONTAINS_NODE_NAME = "com.tivoli.pd.as.gso.AliasContainsNodeName";
    public static final String AM_CFG_URL = "com.tivoli.pd.as.gso.AMCfgURL";
    public static final String AM_LOG_URL = "com.tivoli.pd.as.gso.AMLoggingURL";
    static /* synthetic */ Class class$com$tivoli$pdwas$gso$AMPrincipalMapper;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        this._subject = subject;
        this._callbackHandler = callbackHandler;
        this._sharedState = map;
        this._options = map2;
        this._aliasContainsUserName = "true".equalsIgnoreCase((String)this._options.get(ALIAS_CONTAINS_USER_NAME));
        this._aliasContainsNodeName = "true".equalsIgnoreCase((String)this._options.get(ALIAS_CONTAINS_NODE_NAME));
        this._cfgURL = (String)this._options.get(AM_CFG_URL);
        String string = (String)this._options.get(AM_LOG_URL);
        if (string == null) {
            string = "file:///" + System.getProperty("java.home") + System.getProperty("file.separator") + "PolicyDirector" + System.getProperty("file.separator") + "PDJLog.properties";
        }
        this.initializeLogging(string);
        if (this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)this, "initialize(Subject, CallbackHandler, Map, Map)");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean login() throws LoginException {
        block32: {
            if (this._traceLogger.isLogging()) {
                this._traceLogger.entry(80L, (Object)this, "login()");
            }
            if (this._commitSucceeded) {
                if (this._traceLogger.isLogging()) {
                    this._traceLogger.text(16L, (Object)this, "login", "Calling logout");
                }
                this.logout();
            }
            this._succeeded = false;
            Callback[] callbackArray = new Callback[2];
            if (this._traceLogger.isLogging()) {
                this._traceLogger.text(16L, (Object)this, "login", "Creating callbacks");
            }
            callbackArray[0] = new WSManagedConnectionFactoryCallback("Target ManagedConnectionFactory: ");
            callbackArray[1] = new WSAuthDataAliasCallback("Resource Adapter AuthDataEntries alias: ");
            try {
                block33: {
                    String string;
                    String string2;
                    char[] cArray;
                    String string3;
                    block35: {
                        String string4;
                        block34: {
                            int n;
                            block31: {
                                if (this._traceLogger.isLogging()) {
                                    this._traceLogger.text(16L, (Object)this, "login", "Calling the callback");
                                }
                                this._callbackHandler.handle(callbackArray);
                                string3 = null;
                                cArray = null;
                                string2 = null;
                                string = null;
                                String string5 = ((WSAuthDataAliasCallback)callbackArray[1]).getAlias();
                                if (this._traceLogger.isLogging()) {
                                    this._traceLogger.text(16L, (Object)this, "login", "Callback alias [" + string5 + "]");
                                }
                                if (string5 == null) break block33;
                                if (this._traceLogger.isLogging()) {
                                    this._traceLogger.text(16L, (Object)this, "login", "Alias has username [" + this._aliasContainsUserName + "]");
                                    this._traceLogger.text(16L, (Object)this, "login", "Alias has node name [" + this._aliasContainsNodeName + "]");
                                }
                                string4 = null;
                                if (this._aliasContainsNodeName) {
                                    n = string5.indexOf("/");
                                    if (n != -1) {
                                        string4 = string5.substring(n + 1);
                                        break block31;
                                    } else {
                                        if (this._traceLogger.isLogging()) {
                                            this._traceLogger.text(16L, (Object)this, "login", "Alias does not contain expected \"/\" [" + string5 + "]");
                                        }
                                        AmasMessage amasMessage = new AmasMessage(864296979, string5);
                                        throw new AmasException(amasMessage);
                                    }
                                }
                                string4 = string5;
                            }
                            if (this._traceLogger.isLogging()) {
                                this._traceLogger.text(16L, (Object)this, "login", "Callback partAlias [" + string4 + "]");
                            }
                            if (!this._aliasContainsUserName) break block34;
                            n = string4.lastIndexOf("/");
                            if (n != -1) {
                                string = string4.substring(n + 1);
                                string2 = string4.substring(0, n);
                                if (this._traceLogger.isLogging()) {
                                    this._traceLogger.text(16L, (Object)this, "login", "Resource [" + string2 + "] User [" + string + "]");
                                }
                                break block35;
                            } else {
                                if (this._traceLogger.isLogging()) {
                                    this._traceLogger.text(16L, (Object)this, "login", "Alias does not contain expected \"/\" [" + string4 + "]");
                                }
                                AmasMessage amasMessage = new AmasMessage(864296979, string4);
                                throw new AmasException(amasMessage);
                            }
                        }
                        string2 = string4;
                        string = WSSubject.getCallerPrincipal();
                        if (this._traceLogger.isLogging()) {
                            this._traceLogger.text(16L, (Object)this, "login", "Resource [" + string2 + "] User [" + string + "]");
                        }
                    }
                    GSOHelper gSOHelper = null;
                    gSOHelper = this._cfgURL == null || this._cfgURL.equals("") ? GSOHelper.getInstance() : GSOHelper.getInstance(this._cfgURL);
                    PDSSOCred pDSSOCred = gSOHelper.getAuthData(string2, string);
                    if (pDSSOCred == null) break block32;
                    try {
                        string3 = pDSSOCred.getResourceUser();
                        cArray = pDSSOCred.getResourcePassword();
                    }
                    catch (PDException pDException) {
                        if (this._traceLogger.isLogging()) {
                            this._traceLogger.text(16L, (Object)this, "login", "Got an exception from PD [" + GSOHelper.getFirstExceptionMessage(pDException) + "]");
                            this._traceLogger.text(16L, (Object)this, "login", "ResourceUser [" + string3 + "] resourcePasswd null");
                        }
                        AmasMessage amasMessage = new AmasMessage(916942902, GSOHelper.getFirstExceptionMessage(pDException));
                        throw new AmasException(amasMessage);
                    }
                    ManagedConnectionFactory managedConnectionFactory = ((WSManagedConnectionFactoryCallback)callbackArray[0]).getManagedConnectionFacotry();
                    this._passwordCredential = new PasswordCredential(string3, cArray);
                    this._passwordCredential.setManagedConnectionFactory(managedConnectionFactory);
                    WSCredential wSCredential = ContextManagerFactory.getInstance().getInvocationCredential();
                    String string6 = null;
                    if (wSCredential != null && !wSCredential.isUnauthenticated()) {
                        string6 = wSCredential.getSecurityName();
                    }
                    this._principal = new WSPrincipalImpl(string6);
                    this._succeeded = true;
                    break block32;
                }
                if (this._traceLogger.isLogging()) {
                    this._traceLogger.text(16L, (Object)this, "login", "The alias specified was null");
                }
                if (this._msgLogger.isLogging()) {
                    Object[] objectArray = new Object[]{"alias"};
                    AmasMessage amasMessage = new AmasMessage(916942900, objectArray);
                    this._msgLogger.text(1L, (Object)this, "login", amasMessage.getMessageString());
                }
            }
            catch (UnsupportedCallbackException unsupportedCallbackException) {
                throw new LoginException("Error: " + unsupportedCallbackException.getCallback().toString() + " not available to garner authentication " + "information from the user");
            }
            catch (IOException iOException) {
                AmasMessage amasMessage = new AmasMessage(864296980, iOException.toString());
                if (this._msgLogger.isLogging()) {
                    this._msgLogger.text(1L, (Object)this, "login", amasMessage.getMessageString());
                }
                throw new LoginException(amasMessage.getMessageString());
            }
            catch (WSSecurityException wSSecurityException) {
                AmasMessage amasMessage = new AmasMessage(864296980, wSSecurityException.toString());
                if (this._msgLogger.isLogging()) {
                    this._msgLogger.text(1L, (Object)this, "login", amasMessage.getMessageString());
                }
                throw new LoginException(amasMessage.getMessageString());
            }
            catch (AmasException amasException) {
                if (!this._msgLogger.isLogging()) break block32;
                this._msgLogger.text(4L, (Object)this, "login", amasException.getAmasMessage().getMessageString());
            }
        }
        if (this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)this, "login()");
        }
        return this._succeeded;
    }

    public boolean commit() throws LoginException {
        if (this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)this, "commit()");
        }
        if (this._principal != null) {
            Set<Principal> set = this._subject.getPrincipals();
            if (!set.contains(this._principal)) {
                set.add(this._principal);
            }
            if (!this._subject.getPrivateCredentials().contains(this._passwordCredential)) {
                this._subject.getPrivateCredentials().add(this._passwordCredential);
            }
            this._commitSucceeded = true;
        }
        if (this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)this, "commit()");
        }
        return this._commitSucceeded;
    }

    public boolean abort() throws LoginException {
        if (this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)this, "abort()");
        }
        if (!this._succeeded) {
            return false;
        }
        if (!this._commitSucceeded) {
            this._succeeded = false;
            this._principal = null;
            this._passwordCredential = null;
        } else {
            this.logout();
        }
        if (this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)this, "abort()");
        }
        return this._succeeded;
    }

    public boolean logout() throws LoginException {
        if (this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)this, "logout()");
        }
        Set<Principal> set = this._subject.getPrincipals();
        set.remove(this._principal);
        this._subject.getPrivateCredentials().remove(this._passwordCredential);
        this._principal = null;
        this._passwordCredential = null;
        this._succeeded = false;
        this._commitSucceeded = false;
        if (this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)this, "logout()");
        }
        return true;
    }

    private void initializeLogging(String string) {
        URL uRL = null;
        Properties properties = null;
        try {
            uRL = new URL(string);
            properties = new Properties();
            properties.load(uRL.openStream());
        }
        catch (IOException iOException) {
            System.out.println(iOException.toString());
            System.out.println(AmasMsgHelper.formatSingleParamMessage(916942851, string));
        }
        LogManager logManager = null;
        if (properties != null) {
            SinglePropertyDataStore singlePropertyDataStore = new SinglePropertyDataStore(properties);
            try {
                PDBasicContext pDBasicContext = new PDBasicContext(properties);
            }
            catch (PDException pDException) {
                System.out.println(AmasMsgHelper.formatSingleParamMessage(916942884, pDException.toString()));
            }
            logManager = LogManager.getManager();
            MessageCatalog.setClassLoader((ClassLoader)(class$com$tivoli$pdwas$gso$AMPrincipalMapper == null ? (class$com$tivoli$pdwas$gso$AMPrincipalMapper = AMPrincipalMapper.class$("com.tivoli.pdwas.gso.AMPrincipalMapper")) : class$com$tivoli$pdwas$gso$AMPrincipalMapper).getClassLoader());
            this._traceLogger = logManager.getTraceLogger("AmasCacheTraceLogger");
            this._msgLogger = logManager.getMessageLogger("AmasCacheMessageLogger");
        }
        if (logManager == null) {
            System.out.println(AmasMsgHelper.formatMessage(916942852, null));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

