/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pdwas.migrate;

import com.tivoli.pdwas.nls.PDWASMsgHelper;
import com.tivoli.pdwas.util.CACFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;

class EJBJarHandler
extends ClassLoader {
    private final String EJBJarHandler_java_sourceCodeID = "$Id: @(#)97  1.2 src/pdwas/com/tivoli/pdwas/migrate/EJBJarHandler.java, amemb.jacc.was, amemb600, 051118a 04/07/15 17:54:45 @(#) $";
    String originalFile;
    JarFile beanJarFile;
    File EARDir;
    JarInputStream originalJarFile;
    JarOutputStream updatedJarFile;
    Vector updatedEntries = new Vector();
    private boolean isDir = false;

    public EJBJarHandler(String string) throws CACFException {
        try {
            this.originalFile = string;
            File file = new File(string);
            if (file.isDirectory()) {
                this.isDir = true;
                this.EARDir = new File(string);
            } else {
                this.beanJarFile = new JarFile(string);
                Enumeration<JarEntry> enumeration = this.beanJarFile.entries();
                while (enumeration.hasMoreElements()) {
                    this.updatedEntries.add(enumeration.nextElement().getName());
                }
                this.originalJarFile = new JarInputStream(new FileInputStream(new File(string)));
            }
        }
        catch (IOException iOException) {
            throw new CACFException(PDWASMsgHelper.formatMessage(949559310, null));
        }
    }

    public Vector getClassNames() {
        Vector<String> vector = new Vector<String>();
        Enumeration<JarEntry> enumeration = this.beanJarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            Class<?> clazz = jarEntry.getClass();
            JarEntry jarEntry2 = jarEntry;
            String string = jarEntry2.toString();
            if (!string.endsWith(".class")) continue;
            vector.addElement(new String(string));
        }
        return vector;
    }

    public Vector getClasses() {
        Vector vector = this.getClassNames();
        Enumeration enumeration = vector.elements();
        Vector<Class> vector2 = new Vector<Class>();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Class clazz = this.loadClassFromFile(string);
            vector2.addElement(clazz);
        }
        return vector2;
    }

    public Class loadClassFromFile(String string) {
        byte[] byArray;
        int n;
        int n2 = 0;
        try {
            int n3;
            FileInputStream fileInputStream = new FileInputStream(string);
            n = ((InputStream)fileInputStream).available();
            byArray = new byte[n];
            for (n2 = ((InputStream)fileInputStream).read(byArray); n2 < n; n2 += ((InputStream)fileInputStream).read(byArray, n3, n - n3)) {
                n3 = n2;
            }
            ((InputStream)fileInputStream).close();
        }
        catch (IOException iOException) {
            System.out.println(PDWASMsgHelper.formatSingleParamMessage(949559312, string));
            iOException.printStackTrace();
            return null;
        }
        Class<?> clazz = this.defineClass(null, byArray, 0, n);
        return clazz;
    }

    public InputStream getFileInputStream(String string) throws CACFException {
        InputStream inputStream = null;
        inputStream = this.isDir ? this.getDirectoryInputStream(string) : this.getFileStreamInJar(string);
        return inputStream;
    }

    private InputStream getDirectoryInputStream(String string) throws CACFException {
        FileInputStream fileInputStream = null;
        File file = new File(this.EARDir.getPath() + System.getProperties().getProperty("file.separator") + string);
        if (file.canRead()) {
            try {
                fileInputStream = new FileInputStream(file);
            }
            catch (IOException iOException) {
                throw new CACFException(PDWASMsgHelper.formatMessage(949559313, null));
            }
        }
        return fileInputStream;
    }

    private InputStream getFileStreamInJar(String string) throws CACFException {
        try {
            return this.beanJarFile.getInputStream(this.beanJarFile.getJarEntry(string));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new CACFException(PDWASMsgHelper.formatMessage(949559313, null));
        }
    }

    public boolean isFile(String string) {
        boolean bl = false;
        bl = this.isDir ? this.isFileInDir(string) : this.isFileInJar(string);
        return bl;
    }

    private boolean isFileInDir(String string) {
        boolean bl = false;
        File file = new File(this.EARDir.getPath() + System.getProperties().getProperty("file.separator") + string);
        if (file.canRead()) {
            bl = true;
        }
        return bl;
    }

    private boolean isFileInJar(String string) {
        boolean bl = false;
        JarEntry jarEntry = this.beanJarFile.getJarEntry(string);
        if (jarEntry != null) {
            bl = true;
        }
        return bl;
    }
}

