/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pdwas.migrate;

import com.ibm.websphere.management.exception.RepositoryException;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.tivoli.pdwas.ddparser.ACE;
import com.tivoli.pdwas.ddparser.AnyOtherACE;
import com.tivoli.pdwas.ddparser.DeploymentDescriptorParser;
import com.tivoli.pdwas.ddparser.GroupACE;
import com.tivoli.pdwas.ddparser.PDACL;
import com.tivoli.pdwas.ddparser.PDACLCollection;
import com.tivoli.pdwas.ddparser.UnauthenticatedACE;
import com.tivoli.pdwas.ddparser.UserACE;
import com.tivoli.pdwas.migrate.CmdLine;
import com.tivoli.pdwas.migrate.CmdLineData;
import com.tivoli.pdwas.migrate.EJBJarHandler;
import com.tivoli.pdwas.migrate.MigrateLogFile;
import com.tivoli.pdwas.migrate.PDPopulate;
import com.tivoli.pdwas.nls.PDWASMsgHelper;
import com.tivoli.pdwas.util.CACFException;
import com.tivoli.pdwas.util.Constants;
import com.tivoli.pdwas.util.PDPrintStream;
import com.tivoli.pdwas.util.PDWASConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class Migrate {
    private final String CmdLine_java_sourceCodeID = "$Id: @(#)99 1.19 src/pdwas/com/tivoli/pdwas/migrate/Migrate.java, amemb.jacc.was, amemb600, 051118a 05/10/04 00:38:38 @(#) $";
    private static boolean isWebSphere = false;
    private static DeploymentDescriptorParser xml = null;
    private static PDACLCollection ACLCollection;
    protected static PDWASConfig pdProps;
    private static final String MIGRATE_LOG = ".//pdwas_migrate.log";
    private static final String PROG_MIGRATE_LOG = "pdwas_migrate.log";
    private static MigrateLogFile _logFile;
    private static boolean _jaccCfgMigrate;
    private static boolean _cmdLineParsed;
    public static final String EJB_JAR_XML = "META-INF/weblogic-ejb-jar.xml";
    public static final String OUTPUTDIR = ".";

    protected Migrate() {
    }

    public static boolean JaccCfgMigrate(String[] stringArray, String string) throws IOException {
        _jaccCfgMigrate = true;
        _cmdLineParsed = false;
        try {
            String string2 = null;
            string2 = string != null && string.endsWith(File.separator) ? string + PROG_MIGRATE_LOG : (string != null ? string + File.separator + PROG_MIGRATE_LOG : MIGRATE_LOG);
            _logFile = new MigrateLogFile(string2);
            System.out.println(PDWASMsgHelper.formatSingleParamMessage(949559317, string2));
            Date date = new Date();
            String string3 = DateFormat.getDateTimeInstance().format(date);
            if (stringArray[0] != null && stringArray[0].equalsIgnoreCase("-q") && stringArray[1] != null) {
                _logFile.write(string3 + " : " + stringArray[1]);
            } else {
                _logFile.write(string3);
            }
        }
        catch (IOException iOException) {
            System.out.println(PDWASMsgHelper.formatMessage(949559316, null));
            throw iOException;
        }
        return Migrate.DoMigrate(stringArray);
    }

    public static void main(String[] stringArray) throws IOException {
        Object object;
        CmdLineData cmdLineData = CmdLineData.getInstance();
        if (!_cmdLineParsed) {
            object = new CmdLine(stringArray);
            try {
                if (!((CmdLine)object).parse(cmdLineData)) {
                    System.out.println(PDWASMsgHelper.formatMessage(949559314, null));
                    System.out.println(PDWASMsgHelper.formatMessage(949559346, null));
                    System.exit(1);
                } else {
                    _cmdLineParsed = true;
                }
            }
            catch (CACFException cACFException) {
                System.out.println(cACFException);
                System.out.println(PDWASMsgHelper.formatMessage(949559346, null));
                System.exit(1);
            }
        }
        try {
            object = cmdLineData.getLogFileName();
            if (object == null) {
                object = MIGRATE_LOG;
            }
            _logFile = new MigrateLogFile((String)object);
            System.out.println(PDWASMsgHelper.formatSingleParamMessage(949559317, object));
            Date date = new Date();
            String string = DateFormat.getDateTimeInstance().format(date);
            _logFile.write(string);
        }
        catch (IOException iOException) {
            System.out.println(PDWASMsgHelper.formatMessage(949559316, null));
        }
        if (Migrate.DoMigrate(stringArray)) {
            System.exit(0);
        } else {
            System.exit(1);
        }
    }

    private static boolean DoMigrate(String[] stringArray) throws IOException {
        Object object;
        Object object2;
        Object object3;
        String string = System.getProperty("ws.output.encoding");
        if (string != null) {
            try {
                System.setOut(new PDPrintStream((OutputStream)System.out, true, string));
                System.setErr(new PDPrintStream((OutputStream)System.err, true, string));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
        }
        if ((pdProps = PDWASConfig.getInstance()) != null && (object3 = pdProps.getProperty("com.tivoli.pdwas.DTDDirectory")) == null) {
            object2 = System.getProperty("pdwas.home");
            if (object2 != null) {
                object3 = (String)object2 + File.separator + "etc" + File.separator;
                pdProps.setProperty("com.tivoli.pdwas.DTDDirectory", (String)object3);
            } else {
                object = System.getProperty("was.home");
                object3 = object != null ? object : "..";
                object3 = (String)object3 + File.separatorChar + "deploytool" + File.separatorChar + "itp" + File.separatorChar + "plugins" + File.separatorChar + "com.ibm.wtp.j2ee_1.0.0" + File.separatorChar + "dtds" + File.separatorChar;
                pdProps.setProperty("com.tivoli.pdwas.DTDDirectory", (String)object3);
            }
        }
        object3 = CmdLineData.getInstance();
        if (!_cmdLineParsed) {
            object2 = new CmdLine(stringArray);
            try {
                if (!((CmdLine)object2).parse((CmdLineData)object3)) {
                    _logFile.write(PDWASMsgHelper.formatMessage(949559314, null));
                    System.out.println(PDWASMsgHelper.formatMessage(949559314, null));
                    _logFile.write(PDWASMsgHelper.formatMessage(949559346, null));
                    System.out.println(PDWASMsgHelper.formatMessage(949559346, null));
                    return false;
                }
                _cmdLineParsed = true;
            }
            catch (CACFException cACFException) {
                _logFile.write(cACFException.toString());
                System.out.println(cACFException);
                _logFile.write(PDWASMsgHelper.formatMessage(949559346, null));
                System.out.println(PDWASMsgHelper.formatMessage(949559346, null));
                return false;
            }
        }
        try {
            if (((CmdLineData)object3).getActionGroupName() != null) {
                Constants.J2EE_ACTION_GROUP = "[" + ((CmdLineData)object3).getActionGroupName() + "]";
                Constants.J2EE_PD_ACTION = Constants.J2EE_ACTION_GROUP + "i";
                Constants.DEFAULT_PERMISSIONS = "T" + Constants.J2EE_ACTION_GROUP + "i";
            }
            if (((CmdLineData)object3).getRootObjSpace() != null) {
                Constants.WEB_ACTION_NAME = ((CmdLineData)object3).getRootObjSpace();
                Constants.PD_J2EE_OBJECTSPACE = "/" + Constants.WEB_ACTION_NAME + "/deployedResources/";
            }
            Constants.PD_J2EE_OBJECTSPACE = Constants.PD_J2EE_OBJECTSPACE + ((CmdLineData)object3).getRolePrefix() + "/";
            if (((CmdLineData)object3).getIvadminUserName() == null) {
                _logFile.write(PDWASMsgHelper.formatMessage(949559306, null));
                System.out.print(PDWASMsgHelper.formatMessage(949559306, null));
                object2 = new BufferedReader(new InputStreamReader(System.in));
                ((CmdLineData)object3).setIvadminUserName(((BufferedReader)object2).readLine());
                object2 = null;
                object = ((CmdLineData)object3).getIvadminUserName();
                if (object == null || ((String)object).length() == 0) {
                    _logFile.write(PDWASMsgHelper.formatMessage(949559309, null));
                    System.out.println(PDWASMsgHelper.formatMessage(949559309, null));
                    _logFile.write(PDWASMsgHelper.formatMessage(949559346, null));
                    System.out.println(PDWASMsgHelper.formatMessage(949559346, null));
                    return false;
                }
            }
            if (((CmdLineData)object3).getIvadminPwd() == null) {
                _logFile.write(PDWASMsgHelper.formatMessage(949559307, null));
                System.out.println(PDWASMsgHelper.formatMessage(949559307, null));
                object2 = new BufferedReader(new InputStreamReader(System.in));
                ((CmdLineData)object3).setIvadminPwd(((BufferedReader)object2).readLine());
                object2 = null;
            }
            if ((object2 = ((CmdLineData)object3).getIvadminPwd()) == null) {
                object2 = "";
            }
            object = new char[((String)object2).length()];
            ((String)object2).getChars(0, ((String)object2).length(), (char[])object, 0);
            PDPopulate pDPopulate = new PDPopulate(((CmdLineData)object3).getIvadminUserName(), (char[])object, ((CmdLineData)object3).getWasUserName(), ((CmdLineData)object3).getDnSuffix(), ((CmdLineData)object3).getCfgUrl(), ((CmdLineData)object3).getMtsTimeOut(), ((CmdLineData)object3).getAMDomain(), _logFile);
            String string2 = ((CmdLineData)object3).getEarFileName();
            String string3 = ((CmdLineData)object3).getEntAppName();
            object3 = null;
            System.gc();
            String string4 = null;
            if (string2.endsWith(".xml")) {
                if (_jaccCfgMigrate) {
                    if (!Migrate.parseCfgRep(string2)) {
                        return false;
                    }
                } else {
                    Migrate.parseXML(string2);
                }
                if (string3 == null || string3.equals("")) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, File.separator);
                    while (stringTokenizer.hasMoreTokens()) {
                        if (string2.indexOf("authorizationgroups") != -1) {
                            string4 = string3;
                        }
                        string3 = stringTokenizer.nextToken();
                    }
                    string3 = string3.substring(0, string3.indexOf(OUTPUTDIR));
                }
            } else {
                EJBJarHandler eJBJarHandler = new EJBJarHandler(string2);
                Migrate.parseEAR(eJBJarHandler);
            }
            if (string3 != null) {
                if (string4 != null) {
                    ACLCollection.setApplicationName(string3 + "-" + string4);
                } else {
                    ACLCollection.setApplicationName(string3);
                }
            }
            pDPopulate.prepare();
            pDPopulate.populate(ACLCollection);
            pDPopulate.shutdown();
            pdProps.closeSession();
            _logFile.write(PDWASMsgHelper.formatMessage(949559347, null));
            System.out.println(PDWASMsgHelper.formatMessage(949559347, null));
        }
        catch (CACFException cACFException) {
            _logFile.write(cACFException.toString());
            System.out.println(cACFException);
            _logFile.write(PDWASMsgHelper.formatMessage(949559346, null));
            System.out.println(PDWASMsgHelper.formatMessage(949559346, null));
            return false;
        }
        catch (Exception exception) {
            _logFile.write(PDWASMsgHelper.formatMessage(949559346, null));
            exception.printStackTrace();
            System.out.println(PDWASMsgHelper.formatMessage(949559346, null));
            return false;
        }
        _logFile.close();
        return true;
    }

    private static boolean parseCfgRep(String string) {
        StringBuffer stringBuffer = null;
        InputStream inputStream = null;
        ConfigRepository configRepository = null;
        configRepository = ConfigRepositoryFactory.getConfigRepository();
        stringBuffer = new StringBuffer("ConfigRepository");
        if (configRepository != null) {
            DocumentContentSource documentContentSource = null;
            try {
                documentContentSource = configRepository.extract(string);
            }
            catch (RepositoryException repositoryException) {
                _logFile.write(PDWASMsgHelper.formatDoubleParamMessage(949559348, string, repositoryException.toString()));
                return false;
            }
            stringBuffer = new StringBuffer("DocumentContentSource");
            if (documentContentSource != null) {
                inputStream = documentContentSource.getSource();
                stringBuffer = new StringBuffer("InputStream");
                if (inputStream != null) {
                    try {
                        xml = new DeploymentDescriptorParser(inputStream);
                        ACLCollection = xml.getACLsXML();
                    }
                    catch (Exception exception) {
                        _logFile.write(exception.toString());
                        System.out.println(exception);
                        exception.printStackTrace();
                        return false;
                    }
                    return true;
                }
            }
        }
        _logFile.write(PDWASMsgHelper.formatSingleParamMessage(864636992, stringBuffer.toString()));
        return false;
    }

    private static void parseXML(String string) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            xml = new DeploymentDescriptorParser(fileInputStream);
            ACLCollection = xml.getACLsXML();
        }
        catch (Exception exception) {
            _logFile.write(exception.toString());
            System.out.println(exception);
            exception.printStackTrace();
        }
    }

    private static void parseEAR(EJBJarHandler eJBJarHandler) {
        boolean bl = false;
        InputStream inputStream = null;
        InputStream inputStream2 = null;
        if (eJBJarHandler.isFile("META-INF/ibm-application-bnd.xmi")) {
            try {
                inputStream = eJBJarHandler.getFileInputStream("META-INF/ibm-application-bnd.xmi");
                isWebSphere = true;
            }
            catch (CACFException cACFException) {
                _logFile.write(cACFException.toString());
                System.out.println(cACFException);
                cACFException.printStackTrace();
            }
        } else {
            _logFile.write(PDWASMsgHelper.formatMessage(949559308, null));
            System.out.println(PDWASMsgHelper.formatMessage(949559308, null));
        }
        try {
            inputStream2 = eJBJarHandler.getFileInputStream("META-INF/application.xml");
            xml = new DeploymentDescriptorParser(inputStream2, inputStream);
            ACLCollection = xml.getACLs();
        }
        catch (Exception exception) {
            _logFile.write(exception.toString());
            System.out.println(exception);
            exception.printStackTrace();
        }
    }

    private static void printACLS(PDACLCollection pDACLCollection) {
        Collection collection = pDACLCollection.getACLS();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            PDACL pDACL = (PDACL)iterator.next();
            String string = pDACL.getObjectRef() + pDACLCollection.getObjectRefTale();
            _logFile.write("Object Name [" + string + "]");
            String string2 = new String(string + "_ACL");
            String string3 = string2.replace('/', '_');
            String string4 = string3.replace('.', '_');
            String string5 = "";
            StringTokenizer stringTokenizer = new StringTokenizer(string4, " ");
            while (stringTokenizer.hasMoreTokens()) {
                string5 = string5 + stringTokenizer.nextToken();
                if (!stringTokenizer.hasMoreTokens()) continue;
                string5 = string5 + "_20_";
            }
            Vector vector = pDACL.getACEs();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                ACE aCE = (ACE)enumeration.nextElement();
                if (aCE instanceof UserACE) {
                    _logFile.write("UserACE -");
                } else if (aCE instanceof GroupACE) {
                    _logFile.write("GroupACE -");
                } else if (aCE instanceof UnauthenticatedACE) {
                    _logFile.write("UnauthACE -");
                } else if (aCE instanceof AnyOtherACE) {
                    _logFile.write("AnyOtherACE -");
                }
                _logFile.write("Element [" + aCE.getName() + "]");
            }
        }
    }

    static {
        _jaccCfgMigrate = false;
        _cmdLineParsed = false;
    }
}

