/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pdwas.migrate;

import com.tivoli.pd.jutil.PDContext;
import com.tivoli.pd.jutil.PDException;
import java.net.URL;
import java.util.Random;

public class PDAdminSession {
    private final String PDAdminSession_java_sourceCodeID = "$Id: @(#)02  1.3 src/pdwas/com/tivoli/pdwas/migrate/PDAdminSession.java, amemb.jacc.was, amemb600, 051118a 04/09/09 19:08:39 @(#) $";
    private PDContext _ctx;
    private String _adminName;
    private char[] _adminPasswd;
    private byte[] _reserved;
    private URL _cfgUrl;
    private String _amDomain;
    private long _sessTimeOut;
    private long _sessStart;

    public PDAdminSession(String string, char[] cArray, URL uRL, String string2, long l) throws PDException {
        this._sessTimeOut = l;
        this._adminName = string;
        this._cfgUrl = uRL;
        this._amDomain = string2;
        this.generateMask(cArray.length);
        this._adminPasswd = PDAdminSession.passwordMaskOp(cArray, this._reserved);
        this._ctx = new PDContext(string, cArray, string2, uRL);
        this._sessStart = System.currentTimeMillis();
    }

    public PDContext getCtx() throws PDException {
        PDContext pDContext = null;
        long l = System.currentTimeMillis();
        if (l - this._sessStart > this._sessTimeOut * 1000L / 2L) {
            // empty if block
        }
        pDContext = this._ctx;
        return pDContext;
    }

    public void closeCtx() throws PDException {
        if (this._ctx != null) {
            this._ctx.close();
        }
    }

    protected void refreshCtx() throws PDException {
        char[] cArray = PDAdminSession.passwordMaskOp(this._adminPasswd, this._reserved);
        this._ctx = new PDContext(this._adminName, this._adminPasswd, this._amDomain, this._cfgUrl);
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = '\u0000';
        }
    }

    protected static char[] passwordMaskOp(char[] cArray, byte[] byArray) {
        char[] cArray2 = new char[cArray.length];
        for (int i = 0; i < cArray.length; ++i) {
            cArray2[i] = (char)(cArray[i] ^ byArray[i]);
        }
        return cArray2;
    }

    protected void generateMask(int n) {
        long l = System.currentTimeMillis();
        Random random = new Random(l);
        this._reserved = new byte[n];
        random.nextBytes(this._reserved);
    }
}

