/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pdwas.migrate;

import com.tivoli.pd.jutil.PDException;
import com.tivoli.pd.jutil.PDMessage;
import com.tivoli.pd.jutil.PDMessages;
import com.tivoli.pdwas.ddparser.ACE;
import com.tivoli.pdwas.ddparser.AnyOtherACE;
import com.tivoli.pdwas.ddparser.GroupACE;
import com.tivoli.pdwas.ddparser.PDACL;
import com.tivoli.pdwas.ddparser.PDACLCollection;
import com.tivoli.pdwas.ddparser.UnauthenticatedACE;
import com.tivoli.pdwas.ddparser.UserACE;
import com.tivoli.pdwas.migrate.MigrateLogFile;
import com.tivoli.pdwas.migrate.PDAdminAdapter;
import com.tivoli.pdwas.migrate.PDAdminSession;
import com.tivoli.pdwas.nls.PDWASMsgHelper;
import com.tivoli.pdwas.util.CACFException;
import com.tivoli.pdwas.util.Constants;
import com.tivoli.pdwas.util.Misc;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

class PDPopulate {
    private final String PDPopulate_java_sourceCodeID = "$Id: @(#)03  1.8 src/pdwas/com/tivoli/pdwas/migrate/PDPopulate.java, amemb.jacc.was, amemb600, 060111a 06/01/02 18:51:01 @(#) $";
    private PDAdminSession _adminSess;
    private PDAdminAdapter _adminAdapter;
    private String _cfgUrl;
    private String _adminUser;
    private String _wasAdminUser;
    private String _wasAdminUserDN;
    private char[] _wasAdminPasswd;
    private String _dnSuffix;
    private MigrateLogFile _logFile;
    private static final String PROG_NAME = "PDWASMigrationTool";
    private static final String WAS_ADMIN_OBJ = "/deployedResources/AdminRole/admin";
    private static final String WAS_ADMIN_ACL = "_deployedResources_AdminRole_admin";
    private static final String PDWAS_ADMIN_GROUP = "pdwas-admin";
    public static final String APPLICATION_XML = "META-INF/application.xml";
    public static final String APPLICATION_XMI = "META-INF/ibm-application-bnd.xmi";

    public PDPopulate(String string, char[] cArray, String string2, String string3, String string4, long l, String string5, MigrateLogFile migrateLogFile) throws NullPointerException, IllegalArgumentException, CACFException {
        this._logFile = migrateLogFile;
        if (string == null || string2 == null || string3 == null) {
            throw new NullPointerException("Provided null name");
        }
        if (string.length() == 0 || string2.length() == 0 || string3.length() == 0) {
            throw new IllegalStateException("Provided empty name");
        }
        this._adminUser = string;
        this._dnSuffix = string3;
        this._cfgUrl = string4;
        String string6 = Misc.getRandomPassword();
        int n = string6.length();
        this._wasAdminPasswd = new char[n];
        string6.getChars(0, n - 1, this._wasAdminPasswd, 0);
        this.initPDAdmin(this._adminUser, cArray, this._cfgUrl, string5, l);
        boolean bl = false;
        try {
            bl = this.isLDAPReg();
        }
        catch (PDException pDException) {
            PDMessages pDMessages = pDException.getMessages();
            if (pDMessages != null && pDMessages.size() > 0) {
                throw new CACFException(this.getFirstExceptionMessage(pDException));
            }
            throw new CACFException(pDException.getCause().toString());
        }
        if (bl) {
            this.setWasAdminNamesLDAP(string2, string3);
        } else {
            this.setWasAdminNamesDomino(string2, string3);
        }
    }

    private boolean isLDAPReg() throws PDException {
        boolean bl = false;
        int n = 0;
        n = this._adminAdapter.getRegistryType(new PDMessages());
        if (n == 1 || n == 2 || n == 4) {
            bl = true;
        }
        return bl;
    }

    private void setWasAdminNamesLDAP(String string, String string2) {
        String string3 = "=";
        String string4 = ",";
        if (string.indexOf(string3) != -1) {
            this._wasAdminUserDN = string;
            try {
                this._wasAdminUser = this._adminAdapter.getUserIdFromDN(this._wasAdminUserDN, new PDMessages());
            }
            catch (PDException pDException) {
                this._wasAdminUser = null;
            }
            if (this._wasAdminUser == null) {
                int n = string.indexOf(string3);
                int n2 = string.indexOf(string4);
                this._wasAdminUser = string.substring(n + 1, n2);
            }
        } else {
            this._wasAdminUser = string;
            this._wasAdminUserDN = "cn=" + string + string4 + string2;
        }
    }

    private void setWasAdminNamesDomino(String string, String string2) {
        String string3 = "/";
        String string4 = "=";
        String string5 = ",";
        if (string.indexOf(string3) == -1) {
            if (string.indexOf(string4) == -1) {
                this._wasAdminUser = string;
                this._wasAdminUserDN = "cn=" + string + string5 + string2;
            } else {
                this._wasAdminUserDN = string;
                try {
                    this._wasAdminUser = this._adminAdapter.getUserIdFromDN(this._wasAdminUserDN, new PDMessages());
                }
                catch (PDException pDException) {
                    this._wasAdminUser = null;
                }
                if (this._wasAdminUser == null) {
                    int n = string.indexOf(string4);
                    int n2 = string.indexOf(string5);
                    this._wasAdminUser = string.substring(n + 1, n2);
                }
            }
        } else {
            this._wasAdminUserDN = string;
            try {
                this._wasAdminUser = this._adminAdapter.getUserIdFromDN(this._wasAdminUserDN, new PDMessages());
            }
            catch (PDException pDException) {
                this._wasAdminUser = null;
            }
            if (this._wasAdminUser == null) {
                int n = string.indexOf(string3);
                this._wasAdminUser = string.substring(0, n);
            }
        }
    }

    private void initPDAdmin(String string, char[] cArray, String string2, String string3, long l) throws CACFException {
        try {
            PDMessages pDMessages = new PDMessages();
            PDAdminAdapter.initialize(PROG_NAME, pDMessages);
            URL uRL = new URL(string2);
            this._adminSess = new PDAdminSession(string, cArray, uRL, string3, l);
            this._adminAdapter = new PDAdminAdapter(this._adminSess);
        }
        catch (PDException pDException) {
            throw new CACFException(this.getFirstExceptionMessage(pDException));
        }
        catch (MalformedURLException malformedURLException) {
            throw new CACFException(malformedURLException.toString());
        }
        catch (Exception exception) {
            throw new CACFException(exception.toString());
        }
    }

    private void shutdownPDAdmin() {
        try {
            PDMessages pDMessages = new PDMessages();
            PDAdminAdapter.shutdown(pDMessages);
        }
        catch (PDException pDException) {
            this.printExceptionMessages(pDException);
        }
    }

    public void prepare() throws CACFException {
        PDMessages pDMessages = new PDMessages();
        try {
            this._adminAdapter.createActionAndGroup(Constants.WEB_ACTION_NAME, "i", "i", "i", pDMessages);
            this._logFile.write(PDWASMsgHelper.formatSingleParamMessage(949559318, Constants.PD_J2EE_OBJECTSPACE));
            this._adminAdapter.createObjectSpace(Constants.PD_J2EE_OBJECTSPACE, pDMessages);
            ArrayList arrayList = this._adminAdapter.getGroupMembers(PDWAS_ADMIN_GROUP, this._dnSuffix, pDMessages);
            if (arrayList != null) {
                Iterator iterator = arrayList.iterator();
                String string = "";
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    if (string.length() >= 1) {
                        string = string + ", ";
                    }
                    string = string + string2;
                }
                this._logFile.write(PDWASMsgHelper.formatDoubleParamMessage(949559321, PDWAS_ADMIN_GROUP, string));
                System.out.println(PDWASMsgHelper.formatDoubleParamMessage(949559321, PDWAS_ADMIN_GROUP, string));
            } else {
                this._logFile.write(PDWASMsgHelper.formatSingleParamMessage(949559320, PDWAS_ADMIN_GROUP));
                this._adminAdapter.createGroup(PDWAS_ADMIN_GROUP, this._dnSuffix, pDMessages);
            }
            this._logFile.write(PDWASMsgHelper.formatDoubleParamMessage(949559319, this._wasAdminUser, PDWAS_ADMIN_GROUP));
            this._adminAdapter.createUser(this._wasAdminUser, this._wasAdminUserDN, this._wasAdminUser, this._wasAdminUser, PDWAS_ADMIN_GROUP, this._wasAdminPasswd, pDMessages);
        }
        catch (PDException pDException) {
            throw new CACFException(this.getFirstExceptionMessage(pDException));
        }
        catch (Exception exception) {
            throw new CACFException(exception.toString());
        }
    }

    public void populate(PDACLCollection pDACLCollection) throws CACFException {
        Collection collection = pDACLCollection.getACLS();
        Iterator iterator = collection.iterator();
        PDMessages pDMessages = new PDMessages();
        while (iterator.hasNext()) {
            Object object;
            PDACL pDACL = (PDACL)iterator.next();
            String string = pDACL.getObjectRef() + pDACLCollection.getObjectRefTale();
            String string2 = new String(string + "_ACL");
            String string3 = string2.replace('/', '_');
            String string4 = string3.replace('.', '_');
            String string5 = "";
            StringTokenizer stringTokenizer = new StringTokenizer(string4, " ");
            while (stringTokenizer.hasMoreTokens()) {
                string5 = string5 + stringTokenizer.nextToken();
                if (!stringTokenizer.hasMoreTokens()) continue;
                string5 = string5 + "_20_";
            }
            try {
                this._logFile.write(PDWASMsgHelper.formatSingleParamMessage(949559322, string));
                this._adminAdapter.deleteObject(string, pDMessages);
                this._logFile.write(PDWASMsgHelper.formatSingleParamMessage(949559323, string5));
                this._adminAdapter.deleteAcl(string5, pDMessages);
                this._logFile.write(PDWASMsgHelper.formatSingleParamMessage(949559324, string));
                this._adminAdapter.createObject(string, pDMessages);
                this._logFile.write(PDWASMsgHelper.formatSingleParamMessage(949559325, string5));
                this._adminAdapter.createAcl(string5, pDMessages);
                this._logFile.write(PDWASMsgHelper.formatDoubleParamMessage(949559326, string5, string));
                this._adminAdapter.attachAcl(string5, string, pDMessages);
                Vector vector = pDACL.getACEs();
                object = vector.elements();
                while (object.hasMoreElements()) {
                    Object object2;
                    try {
                        Object object3;
                        Object object4;
                        ACE aCE = (ACE)object.nextElement();
                        if (aCE instanceof UserACE) {
                            object2 = aCE.getName();
                            if (((String)object2).indexOf(",") > 0) {
                                object4 = new StringTokenizer((String)object2, ", \t");
                                object3 = new StringTokenizer(this._dnSuffix, ", \t");
                                if (((StringTokenizer)object4).countTokens() > ((StringTokenizer)object3).countTokens()) {
                                    int n;
                                    boolean bl = true;
                                    String[] stringArray = new String[((StringTokenizer)object4).countTokens()];
                                    for (int i = 0; i < stringArray.length; ++i) {
                                        stringArray[i] = ((StringTokenizer)object4).nextToken();
                                    }
                                    String[] stringArray2 = new String[((StringTokenizer)object3).countTokens()];
                                    for (n = 0; n < stringArray2.length; ++n) {
                                        stringArray2[n] = ((StringTokenizer)object3).nextToken();
                                    }
                                    n = stringArray.length - stringArray2.length;
                                    for (int i = 0; i < stringArray2.length && bl; ++i) {
                                        bl = stringArray[i + n].equalsIgnoreCase(stringArray2[i]);
                                    }
                                    if (bl) {
                                        String string6 = this._adminAdapter.getUserIdFromDN((String)object2, pDMessages);
                                        object2 = string6;
                                    }
                                }
                            }
                            this._logFile.write(PDWASMsgHelper.formatTripleParamMessage(949559327, string5, aCE.getPermission(), aCE.getName()));
                            this._adminAdapter.modifyAclUser(string5, (String)object2, aCE.getPermission(), pDMessages);
                            continue;
                        }
                        if (aCE instanceof GroupACE) {
                            object2 = aCE.getName();
                            object4 = ((String)object2).substring(0, 3);
                            this._logFile.write("aceElement is a GroupACE; name = " + (String)object2);
                            if (((String)object4).equalsIgnoreCase("cn=")) {
                                this._logFile.write("Calling _adminAdapter.getGroupIdFromDN()");
                                object3 = this._adminAdapter.getGroupIdFromDN((String)object2, pDMessages);
                                this._logFile.write("_adminAdapter.getGroupIdfromDN() returned " + (String)object3);
                                object2 = object3;
                            }
                            this._logFile.write(PDWASMsgHelper.formatTripleParamMessage(949559327, string5, aCE.getPermission(), object2));
                            this._logFile.write("Calling _adminAdapter.modifyAclGroup(); aclName = " + string5 + ", name = " + (String)object2 + ", aceElement.getPermission() = " + aCE.getPermission());
                            this._adminAdapter.modifyAclGroup(string5, (String)object2, aCE.getPermission(), pDMessages);
                            continue;
                        }
                        if (aCE instanceof UnauthenticatedACE) {
                            this._logFile.write(PDWASMsgHelper.formatTripleParamMessage(949559327, string5, aCE.getPermission(), "unauthenticated"));
                            this._adminAdapter.modifyAclUnAuth(string5, aCE.getPermission(), pDMessages);
                            this._logFile.write(PDWASMsgHelper.formatTripleParamMessage(949559327, string5, aCE.getPermission(), "anyother"));
                            this._adminAdapter.modifyAclAnyOther(string5, aCE.getPermission(), pDMessages);
                            continue;
                        }
                        if (!(aCE instanceof AnyOtherACE)) continue;
                        this._logFile.write(PDWASMsgHelper.formatTripleParamMessage(949559327, string5, aCE.getPermission(), "anyother"));
                        this._adminAdapter.modifyAclAnyOther(string5, aCE.getPermission(), pDMessages);
                    }
                    catch (PDException pDException) {
                        object2 = pDException.getMessages();
                        if (object2 != null && object2.size() > 0) {
                            this.printExceptionMessages(pDException);
                            continue;
                        }
                        this._logFile.write(pDException.getCause().toString());
                        System.out.println(pDException.getCause().toString());
                        pDException.getCause().printStackTrace();
                    }
                }
            }
            catch (PDException pDException) {
                object = pDException.getMessages();
                if (object != null && object.size() > 0) {
                    this.printExceptionMessages(pDException);
                    break;
                }
                this._logFile.write(pDException.getCause().toString());
                System.out.println(pDException.getCause().toString());
                pDException.getCause().printStackTrace();
                break;
            }
        }
    }

    private void printExceptionMessages(PDException pDException) {
        if (pDException != null) {
            PDMessages pDMessages = pDException.getMessages();
            this.printMessages(pDMessages);
        }
    }

    private String getFirstExceptionMessage(PDException pDException) {
        String string = null;
        if (pDException != null) {
            PDMessages pDMessages = pDException.getMessages();
            if (pDMessages != null && pDMessages.size() > 0) {
                PDMessage pDMessage = (PDMessage)pDMessages.get(0);
                string = pDMessage.getMsgText();
            } else {
                PDException pDException2 = (PDException)pDException.getCause();
                string = this.getFirstExceptionMessage(pDException2);
            }
        }
        return string;
    }

    private void printMessages(PDMessages pDMessages) {
        if (pDMessages != null) {
            Iterator iterator = pDMessages.iterator();
            while (iterator.hasNext()) {
                PDMessage pDMessage = (PDMessage)iterator.next();
                this._logFile.write(pDMessage.getMsgText());
                System.out.println(pDMessage.getMsgText());
            }
        }
    }

    public void shutdown() throws CACFException {
        this.shutdownPDAdmin();
        try {
            if (this._adminSess != null) {
                this._adminSess.closeCtx();
            }
        }
        catch (PDException pDException) {
            throw new CACFException(pDException.toString());
        }
    }
}

