/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pdwas.nls;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class PDWASMsgHelper {
    private final String PDWASMsgHelper_java_sourceCodeID = "$Id: @(#)06  1.2 src/pdwas/com/tivoli/pdwas/nls/PDWASMsgHelper.java, amemb.jacc.was, amemb600, 051118a 04/07/15 17:54:49 @(#) $";
    private static final String RAD40ALPHABET = "abcdefghijklmnopqrstuvwxyz_0123456789-+@";
    private static final int TECH_MASK = -268435456;
    private static final int TECH_MASK_DCE = 0x10000000;
    private static final int TECH_MASK_PD = 0x30000000;
    private static final int COMP_SHIFT = 12;
    private static final int COMP_MASK = 0xFFFF000;
    private static final String cls = "com.tivoli.pdwas.nls.PDWasMsgHelper";
    private static final char SINGLE_QUOTE = '\'';
    private static final char CURLY_BRACE_LEFT = '{';
    private static final char CURLY_BRACE_RIGHT = '}';
    private static final int STATE_INITIAL = 0;
    private static final int STATE_SINGLE_QUOTE = 1;
    private static final int STATE_LITHERAL_BRACE = 2;
    private static final int STATE_MSG_ELEMENT = 3;

    public static String formatSingleParamMessage(int n, Object object) {
        Object[] objectArray = new Object[]{object};
        return PDWASMsgHelper.formatMessage(n, objectArray);
    }

    public static String formatDoubleParamMessage(int n, Object object, Object object2) {
        Object[] objectArray = new Object[]{object, object2};
        return PDWASMsgHelper.formatMessage(n, objectArray);
    }

    public static String formatTripleParamMessage(int n, Object object, Object object2, Object object3) {
        Object[] objectArray = new Object[]{object, object2, object3};
        return PDWASMsgHelper.formatMessage(n, objectArray);
    }

    public static String formatMessage(int n, Object[] objectArray) {
        String string = null;
        String string2 = PDWASMsgHelper.getResourceBundle(n).getString(Integer.toString(n, 16));
        string = objectArray != null && objectArray.length > 0 ? MessageFormat.format(PDWASMsgHelper.fixPattern(string2), objectArray) : string2;
        return string;
    }

    private static ResourceBundle getResourceBundle(int n) {
        ResourceBundle resourceBundle = null;
        resourceBundle = ResourceBundle.getBundle(PDWASMsgHelper.nameFromCode(n), Locale.getDefault());
        return resourceBundle;
    }

    private static String fixPattern(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            block0 : switch (n) {
                case 0: {
                    switch (c) {
                        case '\'': {
                            n = 1;
                            break;
                        }
                        case '{': {
                            n = 3;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (c) {
                        case '\'': {
                            n = 0;
                            break block0;
                        }
                        case '{': 
                        case '}': {
                            n = 2;
                            break block0;
                        }
                    }
                    stringBuffer.append('\'');
                    n = 0;
                    break;
                }
                case 2: {
                    switch (c) {
                        case '\'': {
                            n = 0;
                        }
                    }
                    break;
                }
                case 3: {
                    switch (c) {
                        case '}': {
                            n = 0;
                        }
                    }
                    break;
                }
            }
            stringBuffer.append(c);
        }
        if (n == 1) {
            stringBuffer.append('\'');
        }
        return new String(stringBuffer);
    }

    private static String nameFromCode(int n) throws MissingResourceException {
        StringBuffer stringBuffer = new StringBuffer(10);
        char[] cArray = new char[3];
        switch (n & 0xF0000000) {
            case 0x30000000: {
                stringBuffer.append("pd");
                break;
            }
            case 0x10000000: {
                stringBuffer.append("pdb");
                break;
            }
            default: {
                throw new MissingResourceException(PDWASMsgHelper.formatMessage(949559343, null), cls, Integer.toHexString(n));
            }
        }
        stringBuffer.append(PDWASMsgHelper.componentFromCode(n));
        stringBuffer.append("res");
        return stringBuffer.toString();
    }

    private static char[] componentFromCode(int n) {
        char[] cArray = new char[3];
        n = (n & 0xFFFF000) >> 12;
        cArray[2] = RAD40ALPHABET.charAt(n % 40);
        cArray[1] = RAD40ALPHABET.charAt((n /= 40) % 40);
        cArray[0] = RAD40ALPHABET.charAt(n / 40);
        return cArray;
    }
}

