/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pdwas.util.command;

import com.tivoli.pd.as.nls.AmasMsgHelper;
import com.tivoli.pdwas.util.command.CommandAction;
import com.tivoli.pdwas.util.command.CommandOption;
import com.tivoli.pdwas.util.command.CommandParsingException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public abstract class Command {
    private final String Command_java_sourceCodeID = "$Id: @(#)29  1.2 src/pdwas/com/tivoli/pdwas/util/command/Command.java, amemb.jacc.was, amemb600, 051118a 04/07/15 17:54:57 @(#) $";
    public static final String sCopyright = "IBM Confidential\nObject Code Only Source Materials\n5747-SM3\n(c) Copyright International Business Machines Corp. 1994-2002.  All Rights Reserved.\nThe source code for this program is not published or otherwise divested\nof its trade secrets, irrespective of what has been deposited with the\nU.S. Copyright Office.\n";
    private final int _OPTION_PAD_LENGTH = 17;
    private String _name;
    private String _description;

    public Command(String string, String string2) {
        this._name = string;
        this._description = string2;
    }

    public void run(String[] stringArray) throws CommandParsingException {
        Object object;
        if (stringArray.length == 0) {
            throw new CommandParsingException(this.getUsage());
        }
        if (stringArray.length == 1) {
            if (stringArray[0].equals("-help")) {
                throw new CommandParsingException(this._description + "\n" + this.getUsage());
            }
            if (stringArray[0].equals("-action")) {
                throw new CommandParsingException(this.getUsage());
            }
            throw new CommandParsingException(this.getUsage());
        }
        if (stringArray.length >= 2) {
            if (stringArray[0].equals("-help")) {
                if (stringArray.length > 2) {
                    throw new CommandParsingException(this.getUsage());
                }
                List<CommandAction> list = Arrays.asList(this.getActions());
                Iterator<CommandAction> iterator = list.iterator();
                while (iterator.hasNext()) {
                    CommandAction commandAction = iterator.next();
                    if (!commandAction.getName().equals(stringArray[1])) continue;
                    String string = AmasMsgHelper.formatMessage(819257345, null) + commandAction.getDescription() + "\n" + AmasMsgHelper.formatMessage(819257346, null) + "\n" + this._name + " -action " + commandAction.getName() + " " + commandAction.getOptionsDescriptor();
                    CommandOption[] commandOptionArray = commandAction.getOptions();
                    if (commandOptionArray.length > 0) {
                        string = string + "\n";
                    }
                    for (int i = 0; i < commandOptionArray.length; ++i) {
                        string = string + "\n" + this.ident(this.pad(commandOptionArray[i].getName() + ": "), 3) + this.lineReturn(19, 59, commandOptionArray[i].getDescription());
                    }
                    throw new CommandParsingException(string);
                }
                throw new CommandParsingException(AmasMsgHelper.formatSingleParamMessage(819257347, stringArray[1]) + "\n" + this.getUsage());
            }
            if (stringArray[0].equals("-action")) {
                object = Arrays.asList(this.getActions());
                List<String> list = Arrays.asList(stringArray);
                Iterator iterator = object.iterator();
                boolean bl = false;
                while (iterator.hasNext()) {
                    CommandAction commandAction = (CommandAction)iterator.next();
                    if (!commandAction.getName().equals(stringArray[1])) continue;
                    bl = true;
                    commandAction.run(list.subList(2, list.size()));
                }
                if (!bl) {
                    throw new CommandParsingException(AmasMsgHelper.formatSingleParamMessage(819257353, stringArray[1]) + "\n" + this.getUsage());
                }
            } else {
                throw new CommandParsingException(this.getUsage());
            }
        }
        object = this.getActions();
    }

    public String getUsage() {
        String string = AmasMsgHelper.formatMessage(819257346, null) + "\n" + this._name + " -help [<action>] ";
        CommandAction[] commandActionArray = this.getActions();
        for (int i = 0; i < commandActionArray.length; ++i) {
            string = string + "\n" + this._name + " -action " + commandActionArray[i].getName() + " [" + AmasMsgHelper.formatMessage(819257349, null) + " ..]";
        }
        return string;
    }

    public String getName() {
        return this._name;
    }

    private String pad(String string) {
        for (int i = string.length(); i < 17; ++i) {
            string = string + " ";
        }
        return string;
    }

    private String lineReturn(int n, int n2, String string) {
        if (string.length() <= n2) {
            return string;
        }
        String string2 = "";
        int n3 = string.length() / n2 + 1;
        String string3 = string;
        for (int i = 0; i < n3; ++i) {
            String string4;
            if (string3.length() <= n2) {
                string4 = string3;
            } else if (string3.charAt(n2 - 1) == ' ') {
                string4 = string3.substring(0, n2 - 1);
                string3 = string3.substring(n2 - 1, string3.length());
            } else {
                char c;
                int n4 = n2;
                while ((c = string3.charAt(--n4)) != ' ') {
                }
                string4 = string3.substring(0, n4);
                string3 = string3.substring(n4, string3.length());
            }
            if (i != 0) {
                string4 = this.ident(string4, n);
            }
            string2 = string2 + string4;
            if (i == n3 - 1) continue;
            string2 = string2 + "\n";
        }
        return string2;
    }

    private String ident(String string, int n) {
        for (int i = 0; i < n; ++i) {
            string = " " + string;
        }
        return string;
    }

    public abstract CommandAction[] getActions();
}

