/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pdwas.websphere;

import com.ibm.websphere.security.AuthorizationTable;
import com.ibm.websphere.security.SecurityProviderException;
import com.ibm.websphere.security.WASPrincipal;
import com.tivoli.pd.as.rbpf.AmasSession;
import com.tivoli.pd.as.rbpf.RtManager;
import com.tivoli.pd.as.util.AmasException;
import com.tivoli.pd.jras.pdjlog.jlog.ILogger;
import com.tivoli.pdwas.nls.PDWASMsgHelper;
import com.tivoli.pdwas.util.PDWASConfig;
import com.tivoli.pdwas.util.ParameterIsNullException;
import com.tivoli.pdwas.websphere.AuthzAccessContext;
import com.tivoli.pdwas.websphere.PrincipalHelper;
import java.security.Principal;
import java.util.HashMap;

public class PDWASAuthzManager
implements AuthorizationTable {
    private final String PDWASAuthzManager_java_sourceCodeID = "$Id: @(#)37  1.2 src/pdwas/com/tivoli/pdwas/websphere/PDWASAuthzManager.java, amemb.jacc.was, amemb600, 051118a 04/07/15 17:55:02 @(#) $";
    public static final String sCopyright = "IBM Confidential\nObject Code Only Source Materials\n5747-SM3\n(c) Copyright International Business Machines Corp. 1994-2002.  All Rights Reserved.\nThe source code for this program is not published or otherwise divested\nof its trade secrets, irrespective of what has been deposited with the\nU.S. Copyright Office.\n";
    protected ILogger _trcLogger;
    protected ILogger _msgLogger;
    protected AmasSession _amasSession;
    protected RtManager _rtMgr;
    private static final String CLASSNAME = "com.tivoli.pdwas.websphere.PDWASAuthzManager";
    protected static final WASPrincipal WASPRINCIPALUNAUTHENTICATED = new WASPrincipal(null, null, null);
    private boolean _initRun = false;
    static /* synthetic */ Class class$com$tivoli$pdwas$websphere$AuthzAccessContext;
    static /* synthetic */ Class class$com$tivoli$pdwas$websphere$AuthzAccessContextHandler;

    public PDWASAuthzManager() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        PDWASAuthzManager pDWASAuthzManager = this;
        synchronized (pDWASAuthzManager) {
            if (!this._initRun) {
                PDWASConfig pDWASConfig = PDWASConfig.getInstance();
                this._amasSession = pDWASConfig.getAmasSession();
                this._trcLogger = this._amasSession.getLogManager().getTraceLogger("AMWASWebTraceLogger");
                this._msgLogger = this._amasSession.getLogManager().getMessageLogger("AMWASWebMessageLogger");
                this._rtMgr = this._amasSession.getRtManager();
                this._amasSession.registerResourceHandlerClass(class$com$tivoli$pdwas$websphere$AuthzAccessContext == null ? (class$com$tivoli$pdwas$websphere$AuthzAccessContext = PDWASAuthzManager.class$("com.tivoli.pdwas.websphere.AuthzAccessContext")) : class$com$tivoli$pdwas$websphere$AuthzAccessContext, class$com$tivoli$pdwas$websphere$AuthzAccessContextHandler == null ? (class$com$tivoli$pdwas$websphere$AuthzAccessContextHandler = PDWASAuthzManager.class$("com.tivoli.pdwas.websphere.AuthzAccessContextHandler")) : class$com$tivoli$pdwas$websphere$AuthzAccessContextHandler);
                this._initRun = true;
            }
        }
    }

    public boolean isEveryoneGranted(HashMap hashMap, String[] stringArray) throws SecurityProviderException {
        boolean bl = false;
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "isEveryoneGranted(HashMap, String[])");
        }
        try {
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "isEveryoneGranted", "Permission check");
            }
            WASPrincipal wASPrincipal = WASPRINCIPALUNAUTHENTICATED;
            bl = this.isGrantedAnyRole(hashMap, stringArray, wASPrincipal);
        }
        catch (SecurityProviderException securityProviderException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                this._msgLogger.text(2L, (Object)CLASSNAME, "isEveryoneGranted", PDWASMsgHelper.formatSingleParamMessage(949559302, "SecurityProviderException"));
                this._msgLogger.text(2L, (Object)CLASSNAME, "isEveryoneGranted", PDWASMsgHelper.formatSingleParamMessage(949559303, "SecurityProviderException"));
            }
            throw securityProviderException;
        }
        catch (Exception exception) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                this._msgLogger.text(2L, (Object)CLASSNAME, "isEveryoneGranted", PDWASMsgHelper.formatSingleParamMessage(949559302, exception.toString()));
                this._msgLogger.text(2L, (Object)CLASSNAME, "isEveryoneGranted", PDWASMsgHelper.formatSingleParamMessage(949559303, "SecurityProviderException"));
            }
            throw new SecurityProviderException(exception.toString(), exception);
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.text(16L, (Object)CLASSNAME, "isEveryoneGranted", "Return value [" + bl + "]");
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "isEveryoneGranted(HashMap, String[])");
        }
        return bl;
    }

    public boolean isGrantedRole(HashMap hashMap, String string, Principal principal) throws SecurityProviderException {
        boolean bl = false;
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "isGrantedRole(HashMap, String, Principal)");
        }
        try {
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "isGrantedRole", "Check security role is not null");
            }
            String[] stringArray = new String[1];
            if (string == null) {
                if (this._msgLogger != null && this._msgLogger.isLogging()) {
                    this._msgLogger.text(2L, (Object)CLASSNAME, "isGrantedRole", PDWASMsgHelper.formatMessage(949559301, null));
                    this._msgLogger.text(2L, (Object)CLASSNAME, "isGrantedRole", PDWASMsgHelper.formatSingleParamMessage(949559303, "ParameterIsNullException"));
                }
                throw new ParameterIsNullException(PDWASMsgHelper.formatMessage(949559301, null));
            }
            stringArray[0] = string;
            bl = this.isGrantedAnyRole(hashMap, stringArray, principal);
        }
        catch (SecurityProviderException securityProviderException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                this._msgLogger.text(2L, (Object)CLASSNAME, "isGrantedRole", PDWASMsgHelper.formatSingleParamMessage(949559302, "SecurityProviderException"));
                this._msgLogger.text(2L, (Object)CLASSNAME, "isGrantedRole", PDWASMsgHelper.formatSingleParamMessage(949559303, "SecurityProviderException"));
            }
            throw securityProviderException;
        }
        catch (ParameterIsNullException parameterIsNullException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                this._msgLogger.text(2L, (Object)CLASSNAME, "isGrantedRole", PDWASMsgHelper.formatSingleParamMessage(949559302, "ParameterIsNullException"));
                this._msgLogger.text(2L, (Object)CLASSNAME, "isGrantedRole", PDWASMsgHelper.formatSingleParamMessage(949559303, "SecurityProviderException"));
            }
            throw new SecurityProviderException("ParameterIsNullException", parameterIsNullException);
        }
        catch (Exception exception) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                this._msgLogger.text(2L, (Object)CLASSNAME, "isGrantedRole", PDWASMsgHelper.formatSingleParamMessage(949559302, exception.toString()));
                this._msgLogger.text(2L, (Object)CLASSNAME, "isGrantedRole", PDWASMsgHelper.formatSingleParamMessage(949559303, "SecurityProviderException"));
            }
            throw new SecurityProviderException(exception.toString(), exception);
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.text(16L, (Object)CLASSNAME, "isGrantedRole", "Return value [" + bl + "]");
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "isGrantedRole(HashMap, String, Principal)");
        }
        return bl;
    }

    public boolean isGrantedAnyRole(HashMap hashMap, String[] stringArray, Principal principal) throws SecurityProviderException {
        boolean bl = false;
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "isGrantedAnyRole(HashMap, String[], Principal)");
        }
        AuthzAccessContext authzAccessContext = new AuthzAccessContext(hashMap);
        if (this._rtMgr != null) {
            PrincipalHelper principalHelper = new PrincipalHelper(principal);
            String string = principalHelper.getShortName();
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "isGrantedAnyRole", "userShortName [" + string + "]");
            }
            try {
                bl = this._rtMgr.isGrantedRole(string, (Object)authzAccessContext, stringArray);
            }
            catch (AmasException amasException) {
                if (this._msgLogger != null && this._msgLogger.isLogging()) {
                    this._msgLogger.text(2L, (Object)CLASSNAME, "isGrantedAnyRole", PDWASMsgHelper.formatSingleParamMessage(949559302, amasException.toString()));
                    this._msgLogger.text(2L, (Object)CLASSNAME, "isGrantedAnyRole", PDWASMsgHelper.formatSingleParamMessage(949559303, "SecurityProviderException"));
                }
                throw new SecurityProviderException(amasException.toString(), amasException);
            }
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.text(16L, (Object)CLASSNAME, "isGrantedAnyRole", "Result [" + bl + "]");
            this._trcLogger.exit(96L, (Object)CLASSNAME, "isGrantedAnyRole(HashMap, String[], Principal)");
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

