/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pdwas.websphere;

import com.ibm.websphere.security.WASPrincipal;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.ws.security.common.auth.WSPrincipalImpl;
import com.tivoli.pd.as.rbpf.AmasSession;
import com.tivoli.pd.jazn.PDPrincipal;
import com.tivoli.pd.jras.pdjlog.jlog.ILogger;
import com.tivoli.pdwas.nls.PDWASMsgHelper;
import com.tivoli.pdwas.util.PDWASConfig;
import java.security.Principal;

public class PrincipalHelper {
    private final String PrincipalHelper_java_sourceCodeID = "$Id: @(#)38  1.2 src/pdwas/com/tivoli/pdwas/websphere/PrincipalHelper.java, amemb.jacc.was, amemb600, 051118a 04/07/15 17:55:02 @(#) $";
    public static final String sCopyright = "IBM Confidential\nObject Code Only Source Materials\n5747-SM3\n(c) Copyright International Business Machines Corp. 1994-2002.  All Rights Reserved.\nThe source code for this program is not published or otherwise divested\nof its trade secrets, irrespective of what has been deposited with the\nU.S. Copyright Office.\n";
    private String _shortName = null;
    private PDWASConfig pdProps = null;
    private ILogger _trcLogger;
    private ILogger _msgLogger;
    private AmasSession _sess;
    private static final String CLASSNAME = "com.tivoli.pdwas.websphere.PrincipalHelper";
    private static int _wasVersion = 4;

    public PrincipalHelper(Principal principal) {
        try {
            this.pdProps = PDWASConfig.getInstance();
            this._sess = this.pdProps.getAmasSession();
            this._trcLogger = this._sess.getLogManager().getTraceLogger("AMWASWebTraceLogger");
            this._msgLogger = this._sess.getLogManager().getMessageLogger("AMWASWebMessageLogger");
        }
        catch (NullPointerException nullPointerException) {
            System.out.println(PDWASMsgHelper.formatMessage(949559297, null));
        }
        if (principal == null) {
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "PrincipalHelper", "Passed principal null");
                this._trcLogger.text(16L, (Object)CLASSNAME, "PrincipalHepler", "Setting user to UNAUTHENTICATED");
            }
            this._shortName = "unauthenticated";
        } else {
            String string = principal.getName();
            if (string == null) {
                if (this._trcLogger != null && this._trcLogger.isLogging()) {
                    this._trcLogger.text(16L, (Object)CLASSNAME, "PrincipalHelper", "Unable to getName from principal");
                    this._trcLogger.text(16L, (Object)CLASSNAME, "PrincipalHelper", "Setting user to UNAUTHENTICATED");
                }
                this._shortName = "unauthenticated";
            } else if (principal instanceof PDPrincipal) {
                if (this._trcLogger != null && this._trcLogger.isLogging()) {
                    this._trcLogger.text(16L, (Object)CLASSNAME, "PrincipalHelper", "Got a PDPrincipal");
                }
                this._shortName = principal.getName();
            } else if (_wasVersion == 4) {
                if (principal instanceof WASPrincipal) {
                    if (this._trcLogger != null && this._trcLogger.isLogging()) {
                        this._trcLogger.text(16L, (Object)CLASSNAME, "PrincipalHelper", "Got a WSPrincipal (WAS 4)");
                    }
                    if (string.equals("UNAUTHENTICATED")) {
                        if (this._trcLogger != null && this._trcLogger.isLogging()) {
                            this._trcLogger.text(16L, (Object)CLASSNAME, "PrincipalHelper", "Passed principal WAS unauthenticated");
                            this._trcLogger.text(16L, (Object)CLASSNAME, "PrincipalHelper", "Setting user to UNAUTHENTICATED");
                        }
                        this._shortName = "unauthenticated";
                    } else {
                        if (this._trcLogger != null && this._trcLogger.isLogging()) {
                            this._trcLogger.text(16L, (Object)CLASSNAME, "PrincipalHelper", "Extracting username");
                        }
                        int n = string.indexOf("/");
                        this._shortName = string.substring(n + 1);
                    }
                } else {
                    if (this._trcLogger != null && this._trcLogger.isLogging()) {
                        this._trcLogger.text(16L, (Object)CLASSNAME, "PrincipalHelper", "Unsupported principal type (WAS 4)");
                        this._trcLogger.text(16L, (Object)CLASSNAME, "PrincipalHelper", "The class of " + principal + " is " + principal.getClass().getName());
                        this._trcLogger.text(16L, (Object)CLASSNAME, "PrincipalHelper", "Setting user to UNAUTHENTICATED");
                    }
                    this._shortName = "unauthenticated";
                }
            } else if (_wasVersion == 5) {
                if (principal instanceof WASPrincipal || principal instanceof WSPrincipalImpl || principal instanceof WSPrincipal) {
                    if (this._trcLogger != null && this._trcLogger.isLogging()) {
                        this._trcLogger.text(16L, (Object)CLASSNAME, "PrincipalHelper", "Got a WSPrincipal (WAS 5)");
                    }
                    if (string.equals("UNAUTHENTICATED")) {
                        if (this._trcLogger != null && this._trcLogger.isLogging()) {
                            this._trcLogger.text(16L, (Object)CLASSNAME, "PrincipalHelper", "Passed principal WAS unauthenticated");
                            this._trcLogger.text(16L, (Object)CLASSNAME, "PrincipalHelper", "Setting user to UNAUTHENTICATED");
                        }
                        this._shortName = "unauthenticated";
                    } else {
                        if (this._trcLogger != null && this._trcLogger.isLogging()) {
                            this._trcLogger.text(16L, (Object)CLASSNAME, "PrincipalHelper", "Extracting username");
                        }
                        int n = string.indexOf("/");
                        this._shortName = string.substring(n + 1);
                    }
                } else {
                    if (this._trcLogger != null && this._trcLogger.isLogging()) {
                        this._trcLogger.text(16L, (Object)CLASSNAME, "PrincipalHelper", "Unsupported principal type (WAS 5)");
                        this._trcLogger.text(16L, (Object)CLASSNAME, "PrincipalHelper", "The class of " + principal + " is " + principal.getClass().getName());
                        this._trcLogger.text(16L, (Object)CLASSNAME, "PrincipalHelper", "Setting user to UNAUTHENTICATED");
                    }
                    this._shortName = "unauthenticated";
                }
            } else {
                if (this._trcLogger != null && this._trcLogger.isLogging()) {
                    this._trcLogger.text(16L, (Object)CLASSNAME, "PrincipalHelper", "Unsupported principal type");
                    this._trcLogger.text(16L, (Object)CLASSNAME, "PrincipalHelper", "The class of " + principal + " is " + principal.getClass().getName());
                    this._trcLogger.text(16L, (Object)CLASSNAME, "PrincipalHelper", "Setting user to UNAUTHENTICATED");
                }
                this._shortName = "unauthenticated";
            }
        }
    }

    public String getShortName() {
        return this._shortName;
    }

    static {
        try {
            Class<?> clazz = Class.forName("com.ibm.websphere.security.auth.WSPrincipal");
            _wasVersion = 5;
        }
        catch (ClassNotFoundException classNotFoundException) {
            _wasVersion = 4;
        }
    }
}

