/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.soap.AttributeHandler;
import org.apache.soap.Body;
import org.apache.soap.Constants;
import org.apache.soap.Header;
import org.apache.soap.Utils;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.util.StringUtils;
import org.apache.soap.util.xml.DOM2Writer;
import org.apache.soap.util.xml.DOMUtils;
import org.apache.soap.util.xml.NSStack;
import org.apache.soap.util.xml.QName;
import org.apache.soap.util.xml.XMLJavaMappingRegistry;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Envelope {
    private Header header = null;
    private Body body = null;
    private Vector envelopeEntries = null;
    private AttributeHandler attrHandler = new AttributeHandler();

    public Envelope() {
        this.declareNamespace("SOAP-ENV", "http://schemas.xmlsoap.org/soap/envelope/");
        this.declareNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.declareNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
    }

    public void setAttribute(QName attrQName, String value2) {
        this.attrHandler.setAttribute(attrQName, value2);
    }

    public String getAttribute(QName attrQName) {
        return this.attrHandler.getAttribute(attrQName);
    }

    public void removeAttribute(QName attrQName) {
        this.attrHandler.removeAttribute(attrQName);
    }

    public void declareNamespace(String nsPrefix, String namespaceURI) {
        this.attrHandler.declareNamespace(nsPrefix, namespaceURI);
    }

    public void setHeader(Header header2) {
        this.header = header2;
    }

    public Header getHeader() {
        return this.header;
    }

    public void setBody(Body body) {
        this.body = body;
    }

    public Body getBody() {
        return this.body;
    }

    public void setEnvelopeEntries(Vector envelopeEntries) {
        this.envelopeEntries = envelopeEntries;
    }

    public Vector getEnvelopeEntries() {
        return this.envelopeEntries;
    }

    public void marshall(Writer sink, XMLJavaMappingRegistry xjmr) throws IllegalArgumentException, IOException {
        this.marshall(sink, xjmr, new SOAPContext());
    }

    public void marshall(Writer sink, XMLJavaMappingRegistry xjmr, SOAPContext ctx) throws IllegalArgumentException, IOException {
        NSStack nsStack = new NSStack();
        this.attrHandler.populateNSStack(nsStack);
        Header header2 = this.getHeader();
        Body body = this.getBody();
        Vector envelopeEntries = this.getEnvelopeEntries();
        String declEncStyle = this.getAttribute(new QName("http://schemas.xmlsoap.org/soap/envelope/", "encodingStyle"));
        String soapEnvNSPrefix = this.attrHandler.getUniquePrefixFromURI("http://schemas.xmlsoap.org/soap/envelope/", "SOAP-ENV", nsStack);
        sink.write("<?xml version='1.0' encoding='UTF-8'?>\r\n");
        sink.write('<' + soapEnvNSPrefix + ':' + "Envelope");
        this.attrHandler.marshall(sink, ctx);
        sink.write('>' + StringUtils.lineSeparator);
        if (header2 != null) {
            header2.marshall(sink, nsStack, xjmr, ctx);
        }
        if (body == null) {
            throw new IllegalArgumentException("An '" + Constants.Q_ELEM_ENVELOPE + "' must contain a: '" + Constants.Q_ELEM_BODY + "'.");
        }
        body.marshall(declEncStyle, sink, nsStack, xjmr, ctx);
        if (envelopeEntries != null) {
            Enumeration e2 = envelopeEntries.elements();
            while (e2.hasMoreElements()) {
                Element envelopeEntryEl = (Element)e2.nextElement();
                Utils.marshallNode(envelopeEntryEl, sink);
                sink.write(StringUtils.lineSeparator);
            }
        }
        sink.write("</" + soapEnvNSPrefix + ':' + "Envelope" + '>' + StringUtils.lineSeparator);
    }

    public static Envelope unmarshall(Node src) throws IllegalArgumentException {
        return Envelope.unmarshall(src, new SOAPContext());
    }

    public static Envelope unmarshall(Node src, SOAPContext ctx) throws IllegalArgumentException {
        Element root = (Element)src;
        Envelope env = new Envelope();
        if (Constants.Q_ELEM_ENVELOPE.matches(root)) {
            env.attrHandler = AttributeHandler.unmarshall(root, ctx);
            Element headerEl = null;
            Element bodyEl = null;
            Element tempEl = DOMUtils.getFirstChildElement(root);
            if (Constants.Q_ELEM_HEADER.matches(tempEl)) {
                headerEl = tempEl;
                tempEl = DOMUtils.getNextSiblingElement(tempEl);
            }
            if (Constants.Q_ELEM_BODY.matches(tempEl)) {
                bodyEl = tempEl;
                tempEl = DOMUtils.getNextSiblingElement(tempEl);
            }
            if (headerEl != null) {
                Header header2 = Header.unmarshall(headerEl, ctx);
                env.setHeader(header2);
            }
            if (bodyEl == null) {
                throw new IllegalArgumentException("An '" + Constants.Q_ELEM_ENVELOPE + "' element must contain a: '" + Constants.Q_ELEM_BODY + "' element.");
            }
            Body body = Body.unmarshall(bodyEl, ctx);
            env.setBody(body);
            if (tempEl != null) {
                Vector<Element> envelopeEntries = new Vector<Element>();
                while (tempEl != null) {
                    envelopeEntries.addElement(tempEl);
                    tempEl = DOMUtils.getNextSiblingElement(tempEl);
                }
                env.setEnvelopeEntries(envelopeEntries);
            }
        } else {
            String localName = root.getLocalName();
            if (localName != null && localName.equals("Envelope")) {
                throw new IllegalArgumentException(Constants.ERR_MSG_VERSION_MISMATCH);
            }
            throw new IllegalArgumentException("Root element of a SOAP message must be: '" + Constants.Q_ELEM_ENVELOPE + "'.");
        }
        return env;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.print("[Attributes=" + this.attrHandler + "] " + "[Header=" + this.header + "] " + "[Body=" + this.body + "] " + "[EnvelopeEntries=");
        if (this.envelopeEntries != null) {
            pw.println();
            for (int i = 0; i < this.envelopeEntries.size(); ++i) {
                pw.println("[(" + i + ")=" + DOM2Writer.nodeToString((Element)this.envelopeEntries.elementAt(i)) + "]");
            }
        }
        pw.print("]");
        return sw.toString();
    }
}

