/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.encoding;

import java.io.IOException;
import java.io.Writer;
import org.apache.soap.Constants;
import org.apache.soap.Utils;
import org.apache.soap.encoding.literalxml.XMLParameterSerializer;
import org.apache.soap.encoding.soapenc.ArraySerializer;
import org.apache.soap.encoding.soapenc.Base64Serializer;
import org.apache.soap.encoding.soapenc.BooleanDeserializer;
import org.apache.soap.encoding.soapenc.ByteDeserializer;
import org.apache.soap.encoding.soapenc.CalendarSerializer;
import org.apache.soap.encoding.soapenc.DateSerializer;
import org.apache.soap.encoding.soapenc.DecimalDeserializer;
import org.apache.soap.encoding.soapenc.DoubleDeserializer;
import org.apache.soap.encoding.soapenc.FloatDeserializer;
import org.apache.soap.encoding.soapenc.HashtableSerializer;
import org.apache.soap.encoding.soapenc.HexDeserializer;
import org.apache.soap.encoding.soapenc.IntDeserializer;
import org.apache.soap.encoding.soapenc.LongDeserializer;
import org.apache.soap.encoding.soapenc.MapSerializer;
import org.apache.soap.encoding.soapenc.MimePartSerializer;
import org.apache.soap.encoding.soapenc.ParameterSerializer;
import org.apache.soap.encoding.soapenc.QNameSerializer;
import org.apache.soap.encoding.soapenc.ShortDeserializer;
import org.apache.soap.encoding.soapenc.SoapEncUtils;
import org.apache.soap.encoding.soapenc.StringDeserializer;
import org.apache.soap.encoding.soapenc.UrTypeDeserializer;
import org.apache.soap.encoding.soapenc.VectorSerializer;
import org.apache.soap.rpc.RPCConstants;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.util.xml.Deserializer;
import org.apache.soap.util.xml.NSStack;
import org.apache.soap.util.xml.QName;
import org.apache.soap.util.xml.Serializer;
import org.apache.soap.util.xml.XMLJavaMappingRegistry;

public class SOAPMappingRegistry
extends XMLJavaMappingRegistry {
    private static SOAPMappingRegistry baseReg1999;
    private static SOAPMappingRegistry baseReg2000;
    private static SOAPMappingRegistry baseReg2001;
    private SOAPMappingRegistry parent = null;
    private String schemaURI;
    private static String soapEncURI;
    private static QName arrayQName;
    private static StringDeserializer stringDeser;
    private static IntDeserializer intDeser;
    private static DecimalDeserializer decimalDeser;
    private static FloatDeserializer floatDeser;
    private static DoubleDeserializer doubleDeser;
    private static BooleanDeserializer booleanDeser;
    private static LongDeserializer longDeser;
    private static ShortDeserializer shortDeser;
    private static ByteDeserializer byteDeser;
    private static HexDeserializer hexDeser;
    private static QNameSerializer qNameSer;
    private static ParameterSerializer paramSer;
    private static ArraySerializer arraySer;
    private static VectorSerializer vectorSer;
    private static HashtableSerializer hashtableSer;
    private static XMLParameterSerializer xmlParamSer;
    private static DateSerializer dateSer;
    private static CalendarSerializer calSer;
    private static UrTypeDeserializer objDeser;
    public static MimePartSerializer partSer;
    private static QName[] schema1999QNames;
    private static QName[] schema2000QNames;
    private static QName[] schema2001QNames;
    private static Class[] classes;
    private static Serializer cleanSer;
    private static Serializer ser;
    private static Serializer[] serializers;
    private static Deserializer[] deserializers;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$org$apache$soap$encoding$Hex;
    static /* synthetic */ Class class$org$apache$soap$util$xml$QName;
    static /* synthetic */ Class class$java$util$GregorianCalendar;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$javax$mail$internet$MimeBodyPart;
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class class$javax$activation$DataSource;
    static /* synthetic */ Class class$javax$activation$DataHandler;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$apache$soap$encoding$SOAPMappingRegistry;
    static /* synthetic */ Class class$org$apache$soap$rpc$Parameter;
    static /* synthetic */ Class class$java$util$Vector;
    static /* synthetic */ Class class$java$util$Hashtable;
    static /* synthetic */ Class array$B;

    public SOAPMappingRegistry() {
        this.schemaURI = "http://www.w3.org/2001/XMLSchema";
        this.parent = SOAPMappingRegistry.getBaseRegistry("http://www.w3.org/2001/XMLSchema");
    }

    public SOAPMappingRegistry(SOAPMappingRegistry parent2) {
        this(parent2, "http://www.w3.org/2001/XMLSchema");
    }

    public SOAPMappingRegistry(SOAPMappingRegistry parent2, String schemaURI) {
        this.parent = parent2;
        if (parent2 == null) {
            this.initializeRegistry(schemaURI);
        }
        this.schemaURI = schemaURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SOAPMappingRegistry getBaseRegistry(String schemaURI) {
        Class clazz = class$org$apache$soap$encoding$SOAPMappingRegistry == null ? (class$org$apache$soap$encoding$SOAPMappingRegistry = SOAPMappingRegistry.class$("org.apache.soap.encoding.SOAPMappingRegistry")) : class$org$apache$soap$encoding$SOAPMappingRegistry;
        synchronized (clazz) {
            if (baseReg1999 == null) {
                baseReg1999 = new SOAPMappingRegistry(null, "http://www.w3.org/1999/XMLSchema");
                baseReg2000 = new SOAPMappingRegistry(null, "http://www.w3.org/2000/10/XMLSchema");
                baseReg2001 = new SOAPMappingRegistry(null, "http://www.w3.org/2001/XMLSchema");
            }
        }
        if (schemaURI.equals("http://www.w3.org/1999/XMLSchema")) {
            return baseReg1999;
        }
        if (schemaURI.equals("http://www.w3.org/2000/10/XMLSchema")) {
            return baseReg2000;
        }
        return baseReg2001;
    }

    public void setDefaultEncodingStyle(String defEncStyle) {
        super.setDefaultEncodingStyle(defEncStyle);
        if (this.parent != null) {
            this.parent.setDefaultEncodingStyle(defEncStyle);
        }
    }

    public String getSchemaURI() {
        return this.schemaURI;
    }

    public SOAPMappingRegistry getParent() {
        return this.parent;
    }

    private void initializeRegistry(String schemaURI) {
        QName[] schemaQNames = null;
        if (schemaURI.equals("http://www.w3.org/1999/XMLSchema")) {
            schemaQNames = schema1999QNames;
            this.mapSchemaTypes(schema2000QNames, false);
            this.mapSchemaTypes(schema2001QNames, false);
        } else if (schemaURI.equals("http://www.w3.org/2000/10/XMLSchema")) {
            this.mapSchemaTypes(schema1999QNames, false);
            schemaQNames = schema2000QNames;
            this.mapSchemaTypes(schema2001QNames, false);
        } else {
            if (!schemaURI.equals("http://www.w3.org/2001/XMLSchema")) {
                System.err.println("WARNING: Unrecognized Schema URI '" + schemaURI + "' specified.  Defaulting to '" + "http://www.w3.org/2001/XMLSchema" + "'.");
            }
            this.mapSchemaTypes(schema1999QNames, false);
            this.mapSchemaTypes(schema2000QNames, false);
            schemaQNames = schema2001QNames;
        }
        this.mapSchemaTypes(schemaQNames, true);
        this.mapTypes(soapEncURI, RPCConstants.Q_ELEM_PARAMETER, class$org$apache$soap$rpc$Parameter == null ? (class$org$apache$soap$rpc$Parameter = SOAPMappingRegistry.class$("org.apache.soap.rpc.Parameter")) : class$org$apache$soap$rpc$Parameter, paramSer, paramSer);
        this.mapTypes(soapEncURI, arrayQName, null, null, arraySer);
        this.mapTypes("http://xml.apache.org/xml-soap/literalxml", RPCConstants.Q_ELEM_PARAMETER, class$org$apache$soap$rpc$Parameter == null ? (class$org$apache$soap$rpc$Parameter = SOAPMappingRegistry.class$("org.apache.soap.rpc.Parameter")) : class$org$apache$soap$rpc$Parameter, xmlParamSer, xmlParamSer);
        try {
            Class<?> XMISerializer = Class.forName("org.apache.soap.util.xml.XMISerializer");
            Class<?> XMIParameterSerializer = Class.forName("org.apache.soap.encoding.xmi.XMIParameterSerializer");
            this.mapTypes("http://www.ibm.com/namespaces/xmi", null, null, (Serializer)XMISerializer.newInstance(), (Deserializer)XMIParameterSerializer.newInstance());
            this.mapTypes("http://www.ibm.com/namespaces/xmi", null, class$org$apache$soap$rpc$Parameter == null ? (class$org$apache$soap$rpc$Parameter = SOAPMappingRegistry.class$("org.apache.soap.rpc.Parameter")) : class$org$apache$soap$rpc$Parameter, (Serializer)XMIParameterSerializer.newInstance(), null);
        }
        catch (IllegalAccessException iae) {
        }
        catch (InstantiationException ie) {
        }
        catch (ClassNotFoundException cnfe) {
        }
        catch (NoClassDefFoundError ncdfe) {
            // empty catch block
        }
        this.mapTypes(soapEncURI, new QName("http://xml.apache.org/xml-soap", "Vector"), class$java$util$Vector == null ? (class$java$util$Vector = SOAPMappingRegistry.class$("java.util.Vector")) : class$java$util$Vector, vectorSer, vectorSer);
        this.mapTypes(soapEncURI, new QName("http://xml.apache.org/xml-soap", "Map"), class$java$util$Hashtable == null ? (class$java$util$Hashtable = SOAPMappingRegistry.class$("java.util.Hashtable")) : class$java$util$Hashtable, hashtableSer, hashtableSer);
        try {
            Class<?> mapClass = Class.forName("java.util.Map");
            MapSerializer mapSer = new MapSerializer();
            this.mapTypes(soapEncURI, new QName("http://xml.apache.org/xml-soap", "Map"), mapClass, mapSer, mapSer);
        }
        catch (ClassNotFoundException cnfe) {
        }
        catch (NoClassDefFoundError ncdfe) {
            // empty catch block
        }
        Base64Serializer base64Ser = new Base64Serializer();
        QName base64QName = new QName("http://www.w3.org/2001/XMLSchema", "base64Binary");
        this.mapTypes(soapEncURI, base64QName, array$B == null ? (array$B = SOAPMappingRegistry.class$("[B")) : array$B, base64Ser, base64Ser);
        base64QName = new QName(soapEncURI, "base64");
        this.mapTypes(soapEncURI, base64QName, array$B == null ? (array$B = SOAPMappingRegistry.class$("[B")) : array$B, base64Ser, base64Ser);
    }

    private void mapSchemaTypes(QName[] schemaQNames, boolean serialize) {
        for (int i = 0; i < schemaQNames.length; ++i) {
            QName qName = schemaQNames[i];
            Class cls = classes[i];
            Serializer ser = serialize ? serializers[i] : null;
            Deserializer dser = deserializers[i];
            this.mapTypes(soapEncURI, qName, cls, ser, dser);
        }
    }

    protected QName queryElementType_(Class javaType, String encodingStyleURI) {
        QName qn = super.queryElementType_(javaType, encodingStyleURI);
        if (qn != null) {
            return qn;
        }
        if (this.parent != null && (qn = this.parent.queryElementType_(javaType, encodingStyleURI)) != null) {
            return qn;
        }
        if (javaType != null && javaType.isArray() && encodingStyleURI != null && encodingStyleURI.equals(soapEncURI)) {
            return arrayQName;
        }
        return null;
    }

    protected Serializer querySerializer_(Class javaType, String encodingStyleURI) {
        Serializer s = super.querySerializer_(javaType, encodingStyleURI);
        if (s != null) {
            return s;
        }
        if (this.parent != null && (s = this.parent.querySerializer_(javaType, encodingStyleURI)) != null) {
            return s;
        }
        if (javaType != null && encodingStyleURI != null && encodingStyleURI.equals(soapEncURI) && javaType.isArray()) {
            return arraySer;
        }
        return null;
    }

    protected Deserializer queryDeserializer_(QName elementType, String encodingStyleURI) {
        Deserializer ds = super.queryDeserializer_(elementType, encodingStyleURI);
        if (ds != null) {
            return ds;
        }
        if (this.parent != null && (ds = this.parent.queryDeserializer_(elementType, encodingStyleURI)) != null) {
            return ds;
        }
        return null;
    }

    protected Class queryJavaType_(QName elementType, String encodingStyleURI) {
        Class jt = super.queryJavaType_(elementType, encodingStyleURI);
        if (jt != null) {
            return jt;
        }
        if (this.parent != null && (jt = this.parent.queryJavaType_(elementType, encodingStyleURI)) != null) {
            return jt;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        soapEncURI = "http://schemas.xmlsoap.org/soap/encoding/";
        arrayQName = new QName(soapEncURI, "Array");
        stringDeser = new StringDeserializer();
        intDeser = new IntDeserializer();
        decimalDeser = new DecimalDeserializer();
        floatDeser = new FloatDeserializer();
        doubleDeser = new DoubleDeserializer();
        booleanDeser = new BooleanDeserializer();
        longDeser = new LongDeserializer();
        shortDeser = new ShortDeserializer();
        byteDeser = new ByteDeserializer();
        hexDeser = new HexDeserializer();
        qNameSer = new QNameSerializer();
        paramSer = new ParameterSerializer();
        arraySer = new ArraySerializer();
        vectorSer = new VectorSerializer();
        hashtableSer = new HashtableSerializer();
        xmlParamSer = new XMLParameterSerializer();
        dateSer = new DateSerializer();
        calSer = new CalendarSerializer();
        objDeser = new UrTypeDeserializer();
        partSer = new MimePartSerializer();
        schema1999QNames = new QName[]{Constants.string1999QName, Constants.int1999QName, Constants.int1999QName, Constants.decimal1999QName, Constants.float1999QName, Constants.float1999QName, Constants.double1999QName, Constants.double1999QName, Constants.boolean1999QName, Constants.boolean1999QName, Constants.long1999QName, Constants.long1999QName, Constants.short1999QName, Constants.short1999QName, Constants.byte1999QName, Constants.byte1999QName, Constants.hex1999QName, Constants.qName1999QName, Constants.date1999QName, Constants.timeInst1999QName, Constants.object1999QName, Constants.object1999QName, Constants.object1999QName, Constants.object1999QName, Constants.object1999QName};
        schema2000QNames = new QName[]{Constants.string2000QName, Constants.int2000QName, Constants.int2000QName, Constants.decimal2000QName, Constants.float2000QName, Constants.float2000QName, Constants.double2000QName, Constants.double2000QName, Constants.boolean2000QName, Constants.boolean2000QName, Constants.long2000QName, Constants.long2000QName, Constants.short2000QName, Constants.short2000QName, Constants.byte2000QName, Constants.byte2000QName, Constants.hex2000QName, Constants.qName2000QName, Constants.date2000QName, Constants.timeInst2000QName, Constants.object2000QName, Constants.object2000QName, Constants.object2000QName, Constants.object2000QName, Constants.object2000QName};
        schema2001QNames = new QName[]{Constants.string2001QName, Constants.int2001QName, Constants.int2001QName, Constants.decimal2001QName, Constants.float2001QName, Constants.float2001QName, Constants.double2001QName, Constants.double2001QName, Constants.boolean2001QName, Constants.boolean2001QName, Constants.long2001QName, Constants.long2001QName, Constants.short2001QName, Constants.short2001QName, Constants.byte2001QName, Constants.byte2001QName, Constants.hex2001QName, Constants.qName2001QName, Constants.date2001QName, Constants.timeInst2001QName, Constants.object2001QName, Constants.object2001QName, Constants.object2001QName, Constants.object2001QName, Constants.object2001QName};
        classes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = SOAPMappingRegistry.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Integer == null ? (class$java$lang$Integer = SOAPMappingRegistry.class$("java.lang.Integer")) : class$java$lang$Integer, Integer.TYPE, class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = SOAPMappingRegistry.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, class$java$lang$Float == null ? (class$java$lang$Float = SOAPMappingRegistry.class$("java.lang.Float")) : class$java$lang$Float, Float.TYPE, class$java$lang$Double == null ? (class$java$lang$Double = SOAPMappingRegistry.class$("java.lang.Double")) : class$java$lang$Double, Double.TYPE, class$java$lang$Boolean == null ? (class$java$lang$Boolean = SOAPMappingRegistry.class$("java.lang.Boolean")) : class$java$lang$Boolean, Boolean.TYPE, class$java$lang$Long == null ? (class$java$lang$Long = SOAPMappingRegistry.class$("java.lang.Long")) : class$java$lang$Long, Long.TYPE, class$java$lang$Short == null ? (class$java$lang$Short = SOAPMappingRegistry.class$("java.lang.Short")) : class$java$lang$Short, Short.TYPE, class$java$lang$Byte == null ? (class$java$lang$Byte = SOAPMappingRegistry.class$("java.lang.Byte")) : class$java$lang$Byte, Byte.TYPE, class$org$apache$soap$encoding$Hex == null ? (class$org$apache$soap$encoding$Hex = SOAPMappingRegistry.class$("org.apache.soap.encoding.Hex")) : class$org$apache$soap$encoding$Hex, class$org$apache$soap$util$xml$QName == null ? (class$org$apache$soap$util$xml$QName = SOAPMappingRegistry.class$("org.apache.soap.util.xml.QName")) : class$org$apache$soap$util$xml$QName, class$java$util$GregorianCalendar == null ? (class$java$util$GregorianCalendar = SOAPMappingRegistry.class$("java.util.GregorianCalendar")) : class$java$util$GregorianCalendar, class$java$util$Date == null ? (class$java$util$Date = SOAPMappingRegistry.class$("java.util.Date")) : class$java$util$Date, class$javax$mail$internet$MimeBodyPart == null ? (class$javax$mail$internet$MimeBodyPart = SOAPMappingRegistry.class$("javax.mail.internet.MimeBodyPart")) : class$javax$mail$internet$MimeBodyPart, class$java$io$InputStream == null ? (class$java$io$InputStream = SOAPMappingRegistry.class$("java.io.InputStream")) : class$java$io$InputStream, class$javax$activation$DataSource == null ? (class$javax$activation$DataSource = SOAPMappingRegistry.class$("javax.activation.DataSource")) : class$javax$activation$DataSource, class$javax$activation$DataHandler == null ? (class$javax$activation$DataHandler = SOAPMappingRegistry.class$("javax.activation.DataHandler")) : class$javax$activation$DataHandler, class$java$lang$Object == null ? (class$java$lang$Object = SOAPMappingRegistry.class$("java.lang.Object")) : class$java$lang$Object};
        cleanSer = new Serializer(){

            public void marshall(String inScopeEncStyle, Class javaType, Object src, Object context, Writer sink, NSStack nsStack, XMLJavaMappingRegistry xjmr, SOAPContext ctx) throws IllegalArgumentException, IOException {
                nsStack.pushScope();
                if (src == null) {
                    SoapEncUtils.generateNullStructure(inScopeEncStyle, javaType, context, sink, nsStack, xjmr);
                } else {
                    SoapEncUtils.generateStructureHeader(inScopeEncStyle, javaType, context, sink, nsStack, xjmr);
                    sink.write(Utils.cleanString(src.toString()) + "</" + context + '>');
                }
                nsStack.popScope();
            }
        };
        ser = new Serializer(){

            public void marshall(String inScopeEncStyle, Class javaType, Object src, Object context, Writer sink, NSStack nsStack, XMLJavaMappingRegistry xjmr, SOAPContext ctx) throws IllegalArgumentException, IOException {
                nsStack.pushScope();
                SoapEncUtils.generateStructureHeader(inScopeEncStyle, javaType, context, sink, nsStack, xjmr);
                sink.write(src + "</" + context + '>');
                nsStack.popScope();
            }
        };
        serializers = new Serializer[]{cleanSer, ser, ser, ser, ser, ser, ser, ser, ser, ser, ser, ser, ser, ser, ser, ser, ser, qNameSer, calSer, dateSer, partSer, partSer, partSer, partSer, null};
        deserializers = new Deserializer[]{stringDeser, null, intDeser, decimalDeser, null, floatDeser, null, doubleDeser, null, booleanDeser, null, longDeser, null, shortDeser, null, byteDeser, hexDeser, qNameSer, calSer, dateSer, null, null, null, null, objDeser};
    }
}

