/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.encoding.soapenc;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import org.apache.soap.encoding.soapenc.SoapEncUtils;
import org.apache.soap.rpc.Parameter;
import org.apache.soap.rpc.RPCConstants;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.util.Bean;
import org.apache.soap.util.StringUtils;
import org.apache.soap.util.xml.DOMUtils;
import org.apache.soap.util.xml.Deserializer;
import org.apache.soap.util.xml.NSStack;
import org.apache.soap.util.xml.QName;
import org.apache.soap.util.xml.Serializer;
import org.apache.soap.util.xml.XMLJavaMappingRegistry;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BeanSerializer
implements Serializer,
Deserializer {
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$org$apache$soap$rpc$Parameter;

    public void marshall(String inScopeEncStyle, Class javaType, Object src, Object context, Writer sink, NSStack nsStack, XMLJavaMappingRegistry xjmr, SOAPContext ctx) throws IllegalArgumentException, IOException {
        nsStack.pushScope();
        SoapEncUtils.generateStructureHeader(inScopeEncStyle, javaType, context, sink, nsStack, xjmr);
        sink.write(StringUtils.lineSeparator);
        PropertyDescriptor[] properties = this.getPropertyDescriptors(javaType);
        for (int i = 0; i < properties.length; ++i) {
            Method propReadMethod;
            String propName = properties[i].getName();
            Class<?> propType = properties[i].getPropertyType();
            if (propType.equals(class$java$lang$Class == null ? BeanSerializer.class$("java.lang.Class") : class$java$lang$Class) || (propReadMethod = properties[i].getReadMethod()) == null) continue;
            Object propValue = null;
            try {
                if (src != null) {
                    propValue = propReadMethod.invoke(src, new Object[0]);
                }
            }
            catch (Exception e2) {
                throw new IllegalArgumentException("Unable to retrieve '" + propName + "' property " + "value: " + e2.getMessage() + '.');
            }
            Parameter param = new Parameter(propName, propType, propValue, null);
            xjmr.marshall("http://schemas.xmlsoap.org/soap/encoding/", class$org$apache$soap$rpc$Parameter == null ? BeanSerializer.class$("org.apache.soap.rpc.Parameter") : class$org$apache$soap$rpc$Parameter, param, null, sink, nsStack, ctx);
            sink.write(StringUtils.lineSeparator);
        }
        sink.write("</" + context + '>');
        nsStack.popScope();
    }

    public Bean unmarshall(String inScopeEncStyle, QName elementType, Node src, XMLJavaMappingRegistry xjmr, SOAPContext ctx) throws IllegalArgumentException {
        Element root = (Element)src;
        Element tempEl = DOMUtils.getFirstChildElement(root);
        Class javaType = xjmr.queryJavaType(elementType, inScopeEncStyle);
        Object bean = this.instantiateBean(javaType);
        PropertyDescriptor[] properties = this.getPropertyDescriptors(javaType);
        while (tempEl != null) {
            Bean paramBean = xjmr.unmarshall(inScopeEncStyle, RPCConstants.Q_ELEM_PARAMETER, tempEl, ctx);
            Parameter param = (Parameter)paramBean.value;
            Method propWriteMethod = this.getWriteMethod(param.getName(), properties, javaType);
            if (propWriteMethod != null) {
                try {
                    propWriteMethod.invoke(bean, param.getValue());
                }
                catch (Exception e2) {
                    throw new IllegalArgumentException("Unable to set '" + param.getName() + "' property: " + e2.getMessage() + '.');
                }
            }
            tempEl = DOMUtils.getNextSiblingElement(tempEl);
        }
        return new Bean(javaType, bean);
    }

    private PropertyDescriptor[] getPropertyDescriptors(Class javaType) throws IllegalArgumentException {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(javaType);
        }
        catch (IntrospectionException e2) {
            // empty catch block
        }
        if (beanInfo != null) {
            PropertyDescriptor[] properties = beanInfo.getPropertyDescriptors();
            if (properties != null) {
                return properties;
            }
            throw new IllegalArgumentException("Unable to retrieve property descriptors for '" + StringUtils.getClassName(javaType) + "'.");
        }
        throw new IllegalArgumentException("Unable to retrieve BeanInfo for '" + StringUtils.getClassName(javaType) + "'.");
    }

    protected Method getWriteMethod(String propertyName, PropertyDescriptor[] pds, Class javaType) {
        for (int i = 0; i < pds.length; ++i) {
            if (!propertyName.equals(pds[i].getName())) continue;
            return pds[i].getWriteMethod();
        }
        throw new IllegalArgumentException("Unable to retrieve PropertyDescriptor for property '" + propertyName + "' of class '" + javaType + "'.");
    }

    private Object instantiateBean(Class javaType) throws IllegalArgumentException {
        try {
            return javaType.newInstance();
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Unable to instantiate '" + StringUtils.getClassName(javaType) + "': " + t.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

