/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.encoding.soapenc;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URLEncoder;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import org.apache.soap.encoding.soapenc.SoapEncUtils;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.util.Bean;
import org.apache.soap.util.mime.ByteArrayDataSource;
import org.apache.soap.util.mime.MimeUtils;
import org.apache.soap.util.xml.Deserializer;
import org.apache.soap.util.xml.NSStack;
import org.apache.soap.util.xml.QName;
import org.apache.soap.util.xml.Serializer;
import org.apache.soap.util.xml.XMLJavaMappingRegistry;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MimePartSerializer
implements Serializer,
Deserializer {
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$javax$activation$DataHandler;

    public void marshall(String inScopeEncStyle, Class javaType, Object src, Object context, Writer sink, NSStack nsStack, XMLJavaMappingRegistry xjmr, SOAPContext ctx) throws IllegalArgumentException, IOException {
        nsStack.pushScope();
        if (!(src == null || src instanceof InputStream || src instanceof DataSource || src instanceof MimeBodyPart || src instanceof DataHandler)) {
            throw new IllegalArgumentException("Tried to pass a '" + src.getClass().toString() + "' to MimePartSerializer");
        }
        if (src == null) {
            SoapEncUtils.generateNullStructure(inScopeEncStyle, class$java$lang$Object == null ? (class$java$lang$Object = MimePartSerializer.class$("java.lang.Object")) : class$java$lang$Object, null, sink, nsStack, xjmr);
        } else {
            DataSource ds = null;
            DataHandler dh = null;
            MimeBodyPart bp = null;
            if (src instanceof InputStream) {
                ds = new ByteArrayDataSource((InputStream)src, "application/octet-stream");
            } else if (src instanceof DataSource) {
                ds = (DataSource)src;
            }
            if (ds != null) {
                dh = new DataHandler(ds);
            } else if (src instanceof DataHandler) {
                dh = (DataHandler)src;
            }
            if (dh != null) {
                bp = new MimeBodyPart();
                try {
                    bp.setDataHandler(dh);
                }
                catch (MessagingException me) {
                    throw new IllegalArgumentException("Invalid InputStream/DataSource/DataHandler: " + (Object)((Object)me));
                }
            } else if (src instanceof MimeBodyPart) {
                bp = (MimeBodyPart)src;
            }
            String cid = null;
            try {
                cid = bp.getContentID();
            }
            catch (MessagingException me) {
                // empty catch block
            }
            if (cid == null) {
                cid = MimeUtils.getUniqueValue();
                try {
                    bp.setHeader("Content-ID", '<' + cid + '>');
                }
                catch (MessagingException me) {
                    throw new IllegalArgumentException("Could not set Content-ID: " + (Object)((Object)me));
                }
            }
            try {
                ctx.addBodyPart(bp);
            }
            catch (MessagingException me) {
                throw new IllegalArgumentException("Could not add attachment: " + (Object)((Object)me));
            }
            sink.write('<' + context.toString());
            sink.write(" href =\"cid:" + URLEncoder.encode(cid) + '\"');
            sink.write("/>");
        }
        nsStack.popScope();
    }

    public Bean unmarshall(String inScopeEncStyle, QName elementType, Node src, XMLJavaMappingRegistry xjmr, SOAPContext ctx) throws IllegalArgumentException {
        Element paramEl = (Element)src;
        DataHandler dh = null;
        if (!SoapEncUtils.isNull(paramEl)) {
            String uri = paramEl.getAttribute("href");
            try {
                MimeBodyPart bp = null;
                try {
                    bp = ctx.findBodyPart(uri);
                }
                catch (NullPointerException npe) {
                }
                catch (ClassCastException cce) {
                    // empty catch block
                }
                if (bp == null) {
                    throw new IllegalArgumentException("Attachment tag \"" + paramEl.getTagName() + "\" refers to a Mime attachment with label \"" + uri + "\" which could not be found.");
                }
                dh = bp.getDataHandler();
            }
            catch (MessagingException me) {
                throw new IllegalArgumentException("Failed to read attachment for tag \"" + paramEl.getTagName() + "\" with label \"" + uri + "\": " + (Object)((Object)me));
            }
        }
        return new Bean(class$javax$activation$DataHandler == null ? (class$javax$activation$DataHandler = MimePartSerializer.class$("javax.activation.DataHandler")) : class$javax$activation$DataHandler, dh);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

