/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.encoding.soapenc;

import java.io.IOException;
import java.io.Writer;
import org.apache.soap.encoding.soapenc.MimePartSerializer;
import org.apache.soap.encoding.soapenc.SoapEncUtils;
import org.apache.soap.rpc.Parameter;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.util.Bean;
import org.apache.soap.util.xml.DOMUtils;
import org.apache.soap.util.xml.Deserializer;
import org.apache.soap.util.xml.NSStack;
import org.apache.soap.util.xml.PrefixedName;
import org.apache.soap.util.xml.QName;
import org.apache.soap.util.xml.Serializer;
import org.apache.soap.util.xml.XMLJavaMappingRegistry;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ParameterSerializer
implements Serializer,
Deserializer {
    static /* synthetic */ Class class$org$apache$soap$rpc$Parameter;

    public void marshall(String inScopeEncStyle, Class javaType, Object src, Object context, Writer sink, NSStack nsStack, XMLJavaMappingRegistry xjmr, SOAPContext ctx) throws IllegalArgumentException, IOException {
        nsStack.pushScope();
        Parameter param = (Parameter)src;
        Class type = param.getType();
        String name2 = param.getName();
        Object value2 = param.getValue();
        if (!(context instanceof PrefixedName)) {
            context = name2;
        }
        if (value2 == null && !type.isArray()) {
            SoapEncUtils.generateNullStructure(inScopeEncStyle, type, context, sink, nsStack, xjmr);
        } else {
            String declEncStyle = param.getEncodingStyleURI();
            String actualEncStyle = declEncStyle != null ? declEncStyle : inScopeEncStyle;
            Serializer s = xjmr.querySerializer(type, actualEncStyle);
            s.marshall(inScopeEncStyle, type, value2, context, sink, nsStack, xjmr, ctx);
        }
        nsStack.popScope();
    }

    public Bean unmarshall(String inScopeEncStyle, QName elementType, Node src, XMLJavaMappingRegistry xjmr, SOAPContext ctx) throws IllegalArgumentException {
        Element paramEl = (Element)src;
        String name2 = paramEl.getTagName();
        Bean bean = null;
        String href = DOMUtils.getAttribute(paramEl, "href");
        if (href != null) {
            if (href.length() > 0 && href.charAt(0) == '#') {
                href = href.substring(1);
                Element el = DOMUtils.getElementByID(src.getOwnerDocument().getDocumentElement(), href);
                if (el == null) {
                    throw new IllegalArgumentException("No such ID '" + href + "'.");
                }
                QName soapType = SoapEncUtils.getTypeQName(el);
                if (soapType == null) {
                    String paramNamespaceURI = paramEl.getNamespaceURI();
                    soapType = paramNamespaceURI != null ? new QName(paramNamespaceURI, name2) : new QName("", name2);
                }
                bean = xjmr.unmarshall(inScopeEncStyle, soapType, el, ctx);
            } else {
                bean = new MimePartSerializer().unmarshall(inScopeEncStyle, elementType, src, xjmr, ctx);
            }
        } else {
            QName soapType = SoapEncUtils.getTypeQName(paramEl);
            if (soapType == null) {
                String paramNamespaceURI = paramEl.getNamespaceURI();
                soapType = paramNamespaceURI != null ? new QName(paramNamespaceURI, name2) : new QName("", name2);
            }
            bean = SoapEncUtils.isNull(paramEl) && !new QName("http://schemas.xmlsoap.org/soap/encoding/", "Array").equals(soapType) ? new Bean(xjmr.queryJavaType(soapType, inScopeEncStyle), null) : xjmr.unmarshall(inScopeEncStyle, soapType, paramEl, ctx);
        }
        Parameter parameter2 = new Parameter(name2, bean.type, bean.value, null);
        return new Bean(class$org$apache$soap$rpc$Parameter == null ? (class$org$apache$soap$rpc$Parameter = ParameterSerializer.class$("org.apache.soap.rpc.Parameter")) : class$org$apache$soap$rpc$Parameter, parameter2);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

