/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.encoding.soapenc;

import java.io.IOException;
import java.io.Writer;
import org.apache.soap.Constants;
import org.apache.soap.util.xml.DOMUtils;
import org.apache.soap.util.xml.NSStack;
import org.apache.soap.util.xml.PrefixedName;
import org.apache.soap.util.xml.QName;
import org.apache.soap.util.xml.XMLJavaMappingRegistry;
import org.w3c.dom.Element;

public class SoapEncUtils {
    public static void generateNullStructure(String inScopeEncStyle, Class javaType, Object context, Writer sink, NSStack nsStack, XMLJavaMappingRegistry xjmr) throws IllegalArgumentException, IOException {
        SoapEncUtils.generateStructureHeader(inScopeEncStyle, javaType, context, sink, nsStack, xjmr, null, null, true);
    }

    public static void generateNullArray(String inScopeEncStyle, Class javaType, Object context, Writer sink, NSStack nsStack, XMLJavaMappingRegistry xjmr, QName arrayElementType, String arrayLengthStr) throws IllegalArgumentException, IOException {
        SoapEncUtils.generateStructureHeader(inScopeEncStyle, javaType, context, sink, nsStack, xjmr, arrayElementType, arrayLengthStr, true);
    }

    public static void generateArrayHeader(String inScopeEncStyle, Class javaType, Object context, Writer sink, NSStack nsStack, XMLJavaMappingRegistry xjmr, QName arrayElementType, String arrayLengthStr) throws IllegalArgumentException, IOException {
        SoapEncUtils.generateStructureHeader(inScopeEncStyle, javaType, context, sink, nsStack, xjmr, arrayElementType, arrayLengthStr, false);
    }

    public static void generateStructureHeader(String inScopeEncStyle, Class javaType, Object context, Writer sink, NSStack nsStack, XMLJavaMappingRegistry xjmr) throws IllegalArgumentException, IOException {
        SoapEncUtils.generateStructureHeader(inScopeEncStyle, javaType, context, sink, nsStack, xjmr, null, null, false);
    }

    private static void generateStructureHeader(String inScopeEncStyle, Class javaType, Object context, Writer sink, NSStack nsStack, XMLJavaMappingRegistry xjmr, QName arrayElementType, String arrayLengthStr, boolean isNull) throws IllegalArgumentException, IOException {
        String namespaceURI;
        PrefixedName pname;
        QName qname;
        QName elementType = xjmr.queryElementType(javaType, "http://schemas.xmlsoap.org/soap/encoding/");
        String namespaceDecl = "";
        if (context instanceof PrefixedName && (qname = (pname = (PrefixedName)context).getQName()) != null && (namespaceURI = qname.getNamespaceURI()) != null && !namespaceURI.equals("") && pname.getPrefix() == null) {
            String prefix = nsStack.getPrefixFromURI(namespaceURI);
            if (prefix == null) {
                prefix = nsStack.addNSDeclaration(namespaceURI);
                namespaceDecl = " xmlns:" + prefix + "=\"" + namespaceURI + '\"';
            }
            pname.setPrefix(prefix);
        }
        sink.write('<' + context.toString() + namespaceDecl);
        String elementTypeNS = elementType.getNamespaceURI();
        String xsiNamespaceURI = "http://www.w3.org/2001/XMLSchema-instance";
        if (elementTypeNS.startsWith("http://www.w3.org/") && elementTypeNS.endsWith("/XMLSchema")) {
            xsiNamespaceURI = elementTypeNS + "-instance";
        }
        String xsiNSPrefix = nsStack.getPrefixFromURI(xsiNamespaceURI, sink);
        String elementTypeNSPrefix = nsStack.getPrefixFromURI(elementTypeNS, sink);
        sink.write(' ' + xsiNSPrefix + ':' + "type" + "=\"" + elementTypeNSPrefix + ':' + elementType.getLocalPart() + '\"');
        if (inScopeEncStyle == null || !inScopeEncStyle.equals("http://schemas.xmlsoap.org/soap/encoding/")) {
            String soapEnvNSPrefix = nsStack.getPrefixFromURI("http://schemas.xmlsoap.org/soap/envelope/", sink);
            sink.write(' ' + soapEnvNSPrefix + ':' + "encodingStyle" + "=\"" + "http://schemas.xmlsoap.org/soap/encoding/" + '\"');
        }
        if (arrayElementType != null) {
            String arrayElementTypeNSPrefix = nsStack.getPrefixFromURI(arrayElementType.getNamespaceURI(), sink);
            String arrayTypeValue = arrayElementTypeNSPrefix + ':' + arrayElementType.getLocalPart() + '[' + arrayLengthStr + ']';
            String soapEncNSPrefix = nsStack.getPrefixFromURI("http://schemas.xmlsoap.org/soap/encoding/", sink);
            sink.write(' ' + soapEncNSPrefix + ':' + "arrayType" + "=\"" + arrayTypeValue + '\"');
        }
        if (isNull) {
            sink.write(' ' + xsiNSPrefix + ':' + SoapEncUtils.nilName(xsiNamespaceURI) + "=\"" + Constants.ATTRVAL_TRUE + "\"/");
        }
        sink.write(62);
    }

    private static String nilName(String currentSchemaXSI) {
        return currentSchemaXSI.equals("http://www.w3.org/2001/XMLSchema-instance") ? "nil" : "null";
    }

    public static boolean isNull(Element element) {
        String nullValue = DOMUtils.getAttributeNS(element, "http://www.w3.org/2001/XMLSchema-instance", "nil");
        if (nullValue == null) {
            nullValue = DOMUtils.getAttributeNS(element, "http://www.w3.org/2000/10/XMLSchema-instance", "null");
        }
        if (nullValue == null) {
            nullValue = DOMUtils.getAttributeNS(element, "http://www.w3.org/1999/XMLSchema-instance", "null");
        }
        return nullValue != null && SoapEncUtils.decodeBooleanValue(nullValue);
    }

    public static boolean decodeBooleanValue(String value2) {
        switch (value2.charAt(0)) {
            case '0': 
            case 'F': 
            case 'f': {
                return false;
            }
            case '1': 
            case 'T': 
            case 't': {
                return true;
            }
        }
        throw new IllegalArgumentException("Invalid boolean value: " + value2);
    }

    public static QName getAttributeValue(Element el, String attrNameNamespaceURI, String attrNameLocalPart, String elDesc, boolean isRequired) throws IllegalArgumentException {
        String attrValue = DOMUtils.getAttributeNS(el, attrNameNamespaceURI, attrNameLocalPart);
        if (attrValue != null) {
            int index = attrValue.indexOf(58);
            if (index != -1) {
                String attrValuePrefix = attrValue.substring(0, index);
                String attrValueLocalPart = attrValue.substring(index + 1);
                String attrValueNamespaceURI = DOMUtils.getNamespaceURIFromPrefix(el, attrValuePrefix);
                if (attrValueNamespaceURI != null) {
                    return new QName(attrValueNamespaceURI, attrValueLocalPart);
                }
                throw new IllegalArgumentException("Unable to resolve namespace URI for '" + attrValuePrefix + "'.");
            }
            throw new IllegalArgumentException("The value of the '" + attrNameNamespaceURI + ':' + attrNameLocalPart + "' attribute must be " + "namespace-qualified.");
        }
        if (isRequired) {
            throw new IllegalArgumentException("The '" + attrNameNamespaceURI + ':' + attrNameLocalPart + "' attribute must be " + "specified for every " + elDesc + '.');
        }
        return null;
    }

    public static QName getTypeQName(Element el) throws IllegalArgumentException {
        QName typeQName = SoapEncUtils.getAttributeValue(el, "http://www.w3.org/2001/XMLSchema-instance", "type", null, false);
        if (typeQName != null) {
            return typeQName;
        }
        typeQName = SoapEncUtils.getAttributeValue(el, "http://www.w3.org/2000/10/XMLSchema-instance", "type", null, false);
        if (typeQName != null) {
            return typeQName;
        }
        typeQName = SoapEncUtils.getAttributeValue(el, "http://www.w3.org/1999/XMLSchema-instance", "type", null, false);
        return typeQName;
    }
}

