/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.messaging;

import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import javax.activation.DataHandler;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.xml.parsers.DocumentBuilder;
import org.apache.soap.Constants;
import org.apache.soap.Envelope;
import org.apache.soap.SOAPException;
import org.apache.soap.rpc.Call;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.transport.SOAPTransport;
import org.apache.soap.transport.http.SOAPHTTPConnection;
import org.apache.soap.util.xml.XMLParserUtils;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Message {
    SOAPTransport st;
    SOAPContext reqCtx = new SOAPContext();
    SOAPContext resCtx = null;
    DocumentBuilder xdb = XMLParserUtils.getXMLDocBuilder();

    public void setSOAPTransport(SOAPTransport st) {
        this.st = st;
    }

    public SOAPTransport getSOAPTransport() {
        return this.st;
    }

    public void send(URL url, String actionURI, Envelope env) throws SOAPException {
        if (this.st == null) {
            this.st = new SOAPHTTPConnection();
        }
        this.st.send(url, actionURI, null, env, null, this.reqCtx);
    }

    public Envelope receiveEnvelope() throws SOAPException {
        if (this.st == null) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Unable to receive without sending on an appropriate transport.");
        }
        try {
            this.resCtx = this.st.getResponseSOAPContext();
            String payloadStr = Call.getEnvelopeString(this.st);
            Document doc = this.xdb.parse(new InputSource(new StringReader(payloadStr)));
            if (doc == null) {
                throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Parsing error, response was:\n" + payloadStr);
            }
            return Envelope.unmarshall(doc.getDocumentElement(), this.resCtx);
        }
        catch (MessagingException me) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, me.getMessage(), me);
        }
        catch (SAXException ioe) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Parsing error, response was:\n" + ioe.getMessage(), ioe);
        }
        catch (IOException ioe) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, ioe.getMessage(), ioe);
        }
        catch (IllegalArgumentException e2) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, e2.getMessage(), e2);
        }
    }

    public DataHandler receive() throws SOAPException, MessagingException {
        if (this.st == null) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Unable to receive without sending on an appropriate transport.");
        }
        this.st.receive();
        this.resCtx = this.st.getResponseSOAPContext();
        return this.resCtx.getRootPart().getDataHandler();
    }

    public SOAPContext getRequestSOAPContext() {
        return this.reqCtx;
    }

    public void addBodyPart(MimeBodyPart part) throws MessagingException {
        this.reqCtx.addBodyPart(part);
    }

    public SOAPContext getResponseSOAPContext() {
        return this.resCtx;
    }

    public MimeBodyPart findBodyPart(String uri) {
        if (this.resCtx == null) {
            return null;
        }
        return this.resCtx.findBodyPart(uri);
    }

    public int getPartCount() throws MessagingException {
        if (this.resCtx == null) {
            return 0;
        }
        return this.resCtx.getCount();
    }

    public MimeBodyPart getBodyPart(int index) throws IndexOutOfBoundsException {
        if (this.resCtx == null) {
            return null;
        }
        return this.resCtx.getBodyPart(index);
    }

    public MimeBodyPart getRootPart() throws MessagingException {
        if (this.resCtx == null) {
            return null;
        }
        return this.resCtx.getRootPart();
    }
}

