/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.providers;

import java.lang.reflect.Method;
import java.rmi.Remote;
import java.util.Hashtable;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.rmi.PortableRemoteObject;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpSession;
import org.apache.soap.Constants;
import org.apache.soap.Envelope;
import org.apache.soap.SOAPException;
import org.apache.soap.providers.StatefulEJBProvider;
import org.apache.soap.rpc.Call;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.server.DeploymentDescriptor;

public class EntityEJBProvider
extends StatefulEJBProvider {
    public void locate(DeploymentDescriptor depDesc, Envelope env, Call origCall, String methodName, String targetObjectURI, SOAPContext reqContext) throws SOAPException {
        HttpServlet servletRef = (HttpServlet)reqContext.getProperty(Constants.BAG_HTTPSERVLET);
        HttpSession sessObj = (HttpSession)reqContext.getProperty(Constants.BAG_HTTPSESSION);
        this.setDd(depDesc);
        this.setCall(origCall);
        this.setTargetObjectURI(origCall.getTargetObjectURI());
        this.setServlet(servletRef);
        this.setSession(sessObj);
        this.setMethodName(origCall.getMethodName());
        this.setMethodParameters(origCall.getParams());
        String fullURI = origCall.getFullTargetObjectURI();
        this.ejbKey = StatefulEJBProvider.getUniqueId(fullURI);
        if (this.ejbKey != null) {
            this.setRemoteObjRef((Remote)this.deSerialize(this.ejbKey));
            return;
        }
        Hashtable props = depDesc.getProps();
        String ContxtProviderURL = (String)props.get("ContextProviderURL");
        String ContxtFactoryName = (String)props.get("FullContextFactoryName");
        if (ContxtProviderURL != null || ContxtFactoryName != null) {
            this.initialize(ContxtProviderURL, ContxtFactoryName);
        } else {
            this.initialize(CNTXT_PROVIDER_URL, CNTXT_FACTORY_NAME);
        }
        String homeInterfaceName = (String)props.get("FullHomeInterfaceName");
        if (homeInterfaceName == null) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Error in Deployment Descriptor Property Settings");
        }
        String jndiName = (String)props.get("JNDIName");
        if (jndiName == null) {
            jndiName = depDesc.getProviderClass();
        }
        if (jndiName != null && this.getContxt() != null) {
            try {
                EJBHome home = (EJBHome)PortableRemoteObject.narrow((Object)this.getContxt().lookup(jndiName), Class.forName(homeInterfaceName));
                if (this.getMethodName().equals("create") || this.getMethodName().startsWith("find")) {
                    this.setRemoteObjRef((Remote)home);
                    this.isCreate = true;
                    return;
                }
                Method createMethod = home.getClass().getMethod("create", new Class[0]);
                this.setRemoteObjRef((Remote)((EJBObject)createMethod.invoke((Object)home, new Object[0])));
            }
            catch (Exception e2) {
                throw new SOAPException(Constants.FAULT_CODE_SERVER, "Error in connecting to EJB", e2);
            }
        }
    }
}

