/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.providers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpSession;
import org.apache.soap.Constants;
import org.apache.soap.Envelope;
import org.apache.soap.SOAPException;
import org.apache.soap.encoding.soapenc.Base64;
import org.apache.soap.rpc.Call;
import org.apache.soap.rpc.Parameter;
import org.apache.soap.rpc.RPCConstants;
import org.apache.soap.rpc.Response;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.server.DeploymentDescriptor;
import org.apache.soap.util.Bean;
import org.apache.soap.util.MethodUtils;
import org.apache.soap.util.Provider;

public class StatefulEJBProvider
implements Provider {
    public static String CNTXT_PROVIDER_URL = "iiop://localhost:900";
    public static String CNTXT_FACTORY_NAME = "com.ibm.ejs.ns.jndi.CNInitialContextFactory";
    protected boolean isCreate = false;
    protected String ejbKey = null;
    public static String DELIM_CHAR = "@";
    private DeploymentDescriptor dd;
    private Envelope envelope;
    private Call call;
    private String targetObjectURI;
    private HttpServlet servlet;
    private HttpSession session;
    private Context contxt = null;
    private Remote remoteObjRef = null;
    private String methodName = null;
    private Vector methodParameters = null;
    private String respEncStyle = null;

    public EJBObject deSerialize(String ejbKey) throws SOAPException {
        try {
            byte[] ejbKeyBytes = Base64.decode(ejbKey);
            ByteArrayInputStream byteStream = new ByteArrayInputStream(ejbKeyBytes);
            ObjectInputStream objStream = new ObjectInputStream(byteStream);
            Handle ejbHandle = (Handle)objStream.readObject();
            objStream.close();
            return ejbHandle.getEJBObject();
        }
        catch (Exception e2) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, e2.toString());
        }
    }

    public Call getCall() {
        return this.call;
    }

    public Context getContxt() {
        return this.contxt;
    }

    public DeploymentDescriptor getDd() {
        return this.dd;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Vector getMethodParameters() {
        return this.methodParameters;
    }

    public Remote getRemoteObjRef() {
        return this.remoteObjRef;
    }

    public String getRespEncStyle() {
        return this.respEncStyle;
    }

    public HttpServlet getServlet() {
        return this.servlet;
    }

    public HttpSession getSession() {
        return this.session;
    }

    public String getTargetObjectURI() {
        return this.targetObjectURI;
    }

    public static String getUniqueId(String fullURI) {
        int occurance = fullURI.indexOf(DELIM_CHAR);
        if (occurance > 0) {
            return fullURI.substring(occurance + 1);
        }
        return null;
    }

    protected void initialize(String url, String factory) throws SOAPException {
        if (this.contxt == null) {
            Properties properties = new Properties();
            if (url != null && !url.trim().equals("")) {
                properties.put("java.naming.provider.url", url);
            }
            if (factory != null && !factory.trim().equals("")) {
                properties.put("java.naming.factory.initial", factory);
            }
            try {
                this.contxt = new InitialContext(properties);
            }
            catch (NamingException ne) {
                System.out.println("Naming Exception caught during InitialContext creation @ " + url);
                throw new SOAPException(Constants.FAULT_CODE_SERVER, "Unable to initialize context");
            }
        }
    }

    public void invoke(SOAPContext reqContext, SOAPContext resContext) throws SOAPException {
        Parameter ret = null;
        Object[] args = null;
        Class[] argTypes = null;
        this.respEncStyle = this.call.getEncodingStyleURI();
        if (this.methodParameters != null) {
            int parametersCount = this.methodParameters.size();
            args = new Object[parametersCount];
            argTypes = new Class[parametersCount];
            for (int i = 0; i < parametersCount; ++i) {
                Parameter param = (Parameter)this.methodParameters.elementAt(i);
                args[i] = param.getValue();
                argTypes[i] = param.getType();
                if (this.respEncStyle != null) continue;
                this.respEncStyle = param.getEncodingStyleURI();
            }
        }
        if (this.respEncStyle == null) {
            this.respEncStyle = "http://schemas.xmlsoap.org/soap/encoding/";
        }
        try {
            Method m = MethodUtils.getMethod(this.remoteObjRef, this.methodName, argTypes);
            Bean result = new Bean(m.getReturnType(), m.invoke((Object)this.remoteObjRef, args));
            if (result.type != Void.TYPE) {
                ret = new Parameter(RPCConstants.ELEM_RETURN, result.type, result.value, null);
            }
        }
        catch (InvocationTargetException e2) {
            Throwable t = e2.getTargetException();
            throw new SOAPException(Constants.FAULT_CODE_SERVER, t.getMessage(), t);
        }
        catch (Throwable t) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, t.getMessage(), t);
        }
        if (this.isCreate) {
            try {
                this.remoteObjRef = (Remote)ret.getValue();
            }
            catch (ClassCastException cce) {
                Enumeration enumeration = (Enumeration)ret.getValue();
                this.remoteObjRef = (Remote)enumeration.nextElement();
            }
            ret = null;
        }
        if (this.ejbKey == null) {
            this.serialize();
        }
        try {
            Response res = new Response(this.targetObjectURI, this.call.getMethodName(), ret, null, null, this.respEncStyle, resContext);
            res.setFullTargetObjectURI(this.targetObjectURI + DELIM_CHAR + this.ejbKey);
            Envelope env = res.buildEnvelope();
            StringWriter sw = new StringWriter();
            env.marshall(sw, this.call.getSOAPMappingRegistry(), resContext);
            resContext.setRootPart(sw.toString(), "text/xml;charset=utf-8");
        }
        catch (Exception e3) {
            if (e3 instanceof SOAPException) {
                throw (SOAPException)e3;
            }
            throw new SOAPException(Constants.FAULT_CODE_SERVER, e3.toString());
        }
    }

    public void locate(DeploymentDescriptor depDesc, Envelope env, Call origCall, String methodName, String targURI, SOAPContext reqContext) throws SOAPException {
        HttpServlet servletRef = (HttpServlet)reqContext.getProperty(Constants.BAG_HTTPSERVLET);
        HttpSession sessObj = (HttpSession)reqContext.getProperty(Constants.BAG_HTTPSESSION);
        this.dd = depDesc;
        this.envelope = env;
        this.call = origCall;
        this.targetObjectURI = origCall.getTargetObjectURI();
        this.servlet = servletRef;
        this.session = sessObj;
        this.methodName = origCall.getMethodName();
        this.methodParameters = origCall.getParams();
        String fullURI = origCall.getFullTargetObjectURI();
        this.ejbKey = StatefulEJBProvider.getUniqueId(fullURI);
        if (this.ejbKey != null) {
            this.remoteObjRef = this.deSerialize(this.ejbKey);
            return;
        }
        Hashtable props = this.dd.getProps();
        String ContxtProviderURL = (String)props.get("ContextProviderURL");
        String ContxtFactoryName = (String)props.get("FullContextFactoryName");
        if (ContxtProviderURL != null || ContxtFactoryName != null) {
            this.initialize(ContxtProviderURL, ContxtFactoryName);
        } else {
            this.initialize(CNTXT_PROVIDER_URL, CNTXT_FACTORY_NAME);
        }
        String homeInterfaceName = (String)props.get("FullHomeInterfaceName");
        if (homeInterfaceName == null) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Error in Deployment Descriptor Property Settings");
        }
        String jndiName = (String)props.get("JNDIName");
        if (jndiName == null) {
            jndiName = this.dd.getProviderClass();
        }
        if (jndiName != null && this.contxt != null) {
            try {
                EJBHome home = (EJBHome)PortableRemoteObject.narrow((Object)this.contxt.lookup(jndiName), Class.forName(homeInterfaceName));
                if (methodName.equals("create")) {
                    this.remoteObjRef = home;
                    this.isCreate = true;
                    return;
                }
                Method createMethod = home.getClass().getMethod("create", new Class[0]);
                this.remoteObjRef = (EJBObject)createMethod.invoke((Object)home, new Object[0]);
            }
            catch (Exception e2) {
                throw new SOAPException(Constants.FAULT_CODE_SERVER, "Error in connecting to EJB" + e2.toString());
            }
        }
    }

    public void serialize() throws SOAPException {
        try {
            ByteArrayOutputStream biteStream = new ByteArrayOutputStream();
            ObjectOutputStream objector = new ObjectOutputStream(biteStream);
            objector.writeObject(((EJBObject)this.remoteObjRef).getHandle());
            objector.flush();
            objector.close();
            this.ejbKey = Base64.encode(biteStream.toByteArray());
        }
        catch (Exception e2) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, e2.toString());
        }
    }

    public void setCall(Call newCall) {
        this.call = newCall;
    }

    public void setContxt(Context newContxt) {
        this.contxt = newContxt;
    }

    public void setDd(DeploymentDescriptor newDd) {
        this.dd = newDd;
    }

    public void setMethodName(String newMethodName) {
        this.methodName = newMethodName;
    }

    public void setMethodParameters(Vector newMethodParameters) {
        this.methodParameters = newMethodParameters;
    }

    public void setRemoteObjRef(Remote newRemoteObjRef) {
        this.remoteObjRef = newRemoteObjRef;
    }

    public void setRespEncStyle(String newRespEncStyle) {
        this.respEncStyle = newRespEncStyle;
    }

    public void setServlet(HttpServlet newServlet) {
        this.servlet = newServlet;
    }

    public void setSession(HttpSession newSession) {
        this.session = newSession;
    }

    public void setTargetObjectURI(String newTargetObjectURI) {
        this.targetObjectURI = newTargetObjectURI;
    }
}

