/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.rpc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.xml.parsers.DocumentBuilder;
import org.apache.soap.Constants;
import org.apache.soap.Envelope;
import org.apache.soap.Header;
import org.apache.soap.SOAPException;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.rpc.RPCMessage;
import org.apache.soap.rpc.Response;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.server.ServiceManager;
import org.apache.soap.transport.SOAPTransport;
import org.apache.soap.transport.http.SOAPHTTPConnection;
import org.apache.soap.util.IOUtils;
import org.apache.soap.util.net.SSLUtils;
import org.apache.soap.util.xml.XMLParserUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Call
extends RPCMessage {
    private DocumentBuilder xdb;
    private SOAPMappingRegistry smr = null;
    private SOAPTransport st = null;
    private int to = 0;
    private static Map tested_ipaddrs = Collections.synchronizedMap(new HashMap());
    public static boolean traceEnabled = SSLUtils.traceEnabled;

    public Call() {
        this(null, null, null, null, null);
    }

    public Call(String targetObjectURI, String methodName, Vector params, Header header2, String encodingStyleURI) {
        this(targetObjectURI, methodName, params, header2, encodingStyleURI, new SOAPContext());
    }

    public Call(String targetObjectURI, String methodName, Vector params, Header header2, String encodingStyleURI, SOAPContext ctx) {
        super(targetObjectURI, methodName, params, header2, encodingStyleURI, ctx);
    }

    public void setSOAPMappingRegistry(SOAPMappingRegistry smr) {
        this.smr = smr;
    }

    public SOAPMappingRegistry getSOAPMappingRegistry() {
        if (this.smr == null) {
            this.smr = new SOAPMappingRegistry();
        }
        return this.smr;
    }

    public void setSOAPTransport(SOAPTransport st) {
        this.st = st;
    }

    public SOAPTransport getSOAPTransport() {
        return this.st;
    }

    public void setTimeout(int value2) {
        this.to = value2;
    }

    public int getTimeout() {
        return this.to;
    }

    public void addBodyPart(MimeBodyPart part) throws MessagingException {
        this.ctx.addBodyPart(part);
    }

    public void removeBodyPart(MimeBodyPart part) throws MessagingException {
        this.ctx.removeBodyPart(part);
    }

    public Envelope buildEnvelope() {
        return super.buildEnvelope(false);
    }

    public static Call extractFromEnvelope(Envelope env, ServiceManager svcMgr, SOAPContext ctx) throws IllegalArgumentException {
        return (Call)RPCMessage.extractFromEnvelope(env, svcMgr, false, null, ctx);
    }

    public static String getEnvelopeString(SOAPTransport st) throws SOAPException, MessagingException, IOException {
        SOAPContext respCtx = st.getResponseSOAPContext();
        BufferedReader in = null;
        String payloadStr = null;
        MimeBodyPart rootPart = respCtx.getRootPart();
        if (rootPart.isMimeType("text/*")) {
            in = st.receive();
            payloadStr = IOUtils.getStringFromReader(in);
        }
        if (!rootPart.isMimeType("text/xml")) {
            throw new SOAPException(Constants.FAULT_CODE_PROTOCOL, "Unsupported response content type \"" + rootPart.getContentType() + "\", must be: \"" + "text/xml" + "\"." + (payloadStr == null ? "" : " Response was:\n" + payloadStr));
        }
        return payloadStr;
    }

    public Response invoke(URL url, String SOAPActionURI) throws SOAPException {
        if (SOAPActionURI == null) {
            SOAPActionURI = "";
        }
        if (this.smr == null) {
            this.smr = new SOAPMappingRegistry();
        }
        if (this.xdb == null) {
            this.xdb = XMLParserUtils.getXMLDocBuilder();
        }
        try {
            Envelope callEnv = this.buildEnvelope();
            if (this.st == null) {
                this.st = new SOAPHTTPConnection();
            }
            if (this.to != 0 && this.st instanceof SOAPHTTPConnection) {
                ((SOAPHTTPConnection)this.st).setTimeout(this.to);
            }
            this.st.send(url, SOAPActionURI, null, callEnv, this.smr, this.ctx);
            SOAPContext respCtx = this.st.getResponseSOAPContext();
            String payloadStr = Call.getEnvelopeString(this.st);
            Document respDoc = this.xdb.parse(new InputSource(new StringReader(payloadStr)));
            Element payload = null;
            if (respDoc == null) {
                throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Parsing error, response was:\n" + payloadStr);
            }
            payload = respDoc.getDocumentElement();
            Envelope respEnv = Envelope.unmarshall(payload, respCtx);
            Response resp = Response.extractFromEnvelope(respEnv, this.smr, respCtx);
            String fullTargetObjectURI = resp.getFullTargetObjectURI();
            if (fullTargetObjectURI != null) {
                this.setTargetObjectURI(fullTargetObjectURI);
            }
            return resp;
        }
        catch (MessagingException me) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, me.getMessage(), me);
        }
        catch (IllegalArgumentException e2) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, e2.getMessage(), e2);
        }
        catch (SAXException e3) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Parsing error, response was:\n" + e3.getMessage(), e3);
        }
        catch (IOException e4) {
            throw new SOAPException(Constants.FAULT_CODE_PROTOCOL, e4.getMessage(), e4);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Response WASinvoke(URL url, String SOAPActionURI) throws SOAPException {
        if (traceEnabled) {
            System.out.println("org.apache.soap.rpc.Call.WASinvoke > Entry");
            System.out.println("org.apache.soap.rpc.Call.WASinvoke: url=" + url.toString());
        }
        if (SOAPActionURI == null) {
            SOAPActionURI = "";
        }
        if (this.smr == null) {
            this.smr = new SOAPMappingRegistry();
        }
        if (this.xdb == null) {
            this.xdb = XMLParserUtils.getXMLDocBuilder();
        }
        String host = null;
        boolean isFail = false;
        try {
            Response response;
            try {
                host = url.getHost();
                Envelope callEnv = this.buildEnvelope();
                String urlStr = null;
                String tested_connection = (String)tested_ipaddrs.get(host);
                if (tested_connection != null) {
                    urlStr = url.getProtocol() + "://" + tested_connection + ":" + url.getPort() + "/";
                    if (traceEnabled) {
                        System.out.println("org.apache.soap.rpc.Call.WASinvoke: use cached tested connection , url=" + urlStr);
                    }
                } else {
                    InetAddress[] all_inetaddrs = null;
                    try {
                        all_inetaddrs = InetAddress.getAllByName(host);
                    }
                    catch (UnknownHostException e2) {
                        new SOAPException(Constants.FAULT_CODE_CLIENT, e2.getMessage(), e2);
                    }
                    if (all_inetaddrs != null) {
                        for (int i = 0; i < all_inetaddrs.length; ++i) {
                            try {
                                Socket s = new Socket(all_inetaddrs[i], url.getPort());
                                s.close();
                                tested_connection = all_inetaddrs[i].getHostAddress();
                                if (tested_connection.indexOf(58) > -1 && tested_connection.indexOf(91) < 0) {
                                    tested_connection = "[" + tested_connection + "]";
                                }
                                urlStr = url.getProtocol() + "://" + tested_connection + ":" + url.getPort() + "/";
                                if (traceEnabled) {
                                    System.out.println("org.apache.soap.rpc.Call.WASinvoke: InetAddress No. " + i + ", url=" + urlStr);
                                }
                                tested_ipaddrs.put(host, tested_connection);
                                break;
                            }
                            catch (Exception e3) {
                                new SOAPException(Constants.FAULT_CODE_CLIENT, e3.getMessage(), e3);
                                continue;
                            }
                        }
                    }
                }
                url = new URL(urlStr);
                if (traceEnabled) {
                    System.out.println("org.apache.soap.rpc.Call.WASinvoke: url=" + urlStr);
                }
                if (this.st == null) {
                    this.st = new SOAPHTTPConnection();
                }
                if (this.to != 0 && this.st instanceof SOAPHTTPConnection) {
                    ((SOAPHTTPConnection)this.st).setTimeout(this.to);
                }
                this.st.send(url, SOAPActionURI, null, callEnv, this.smr, this.ctx, host);
                SOAPContext respCtx = this.st.getResponseSOAPContext();
                String payloadStr = Call.getEnvelopeString(this.st);
                Document respDoc = this.xdb.parse(new InputSource(new StringReader(payloadStr)));
                Element payload = null;
                if (respDoc == null) throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Parsing error, response was:\n" + payloadStr);
                payload = respDoc.getDocumentElement();
                Envelope respEnv = Envelope.unmarshall(payload, respCtx);
                Response resp = Response.extractFromEnvelope(respEnv, this.smr, respCtx);
                String fullTargetObjectURI = resp.getFullTargetObjectURI();
                if (fullTargetObjectURI != null) {
                    this.setTargetObjectURI(fullTargetObjectURI);
                }
                if (traceEnabled) {
                    System.out.println("org.apache.soap.rpc.Call.WASinvoke > Exit");
                    System.out.println("org.apache.soap.rpc.Call.WASinvoke: url=" + url.toString());
                }
                response = resp;
                Object var17_23 = null;
                if (!isFail) return response;
            }
            catch (MessagingException me) {
                isFail = true;
                throw new SOAPException(Constants.FAULT_CODE_CLIENT, me.getMessage(), me);
            }
            catch (IllegalArgumentException e4) {
                isFail = true;
                throw new SOAPException(Constants.FAULT_CODE_CLIENT, e4.getMessage(), e4);
            }
            catch (SAXException e5) {
                isFail = true;
                throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Parsing error, response was:\n" + e5.getMessage(), e5);
            }
            catch (IOException e6) {
                isFail = true;
                throw new SOAPException(Constants.FAULT_CODE_PROTOCOL, e6.getMessage(), e6);
            }
            if (tested_ipaddrs.get(host) == null) return response;
            tested_ipaddrs.put(host, null);
            return response;
        }
        catch (Throwable throwable) {
            Object var17_24 = null;
            if (!isFail) throw throwable;
            if (tested_ipaddrs.get(host) == null) throw throwable;
            tested_ipaddrs.put(host, null);
            throw throwable;
        }
    }

    static {
        String propName = "org.apache.soap.debug";
        try {
            String envString = System.getProperty(propName);
            boolean envValue = SSLUtils.isTrueExplicitly(envString);
            if (envValue) {
                traceEnabled = true;
            }
            if (traceEnabled) {
                String strSetting = envValue ? "enabled" : "disabled";
                System.out.println(propName + " is " + strSetting);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

