/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.rpc;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Vector;
import org.apache.soap.Body;
import org.apache.soap.Constants;
import org.apache.soap.Envelope;
import org.apache.soap.Fault;
import org.apache.soap.Header;
import org.apache.soap.SOAPException;
import org.apache.soap.Utils;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.rpc.Call;
import org.apache.soap.rpc.Parameter;
import org.apache.soap.rpc.RPCConstants;
import org.apache.soap.rpc.Response;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.server.DeploymentDescriptor;
import org.apache.soap.server.ServiceManager;
import org.apache.soap.util.Bean;
import org.apache.soap.util.StringUtils;
import org.apache.soap.util.xml.DOMUtils;
import org.apache.soap.util.xml.NSStack;
import org.apache.soap.util.xml.QName;
import org.apache.soap.util.xml.Serializer;
import org.apache.soap.util.xml.XMLJavaMappingRegistry;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RPCMessage
implements Serializer {
    protected String targetObjectURI;
    protected String fullTargetObjectURI;
    protected String methodName;
    protected Vector params;
    protected Header header;
    protected String encodingStyleURI;
    protected SOAPContext ctx;
    static /* synthetic */ Class class$org$apache$soap$rpc$Response;
    static /* synthetic */ Class class$org$apache$soap$rpc$Call;
    static /* synthetic */ Class class$org$apache$soap$rpc$Parameter;

    protected RPCMessage(String targetObjectURI, String methodName, Vector params, Header header2, String encodingStyleURI, SOAPContext ctx) {
        this.setTargetObjectURI(targetObjectURI);
        this.methodName = methodName;
        this.params = params;
        this.header = header2;
        this.encodingStyleURI = encodingStyleURI;
        this.ctx = ctx;
    }

    public void setTargetObjectURI(String targetObjectURI) {
        this.fullTargetObjectURI = targetObjectURI;
        this.targetObjectURI = StringUtils.parseFullTargetObjectURI(targetObjectURI);
    }

    public String getTargetObjectURI() {
        return this.targetObjectURI;
    }

    public void setFullTargetObjectURI(String targetObjectURI) {
        this.setTargetObjectURI(targetObjectURI);
    }

    public String getFullTargetObjectURI() {
        return this.fullTargetObjectURI;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setParams(Vector params) {
        this.params = params;
    }

    public Vector getParams() {
        return this.params;
    }

    public void setHeader(Header header2) {
        this.header = header2;
    }

    public Header getHeader() {
        return this.header;
    }

    public void setEncodingStyleURI(String encodingStyleURI) {
        this.encodingStyleURI = encodingStyleURI;
    }

    public String getEncodingStyleURI() {
        return this.encodingStyleURI;
    }

    protected void setSOAPContext(SOAPContext ctx) {
        this.ctx = ctx;
    }

    public SOAPContext getSOAPContext() {
        return this.ctx;
    }

    protected Envelope buildEnvelope(boolean isResponse) {
        Envelope env = new Envelope();
        Body body = new Body();
        Vector<Bean> bodyEntries = new Vector<Bean>();
        Class clazz = isResponse ? (class$org$apache$soap$rpc$Response == null ? (class$org$apache$soap$rpc$Response = RPCMessage.class$("org.apache.soap.rpc.Response")) : class$org$apache$soap$rpc$Response) : (class$org$apache$soap$rpc$Call == null ? (class$org$apache$soap$rpc$Call = RPCMessage.class$("org.apache.soap.rpc.Call")) : class$org$apache$soap$rpc$Call);
        bodyEntries.addElement(new Bean(clazz, this));
        body.setBodyEntries(bodyEntries);
        env.setBody(body);
        env.setHeader(this.header);
        return env;
    }

    protected static RPCMessage extractFromEnvelope(Envelope env, ServiceManager svcMgr, boolean isResponse, SOAPMappingRegistry respSMR, SOAPContext ctx) throws IllegalArgumentException {
        Body body = env.getBody();
        Vector bodyEntries = body.getBodyEntries();
        RPCMessage msg = null;
        if (bodyEntries.size() > 0) {
            Element msgEl = (Element)bodyEntries.elementAt(0);
            Class clazz = isResponse ? (class$org$apache$soap$rpc$Response == null ? (class$org$apache$soap$rpc$Response = RPCMessage.class$("org.apache.soap.rpc.Response")) : class$org$apache$soap$rpc$Response) : (class$org$apache$soap$rpc$Call == null ? (class$org$apache$soap$rpc$Call = RPCMessage.class$("org.apache.soap.rpc.Call")) : class$org$apache$soap$rpc$Call);
            Class toClass = clazz;
            String declEnvEncStyle = env.getAttribute(new QName("http://schemas.xmlsoap.org/soap/envelope/", "encodingStyle"));
            String declBodyEncStyle = body.getAttribute(new QName("http://schemas.xmlsoap.org/soap/envelope/", "encodingStyle"));
            String actualEncStyle = declBodyEncStyle != null ? declBodyEncStyle : declEnvEncStyle;
            msg = RPCMessage.unmarshall(actualEncStyle, msgEl, toClass, svcMgr, respSMR, ctx);
            msg.setHeader(env.getHeader());
            return msg;
        }
        throw new IllegalArgumentException("An '" + Constants.Q_ELEM_BODY + "' element must contain a " + "child element.");
    }

    public void marshall(String inScopeEncStyle, Class javaType, Object src, Object context, Writer sink, NSStack nsStack, XMLJavaMappingRegistry xjmr, SOAPContext ctx) throws IllegalArgumentException, IOException {
        String actualMsgEncStyle;
        nsStack.pushScope();
        RPCMessage msg = (RPCMessage)src;
        boolean isResponse = javaType == (class$org$apache$soap$rpc$Response == null ? (class$org$apache$soap$rpc$Response = RPCMessage.class$("org.apache.soap.rpc.Response")) : class$org$apache$soap$rpc$Response);
        String targetObjectURI = Utils.cleanString(msg.getFullTargetObjectURI());
        String methodName = msg.getMethodName();
        Vector params = msg.getParams();
        String suffix = isResponse ? RPCConstants.RESPONSE_SUFFIX : "";
        String declMsgEncStyle = msg.getEncodingStyleURI();
        String string = actualMsgEncStyle = declMsgEncStyle != null ? declMsgEncStyle : inScopeEncStyle;
        if (isResponse) {
            Response resp = (Response)msg;
            if (!resp.generatedFault()) {
                StringWriter nsDeclSW = new StringWriter();
                String targetObjectNSPrefix = nsStack.getPrefixFromURI(targetObjectURI, nsDeclSW);
                sink.write('<' + targetObjectNSPrefix + ':' + methodName + suffix + nsDeclSW);
                String soapEnvNSPrefix = nsStack.getPrefixFromURI("http://schemas.xmlsoap.org/soap/envelope/", sink);
                if (declMsgEncStyle != null && !declMsgEncStyle.equals(inScopeEncStyle)) {
                    sink.write(' ' + soapEnvNSPrefix + ':' + "encodingStyle" + "=\"" + declMsgEncStyle + '\"');
                }
                sink.write('>' + StringUtils.lineSeparator);
                Parameter ret = resp.getReturnValue();
                if (ret != null) {
                    String declParamEncStyle = ret.getEncodingStyleURI();
                    String actualParamEncStyle = declParamEncStyle != null ? declParamEncStyle : actualMsgEncStyle;
                    Serializer ser = xjmr.querySerializer(class$org$apache$soap$rpc$Parameter == null ? (class$org$apache$soap$rpc$Parameter = RPCMessage.class$("org.apache.soap.rpc.Parameter")) : class$org$apache$soap$rpc$Parameter, actualParamEncStyle);
                    ser.marshall(actualMsgEncStyle, class$org$apache$soap$rpc$Parameter == null ? (class$org$apache$soap$rpc$Parameter = RPCMessage.class$("org.apache.soap.rpc.Parameter")) : class$org$apache$soap$rpc$Parameter, ret, null, sink, nsStack, xjmr, ctx);
                    sink.write(StringUtils.lineSeparator);
                }
                this.serializeParams(params, actualMsgEncStyle, sink, nsStack, xjmr, ctx);
                sink.write("</" + targetObjectNSPrefix + ':' + methodName + suffix + '>' + StringUtils.lineSeparator);
            } else {
                Fault fault2 = resp.getFault();
                fault2.marshall(actualMsgEncStyle, sink, nsStack, xjmr, ctx);
            }
        } else {
            StringWriter nsDeclSW = new StringWriter();
            String targetObjectNSPrefix = nsStack.getPrefixFromURI(targetObjectURI, nsDeclSW);
            sink.write('<' + targetObjectNSPrefix + ':' + methodName + suffix + nsDeclSW);
            String soapEnvNSPrefix = nsStack.getPrefixFromURI("http://schemas.xmlsoap.org/soap/envelope/", sink);
            if (declMsgEncStyle != null && !declMsgEncStyle.equals(inScopeEncStyle)) {
                sink.write(' ' + soapEnvNSPrefix + ':' + "encodingStyle" + "=\"" + declMsgEncStyle + '\"');
            }
            sink.write('>' + StringUtils.lineSeparator);
            this.serializeParams(params, actualMsgEncStyle, sink, nsStack, xjmr, ctx);
            sink.write("</" + targetObjectNSPrefix + ':' + methodName + suffix + '>');
        }
        nsStack.popScope();
    }

    private void serializeParams(Vector params, String inScopeEncStyle, Writer sink, NSStack nsStack, XMLJavaMappingRegistry xjmr, SOAPContext ctx) throws IOException {
        if (params != null) {
            int size = params.size();
            for (int i = 0; i < size; ++i) {
                Parameter param = (Parameter)params.elementAt(i);
                String declParamEncStyle = param.getEncodingStyleURI();
                String actualParamEncStyle = declParamEncStyle != null ? declParamEncStyle : inScopeEncStyle;
                Serializer ser = xjmr.querySerializer(class$org$apache$soap$rpc$Parameter == null ? RPCMessage.class$("org.apache.soap.rpc.Parameter") : class$org$apache$soap$rpc$Parameter, actualParamEncStyle);
                ser.marshall(inScopeEncStyle, class$org$apache$soap$rpc$Parameter == null ? RPCMessage.class$("org.apache.soap.rpc.Parameter") : class$org$apache$soap$rpc$Parameter, param, null, sink, nsStack, xjmr, ctx);
                sink.write(StringUtils.lineSeparator);
            }
        }
    }

    public static RPCMessage unmarshall(String inScopeEncStyle, Node src, Class toClass, ServiceManager svcMgr, SOAPMappingRegistry respSMR, SOAPContext ctx) throws IllegalArgumentException {
        RPCMessage msg;
        String actualMsgEncStyle;
        SOAPMappingRegistry smr = null;
        Element root = (Element)src;
        boolean isResponse = toClass == (class$org$apache$soap$rpc$Response == null ? (class$org$apache$soap$rpc$Response = RPCMessage.class$("org.apache.soap.rpc.Response")) : class$org$apache$soap$rpc$Response);
        String fullTargetObjectURI = null;
        String targetObjectURI = null;
        String methodName = null;
        Parameter returnValue = null;
        Fault fault2 = null;
        Vector<Parameter> params = null;
        String declMsgEncStyle = DOMUtils.getAttributeNS(root, "http://schemas.xmlsoap.org/soap/envelope/", "encodingStyle");
        String string = actualMsgEncStyle = declMsgEncStyle != null ? declMsgEncStyle : inScopeEncStyle;
        if (isResponse && Constants.Q_ELEM_FAULT.matches(root)) {
            fault2 = Fault.unmarshall(actualMsgEncStyle, root, respSMR, ctx);
        } else {
            String actualParamEncStyle;
            String declParamEncStyle;
            String tagName = root.getLocalName();
            fullTargetObjectURI = root.getNamespaceURI();
            targetObjectURI = StringUtils.parseFullTargetObjectURI(fullTargetObjectURI);
            if (!isResponse) {
                DeploymentDescriptor dd = null;
                try {
                    dd = svcMgr.query(targetObjectURI);
                    smr = DeploymentDescriptor.buildSOAPMappingRegistry(dd, ctx);
                }
                catch (SOAPException e2) {
                    throw new IllegalArgumentException("Unable to resolve targetObjectURI '" + targetObjectURI + "'.");
                }
            } else {
                smr = respSMR;
            }
            smr.setDefaultEncodingStyle("http://schemas.xmlsoap.org/soap/encoding/");
            methodName = tagName;
            if (isResponse && methodName.endsWith(RPCConstants.RESPONSE_SUFFIX)) {
                methodName = methodName.substring(0, methodName.length() - 8);
            }
            Element tempEl = DOMUtils.getFirstChildElement(root);
            if (isResponse && tempEl != null) {
                declParamEncStyle = DOMUtils.getAttributeNS(tempEl, "http://schemas.xmlsoap.org/soap/envelope/", "encodingStyle");
                actualParamEncStyle = declParamEncStyle != null ? declParamEncStyle : actualMsgEncStyle;
                Bean returnBean = smr.unmarshall(actualParamEncStyle, RPCConstants.Q_ELEM_PARAMETER, tempEl, ctx);
                returnValue = (Parameter)returnBean.value;
                if (declParamEncStyle != null) {
                    returnValue.setEncodingStyleURI(declParamEncStyle);
                }
                tempEl = DOMUtils.getNextSiblingElement(tempEl);
            }
            if (tempEl != null) {
                params = new Vector<Parameter>();
                while (tempEl != null) {
                    declParamEncStyle = DOMUtils.getAttributeNS(tempEl, "http://schemas.xmlsoap.org/soap/envelope/", "encodingStyle");
                    actualParamEncStyle = declParamEncStyle != null ? declParamEncStyle : actualMsgEncStyle;
                    Bean paramBean = smr.unmarshall(actualParamEncStyle, RPCConstants.Q_ELEM_PARAMETER, tempEl, ctx);
                    Parameter param = (Parameter)paramBean.value;
                    if (declParamEncStyle != null) {
                        param.setEncodingStyleURI(declParamEncStyle);
                    }
                    params.addElement(param);
                    tempEl = DOMUtils.getNextSiblingElement(tempEl);
                }
            }
        }
        RPCMessage rPCMessage = isResponse ? (fault2 == null ? new Response(fullTargetObjectURI, methodName, returnValue, params, null, declMsgEncStyle, ctx) : new Response(fullTargetObjectURI, methodName, fault2, params, null, declMsgEncStyle, ctx)) : (msg = new Call(fullTargetObjectURI, methodName, params, null, actualMsgEncStyle, ctx));
        if (msg instanceof Call) {
            ((Call)msg).setSOAPMappingRegistry(smr);
        }
        return msg;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        boolean isResponse = this instanceof Response;
        pw.print("[Header=" + this.header + "] " + "[methodName=" + this.methodName + "] " + "[targetObjectURI=" + this.targetObjectURI + "] " + "[encodingStyleURI=" + this.encodingStyleURI + "] " + "[SOAPContext=" + this.ctx + "] ");
        if (isResponse) {
            Response res = (Response)this;
            if (res.generatedFault()) {
                pw.print("[fault=" + res.getFault() + "] ");
            } else {
                pw.println("[return=" + res.getReturnValue() + "] ");
            }
        }
        pw.print("[Params={");
        if (this.params != null) {
            for (int i = 0; i < this.params.size(); ++i) {
                if (i > 0) {
                    pw.print(", ");
                }
                pw.print("[" + this.params.elementAt(i) + "]");
            }
        }
        pw.print("}]");
        return sw.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

