/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.rpc;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.soap.util.mime.ByteArrayDataSource;
import org.apache.soap.util.mime.MimeUtils;

public class SOAPContext {
    protected MimeMultipart parts = null;
    protected Hashtable bag = new Hashtable();
    protected ClassLoader loader = null;
    protected boolean rootPartSet = false;
    private static final String[] ignoreHeaders = new String[]{"Message-ID", "Mime-Version"};
    private static final String DEFAULT_BASEURI = "thismessage:/";

    public void readMultipart(DataSource ds) throws MessagingException {
        this.parts = new MimeMultipart(ds);
    }

    public MimeBodyPart getBodyPart(int index) {
        if (this.parts == null) {
            return null;
        }
        try {
            return (MimeBodyPart)this.parts.getBodyPart(index);
        }
        catch (MessagingException me) {
            throw new IndexOutOfBoundsException(me.getMessage());
        }
        catch (IndexOutOfBoundsException iobe) {
            return null;
        }
        catch (NullPointerException npe) {
            return null;
        }
    }

    public MimeBodyPart getBodyPart(String CID) {
        if (this.parts == null) {
            return null;
        }
        try {
            return (MimeBodyPart)this.parts.getBodyPart(CID);
        }
        catch (MessagingException me) {
            return null;
        }
        catch (NullPointerException npe) {
            return null;
        }
        catch (IndexOutOfBoundsException iobe) {
            return null;
        }
    }

    public MimeBodyPart findBodyPart(String uri) {
        block8: {
            if (this.parts == null || uri == null) {
                return null;
            }
            try {
                if (uri.length() > 4 && uri.substring(0, 4).equalsIgnoreCase("cid:")) {
                    String cid = MimeUtils.decode(uri.substring(4));
                    if (cid.charAt(0) != '<' || cid.charAt(cid.length()) != '>') {
                        cid = '<' + cid + '>';
                    }
                    try {
                        return (MimeBodyPart)this.parts.getBodyPart(cid);
                    }
                    catch (NullPointerException nullPointerException) {
                        break block8;
                    }
                }
                return this.findPartByLocation(uri);
            }
            catch (MessagingException me) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getBaseURI() {
        String baseUri = null;
        try {
            baseUri = this.getRootPart().getHeader("Content-Location", null);
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        if (baseUri == null) {
            baseUri = DEFAULT_BASEURI;
        }
        return baseUri;
    }

    public MimeBodyPart findPartByLocation(String uri) {
        try {
            String baseUri = this.getBaseURI();
            uri = this.normalizeURI(uri, baseUri);
            if (uri == null) {
                return null;
            }
            for (int i = 0; i < this.parts.getCount(); ++i) {
                String partUri;
                MimeBodyPart part = this.getBodyPart(i);
                if (part == null || !uri.equals(this.normalizeURI(partUri = part.getHeader("Content-Location", null), baseUri))) continue;
                return part;
            }
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        return null;
    }

    private String normalizeURI(String uri, String baseUri) {
        String scheme;
        int p1 = uri.indexOf(58);
        if (p1 >= 0 && (scheme = uri.substring(0, p1)).indexOf(47) == -1 && scheme.indexOf(63) == -1 && scheme.indexOf(35) == -1) {
            return uri;
        }
        return baseUri + uri;
    }

    public void addBodyPart(MimeBodyPart part) throws MessagingException {
        this.addBodyPart(part, -1);
    }

    public void addBodyPart(MimeBodyPart part, int index) throws MessagingException, IllegalArgumentException {
        if (this.parts == null) {
            this.parts = new MimeMultipart("related");
        }
        DataHandler dh = part.getDataHandler();
        try {
            MimeType ctype = new MimeType(dh.getContentType());
            part.setHeader("Content-Type", ctype.toString());
            if (dh.getDataSource() instanceof ByteArrayDataSource) {
                part.setHeader("Content-Length", String.valueOf(((ByteArrayDataSource)dh.getDataSource()).getSize()));
            }
            if (ctype.match("application/octet-stream") || ctype.match("image/*") || ctype.match("audio/*") || ctype.match("video/*")) {
                part.setHeader("Content-Transfer-Encoding", "8bit");
            }
        }
        catch (MessagingException me) {
            throw new IllegalArgumentException("Invalid InputStream/DataSource/DataHandler metadata: " + (Object)((Object)me));
        }
        catch (MimeTypeParseException mtpe) {
            throw new IllegalArgumentException("Invalid Mime type \"" + dh.getContentType() + "\": " + (Object)((Object)mtpe));
        }
        if (index == -1) {
            this.parts.addBodyPart((BodyPart)part);
        } else {
            this.parts.addBodyPart((BodyPart)part, index);
        }
    }

    public void removeBodyPart(MimeBodyPart part) throws MessagingException {
        this.parts.removeBodyPart((BodyPart)part);
    }

    public void setRootPart(MimeBodyPart part) throws MessagingException {
        String rootCid = '<' + MimeUtils.getUniqueValue() + '>';
        part.setHeader("Content-ID", rootCid);
        if (this.rootPartSet) {
            this.parts.removeBodyPart((BodyPart)this.getRootPart());
        }
        this.addBodyPart(part, 0);
        this.rootPartSet = true;
    }

    public void setRootPart(String s, String contentType) throws MessagingException, IOException {
        this.setRootPart(s.getBytes("UTF8"), contentType);
    }

    public void setRootPart(byte[] b, String contentType) throws MessagingException {
        ByteArrayDataSource ds = new ByteArrayDataSource(b, contentType);
        DataHandler dh = new DataHandler((DataSource)ds);
        MimeBodyPart bp = new MimeBodyPart();
        bp.setDataHandler(dh);
        bp.setHeader("Content-Length", String.valueOf(ds.getSize()));
        bp.setHeader("Content-Transfer-Encoding", "8bit");
        this.setRootPart(bp);
    }

    public MimeBodyPart getRootPart() throws MessagingException {
        String startCid;
        MimeBodyPart rootPart = null;
        if (this.getCount() > 1 && (startCid = new ContentType(this.parts.getContentType()).getParameter("start")) != null) {
            rootPart = this.getBodyPart(MimeUtils.decode(startCid));
        }
        if (rootPart == null) {
            rootPart = this.getBodyPart(0);
        }
        return rootPart;
    }

    public void setSubType(String subtype) throws MessagingException {
        if (this.parts == null) {
            this.parts = new MimeMultipart(subtype);
        } else {
            this.parts.setSubType(subtype);
        }
    }

    public boolean isRootPartSet() {
        return this.rootPartSet;
    }

    public int getCount() throws MessagingException {
        if (this.parts == null) {
            return 0;
        }
        return this.parts.getCount();
    }

    public String getContentType() throws MessagingException {
        if (this.parts == null) {
            return null;
        }
        if (this.parts.getCount() == 1) {
            return this.getRootPart().getContentType();
        }
        return this.parts.getContentType();
    }

    public void writeTo(OutputStream os) throws IOException, MessagingException {
        int count = this.getCount();
        if (count == 0) {
            throw new IOException("Message is empty!");
        }
        if (count == 1) {
            this.getRootPart().writeTo(os);
        } else {
            Session session = Session.getDefaultInstance((Properties)new Properties(), null);
            MimeMessage msg = new MimeMessage(session);
            msg.setContent((Multipart)this.parts);
            msg.saveChanges();
            msg.writeTo(os, ignoreHeaders);
        }
    }

    public void setProperty(String name2, Object value2) {
        this.bag.put(name2, value2);
    }

    public Object getProperty(String name2) {
        return this.bag.get(name2);
    }

    public Object removeProperty(String name2) {
        return this.bag.remove(name2);
    }

    public Enumeration getPropertyNames() {
        return this.bag.keys();
    }

    public void setClassLoader(ClassLoader cl) {
        this.loader = cl;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        if (this.loader == null) {
            return Class.forName(className);
        }
        return Class.forName(className, true, this.loader);
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.print("[Parts={");
        if (this.parts != null) {
            try {
                for (int i = 0; i < this.getCount(); ++i) {
                    if (i > 0) {
                        pw.print(", ");
                    }
                    MimeBodyPart mbp = this.getBodyPart(i);
                    pw.print("[cid:" + mbp.getContentID() + " type: " + mbp.getContentType() + " enc: " + mbp.getEncoding() + "]");
                }
            }
            catch (MessagingException me) {
                me.printStackTrace();
            }
        }
        pw.print("}]");
        return sw.toString();
    }
}

