/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.server;

import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.server.SOAPFaultListener;
import org.apache.soap.server.SOAPFaultRouter;
import org.apache.soap.server.TypeMapping;
import org.apache.soap.util.xml.DOMUtils;
import org.apache.soap.util.xml.Deserializer;
import org.apache.soap.util.xml.QName;
import org.apache.soap.util.xml.Serializer;
import org.apache.soap.util.xml.XMLParserUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class DeploymentDescriptor
implements Serializable {
    public static final int SERVICE_TYPE_RPC = 0;
    public static final int SERVICE_TYPE_MESSAGE = 1;
    public static final int SCOPE_REQUEST = 0;
    public static final int SCOPE_SESSION = 1;
    public static final int SCOPE_APPLICATION = 2;
    public static final byte PROVIDER_JAVA = 0;
    public static final byte PROVIDER_SCRIPT_FILE = 1;
    public static final byte PROVIDER_SCRIPT_STRING = 2;
    public static final byte PROVIDER_USER_DEFINED = 3;
    protected String id;
    protected int serviceType = 0;
    protected int scope;
    protected byte providerType = (byte)-1;
    protected String providerClass;
    protected String serviceClass;
    protected Hashtable props;
    protected boolean isStatic;
    protected String scriptFilenameOrString;
    protected String scriptLanguage;
    protected String[] methods;
    protected TypeMapping[] mappings;
    transient SOAPMappingRegistry cachedSMR;
    protected String[] faultListener;
    private transient SOAPFaultRouter fr;
    private transient Map cachedServiceInfo;
    protected boolean checkMustUnderstands = false;
    private String defaultSMRClass = null;

    public void setID(String id) {
        this.id = id;
    }

    public String getID() {
        return this.id;
    }

    public boolean getCheckMustUnderstands() {
        return this.checkMustUnderstands;
    }

    public void setCheckMustUnderstands(boolean doIt) {
        this.checkMustUnderstands = doIt;
    }

    public void setServiceType(int serviceType) {
        this.serviceType = serviceType;
    }

    public int getServiceType() {
        return this.serviceType;
    }

    public void setScope(int scope) {
        this.scope = scope;
    }

    public int getScope() {
        return this.scope;
    }

    public void setDefaultSMRClass(String _defaultSMRClass) {
        this.defaultSMRClass = _defaultSMRClass;
    }

    public String getDefaultSMRClass() {
        return this.defaultSMRClass;
    }

    public void setMethods(String[] methods) {
        this.methods = methods;
    }

    public String[] getMethods() {
        return this.methods;
    }

    public void setProviderType(byte providerType) {
        this.providerType = providerType;
    }

    public byte getProviderType() {
        return this.providerType;
    }

    public void setServiceClass(String serviceClass) {
        this.serviceClass = serviceClass;
    }

    public String getServiceClass() {
        return this.serviceClass;
    }

    public Hashtable getProps() {
        return this.props;
    }

    public void setProps(Hashtable props) {
        this.props = props;
    }

    public void setProviderClass(String providerClass) {
        this.providerClass = providerClass;
    }

    public String getProviderClass() {
        return this.providerClass;
    }

    public void setIsStatic(boolean isStatic) {
        this.isStatic = isStatic;
    }

    public boolean getIsStatic() {
        return this.isStatic;
    }

    public void setScriptLanguage(String scriptLanguage) {
        this.scriptLanguage = scriptLanguage;
    }

    public String getScriptLanguage() {
        return this.scriptLanguage;
    }

    public void setScriptFilenameOrString(String scriptFilenameOrString) {
        this.scriptFilenameOrString = scriptFilenameOrString;
    }

    public String getScriptFilenameOrString() {
        return this.scriptFilenameOrString;
    }

    public void setMappings(TypeMapping[] mappings) {
        this.mappings = mappings;
    }

    public TypeMapping[] getMappings() {
        return this.mappings;
    }

    private void setCachedSMR(SOAPMappingRegistry cachedSMR) {
        this.cachedSMR = cachedSMR;
    }

    private SOAPMappingRegistry getCachedSMR() {
        return this.cachedSMR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCachedServiceInfo(String cachedInfoName, Object cachedInfo) {
        Object object;
        if (this.cachedServiceInfo == null) {
            object = this;
            synchronized (object) {
                if (this.cachedServiceInfo == null) {
                    this.cachedServiceInfo = Collections.synchronizedMap(new HashMap(8));
                }
            }
        }
        object = cachedInfoName;
        synchronized (object) {
            this.cachedServiceInfo.put(cachedInfoName, cachedInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getCachedServiceInfo(String cachedInfoName) {
        if (this.cachedServiceInfo == null) {
            return null;
        }
        String string = cachedInfoName;
        synchronized (string) {
            return this.cachedServiceInfo.get(cachedInfoName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCachedServiceInfo(String cachedInfoName) {
        if (this.cachedServiceInfo == null) {
            return false;
        }
        String string = cachedInfoName;
        synchronized (string) {
            return this.cachedServiceInfo.containsKey(cachedInfoName);
        }
    }

    public String[] getFaultListener() {
        return this.faultListener;
    }

    public void setFaultListener(String[] _faultListener) {
        this.faultListener = _faultListener;
    }

    public SOAPFaultRouter buildFaultRouter(SOAPContext ctxt) {
        if (this.fr != null) {
            return this.fr;
        }
        this.fr = new SOAPFaultRouter();
        if (this.faultListener == null) {
            return this.fr;
        }
        SOAPFaultListener[] lis = new SOAPFaultListener[this.faultListener.length];
        try {
            for (int i = 0; i < this.faultListener.length; ++i) {
                Class c = ctxt.loadClass(this.faultListener[i]);
                lis[i] = (SOAPFaultListener)c.newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.fr.setFaultListener(lis);
        return this.fr;
    }

    public void toXML(Writer pr) {
        int i;
        PrintWriter pw = new PrintWriter(pr);
        pw.println("<isd:service xmlns:isd=\"http://xml.apache.org/xml-soap/deployment\" id=\"" + this.id + "\"" + (this.serviceType != 0 ? " type=\"message\"" : "") + " checkMustUnderstands=\"" + (this.checkMustUnderstands ? "true" : "false") + "\"" + ">");
        byte pt = this.providerType;
        String[] scopes = new String[]{"Request", "Session", "Application"};
        String providerString = null;
        providerString = pt == 0 ? "java" : (pt == 3 ? this.serviceClass : "script");
        pw.print("  <isd:provider type=\"" + providerString + "\" scope=\"" + scopes[this.scope] + "\" methods=\"");
        for (i = 0; i < this.methods.length; ++i) {
            pw.print(this.methods[i]);
            if (i >= this.methods.length - 1) continue;
            pw.print(" ");
        }
        pw.println("\">");
        if (pt == 0) {
            pw.println("    <isd:java class=\"" + this.providerClass + "\" static=\"" + (this.isStatic ? "true" : "false") + "\"/>");
        } else if (pt == 1 || pt == 2) {
            pw.print("    <isd:script language=\"" + this.scriptLanguage + "\"");
            if (pt == 1) {
                pw.println(" source=\"" + this.scriptFilenameOrString + "\"/>");
            } else {
                pw.println(">");
                pw.println("      <![CDATA[");
                pw.println(this.scriptFilenameOrString);
                pw.println("      ]]>");
                pw.println("    </isd:script>");
            }
        } else if (pt == 3 && this.providerClass != null) {
            pw.println("    <isd:java class=\"" + this.providerClass + "\" static=\"" + (this.isStatic ? "true" : "false") + "\"/>");
        }
        if (this.props != null) {
            Enumeration e2 = this.props.keys();
            while (e2.hasMoreElements()) {
                String key = (String)e2.nextElement();
                String value2 = (String)this.props.get(key);
                pw.println("    <isd:option key=\"" + key + "\" value=\"" + value2 + "\" />");
            }
        }
        pw.println("  </isd:provider>");
        if (this.faultListener != null) {
            for (i = 0; i < this.faultListener.length; ++i) {
                pw.println("  <isd:faultListener>" + this.faultListener[i] + "</isd:faultListener>");
            }
        }
        if (this.mappings != null) {
            pw.print("  <isd:mappings");
            if (this.defaultSMRClass != null) {
                pw.println(" defaultRegistryClass=\"" + this.defaultSMRClass + "\">");
            } else {
                pw.println(">");
            }
            for (i = 0; i < this.mappings.length; ++i) {
                TypeMapping tm = this.mappings[i];
                pw.print("    <isd:map");
                if (tm.encodingStyle != null) {
                    pw.print(" encodingStyle=\"" + tm.encodingStyle + "\"");
                }
                if (tm.elementType != null) {
                    pw.print(" xmlns:x=\"" + tm.elementType.getNamespaceURI() + "\" qname=\"x:" + tm.elementType.getLocalPart() + "\"");
                }
                if (tm.javaType != null) {
                    pw.print(" javaType=\"" + tm.javaType + "\"");
                }
                if (tm.xml2JavaClassName != null) {
                    pw.print(" xml2JavaClassName=\"" + tm.xml2JavaClassName + "\"");
                }
                if (tm.java2XMLClassName != null) {
                    pw.print(" java2XMLClassName=\"" + tm.java2XMLClassName + "\"");
                }
                pw.println("/>");
            }
            pw.println("  </isd:mappings>");
        }
        pw.println("</isd:service>");
        pw.flush();
    }

    public static DeploymentDescriptor fromXML(Reader rd) throws IllegalArgumentException {
        if (rd == null) {
            throw new IllegalArgumentException("Reader passed to DeploymentDescriptor.fromXML(...) must not be null.");
        }
        try {
            DocumentBuilder xdb = XMLParserUtils.getXMLDocBuilder();
            Document doc = xdb.parse(new InputSource(rd));
            if (doc != null) {
                Element root = doc.getDocumentElement();
                return DeploymentDescriptor.fromXML(root);
            }
            throw new Exception("Document came back null.");
        }
        catch (Exception e2) {
            throw new IllegalArgumentException("Problem parsing deployment descriptor: " + e2);
        }
    }

    public static DeploymentDescriptor fromXML(Element root) throws IllegalArgumentException {
        String isStatic;
        NodeList nl;
        String serviceTypeStr;
        if (root == null || !root.getNamespaceURI().equals("http://xml.apache.org/xml-soap/deployment") || !root.getLocalName().equals("service")) {
            throw new IllegalArgumentException("root is null or document element is not {http://xml.apache.org/xml-soap/deployment}service");
        }
        DeploymentDescriptor dd = new DeploymentDescriptor();
        String id = DOMUtils.getAttribute(root, "id");
        if (id == null) {
            throw new IllegalArgumentException("required 'id' attribute missing in deployment descriptor");
        }
        dd.setID(id);
        String checkMustUnderstands = DOMUtils.getAttribute(root, "checkMustUnderstands");
        if (checkMustUnderstands != null && checkMustUnderstands.equals("true")) {
            dd.checkMustUnderstands = true;
        }
        if ((serviceTypeStr = DOMUtils.getAttribute(root, "type")) != null) {
            if (serviceTypeStr.equals("message")) {
                dd.setServiceType(1);
            } else {
                throw new IllegalArgumentException("unknown value for 'type' attribute: '" + serviceTypeStr + "': bad deployment descriptor");
            }
        }
        if ((nl = root.getElementsByTagNameNS("http://xml.apache.org/xml-soap/deployment", "provider")) == null || nl.getLength() != 1) {
            throw new IllegalArgumentException("exactly one 'provider' element missing in deployment descriptor");
        }
        Element e2 = (Element)nl.item(0);
        String typeStr = DOMUtils.getAttribute(e2, "type");
        String scopeStr = DOMUtils.getAttribute(e2, "scope");
        String methodsStr = DOMUtils.getAttribute(e2, "methods");
        if (typeStr == null || scopeStr == null || !scopeStr.equals("Request") && !scopeStr.equals("Session") && !scopeStr.equals("Application") || methodsStr == null || methodsStr.equals("")) {
            throw new IllegalArgumentException("invalid value for type or scope or methods attribute in provider element of deployment descriptor");
        }
        int scope = -1;
        Element saved_E = e2;
        nl = e2.getElementsByTagNameNS("http://xml.apache.org/xml-soap/deployment", "option");
        for (int i = 0; nl != null && i < nl.getLength(); ++i) {
            e2 = (Element)nl.item(i);
            String key = DOMUtils.getAttribute(e2, "key");
            String value2 = DOMUtils.getAttribute(e2, "value");
            if (key == null || key.equals("")) {
                throw new IllegalArgumentException("Missing 'key' attribute on 'option' element in deployment desriptor");
            }
            if (dd.props == null) {
                dd.props = new Hashtable();
            }
            dd.props.put(key, value2);
        }
        e2 = saved_E;
        if (typeStr.equals("java")) {
            dd.setProviderType((byte)0);
            nl = e2.getElementsByTagNameNS("http://xml.apache.org/xml-soap/deployment", "java");
            if (nl == null || nl.getLength() != 1) {
                throw new IllegalArgumentException("exactly one 'java' element missing in deployment descriptor");
            }
            e2 = (Element)nl.item(0);
            String className = DOMUtils.getAttribute(e2, "class");
            if (className == null) {
                throw new IllegalArgumentException("<java> element requires 'class' attribute");
            }
            dd.setProviderClass(className);
            isStatic = DOMUtils.getAttribute(e2, "static");
            boolean isStaticBool = false;
            if (isStatic != null) {
                if (isStatic.equals("false")) {
                    isStaticBool = false;
                } else if (isStatic.equals("true")) {
                    isStaticBool = true;
                } else {
                    throw new IllegalArgumentException("'static' attribute of <java> element must be true or false");
                }
            }
            dd.setIsStatic(isStaticBool);
        } else if (typeStr.equals("script")) {
            nl = e2.getElementsByTagNameNS("http://xml.apache.org/xml-soap/deployment", "script");
            if (nl == null || nl.getLength() != 1) {
                throw new IllegalArgumentException("exactly one 'script' element missing in deployment descriptor");
            }
            e2 = (Element)nl.item(0);
            dd.setScriptLanguage(DOMUtils.getAttribute(e2, "language"));
            String source = DOMUtils.getAttribute(e2, "source");
            if (source != null) {
                dd.setProviderType((byte)1);
                dd.setScriptFilenameOrString(source);
            } else {
                dd.setProviderType((byte)2);
                dd.setScriptFilenameOrString(DOMUtils.getChildCharacterData(e2));
            }
        } else {
            dd.setProviderType((byte)3);
            dd.setServiceClass(typeStr);
            nl = e2.getElementsByTagNameNS("http://xml.apache.org/xml-soap/deployment", "java");
            if (nl != null) {
                if (nl.getLength() > 1) {
                    throw new IllegalArgumentException("exactly one 'java' element missing in deployment descriptor");
                }
                if (nl.getLength() != 0) {
                    e2 = (Element)nl.item(0);
                    String className = DOMUtils.getAttribute(e2, "class");
                    if (className == null) {
                        throw new IllegalArgumentException("<java> element requires 'class' attribute");
                    }
                    dd.setProviderClass(className);
                    isStatic = DOMUtils.getAttribute(e2, "static");
                    boolean isStaticBool = false;
                    if (isStatic != null) {
                        if (isStatic.equals("false")) {
                            isStaticBool = false;
                        } else if (isStatic.equals("true")) {
                            isStaticBool = true;
                        } else {
                            throw new IllegalArgumentException("'static' attribute of <java> element must be true or false");
                        }
                    }
                    dd.setIsStatic(isStaticBool);
                }
            }
        }
        scope = scopeStr.equals("Request") ? 0 : (scopeStr.equals("Session") ? 1 : 2);
        dd.setScope(scope);
        StringTokenizer st = new StringTokenizer(methodsStr);
        int nTokens = st.countTokens();
        String[] methods = new String[nTokens];
        for (int i = 0; i < nTokens; ++i) {
            methods[i] = st.nextToken();
        }
        dd.setMethods(methods);
        nl = root.getElementsByTagNameNS("http://xml.apache.org/xml-soap/deployment", "faultListener");
        String[] lis = new String[nl.getLength()];
        try {
            for (int i = 0; i < nl.getLength(); ++i) {
                lis[i] = DOMUtils.getChildCharacterData((Element)nl.item(i));
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
        dd.setFaultListener(lis);
        nl = root.getElementsByTagNameNS("http://xml.apache.org/xml-soap/deployment", "mappings");
        if (nl == null || nl.getLength() > 1) {
            throw new IllegalArgumentException("at most one 'mappings' element allowed in deployment descriptor");
        }
        if (nl.getLength() == 1) {
            int nmaps;
            e2 = (Element)nl.item(0);
            String className = DOMUtils.getAttribute(e2, "defaultRegistryClass");
            if (className != null) {
                dd.setDefaultSMRClass(className);
            }
            if ((nmaps = (nl = e2.getElementsByTagNameNS("http://xml.apache.org/xml-soap/deployment", "map")).getLength()) > 0) {
                TypeMapping[] tms = new TypeMapping[nmaps];
                dd.setMappings(tms);
                for (int i = 0; i < nmaps; ++i) {
                    e2 = (Element)nl.item(i);
                    QName qname = DOMUtils.getQualifiedAttributeValue(e2, "qname", true);
                    tms[i] = new TypeMapping(DOMUtils.getAttribute(e2, "encodingStyle"), qname, DOMUtils.getAttribute(e2, "javaType"), DOMUtils.getAttribute(e2, "java2XMLClassName"), DOMUtils.getAttribute(e2, "xml2JavaClassName"));
                }
            }
        }
        return dd;
    }

    public String toString() {
        StringBuffer methodsStrbuf = new StringBuffer("[");
        for (int i = 0; i < this.methods.length; ++i) {
            methodsStrbuf.append(this.methods[i]);
            if (i >= this.methods.length - 1) continue;
            methodsStrbuf.append(",");
        }
        methodsStrbuf.append("]");
        String header2 = "[DeploymentDescriptor id='" + this.id + "', " + (this.serviceType != 0 ? "type='message', " : "") + "scope='" + this.scope + "', ";
        String body = null;
        if (this.providerType == 0) {
            body = "class='" + this.providerClass + "', static='" + this.isStatic + "', ";
        } else if (this.providerType == 1) {
            body = "source='" + this.scriptFilenameOrString + "', ";
            body = body + "language='" + this.scriptLanguage + "', ";
        } else if (this.providerType == 3) {
            body = "type='" + this.serviceClass + "', class='" + this.providerClass;
            body = body + "', static='" + this.isStatic + "', ";
        }
        StringBuffer lis = new StringBuffer("[");
        if (this.faultListener != null) {
            for (int i = 0; i < this.faultListener.length; ++i) {
                lis.append(this.faultListener[i]);
                lis.append(" ");
            }
        }
        lis.append("]");
        StringBuffer opts = new StringBuffer();
        if (this.props != null) {
            opts.append(this.props.toString());
        }
        return header2 + body + "methods='" + methodsStrbuf + "', " + "faultListener='" + lis + "', " + "mappings='" + DeploymentDescriptor.mappingsToString(this.mappings) + "'], " + "opts='" + opts;
    }

    private static String mappingsToString(TypeMapping[] mappings) {
        if (mappings != null) {
            StringBuffer strBuf = new StringBuffer();
            for (int i = 0; i < mappings.length; ++i) {
                strBuf.append((i > 0 ? " " : "") + mappings[i]);
            }
            return strBuf.toString();
        }
        return null;
    }

    public static SOAPMappingRegistry buildSOAPMappingRegistry(DeploymentDescriptor dd, SOAPContext ctx) {
        TypeMapping[] maps = dd.getMappings();
        SOAPMappingRegistry smr = dd.getCachedSMR();
        if (smr != null) {
            return smr;
        }
        String defaultSMRClassName = dd.getDefaultSMRClass();
        if (defaultSMRClassName != null) {
            try {
                Class defaultSMRClass = ctx.loadClass(defaultSMRClassName);
                smr = (SOAPMappingRegistry)defaultSMRClass.newInstance();
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        if (smr == null) {
            SOAPMappingRegistry baseReg = SOAPMappingRegistry.getBaseRegistry("http://www.w3.org/2001/XMLSchema");
            if (maps == null) {
                dd.setCachedSMR(baseReg);
                return baseReg;
            }
            smr = new SOAPMappingRegistry(baseReg);
        }
        if (maps != null) {
            for (int i = 0; i < maps.length; ++i) {
                TypeMapping tm = maps[i];
                int step = 0;
                try {
                    step = 0;
                    Class javaType = null;
                    if (tm.javaType != null) {
                        javaType = ctx.loadClass(tm.javaType);
                    }
                    step = 1;
                    Serializer s = null;
                    if (tm.java2XMLClassName != null) {
                        Class c = ctx.loadClass(tm.java2XMLClassName);
                        s = (Serializer)c.newInstance();
                    }
                    step = 2;
                    Deserializer d = null;
                    if (tm.xml2JavaClassName != null) {
                        Class c = ctx.loadClass(tm.xml2JavaClassName);
                        d = (Deserializer)c.newInstance();
                    }
                    smr.mapTypes(tm.encodingStyle, tm.elementType, javaType, s, d);
                    continue;
                }
                catch (Exception e2) {
                    String m = "Deployment error in SOAP service '" + dd.getID() + "': ";
                    m = step == 0 ? m + "class name '" + tm.javaType + "' could not be resolved: " : (step == 1 ? m + "class name '" + tm.java2XMLClassName + "' could not be " + "resolved as a serializer: " : m + "class name '" + tm.xml2JavaClassName + "' could not be " + "resolved as a deserializer: ");
                    throw new IllegalArgumentException(m + e2.getMessage());
                }
            }
        }
        dd.setCachedSMR(smr);
        return smr;
    }
}

