/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.server;

import java.io.IOException;
import java.io.InputStream;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.xml.parsers.DocumentBuilder;
import org.apache.soap.Constants;
import org.apache.soap.Envelope;
import org.apache.soap.SOAPException;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.server.DeploymentDescriptor;
import org.apache.soap.transport.EnvelopeEditor;
import org.apache.soap.transport.TransportMessage;
import org.apache.soap.util.Provider;

public class ServerUtils {
    private static final String providerClassCache = "SERVICE_CACHE_PROVIDER_CLASS";

    public static Envelope readEnvelopeFromInputStream(DocumentBuilder xdb, InputStream is, int contentLength, String contentType, EnvelopeEditor editor, SOAPContext ctx) throws SOAPException, IOException, IllegalArgumentException, MessagingException {
        TransportMessage reqMsg = new TransportMessage(is, contentLength, contentType, ctx, null);
        reqMsg.read();
        MimeBodyPart rootPart = ctx.getRootPart();
        if (!rootPart.isMimeType("text/xml")) {
            throw new SOAPException(Constants.FAULT_CODE_PROTOCOL, "Unsupported content type \"" + rootPart.getContentType() + "\", must be: \"" + "text/xml" + "\".");
        }
        reqMsg.editIncoming(editor);
        return reqMsg.unmarshall(xdb);
    }

    public static Provider loadProvider(DeploymentDescriptor dd, SOAPContext ctxt) throws SOAPException {
        Object newObj;
        String className = dd.getServiceClass();
        if (className == null) {
            return null;
        }
        if (className.equals("java")) {
            className = "org.apache.soap.providers.RPCJavaProvider";
        } else if (className.equals("script")) {
            className = "org.apache.soap.providers.RPCJavaProvider";
        }
        try {
            Class c = (Class)dd.getCachedServiceInfo(providerClassCache);
            if (c == null) {
                if (dd.isCachedServiceInfo(providerClassCache)) {
                    throw new SOAPException(Constants.FAULT_CODE_SERVER, "Provider '" + className + "'" + "was not successfully loaded");
                }
                c = ctxt.loadClass(className);
                dd.addCachedServiceInfo(providerClassCache, c);
            }
            newObj = c.newInstance();
        }
        catch (Exception exp) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Can't load provider '" + className + "'", exp);
        }
        if (!(newObj instanceof Provider)) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "'" + className + "' isn't a provider");
        }
        return (Provider)newObj;
    }
}

