/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.server;

import java.io.FileReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import org.apache.soap.Fault;
import org.apache.soap.SOAPException;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.encoding.soapenc.BeanSerializer;
import org.apache.soap.rpc.Call;
import org.apache.soap.rpc.Parameter;
import org.apache.soap.rpc.Response;
import org.apache.soap.server.DeploymentDescriptor;
import org.apache.soap.server.TypeMappingSerializer;
import org.apache.soap.transport.http.SOAPHTTPConnection;
import org.apache.soap.util.xml.Deserializer;
import org.apache.soap.util.xml.QName;
import org.apache.soap.util.xml.Serializer;
import org.apache.soap.util.xml.XMLParserUtils;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class ServiceManagerClient {
    URL routerURL;
    Vector params = new Vector();
    Call call = new Call();
    String userName;
    String password;
    static /* synthetic */ Class class$org$apache$soap$server$DeploymentDescriptor;
    static /* synthetic */ Class class$org$apache$soap$server$TypeMapping;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$apache$soap$server$ServiceManagerClient;

    public ServiceManagerClient(URL routerURL) {
        Deserializer bs = new BeanSerializer();
        this.routerURL = routerURL;
        SOAPMappingRegistry smr = this.call.getSOAPMappingRegistry();
        smr.mapTypes("http://schemas.xmlsoap.org/soap/encoding/", new QName("http://xml.apache.org/xml-soap", "DeploymentDescriptor"), class$org$apache$soap$server$DeploymentDescriptor == null ? (class$org$apache$soap$server$DeploymentDescriptor = ServiceManagerClient.class$("org.apache.soap.server.DeploymentDescriptor")) : class$org$apache$soap$server$DeploymentDescriptor, (Serializer)((Object)bs), bs);
        bs = new TypeMappingSerializer();
        smr.mapTypes("http://schemas.xmlsoap.org/soap/encoding/", new QName("http://xml.apache.org/xml-soap", "TypeMapping"), class$org$apache$soap$server$TypeMapping == null ? (class$org$apache$soap$server$TypeMapping = ServiceManagerClient.class$("org.apache.soap.server.TypeMapping")) : class$org$apache$soap$server$TypeMapping, (Serializer)((Object)bs), bs);
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    private Response invokeMethod(String methodName, Parameter param) throws SOAPException {
        this.call.setTargetObjectURI("urn:xml-soap-service-management-service");
        this.call.setMethodName(methodName);
        this.call.setEncodingStyleURI("http://schemas.xmlsoap.org/soap/encoding/");
        if (this.userName != null) {
            SOAPHTTPConnection hc = new SOAPHTTPConnection();
            hc.setUserName(this.userName);
            hc.setPassword(this.password);
            this.call.setSOAPTransport(hc);
        }
        if (param != null) {
            this.params.removeAllElements();
            this.params.addElement(param);
            this.call.setParams(this.params);
        } else {
            this.call.setParams(null);
        }
        Response resp = this.call.invoke(this.routerURL, "");
        if (resp.generatedFault()) {
            Fault fault2 = resp.getFault();
            System.out.println("Ouch, the call failed: ");
            System.out.println("  Fault Code   = " + fault2.getFaultCode());
            System.out.println("  Fault String = " + fault2.getFaultString());
        }
        return resp;
    }

    public void deploy(DeploymentDescriptor dd) throws SOAPException {
        Parameter p1 = new Parameter("descriptor", class$org$apache$soap$server$DeploymentDescriptor == null ? (class$org$apache$soap$server$DeploymentDescriptor = ServiceManagerClient.class$("org.apache.soap.server.DeploymentDescriptor")) : class$org$apache$soap$server$DeploymentDescriptor, dd, null);
        this.invokeMethod("deploy", p1);
    }

    public void undeploy(String serviceName) throws SOAPException {
        Parameter p1 = new Parameter("name", class$java$lang$String == null ? (class$java$lang$String = ServiceManagerClient.class$("java.lang.String")) : class$java$lang$String, serviceName, null);
        this.invokeMethod("undeploy", p1);
    }

    public String[] list() throws SOAPException {
        Response resp = this.invokeMethod("list", null);
        if (!resp.generatedFault()) {
            Parameter result = resp.getReturnValue();
            return (String[])result.getValue();
        }
        return null;
    }

    public DeploymentDescriptor query(String serviceName) throws SOAPException {
        Parameter p1 = new Parameter("name", class$java$lang$String == null ? (class$java$lang$String = ServiceManagerClient.class$("java.lang.String")) : class$java$lang$String, serviceName, null);
        Response resp = this.invokeMethod("query", p1);
        if (!resp.generatedFault()) {
            Parameter result = resp.getReturnValue();
            return (DeploymentDescriptor)result.getValue();
        }
        return null;
    }

    private static void badUsage() {
        System.err.println("Usage: java " + (class$org$apache$soap$server$ServiceManagerClient == null ? (class$org$apache$soap$server$ServiceManagerClient = ServiceManagerClient.class$("org.apache.soap.server.ServiceManagerClient")) : class$org$apache$soap$server$ServiceManagerClient).getName() + " [-auth username:password] url operation arguments");
        System.err.println("where");
        System.err.println("\tusername and password is the HTTP Basic authentication info");
        System.err.println("\turl is the Apache SOAP router's URL whose services are managed");
        System.err.println("\toperation and arguments are:");
        System.err.println("\t\tdeploy deployment-descriptor-file.xml");
        System.err.println("\t\tlist");
        System.err.println("\t\tquery service-name");
        System.err.println("\t\tundeploy service-name");
        System.exit(1);
    }

    public static void main(String[] args) throws Exception {
        String op;
        String userName = null;
        String password = null;
        if (args.length < 2) {
            ServiceManagerClient.badUsage();
        }
        int base = 0;
        if (args[0].equals("-auth")) {
            StringTokenizer st;
            if (args.length < 4) {
                ServiceManagerClient.badUsage();
            }
            if ((st = new StringTokenizer(args[1], ":")).countTokens() != 2) {
                ServiceManagerClient.badUsage();
            }
            userName = st.nextToken();
            password = st.nextToken();
            base = 2;
        }
        ServiceManagerClient smc = new ServiceManagerClient(new URL(args[base]));
        if (base == 2) {
            smc.setUserName(userName);
            smc.setPassword(password);
        }
        if ((op = args[base + 1]).equals("deploy")) {
            if (args.length != base + 3) {
                ServiceManagerClient.badUsage();
            }
            FileReader fr = new FileReader(args[base + 2]);
            DocumentBuilder xdb = XMLParserUtils.getXMLDocBuilder();
            Document doc = xdb.parse(new InputSource(fr));
            smc.deploy(DeploymentDescriptor.fromXML(doc.getDocumentElement()));
        } else if (op.equals("undeploy")) {
            if (args.length != base + 3) {
                ServiceManagerClient.badUsage();
            }
            smc.undeploy(args[base + 2]);
        } else if (op.equals("list")) {
            String[] sms = smc.list();
            if (sms != null) {
                System.out.println("Deployed Services:");
                for (int i = 0; i < sms.length; ++i) {
                    System.out.println("\t" + sms[i]);
                }
            }
        } else if (op.equals("query")) {
            DeploymentDescriptor dd;
            if (args.length != base + 3) {
                ServiceManagerClient.badUsage();
            }
            if ((dd = smc.query(args[base + 2])) != null) {
                dd.toXML(new OutputStreamWriter(System.out));
            }
        } else {
            ServiceManagerClient.badUsage();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

